/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputListener;

final class PResizeHandles
extends JComponent {
    private static final int HANDLE_WIDTH = 5;
    private static final int HANDLE_HEIGHT = 5;
    private static final int DISTANCE = 5;
    Rectangle selectedRect;
    Rectangle upperLeftHandle = new Rectangle();
    Rectangle upperMiddleHandle = new Rectangle();
    Rectangle upperRightHandle = new Rectangle();
    Rectangle middleRightHandle = new Rectangle();
    Rectangle lowerRightHandle = new Rectangle();
    Rectangle lowerMiddleHandle = new Rectangle();
    Rectangle lowerLeftHandle = new Rectangle();
    Rectangle middleLeftHandle = new Rectangle();
    JPopupMenu popupMenu = null;
    private boolean popupMenuVisible;

    public PResizeHandles(int x, int y, int width, int height) {
        this.setOpaque(false);
        this.setSelectedRect(new Rectangle(x, y, width, height));
        MouseInputHandler mouseHandler = new MouseInputHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.registerKeystrokes();
    }

    public Rectangle getSelectedRect() {
        return (Rectangle)this.selectedRect.clone();
    }

    public void setSelectedRect(Rectangle rect) {
        this.selectedRect = (Rectangle)rect.clone();
        this.selectedRect.setSize(Math.max(this.selectedRect.width, 1), Math.max(this.selectedRect.height, 1));
        Rectangle newBounds = (Rectangle)this.selectedRect.clone();
        newBounds.grow(2, 2);
        this.calculateHandleRects(newBounds);
        this.setBounds(newBounds);
        this.repaint();
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void paint(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{4.0f, 4.0f}, 0.0f));
        g.setXORMode(Color.white);
        g.drawRect(2, 2, this.selectedRect.width - 1, this.selectedRect.height - 1);
        g.setPaintMode();
        g.setStroke(new BasicStroke());
        g.setColor(Color.black);
        g.draw(this.upperLeftHandle);
        g.draw(this.upperMiddleHandle);
        g.draw(this.upperRightHandle);
        g.draw(this.middleRightHandle);
        g.draw(this.lowerRightHandle);
        g.draw(this.lowerMiddleHandle);
        g.draw(this.lowerLeftHandle);
        g.draw(this.middleLeftHandle);
        g.setColor(Color.white);
        int fillWidth = 3;
        int fillHeight = 3;
        g.fillRect(this.upperLeftHandle.x + 1, this.upperLeftHandle.y + 1, fillWidth, fillHeight);
        g.fillRect(this.upperMiddleHandle.x + 1, this.upperMiddleHandle.y + 1, fillWidth, fillHeight);
        g.fillRect(this.upperRightHandle.x + 1, this.upperRightHandle.y + 1, fillWidth, fillHeight);
        g.fillRect(this.middleRightHandle.x + 1, this.middleRightHandle.y + 1, fillWidth, fillHeight);
        g.fillRect(this.lowerRightHandle.x + 1, this.lowerRightHandle.y + 1, fillWidth, fillHeight);
        g.fillRect(this.lowerMiddleHandle.x + 1, this.lowerLeftHandle.y + 1, fillWidth, fillHeight);
        g.fillRect(this.lowerLeftHandle.x + 1, this.lowerLeftHandle.y + 1, fillWidth, fillHeight);
        g.fillRect(this.middleLeftHandle.x + 1, this.middleLeftHandle.y + 1, fillWidth, fillHeight);
        g.setStroke(oldStroke);
        g.setColor(oldColor);
    }

    private void calculateHandleRects(Rectangle bounds) {
        int width = bounds.width;
        int height = bounds.height;
        int xmidpoint = width / 2 - 2;
        int ymidpoint = height / 2 - 2;
        this.upperLeftHandle.setBounds(0, 0, 5, 5);
        this.upperMiddleHandle.setBounds(xmidpoint, 0, 5, 5);
        this.upperRightHandle.setBounds(width - 5 - 1, 0, 5, 5);
        this.middleRightHandle.setBounds(width - 5 - 1, ymidpoint, 5, 5);
        this.lowerRightHandle.setBounds(width - 5 - 1, height - 5 - 1, 5, 5);
        this.lowerMiddleHandle.setBounds(xmidpoint, height - 5 - 1, 5, 5);
        this.lowerLeftHandle.setBounds(0, height - 5 - 1, 5, 5);
        this.middleLeftHandle.setBounds(0, ymidpoint, 5, 5);
    }

    private void displayAppropriateCursor(Point p) {
        if (this.lowerRightHandle.contains(p)) {
            this.setCursor(new Cursor(5));
        } else if (this.upperRightHandle.contains(p)) {
            this.setCursor(new Cursor(7));
        } else if (this.lowerLeftHandle.contains(p)) {
            this.setCursor(new Cursor(4));
        } else if (this.upperLeftHandle.contains(p)) {
            this.setCursor(new Cursor(6));
        } else if (this.middleRightHandle.contains(p)) {
            this.setCursor(new Cursor(11));
        } else if (this.lowerMiddleHandle.contains(p)) {
            this.setCursor(new Cursor(9));
        } else if (this.upperMiddleHandle.contains(p)) {
            this.setCursor(new Cursor(8));
        } else if (this.middleLeftHandle.contains(p)) {
            this.setCursor(new Cursor(10));
        } else {
            this.setCursor(new Cursor(13));
        }
    }

    private void registerKeystrokes() {
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Rectangle rect = PResizeHandles.this.getSelectedRect();
                rect.translate(0, -5);
                PResizeHandles.this.setSelectedRect(rect);
            }
        }, KeyStroke.getKeyStroke(38, 8, false), 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Rectangle rect = PResizeHandles.this.getSelectedRect();
                rect.translate(0, 5);
                PResizeHandles.this.setSelectedRect(rect);
            }
        }, KeyStroke.getKeyStroke(40, 8, false), 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Rectangle rect = PResizeHandles.this.getSelectedRect();
                rect.translate(-5, 0);
                PResizeHandles.this.setSelectedRect(rect);
            }
        }, KeyStroke.getKeyStroke(37, 8, false), 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Rectangle rect = PResizeHandles.this.getSelectedRect();
                rect.translate(5, 0);
                PResizeHandles.this.setSelectedRect(rect);
            }
        }, KeyStroke.getKeyStroke(39, 8, false), 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Rectangle rect = PResizeHandles.this.getSelectedRect();
                rect.setSize(rect.width, rect.height - 5);
                PResizeHandles.this.setSelectedRect(rect);
            }
        }, KeyStroke.getKeyStroke(38, 1, false), 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Rectangle rect = PResizeHandles.this.getSelectedRect();
                rect.setSize(rect.width, rect.height + 5);
                PResizeHandles.this.setSelectedRect(rect);
            }
        }, KeyStroke.getKeyStroke(40, 1, false), 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Rectangle rect = PResizeHandles.this.getSelectedRect();
                rect.setSize(rect.width - 5, rect.height);
                PResizeHandles.this.setSelectedRect(rect);
            }
        }, KeyStroke.getKeyStroke(37, 1, false), 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Rectangle rect = PResizeHandles.this.getSelectedRect();
                rect.setSize(rect.width + 5, rect.height);
                PResizeHandles.this.setSelectedRect(rect);
            }
        }, KeyStroke.getKeyStroke(39, 1, false), 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PResizeHandles.this.popupMenu != null) {
                    Dimension size = PResizeHandles.this.getSize();
                    PResizeHandles.this.popupMenu.show(PResizeHandles.this, size.width / 2, size.height / 2);
                }
            }
        }, KeyStroke.getKeyStroke(121, 1, false), 0);
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private int pressedX;
        private int pressedY;
        Rectangle pressedHandle;
        Rectangle originalSelectedRect;

        private MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            PResizeHandles.this.requestFocus();
        }

        public void mouseEntered(MouseEvent e) {
            PResizeHandles.this.displayAppropriateCursor(e.getPoint());
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && PResizeHandles.this.popupMenu != null) {
                PResizeHandles.this.popupMenu.show(PResizeHandles.this, e.getX(), e.getY());
                PResizeHandles.this.popupMenuVisible = true;
            }
            Point locationOnScreen = PResizeHandles.this.getLocationOnScreen();
            Point p = e.getPoint();
            this.pressedX = locationOnScreen.x + p.x;
            this.pressedY = locationOnScreen.y + p.y;
            this.pressedHandle = PResizeHandles.this.lowerRightHandle.contains(p) ? PResizeHandles.this.lowerRightHandle : (PResizeHandles.this.upperRightHandle.contains(p) ? PResizeHandles.this.upperRightHandle : (PResizeHandles.this.lowerLeftHandle.contains(p) ? PResizeHandles.this.lowerLeftHandle : (PResizeHandles.this.upperLeftHandle.contains(p) ? PResizeHandles.this.upperLeftHandle : (PResizeHandles.this.middleRightHandle.contains(p) ? PResizeHandles.this.middleRightHandle : (PResizeHandles.this.lowerMiddleHandle.contains(p) ? PResizeHandles.this.lowerMiddleHandle : (PResizeHandles.this.upperMiddleHandle.contains(p) ? PResizeHandles.this.upperMiddleHandle : (PResizeHandles.this.middleLeftHandle.contains(p) ? PResizeHandles.this.middleLeftHandle : null)))))));
            this.originalSelectedRect = PResizeHandles.this.getSelectedRect();
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (PResizeHandles.this.popupMenu != null) {
                    PResizeHandles.this.popupMenu.show(PResizeHandles.this, e.getX(), e.getY());
                }
            } else if (!PResizeHandles.this.popupMenuVisible) {
                this.drag(e);
            } else {
                PResizeHandles.this.popupMenuVisible = false;
            }
        }

        public void mouseDragged(MouseEvent e) {
            this.drag(e);
        }

        public void mouseMoved(MouseEvent e) {
            PResizeHandles.this.displayAppropriateCursor(e.getPoint());
        }

        private void drag(MouseEvent e) {
            Point locationOnScreen = PResizeHandles.this.getLocationOnScreen();
            Point p = e.getPoint();
            int currentX = locationOnScreen.x + p.x;
            int currentY = locationOnScreen.y + p.y;
            int deltaX = currentX - this.pressedX;
            int deltaY = currentY - this.pressedY;
            Rectangle newRect = this.pressedHandle == PResizeHandles.this.upperLeftHandle ? new Rectangle(this.originalSelectedRect.x + deltaX, this.originalSelectedRect.y + deltaY, this.originalSelectedRect.width - deltaX, this.originalSelectedRect.height - deltaY) : (this.pressedHandle == PResizeHandles.this.upperMiddleHandle ? new Rectangle(this.originalSelectedRect.x, this.originalSelectedRect.y + deltaY, this.originalSelectedRect.width, this.originalSelectedRect.height - deltaY) : (this.pressedHandle == PResizeHandles.this.upperRightHandle ? new Rectangle(this.originalSelectedRect.x, this.originalSelectedRect.y + deltaY, this.originalSelectedRect.width + deltaX, this.originalSelectedRect.height - deltaY) : (this.pressedHandle == PResizeHandles.this.middleRightHandle ? new Rectangle(this.originalSelectedRect.x, this.originalSelectedRect.y, this.originalSelectedRect.width + deltaX, this.originalSelectedRect.height) : (this.pressedHandle == PResizeHandles.this.lowerRightHandle ? new Rectangle(this.originalSelectedRect.x, this.originalSelectedRect.y, this.originalSelectedRect.width + deltaX, this.originalSelectedRect.height + deltaY) : (this.pressedHandle == PResizeHandles.this.lowerMiddleHandle ? new Rectangle(this.originalSelectedRect.x, this.originalSelectedRect.y, this.originalSelectedRect.width, this.originalSelectedRect.height + deltaY) : (this.pressedHandle == PResizeHandles.this.lowerLeftHandle ? new Rectangle(this.originalSelectedRect.x + deltaX, this.originalSelectedRect.y, this.originalSelectedRect.width - deltaX, this.originalSelectedRect.height + deltaY) : (this.pressedHandle == PResizeHandles.this.middleLeftHandle ? new Rectangle(this.originalSelectedRect.x + deltaX, this.originalSelectedRect.y, this.originalSelectedRect.width - deltaX, this.originalSelectedRect.height) : new Rectangle(this.originalSelectedRect.x + deltaX, this.originalSelectedRect.y + deltaY, this.originalSelectedRect.width, this.originalSelectedRect.height))))))));
            PResizeHandles.this.setSelectedRect(newRect);
        }
    }
}

