/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PAbstractTask;
import com.ibm.mm.viewer.PTaskManager;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationView;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import java.awt.Point;
import java.awt.Rectangle;

class PResizeAnnotationTask
extends PAbstractTask {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBGenericDocViewer viewer = null;
    private Point newPoint;
    private Point oldPoint;
    private CMBPageAnnotation annotation;
    private CMBAnnotationView view;

    PResizeAnnotationTask(PTaskManager taskManager, CMBGenericDocViewer viewer, CMBAnnotationView view, CMBPageAnnotation a, Point newPoint, Point oldPoint, boolean doItNow) {
        super(taskManager);
        this.viewer = viewer;
        this.view = view;
        this.annotation = a;
        this.newPoint = newPoint;
        this.oldPoint = oldPoint;
        this.getManager().invokeTask(this, doItNow);
    }

    public boolean doIt() {
        String methodName = "doIt";
        try {
            Rectangle oldRefreshRect = this.annotation.getRefreshRect();
            this.annotation.growBy(this.newPoint.x - this.oldPoint.x, this.newPoint.y - this.oldPoint.y);
            this.view.getViewComponent().repaint(oldRefreshRect);
            this.view.getViewComponent().repaint(this.annotation.getRefreshRect());
            this.viewer.getSelectedThumbnailView().repaint();
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return false;
        }
        return true;
    }

    public boolean undoIt() {
        String methodName = "undoIt";
        try {
            Rectangle oldRefreshRect = this.annotation.getRefreshRect();
            this.annotation.growBy(this.oldPoint.x - this.newPoint.x, this.oldPoint.y - this.newPoint.y);
            this.view.getViewComponent().repaint(oldRefreshRect);
            this.view.getViewComponent().repaint(this.annotation.getRefreshRect());
            this.viewer.getSelectedThumbnailView().repaint();
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return false;
        }
        return true;
    }

    public String getDescription() {
        return PViewerUtilities.getMessage("resizeAnnotationTask.description");
    }
}

