/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PAbstractTask;
import com.ibm.mm.viewer.PTaskManager;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBAnnotationView;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;

class PReorderAnnotationTask
extends PAbstractTask {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBGenericDocViewer viewer = null;
    private CMBAnnotationSet annModel;
    private CMBAnnotationView annView;
    private CMBPageAnnotation anno;
    private int newIndex;
    private int originalIndex;

    PReorderAnnotationTask(PTaskManager taskManager, CMBGenericDocViewer viewer, CMBAnnotationSet annModel, CMBAnnotationView annView, CMBPageAnnotation anno, int origIndex, int index, boolean doItNow) {
        super(taskManager);
        this.viewer = viewer;
        this.annModel = annModel;
        this.annView = annView;
        this.anno = anno;
        this.newIndex = index;
        this.originalIndex = origIndex;
        this.getManager().invokeTask(this, doItNow);
    }

    public boolean doIt() {
        String methodName = "doIt";
        try {
            this.annModel.reorderAnnotation(this.anno, this.newIndex);
            this.annView.refreshEntireDrawArea();
            this.viewer.getSelectedThumbnailView().repaint();
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return false;
        }
        return true;
    }

    public boolean undoIt() {
        String methodName = "undoIt";
        try {
            this.annModel.reorderAnnotation(this.anno, this.originalIndex);
            this.annView.refreshEntireDrawArea();
            this.viewer.getSelectedThumbnailView().repaint();
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return false;
        }
        return true;
    }

    public String getDescription() {
        return PViewerUtilities.getMessage("reorderAnnotationTask.description");
    }
}

