/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PPropertyDescriptor {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private Class propertyType = null;
    private Object propertyEditor = null;
    private String propertyName = null;
    private String displayName = null;
    private Object[] args = null;
    private PPropertyDescriptor sibling = null;
    FocusListener keepVisibleFocusListener = new KeepVisibleFocusListener();

    PPropertyDescriptor(String propertyName, String displayName, Class propertyType, Object[] args) {
        this.propertyName = propertyName;
        this.displayName = displayName;
        this.propertyType = propertyType;
        this.args = args;
        if (propertyType.equals(JComboBox.class)) {
            this.propertyEditor = new ComboBoxPropertyEditor();
        }
        if (propertyType.equals(Integer.class)) {
            this.propertyEditor = new IntegerPropertyEditor();
        }
        if (propertyType.equals(Boolean.class)) {
            this.propertyEditor = new BooleanPropertyEditor();
        }
        if (propertyType.equals(Color.class)) {
            this.propertyEditor = new ColorPropertyEditor();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Object getPropertyEditor() {
        return this.propertyEditor;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public JPanel getPanel() {
        String methodName = "getPanel";
        Method m_getPanel = null;
        JPanel panel = null;
        try {
            m_getPanel = this.propertyEditor.getClass().getMethod("getPanel", Object[].class);
            panel = (JPanel)m_getPanel.invoke(this.propertyEditor, new Object[]{this.args});
        }
        catch (SecurityException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        catch (NoSuchMethodException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        catch (IllegalArgumentException e1) {
            ViewerLogger.logError((Object)this, methodName, e1);
        }
        catch (IllegalAccessException e1) {
            ViewerLogger.logError((Object)this, methodName, e1);
        }
        catch (InvocationTargetException e1) {
            ViewerLogger.logError((Object)this, methodName, e1);
        }
        return panel;
    }

    public Object getPropertyValue() {
        Object value = null;
        if (this.propertyType.equals(JComboBox.class)) {
            return ((ComboBoxPropertyEditor)this.propertyEditor).getValue();
        }
        if (this.propertyType.equals(Integer.class)) {
            return ((IntegerPropertyEditor)this.propertyEditor).getValue();
        }
        if (this.propertyType.equals(Boolean.class)) {
            return ((BooleanPropertyEditor)this.propertyEditor).getValue();
        }
        if (this.propertyType.equals(Color.class)) {
            return ((ColorPropertyEditor)this.propertyEditor).getValue();
        }
        return value;
    }

    public void setPropertyValue(Object value) {
        if (this.propertyType.equals(JComboBox.class)) {
            ((ComboBoxPropertyEditor)this.propertyEditor).setValue(value);
        }
        if (this.propertyType.equals(Integer.class)) {
            ((IntegerPropertyEditor)this.propertyEditor).setValue(value);
        }
        if (this.propertyType.equals(Boolean.class)) {
            ((BooleanPropertyEditor)this.propertyEditor).setValue(value);
        }
        if (this.propertyType.equals(Color.class)) {
            ((ColorPropertyEditor)this.propertyEditor).setValue(value);
        }
    }

    public PPropertyDescriptor getSibling() {
        return this.sibling;
    }

    public void setSibling(PPropertyDescriptor descriptor) {
        this.sibling = descriptor;
    }

    public boolean isValueValid(Object value) {
        if (this.propertyType.equals(JComboBox.class)) {
            return ((ComboBoxPropertyEditor)this.propertyEditor).isValueValid(value, this.args);
        }
        if (this.propertyType.equals(Integer.class)) {
            return ((IntegerPropertyEditor)this.propertyEditor).isValueValid(value, this.args);
        }
        if (this.propertyType.equals(Boolean.class)) {
            return ((BooleanPropertyEditor)this.propertyEditor).isValueValid(value);
        }
        if (this.propertyType.equals(Color.class)) {
            return ((ColorPropertyEditor)this.propertyEditor).isValueValid(value);
        }
        return false;
    }

    private class KeepVisibleFocusListener
    extends FocusAdapter {
        private KeepVisibleFocusListener() {
        }

        public void focusGained(FocusEvent event) {
            JComponent component = (JComponent)event.getComponent();
            ((JComponent)component.getParent()).scrollRectToVisible(component.getBounds());
        }
    }

    public class NumericSpinner
    extends JSpinner
    implements Accessible {
        public NumericSpinner(SpinnerModel model) {
            super(model);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJSpinner();
            }
            return this.accessibleContext;
        }

        public void setAccessibility(JLabel label, JPanel panel) {
            JSpinner.NumberEditor ne = (JSpinner.NumberEditor)this.getEditor();
            ne.getTextField().getAccessibleContext().setAccessibleParent(panel);
            this.getAccessibleContext().setAccessibleParent(panel);
            label.setLabelFor(ne.getTextField());
        }

        protected class AccessibleJSpinner
        extends JComponent.AccessibleJComponent
        implements AccessibleValue,
        ChangeListener {
            private Object oldModelValue;

            protected AccessibleJSpinner() {
                super(NumericSpinner.this);
                this.oldModelValue = null;
                this.oldModelValue = NumericSpinner.this.getModel().getValue();
                NumericSpinner.this.addChangeListener(this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.SPIN_BOX;
            }

            public void setAccessibleName(String s) {
                super.setAccessibleName(s);
                ((JSpinner.NumberEditor)NumericSpinner.this.getEditor()).getTextField().getAccessibleContext().setAccessibleName(PViewerUtilities.getMessage(PPropertyDescriptor.this.displayName));
            }

            public AccessibleValue getAccessibleValue() {
                return this;
            }

            public Number getCurrentAccessibleValue() {
                return this.getCurrentAccessibleValue();
            }

            public boolean setCurrentAccessibleValue(Number n) {
                if (n instanceof Integer) {
                    ((SpinnerNumberModel)NumericSpinner.this.getModel()).setValue(n);
                    return true;
                }
                return false;
            }

            public Number getMinimumAccessibleValue() {
                Comparable<?> c = ((SpinnerNumberModel)NumericSpinner.this.getModel()).getMinimum();
                return (Number)((Object)c);
            }

            public Number getMaximumAccessibleValue() {
                Comparable<?> c = ((SpinnerNumberModel)NumericSpinner.this.getModel()).getMaximum();
                return (Number)((Object)c);
            }

            public void stateChanged(ChangeEvent e) {
                if (e == null) {
                    throw new NullPointerException();
                }
                Object newModelValue = NumericSpinner.this.getModel().getValue();
                this.firePropertyChange("AccessibleValue", this.oldModelValue, newModelValue);
                this.oldModelValue = newModelValue;
            }
        }
    }

    public class MyComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                Tuple tuple = (Tuple)value;
                this.setText(tuple.displayValue);
            }
            return this;
        }
    }

    public static class Tuple {
        String propertyValue = null;
        String displayValue = null;

        Tuple(String propertyValue, String displayValue) {
            this.propertyValue = propertyValue;
            this.displayValue = displayValue;
        }
    }

    private class PColorField
    extends JTextField {
        public PColorField(Color color) {
            this.setOpaque(true);
            this.setBackground(color);
        }

        public void setBackground(Color c) {
            if (c == null) {
                return;
            }
            Color newColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
            super.setBackground(newColor);
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }

    public class ColorPropertyEditor {
        PColorField colorField = null;
        JButton changeButton = null;

        private JLabel getLabel() {
            JLabel label = new JLabel(PViewerUtilities.getMessage(PPropertyDescriptor.this.displayName));
            String mnemonicString = PViewerUtilities.getMessage(PPropertyDescriptor.this.displayName + ".mnemonic");
            if (mnemonicString != null && mnemonicString.length() == 1) {
                label.setDisplayedMnemonic(mnemonicString.charAt(0));
            }
            return label;
        }

        private JButton getChangeButton() {
            this.changeButton = new JButton(PViewerUtilities.getMessage("preference.color.ellipsesButton"));
            this.changeButton.getAccessibleContext().setAccessibleName(PViewerUtilities.getMessage(PPropertyDescriptor.this.displayName));
            this.changeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Window w = SwingUtilities.windowForComponent(ColorPropertyEditor.this.changeButton);
                    Color bg = ColorPropertyEditor.this.colorField.getBackground();
                    Color newColor = JColorChooser.showDialog(w, PViewerUtilities.getMessage("preference.color.chooseDialog.title"), bg);
                    if (newColor != null) {
                        ColorPropertyEditor.this.setValue(newColor);
                    }
                }
            });
            return this.changeButton;
        }

        private PColorField getColorField(Color color) {
            this.colorField = new PColorField(color);
            return this.colorField;
        }

        public JPanel getPanel(Object[] args) {
            Color color = Color.decode((String)args[0]);
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(1, 0, 5, 5));
            JPanel p1 = new JPanel();
            p1.setLayout(new FlowLayout(3, 0, 0));
            JLabel label = this.getLabel();
            p1.add(label);
            JPanel p2 = new JPanel();
            p2.setLayout(new BorderLayout(0, 0));
            p2.add((Component)this.getColorField(color), "Center");
            JButton changeButton = this.getChangeButton();
            p2.add((Component)changeButton, "After");
            label.setLabelFor(changeButton);
            panel.add(p1);
            panel.add(p2);
            return panel;
        }

        public String getValue() {
            Color bg = this.colorField.getBackground();
            String str = Integer.toHexString(bg.getRGB()).toUpperCase();
            str = "#" + str.substring(2, str.length());
            return str;
        }

        public void setValue(Object value) {
            Color newColor = null;
            newColor = value instanceof String ? Color.decode((String)value) : (value instanceof Color ? (Color)value : new Color((Integer)value));
            if (newColor != null) {
                this.colorField.setBackground(newColor);
            }
        }

        public boolean isValueValid(Object value) {
            if (value instanceof Color) {
                return true;
            }
            if (value instanceof String) {
                try {
                    Color bg = Color.decode((String)value);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        }
    }

    public class ComboBoxPropertyEditor {
        JComboBox comboBox = null;

        private JComboBox getComboBox(Object[] objects, String selectedItem) {
            this.comboBox = new JComboBox<Object>(objects);
            this.comboBox.setRenderer(new MyComboBoxRenderer());
            for (int i = 0; i < objects.length; ++i) {
                Tuple o = (Tuple)objects[i];
                if (!o.propertyValue.equalsIgnoreCase(selectedItem)) continue;
                this.comboBox.setSelectedItem(objects[i]);
            }
            this.comboBox.addFocusListener(PPropertyDescriptor.this.keepVisibleFocusListener);
            return this.comboBox;
        }

        private JLabel getLabel() {
            JLabel label = new JLabel(PViewerUtilities.getMessage(PPropertyDescriptor.this.displayName));
            String mnemonicString = PViewerUtilities.getMessage(PPropertyDescriptor.this.displayName + ".mnemonic");
            if (mnemonicString != null && mnemonicString.length() == 1) {
                label.setDisplayedMnemonic(mnemonicString.charAt(0));
            }
            return label;
        }

        public JPanel getPanel(Object[] args) {
            Object[] objects = (Object[])args[0];
            String selectedItem = (String)args[1];
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(1, 2, 5, 5));
            JLabel label = this.getLabel();
            panel.add(label);
            panel.add(this.getComboBox(objects, selectedItem));
            label.setLabelFor(this.comboBox);
            return panel;
        }

        public String getValue() {
            Tuple item = (Tuple)this.comboBox.getSelectedItem();
            return item.propertyValue;
        }

        public void setValue(Object value) {
            ComboBoxModel dataModel = this.comboBox.getModel();
            int dataModelSize = dataModel.getSize();
            for (int i = 0; i < dataModelSize; ++i) {
                Tuple v = (Tuple)dataModel.getElementAt(i);
                if (!v.propertyValue.equalsIgnoreCase((String)value)) continue;
                this.comboBox.setSelectedIndex(i);
            }
        }

        public boolean isValueValid(Object value, Object[] args) {
            Object[] objects = (Object[])args[0];
            for (int i = 0; i < objects.length; ++i) {
                Tuple v = (Tuple)objects[i];
                String aValidValue = v.propertyValue;
                if (!((String)value).equalsIgnoreCase(aValidValue)) continue;
                return true;
            }
            return false;
        }
    }

    public class IntegerPropertyEditor {
        NumericSpinner spinner = null;

        public NumericSpinner getSpinner(int value, int min, int max, int inc) {
            SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, inc);
            this.spinner = new NumericSpinner(model);
            this.spinner.getAccessibleContext().setAccessibleName(PViewerUtilities.getMessage(PPropertyDescriptor.this.displayName));
            this.spinner.addFocusListener(PPropertyDescriptor.this.keepVisibleFocusListener);
            return this.spinner;
        }

        private JLabel getLabel() {
            JLabel label = new JLabel(PViewerUtilities.getMessage(PPropertyDescriptor.this.displayName));
            String mnemonicString = PViewerUtilities.getMessage(PPropertyDescriptor.this.displayName + ".mnemonic");
            if (mnemonicString != null && mnemonicString.length() == 1) {
                label.setDisplayedMnemonic(mnemonicString.charAt(0));
            }
            return label;
        }

        public JPanel getPanel(Object[] args) {
            int value = (Integer)args[0];
            int min = (Integer)args[1];
            int max = (Integer)args[2];
            int inc = (Integer)args[3];
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(0, 2, 5, 5));
            JLabel label = this.getLabel();
            panel.add(label);
            NumericSpinner spinner = this.getSpinner(value, min, max, inc);
            panel.add(spinner);
            spinner.setAccessibility(label, panel);
            return panel;
        }

        public Integer getValue() {
            return (Integer)this.spinner.getValue();
        }

        public void setValue(Object value) {
            if (value instanceof String) {
                this.spinner.setValue(Integer.valueOf((String)value));
            } else {
                this.spinner.setValue(value);
            }
        }

        public boolean isValueValid(Object value, Object[] args) {
            int min = (Integer)args[1];
            int max = (Integer)args[2];
            int i = 0;
            if (value instanceof String) {
                try {
                    i = Integer.valueOf((String)value);
                    return i <= max && i >= min;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (value instanceof Integer) {
                i = (Integer)value;
                return i <= max && i >= min;
            }
            return false;
        }
    }

    public class BooleanPropertyEditor {
        JCheckBox checkBox = null;

        private JCheckBox getCheckBox(boolean selected) {
            this.checkBox = new JCheckBox(PViewerUtilities.getMessage(PPropertyDescriptor.this.displayName));
            String mnemonicString = PViewerUtilities.getMessage(PPropertyDescriptor.this.displayName + ".mnemonic");
            if (mnemonicString != null && mnemonicString.length() == 1) {
                this.checkBox.setMnemonic(mnemonicString.charAt(0));
            }
            this.checkBox.setSelected(selected);
            this.checkBox.addFocusListener(PPropertyDescriptor.this.keepVisibleFocusListener);
            return this.checkBox;
        }

        public JPanel getPanel(Object[] args) {
            boolean selected = (Boolean)args[0];
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(3, 0, 0));
            panel.add(this.getCheckBox(selected));
            return panel;
        }

        public Boolean getValue() {
            return this.checkBox.isSelected();
        }

        public void setValue(Object value) {
            if (value instanceof String) {
                this.checkBox.setSelected(Boolean.valueOf((String)value));
            } else {
                this.checkBox.setSelected((Boolean)value);
            }
        }

        public boolean isValueValid(Object value) {
            if (value instanceof String) {
                String s = (String)value;
                return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false");
            }
            return value instanceof Boolean;
        }
    }
}

