/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.POCRQueueItem;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;

public class PProgressOCRDialog
extends JDialog
implements CMBGenericDocStateChangedListener {
    private static final long serialVersionUID = 1L;
    private JProgressBar progressBar;
    private int pageCount;
    private int failCount = 0;
    private int successCount = 0;
    private JLabel headingLabel;
    private JLabel trailingLabel;
    private JButton cancelButton;
    private static int PROGRESS_MIN = 0;
    private static int PROGRESS_MAX = 100;
    private CMBGenericDocViewer viewer;
    private ComponentOrientation compOri = null;
    private POCRQueueItem item;

    public PProgressOCRDialog(Frame owner, int pageCount, POCRQueueItem item, CMBGenericDocViewer viewer) throws HeadlessException {
        super(owner, PViewerUtilities.getMessage("progressOCRDialog.title"), true);
        this.pageCount = pageCount;
        this.item = item;
        this.viewer = viewer;
        this.initialize();
        this.pack();
        this.setResizable(false);
        this.setModal(false);
        this.setVisible(true);
    }

    private void initialize() {
        this.headingLabel = new JLabel(PViewerUtilities.getMessage("progressOCRDialog.headingInfo"));
        this.trailingLabel = new JLabel();
        this.cancelButton = new JButton(PViewerUtilities.getMessage("progressOCRDialog.button.Cancel"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel fieldPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        fieldPanel.add(this.headingLabel);
        this.progressBar = new JProgressBar(0, PROGRESS_MIN, this.pageCount);
        this.progressBar.setStringPainted(true);
        fieldPanel.add(this.progressBar);
        fieldPanel.add(this.trailingLabel);
        contentPane.add((Component)fieldPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        buttonPanel.add(this.cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PProgressOCRDialog.this.viewer.cancelOCR(PProgressOCRDialog.this.item.getDocument());
                PProgressOCRDialog.this.dispose();
            }
        });
        AbstractAction EscAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PProgressOCRDialog.this.dispose();
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        Object o1 = this.getRootPane().getInputMap().get(ks);
        this.getRootPane().getInputMap(2).put(ks, "escape");
        this.getRootPane().getActionMap().put("escape", EscAction);
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.applyComponentOrientation(this.getCompOri());
    }

    public ComponentOrientation getCompOri() {
        if (this.compOri == null) {
            boolean ltr = PViewerUtilities.isLeftToRight();
            this.compOri = ComponentOrientation.LEFT_TO_RIGHT;
            if (!ltr) {
                this.compOri = ComponentOrientation.RIGHT_TO_LEFT;
            }
        }
        return this.compOri;
    }

    private synchronized void addProgress(boolean isConfident) {
        if (isConfident) {
            ++this.successCount;
        } else {
            ++this.failCount;
        }
        int currPage = this.successCount + this.failCount;
        String progressMsg = PViewerUtilities.getMessage("progressORCDialog.progress", new Object[]{new Integer(currPage), this.pageCount});
        this.progressBar.setString(progressMsg);
        this.progressBar.setValue(currPage);
        if (this.failCount > 0) {
            String trailingMsg = PViewerUtilities.getMessage("progressOCRDialog.trailingInfo", new Object[]{this.failCount, currPage});
            this.trailingLabel.setText(trailingMsg);
        }
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void genericDocStateChanged(CMBGenericDocStateChangedEvent e) {
        if (e.getChangeType() == 23 && e.getDocument() == this.item.getDocument()) {
            try {
                boolean isConfident = e.getDocument().getPage(e.getCurrentPageNumber()).getOCRLetters().isOcrConfident();
                this.addProgress(isConfident);
                if (this.pageCount < e.getDocument().getPageCount() && this.successCount + this.failCount == this.pageCount) {
                    this.viewer.removeDocStateChangedListener(this);
                    this.disposeIfNoError();
                }
            }
            catch (IndexOutOfBoundsException e1) {
            }
            catch (IOException iOException) {}
        } else if (e.getChangeType() == 24 && e.getDocument() == this.item.getDocument()) {
            this.viewer.removeDocStateChangedListener(this);
            this.disposeIfNoError();
        }
    }

    void disposeIfNoError() {
        if (this.failCount == 0) {
            this.dispose();
        }
    }
}

