/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.POptionPane;
import com.ibm.mm.viewer.PPagePrintable;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.CancelablePrintJob;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

class PPrintQueueItem {
    private static Object printMutex = new Object();
    private CMBGenericDocViewer viewer = null;
    private PPagePrintable pagePrintable = null;
    private PrintService printService = null;
    private CancelablePrintJob cpj = null;
    private Book book = null;
    private PrinterJob pj = null;

    PPrintQueueItem(CMBGenericDocViewer viewer, PPagePrintable pagePrintable) {
        this.viewer = viewer;
        this.pagePrintable = pagePrintable;
        this.printService = null;
        this.cpj = null;
        this.pj = null;
    }

    PPrintQueueItem(CMBGenericDocViewer viewer, PPagePrintable pagePrintable, PrinterJob pj, Book book) {
        this.viewer = viewer;
        this.pagePrintable = pagePrintable;
        this.pj = pj;
        this.book = book;
        this.cpj = null;
        this.printService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executePrint() {
        if (this.pj != null) {
            CMBDocument document = this.pagePrintable.getPageModel().getDocument();
            Object object = printMutex;
            synchronized (object) {
                try {
                    this.viewer.fireCMBDocPrintStatusEvent(2, 1, this.pagePrintable.getNumberOfPagesToPrint(), null, document);
                    if (this.viewer.useNewPrintDialog) {
                        this.pj.print(this.pagePrintable.getAset());
                    } else {
                        this.pj.print();
                    }
                }
                catch (PrinterAbortException pae) {
                    if (pae.getCause() instanceof OutOfMemoryError) {
                        this.handleOutOfMemory();
                    } else {
                        System.out.println("Printing aborted");
                    }
                }
                catch (PrinterException exception) {
                    System.err.println(PViewerUtilities.getMessage("DocumentViewer.printError") + exception);
                }
                this.viewer.printQueue.currItemPrinting = null;
                this.viewer.fireCMBDocPrintStatusEvent(3, 1, this.pagePrintable.getNumberOfPagesToPrint(), null, document);
                this.pagePrintable.dispose();
            }
            return;
        }
        int pagesToPrint = this.pagePrintable.getNumberOfPagesToPrint();
        if (this.cpj == null) {
            this.cpj = (CancelablePrintJob)this.printService.createPrintJob();
        }
        this.pagePrintable.setCpj(this.cpj);
        SimpleDoc doc = new SimpleDoc(this.pagePrintable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        Object object = printMutex;
        synchronized (object) {
            CMBDocument document = this.pagePrintable.getPageModel().getDocument();
            this.viewer.fireCMBDocPrintStatusEvent(2, 1, this.pagePrintable.getNumberOfPagesToPrint(), this.cpj, document);
            try {
                this.cpj.print(doc, this.pagePrintable.getAset());
            }
            catch (PrintException exception) {
                Throwable exceptionCause = exception.getCause();
                if (exceptionCause != null && exceptionCause instanceof PrinterAbortException) {
                    if (exceptionCause.getCause() != null && exceptionCause.getCause() instanceof OutOfMemoryError) {
                        this.handleOutOfMemory();
                    } else {
                        System.out.println("Printing aborted");
                    }
                }
                System.err.println(PViewerUtilities.getMessage("DocumentViewer.printError") + exception);
            }
            this.viewer.printQueue.currItemPrinting = null;
            document = this.pagePrintable.getPageModel().getDocument();
            this.viewer.fireCMBDocPrintStatusEvent(3, 1, this.pagePrintable.getNumberOfPagesToPrint(), null, document);
            this.pagePrintable.dispose();
        }
    }

    void handleOutOfMemory() {
        this.viewer.printQueue.currItemPrinting = null;
        if (this.viewer.hasDocumentsPrinting()) {
            String text = PViewerUtilities.getMessage("DocumentViewer.cancelPrintMultiMessage") + "\n\n" + PViewerUtilities.getMessage("DocumentViewer.cancelPrintMultiCancelMessage");
            Font font = UIManager.getFont("Label.font");
            JTextArea textArea = new JTextArea(0, 50);
            textArea.setText(text);
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setFont(font);
            textArea.setBackground(UIManager.getColor("Label.background"));
            textArea.setFocusable(false);
            FontMetrics fm = textArea.getFontMetrics(font);
            int pw = textArea.getPreferredSize().width;
            int w = fm.stringWidth(text);
            int rows = (int)Math.ceil((w + pw) / pw);
            textArea.setRows(rows + 2);
            int option = POptionPane.showConfirmDialog(this.viewer, (Object)textArea, PViewerUtilities.getMessage("DocumentViewer.outOfMemoryErrorDialogTitle"), 0, 3, null);
            if (option == 0) {
                this.viewer.cancelAllPrintJobs();
            }
        } else {
            JOptionPane.showMessageDialog(null, PViewerUtilities.getMessage("DocumentViewer.outOfMemoryErrorMessage"), PViewerUtilities.getMessage("DocumentViewer.outOfMemoryErrorDialogTitle"), 0, null);
        }
    }

    void executeCancel() {
        if (this.pj != null) {
            this.pj.cancel();
            this.viewer.printQueue.currItemPrinting = null;
            return;
        }
        if (this.cpj != null) {
            try {
                this.cpj.cancel();
                this.viewer.printQueue.currItemPrinting = null;
                return;
            }
            catch (PrintException e) {
                System.err.println(PViewerUtilities.getMessage("DocumentViewer.printError") + e);
            }
        }
        CMBDocument document = this.pagePrintable.getPageModel().getDocument();
        this.viewer.fireCMBDocPrintStatusEvent(3, 1, this.pagePrintable.getNumberOfPagesToPrint(), null, document);
    }

    void dispose() {
        if (this.pagePrintable != null) {
            this.pagePrintable.dispose();
            this.pagePrintable = null;
        }
    }

    public PPagePrintable getPagePrintable() {
        return this.pagePrintable;
    }

    public Book getBook() {
        return this.book;
    }

    public PrinterJob getPj() {
        return this.pj;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pagePrintable.setPageFormat(pageFormat);
    }

    public PageFormat getPageFormat() {
        return this.pagePrintable.getPageFormat(0);
    }

    public void setPrintService(PrintService printService) throws PrinterException {
        this.printService = printService;
        if (this.pj != null) {
            this.pj.setPrintService(printService);
        }
    }
}

