/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.PPrintQueueItem;
import java.util.Enumeration;
import java.util.Vector;

class PPrintQueue {
    Vector items = new Vector();
    PPrintQueueItem currItemPrinting = null;
    Thread printThread = null;

    PPrintQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAll() {
        PPrintQueue pPrintQueue = this;
        synchronized (pPrintQueue) {
            for (PPrintQueueItem r : this.items) {
                r.executeCancel();
            }
            this.items.removeAllElements();
            if (this.currItemPrinting != null) {
                this.cancel(this.currItemPrinting);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(CMBDocument doc) {
        PPrintQueue pPrintQueue = this;
        synchronized (pPrintQueue) {
            Vector foundItems = this.find(doc);
            Enumeration en = foundItems.elements();
            while (en.hasMoreElements()) {
                PPrintQueueItem r = (PPrintQueueItem)en.nextElement();
                this.cancel(r);
            }
        }
    }

    private void cancel(PPrintQueueItem r) {
        if (this.items.contains(r)) {
            this.items.remove(r);
            r.executeCancel();
        } else {
            r.executeCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector find(CMBDocument doc) {
        Vector<PPrintQueueItem> foundItems = new Vector<PPrintQueueItem>();
        PPrintQueue pPrintQueue = this;
        synchronized (pPrintQueue) {
            CMBDocument rDoc;
            if (this.currItemPrinting != null && (rDoc = this.currItemPrinting.getPagePrintable().getPageModel().getDocument()).equals(doc)) {
                foundItems.add(this.currItemPrinting);
            }
            Enumeration en = this.items.elements();
            while (en.hasMoreElements()) {
                CMBDocument rDoc2;
                PPrintQueueItem r = (PPrintQueueItem)en.nextElement();
                if (r.getPagePrintable() == null || !(rDoc2 = r.getPagePrintable().getPageModel().getDocument()).equals(doc)) continue;
                foundItems.add(r);
            }
        }
        return foundItems;
    }

    boolean hasDocumentsPrinting() {
        if (this.currItemPrinting != null) {
            return true;
        }
        return !this.items.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDocumentPrinting(CMBDocument doc) {
        PPrintQueue pPrintQueue = this;
        synchronized (pPrintQueue) {
            CMBDocument rDoc;
            if (this.currItemPrinting != null && (rDoc = this.currItemPrinting.getPagePrintable().getPageModel().getDocument()).equals(doc)) {
                return true;
            }
            Enumeration en = this.items.elements();
            while (en.hasMoreElements()) {
                CMBDocument rDoc2;
                PPrintQueueItem r = (PPrintQueueItem)en.nextElement();
                if (r.getPagePrintable() == null || !(rDoc2 = r.getPagePrintable().getPageModel().getDocument()).equals(doc)) continue;
                return true;
            }
            return false;
        }
    }

    private synchronized void checkToStartThread() {
        if (this.printThread == null || !this.printThread.isAlive()) {
            this.printThread = new Thread((Runnable)new Worker(), "PPrintQueue");
            try {
                this.printThread.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.printThread.start();
        }
    }

    private synchronized boolean checkToEndThread() {
        if (this.items.isEmpty()) {
            this.printThread.interrupt();
            this.printThread = null;
            return true;
        }
        return false;
    }

    synchronized void put(PPrintQueueItem r) {
        this.checkToStartThread();
        this.items.add(r);
    }

    private synchronized PPrintQueueItem take() {
        if (this.items.isEmpty()) {
            return null;
        }
        this.currItemPrinting = (PPrintQueueItem)this.items.firstElement();
        return (PPrintQueueItem)this.items.remove(0);
    }

    private class Worker
    implements Runnable {
        private boolean done;

        private Worker() {
        }

        public void run() {
            this.done = false;
            while (!this.done) {
                PPrintQueueItem r = PPrintQueue.this.take();
                if (r == null) {
                    return;
                }
                r.executePrint();
                this.done = PPrintQueue.this.checkToEndThread();
            }
        }
    }
}

