/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

class PPrintDialog
extends JDialog {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBGenericDocViewer viewer = null;
    private Hashtable printProperties = null;
    PageFormat pageFormat = null;
    boolean bIncludeAnno = false;
    int zoomOptionIndex = 0;
    String zoomOption = null;
    private int iFitPage = 0;
    int result = 0;
    short nZoomType = 0;
    boolean fComponentsAdjusted = false;
    private JPanel optionBox = null;
    private JPanel zoomBox = null;
    private JPanel buttonBox = null;
    private JLabel optionLabel = null;
    private JCheckBox includeAnnoCheckBox = null;
    private JLabel zoomLabel = null;
    private JComboBox zoomCombo = null;
    JButton okButton = null;
    JButton pageSettingsButton = null;
    JButton cancelButton = null;

    PPrintDialog(Frame parent, String title, boolean modal, CMBGenericDocViewer viewer) {
        super(parent, title, modal);
        int defaultIndex;
        this.viewer = viewer;
        boolean ltr = PViewerUtilities.isLeftToRight();
        ComponentOrientation compOri = ComponentOrientation.LEFT_TO_RIGHT;
        float alignmentX = 0.0f;
        if (!ltr) {
            compOri = ComponentOrientation.RIGHT_TO_LEFT;
            alignmentX = 1.0f;
        }
        int strutWidth = 16;
        int strutHeight = 8;
        this.setPrintProperties(this.printProperties);
        JPanel printPanel = new JPanel();
        printPanel.setLayout(new BoxLayout(printPanel, 1));
        printPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.optionBox = new JPanel();
        this.zoomBox = new JPanel();
        this.buttonBox = new JPanel();
        this.optionBox.setLayout(new BoxLayout(this.optionBox, 1));
        this.optionBox.setAlignmentX(alignmentX);
        this.optionBox.setBorder(new EmptyBorder(5, 5, 2, 5));
        this.optionLabel = new JLabel(PViewerUtilities.getMessage("printDialog.options.Title"));
        this.optionLabel.setAlignmentX(alignmentX);
        this.optionLabel.setComponentOrientation(compOri);
        this.optionBox.add(this.optionLabel);
        this.includeAnnoCheckBox = new JCheckBox(PViewerUtilities.getMessage("printDialog.options.AnnoLabel"));
        this.includeAnnoCheckBox.setAlignmentX(alignmentX);
        this.includeAnnoCheckBox.setMnemonic(PViewerUtilities.getMessage("printDialog.options.AnnoLabel.mnemonic").charAt(0));
        this.includeAnnoCheckBox.setComponentOrientation(compOri);
        this.optionBox.add(this.includeAnnoCheckBox);
        printPanel.add(this.optionBox);
        this.zoomBox.setLayout(new BoxLayout(this.zoomBox, 1));
        this.zoomBox.setAlignmentX(alignmentX);
        this.zoomBox.setBorder(new EmptyBorder(2, 5, 5, 5));
        this.zoomLabel = new JLabel(PViewerUtilities.getMessage("DocumentViewer.ZoomCustomMessage"));
        this.zoomLabel.setDisplayedMnemonic(PViewerUtilities.getMessage("DocumentViewer.ZoomCustomMessage.mnemonic").charAt(0));
        this.zoomLabel.setAlignmentX(alignmentX);
        this.zoomLabel.setComponentOrientation(compOri);
        this.zoomBox.add(this.zoomLabel);
        Object[] zoomOptions = this.getZoomOptions(true);
        if (zoomOptions == null || zoomOptions.length < 1) {
            System.out.println(PViewerUtilities.getMessage("DocumentViewer.InvalidPropertyValue", new Object[]{"printDialog.ZoomOptions.items"}));
            zoomOptions = this.getZoomOptions(false);
        }
        this.zoomCombo = new JComboBox<Object>(zoomOptions);
        this.zoomLabel.setLabelFor(this.zoomCombo);
        this.zoomCombo.setAlignmentX(alignmentX);
        this.zoomCombo.setComponentOrientation(compOri);
        ListCellRenderer renderer = this.zoomCombo.getRenderer();
        if (renderer instanceof BasicComboBoxRenderer) {
            BasicComboBoxRenderer r = (BasicComboBoxRenderer)renderer;
            r.setComponentOrientation(compOri);
        }
        if ((defaultIndex = this.zoomCombo.getItemCount() - 1) >= this.iFitPage) {
            defaultIndex = this.iFitPage;
        }
        this.zoomCombo.setSelectedIndex(defaultIndex);
        this.zoomOptionIndex = this.zoomCombo.getSelectedIndex();
        this.zoomOption = (String)this.zoomCombo.getSelectedItem();
        this.zoomLabel.setLabelFor(this.zoomCombo);
        this.zoomBox.add(this.zoomCombo);
        printPanel.add(this.zoomBox);
        this.buttonBox.setLayout(new BoxLayout(this.buttonBox, 0));
        this.buttonBox.setAlignmentX(alignmentX);
        this.buttonBox.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel buttonLeftPanel = new JPanel();
        buttonLeftPanel.setLayout(new FlowLayout(0));
        JPanel buttonRightPanel = new JPanel();
        buttonRightPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(PViewerUtilities.getMessage("printDialog.button.OK"));
        this.cancelButton = new JButton(PViewerUtilities.getMessage("printDialog.button.Cancel"));
        this.pageSettingsButton = new JButton(PViewerUtilities.getMessage("printDialog.button.PageSetup"));
        buttonLeftPanel.add(this.pageSettingsButton);
        if (ltr) {
            buttonRightPanel.add(this.okButton);
            buttonRightPanel.add(this.cancelButton);
            this.buttonBox.add(buttonLeftPanel);
            this.buttonBox.add(buttonRightPanel);
        } else {
            buttonRightPanel.add(this.cancelButton);
            buttonRightPanel.add(this.okButton);
            this.buttonBox.add(buttonRightPanel);
            this.buttonBox.add(buttonLeftPanel);
        }
        printPanel.add(this.buttonBox);
        this.pageSettingsButton.setMnemonic(PViewerUtilities.getMessage("printDialog.button.PageSetup.mnemonic").charAt(0));
        this.getContentPane().add(printPanel);
        this.pack();
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        AbstractAction EscAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PPrintDialog.this.result = 0;
                PPrintDialog.this.setVisible(false);
            }
        };
        this.getRootPane().registerKeyboardAction(EscAction, KeyStroke.getKeyStroke(27, 0), 2);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PPrintDialog.this.onOK();
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PPrintDialog.this.onCancel();
            }
        });
        this.pageSettingsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PPrintDialog.this.onPageSetup();
            }
        });
        this.zoomCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PPrintDialog.this.onZoomComboSelectionChanged(e);
            }
        });
    }

    private Object[] getZoomOptions(boolean custom) {
        Vector<String> vOptions = new Vector<String>();
        Object[] zoomOptions = null;
        String items = null;
        items = custom ? this.viewer.getConfigPropertyOrMessage("printDialog.ZoomOptions.items") : PViewerUtilities.getMessage("printDialog.ZoomOptions.items");
        String itemKey = null;
        String itemName = null;
        this.iFitPage = 0;
        if (items != null) {
            StringTokenizer tok = new StringTokenizer(items, ",");
            int count = tok.countTokens();
            zoomOptions = new Object[count];
            while (tok.hasMoreTokens()) {
                itemKey = tok.nextToken();
                itemName = custom ? this.viewer.getConfigPropertyOrMessage(itemKey) : PViewerUtilities.getMessage(itemKey);
                if (itemName != null) {
                    if (itemKey.equalsIgnoreCase("zoom.item.FitPage")) {
                        this.iFitPage = vOptions.size();
                    }
                    vOptions.add(itemName);
                    continue;
                }
                System.out.println(PViewerUtilities.getMessage("DocumentViewer.InvalidPropertyValue", new Object[]{itemKey}));
            }
            zoomOptions = vOptions.toArray();
        }
        return zoomOptions;
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    PPrintDialog(String title, CMBGenericDocViewer viewer) {
        this(viewer);
    }

    PPrintDialog(Frame parent, String title, PageFormat pageFormat, CMBGenericDocViewer viewer) {
        this(parent, title, true, viewer);
        this.pageFormat = pageFormat;
    }

    PPrintDialog(CMBGenericDocViewer viewer) {
        this((Frame)null, PViewerUtilities.getMessage("printDialog.Title"), true, viewer);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void PPrintDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    public void setPrintProperties(Hashtable printProp) {
        if (printProp != null) {
            this.printProperties = printProp;
        } else {
            this.setDefaultPrintProperties();
        }
    }

    public Hashtable getPrintProperties() {
        if (this.printProperties == null) {
            this.setDefaultPrintProperties();
        }
        return this.printProperties;
    }

    public void setDefaultPrintProperties() {
        this.printProperties = new Hashtable();
    }

    private void onOK() {
        this.result = 1;
        this.bIncludeAnno = this.includeAnnoCheckBox.isSelected();
        this.setVisible(false);
    }

    private void onCancel() {
        this.result = 0;
        this.setVisible(false);
    }

    private void onPageSetup() {
        PrinterJob pjDefault = PrinterJob.getPrinterJob();
        if (this.pageFormat == null) {
            this.pageFormat = pjDefault.defaultPage();
        }
        this.pageFormat = pjDefault.pageDialog(this.pageFormat);
    }

    private void onZoomComboSelectionChanged(ActionEvent e) {
        this.zoomOptionIndex = this.zoomCombo.getSelectedIndex();
        this.zoomOption = (String)this.zoomCombo.getSelectedItem();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == PPrintDialog.this) {
                PPrintDialog.this.PPrintDialog_WindowClosing(event);
            }
        }
    }
}

