/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBGenericDocHelpEvent;
import com.ibm.mm.viewer.CMBGenericDocHelpListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBPreferenceSet;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;

class PPreferencesDialog
extends JDialog
implements TreeSelectionListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    static final String preferencesFileSuffix = PViewerUtilities.getMessage("preferenceDialog.preferencesFileFilter.suffix");
    private static final String VIEWER_CONFIG_DELIM = ",";
    protected Vector docHelpListeners = new Vector();
    private ComponentOrientation compOri = null;
    private boolean needToRequestFocus = true;
    private JTree tree;
    private JPanel setPanel;
    JScrollPane treeView;
    JScrollPane setView;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JButton importButton = null;
    private JButton exportButton = null;
    private JButton helpButton = null;
    private Hashtable preferenceSets = null;
    private Properties configProperties = null;
    private CMBGenericDocViewer viewer = null;
    private CMBPreferenceSet currentSet;
    JFileChooser chooser;

    PPreferencesDialog(Frame owner, CMBGenericDocViewer viewer, Properties properties, DefaultMutableTreeNode top) {
        super(owner, PViewerUtilities.getMessage("preference.Title"), true);
        this.setName("Preferences");
        this.configProperties = properties;
        this.viewer = viewer;
        this.setDefaultCloseOperation(1);
        this.tree = new JTree(top);
        this.tree.setName("PreferenceSetTree");
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        this.tree.setCellRenderer(renderer);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.tree.addTreeSelectionListener(this);
    }

    private JPanel makeCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.treeView = new JScrollPane(this.tree);
        this.treeView.setName("TreeView");
        this.setPanel = new JPanel();
        this.setPanel.setName("SelectedPreferenceSetPanel");
        this.setPanel.setLayout(new BorderLayout());
        this.setView = new JScrollPane(this.setPanel);
        this.setView.setName("SetView");
        panel.add((Component)this.treeView, "Before");
        panel.add((Component)this.setView, "Center");
        AbstractAction SwitchPaneAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JScrollPane left = PPreferencesDialog.this.treeView;
                JScrollPane right = PPreferencesDialog.this.setView;
                KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Component focus = manager.getFocusOwner();
                Component focusOn = this.getNextSide(PPreferencesDialog.this, focus);
                if (focusOn != null) {
                    if (focus != null && (SwingUtilities.isDescendingFrom(focus, left) && SwingUtilities.isDescendingFrom(focusOn, left) || SwingUtilities.isDescendingFrom(focus, right) && SwingUtilities.isDescendingFrom(focusOn, right))) {
                        return;
                    }
                    manager.focusNextComponent(focusOn);
                }
            }

            private Component getNextSide(PPreferencesDialog d, Component focus) {
                JScrollPane left = d.treeView;
                JScrollPane right = d.setView;
                JScrollPane next = null;
                if (focus != null && SwingUtilities.isDescendingFrom(focus, left) && right != null && (next = right) != null) {
                    return next;
                }
                next = left;
                if (next == null) {
                    next = right;
                }
                return next;
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(117, 0);
        Object o1 = this.getRootPane().getInputMap().get(ks);
        panel.getInputMap(1).put(ks, "switchpane");
        panel.getActionMap().put("switchpane", SwitchPaneAction);
        return panel;
    }

    Dimension getMaxViewPreferredSize() {
        Dimension maxSize = new Dimension(0, 0);
        Enumeration<TreeNode> en = this.viewer.getPreferenceSets().preorderEnumeration();
        while (en.hasMoreElements()) {
            CMBPreferenceSet ps;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            if (!(node.getUserObject() instanceof CMBPreferenceSet) || (ps = (CMBPreferenceSet)node.getUserObject()).getComponent() == null) continue;
            Dimension psSize = ps.getComponent().getPreferredSize();
            if (psSize.height > maxSize.height) {
                maxSize.height = psSize.height;
            }
            if (psSize.width <= maxSize.width) continue;
            maxSize.width = psSize.width;
        }
        return maxSize;
    }

    void buildLayout() {
        this.getContentPane().add("Center", this.makeCenterPanel());
        this.getContentPane().add("South", this.makeButtonPanel());
        this.applyComponentOrientation(this.getCompOri());
        AbstractAction EscAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PPreferencesDialog.this.dispatchEvent(new WindowEvent(PPreferencesDialog.this, 201));
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        Object o1 = this.getRootPane().getInputMap().get(ks);
        this.getRootPane().getInputMap(2).put(ks, "escape");
        this.getRootPane().getActionMap().put("escape", EscAction);
        this.setPanel.setPreferredSize(this.getMaxViewPreferredSize());
        this.tree.setSelectionRow(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent we) {
                PPreferencesDialog.this.requestFocus();
            }
        });
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.makeLeftButtonPanel(), "Before");
        panel.add((Component)this.makeRightButtonPanel(), "After");
        return panel;
    }

    private JPanel makeLeftButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(4));
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 0, 5, 5));
        p2.add(this.getImportButton());
        p2.add(this.getExportButton());
        panel.add((Component)p2, "Before");
        panel.setComponentOrientation(this.getCompOri());
        return panel;
    }

    private JPanel makeRightButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(4));
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 0, 5, 5));
        p2.add(this.getOkButton());
        p2.add(this.getCancelButton());
        if (!this.docHelpListeners.isEmpty()) {
            p2.add(this.getHelpButton());
        }
        panel.add((Component)p2, "After");
        panel.setComponentOrientation(this.getCompOri());
        return panel;
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (nodeInfo instanceof CMBPreferenceSet) {
            CMBPreferenceSet set = (CMBPreferenceSet)nodeInfo;
            this.displaySet(set);
        } else {
            this.currentSet = null;
            this.setPanel.removeAll();
            this.setPanel.repaint();
        }
    }

    private void displaySet(CMBPreferenceSet set) {
        if (set != null) {
            this.currentSet = set;
            this.setPanel.removeAll();
            this.setPanel.repaint();
            if (set.getComponent() != null) {
                this.setPanel.add(set.getComponent());
                this.setPanel.revalidate();
                this.setPanel.repaint();
            }
        }
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(PViewerUtilities.getMessage("preference.button.Ok"));
            this.getRootPane().setDefaultButton(this.okButton);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PPreferencesDialog.this.okAction();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(PViewerUtilities.getMessage("preference.button.Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PPreferencesDialog.this.setVisible(false);
                    PPreferencesDialog.this.dispatchEvent(new WindowEvent(PPreferencesDialog.this, 201));
                }
            });
        }
        return this.cancelButton;
    }

    private JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton(PViewerUtilities.getMessage("preference.button.Help"));
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PPreferencesDialog.this.fireCMBDocHelpEvent();
                }
            });
        }
        return this.helpButton;
    }

    private JButton getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new JButton(PViewerUtilities.getMessage("preference.button.Export"));
            this.exportButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PPreferencesDialog.this.exportAction();
                }
            });
        }
        return this.exportButton;
    }

    private void okAction() {
        Enumeration<TreeNode> en = this.viewer.preferenceSets.preorderEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            if (!(node.getUserObject() instanceof CMBPreferenceSet)) continue;
            CMBPreferenceSet ps = (CMBPreferenceSet)node.getUserObject();
            ps.applyAction();
            this.viewer.updateUserPreferencesFromPreferenceSet(ps);
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void exportAction() {
        String methodName = "exportAction";
        this.chooser = new JFileChooser(System.getProperty("user.home"));
        this.chooser.setFileSelectionMode(0);
        PreferencesFileFilter fileFilter = new PreferencesFileFilter();
        this.chooser.addChoosableFileFilter(fileFilter);
        this.chooser.setFileFilter(fileFilter);
        this.chooser.setComponentOrientation(this.getCompOri());
        int ret = this.chooser.showSaveDialog(this);
        if (ret == 0) {
            int option;
            String filename = this.chooser.getSelectedFile().getAbsolutePath();
            if (this.chooser.getFileFilter() instanceof PreferencesFileFilter && !filename.endsWith(preferencesFileSuffix)) {
                filename = filename + "." + preferencesFileSuffix;
            }
            this.chooser = null;
            File saveFile = new File(filename);
            if (saveFile.exists() && (option = JOptionPane.showConfirmDialog(this, PViewerUtilities.getMessage("DocumentViewer.overwriteWarning.message", new Object[]{filename}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0)) == 1) {
                return;
            }
            Properties saveProperties = new Properties();
            Enumeration<TreeNode> en = this.viewer.preferenceSets.preorderEnumeration();
            while (en.hasMoreElements()) {
                CMBPreferenceSet ps;
                Properties psProperties;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
                if (!(node.getUserObject() instanceof CMBPreferenceSet) || (psProperties = (ps = (CMBPreferenceSet)node.getUserObject()).exportAction()) == null) continue;
                Enumeration<?> names = psProperties.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    saveProperties.setProperty(name, psProperties.getProperty(name));
                }
            }
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(filename));
            }
            catch (FileNotFoundException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
            this.viewer.updateUserPreferencesFromProperties(saveProperties);
            try {
                this.viewer.exportUserPreferences(os);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, PViewerUtilities.getMessage("preferenceDialog.cannotBeExported", new Object[]{filename}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
            }
        }
        this.chooser = null;
    }

    private JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton(PViewerUtilities.getMessage("preference.button.Import"));
            this.importButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PPreferencesDialog.this.importAction();
                }
            });
        }
        return this.importButton;
    }

    private void importAction() {
        this.chooser = new JFileChooser(System.getProperty("user.home"));
        this.chooser.setFileSelectionMode(0);
        PreferencesFileFilter fileFilter = new PreferencesFileFilter();
        this.chooser.addChoosableFileFilter(fileFilter);
        this.chooser.setFileFilter(fileFilter);
        this.chooser.setComponentOrientation(this.getCompOri());
        int ret = this.chooser.showOpenDialog(this);
        if (ret == 0) {
            String filename = this.chooser.getSelectedFile().getAbsolutePath();
            this.chooser = null;
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(filename));
                CMBGenericDocViewer.importUserPreferences(is);
                Properties importProperties = this.viewer.getUserProperties(null);
                Enumeration<TreeNode> en = this.viewer.preferenceSets.preorderEnumeration();
                while (en.hasMoreElements()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
                    if (!(node.getUserObject() instanceof CMBPreferenceSet)) continue;
                    CMBPreferenceSet ps = (CMBPreferenceSet)node.getUserObject();
                    ps.importAction(importProperties);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, PViewerUtilities.getMessage("preferenceDialog.cannotBeImported", new Object[]{filename}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
            }
        }
        this.chooser = null;
    }

    void setButtonStates() {
    }

    private ComponentOrientation getCompOri() {
        if (this.compOri == null) {
            boolean ltr = PViewerUtilities.isLeftToRight();
            this.compOri = ComponentOrientation.LEFT_TO_RIGHT;
            if (!ltr) {
                this.compOri = ComponentOrientation.RIGHT_TO_LEFT;
            }
        }
        return this.compOri;
    }

    public void addDocHelpListener(CMBGenericDocHelpListener listener) {
        this.docHelpListeners.addElement(listener);
    }

    public void removeDocHelpListener(CMBGenericDocHelpListener listener) {
        this.docHelpListeners.removeElement(listener);
    }

    private void fireCMBDocHelpEvent() {
        CMBGenericDocHelpEvent docHelpEvent = new CMBGenericDocHelpEvent(this);
        for (int i = 0; i < this.docHelpListeners.size(); ++i) {
            CMBGenericDocHelpListener listener = (CMBGenericDocHelpListener)this.docHelpListeners.elementAt(i);
            listener.onHelp(docHelpEvent);
        }
    }

    public void dispose() {
        if (this.currentSet != null) {
            this.currentSet.dispose();
        }
        if (this.chooser != null) {
            this.chooser.cancelSelection();
        }
        super.dispose();
    }

    class PreferencesFileFilter
    extends FileFilter {
        PreferencesFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String suffix = this.getSuffix(f);
            return suffix != null && suffix.equals(preferencesFileSuffix);
        }

        public String getSuffix(File f) {
            String suffix = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                suffix = s.substring(i + 1);
            }
            return suffix;
        }

        public String getDescription() {
            return PViewerUtilities.getMessage("preferenceDialog.preferencesFileFilter.description");
        }
    }
}

