/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBPreferenceSet;
import com.ibm.mm.viewer.PParentPreferenceSet;
import com.ibm.mm.viewer.PPreferenceSet;
import com.ibm.mm.viewer.PPreferenceSetAnnotation;
import com.ibm.mm.viewer.PPreferenceSetAnnotationCommon;
import com.ibm.mm.viewer.PPreferenceSetAppearanceDocIndicator;
import com.ibm.mm.viewer.PPreferenceSetGeneralCommon;
import com.ibm.mm.viewer.PPreferenceSetGeneralDocument;
import com.ibm.mm.viewer.PPreferenceSetGeneralThumbnails;
import com.ibm.mm.viewer.PPreferenceSetGeneralToolbars;
import com.ibm.mm.viewer.PPreferenceSetPrinting;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBArrowAnnotation;
import com.ibm.mm.viewer.annotation.CMBCircleAnnotation;
import com.ibm.mm.viewer.annotation.CMBHighlightAnnotation;
import com.ibm.mm.viewer.annotation.CMBLineAnnotation;
import com.ibm.mm.viewer.annotation.CMBNoteAnnotation;
import com.ibm.mm.viewer.annotation.CMBPenAnnotation;
import com.ibm.mm.viewer.annotation.CMBRectAnnotation;
import com.ibm.mm.viewer.annotation.CMBStampAnnotation;
import com.ibm.mm.viewer.annotation.CMBTextAnnotation;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;

class PPreferenceSetsBuilder {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private static final String VIEWER_CONFIG_DELIM = ",";

    PPreferenceSetsBuilder() {
    }

    static DefaultMutableTreeNode createPreferenceTree(Properties properties, CMBGenericDocViewer viewer) {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Root");
        Object category = null;
        if (properties == null) {
            System.out.println(PViewerUtilities.getMessage("DocumentViewer.configPropertiesNotSet"));
            return null;
        }
        String categories = properties.getProperty("preference.elements");
        if (categories != null) {
            StringTokenizer tokCategory = new StringTokenizer(categories, VIEWER_CONFIG_DELIM);
            while (tokCategory.hasMoreTokens()) {
                String categoryName = tokCategory.nextToken();
                if (!categoryName.equalsIgnoreCase("annotation") && !categoryName.equalsIgnoreCase("general") && !categoryName.equalsIgnoreCase("custom")) continue;
                PPreferenceSetsBuilder.createCategory(top, categoryName, properties, viewer);
            }
        }
        return top;
    }

    static void createCategory(DefaultMutableTreeNode top, String categoryName, Properties properties, CMBGenericDocViewer viewer) {
        DefaultMutableTreeNode category = null;
        String parentElements = properties.getProperty("preference." + categoryName);
        String childElements = properties.getProperty("preference." + categoryName + ".elements");
        if (childElements == null) {
            if (parentElements == null) {
                System.out.println(PViewerUtilities.getMessage("DocumentViewer.InvalidPropertyValue", new Object[]{"preference." + categoryName}));
            } else {
                PParentPreferenceSet parentSet = new PParentPreferenceSet("preference.set." + categoryName + ".title", viewer);
                parentSet.viewer = viewer;
                category = new DefaultMutableTreeNode(parentSet);
                top.add(category);
                PPreferenceSetsBuilder.addParentElements(categoryName, parentSet, parentElements, viewer);
            }
        } else if (parentElements == null) {
            category = new DefaultMutableTreeNode(PViewerUtilities.getMessage("preference.set." + categoryName + ".title"));
            top.add(category);
            PPreferenceSetsBuilder.createCategoryWithChildren(categoryName, category, childElements, viewer);
        } else {
            PParentPreferenceSet parentSet = new PParentPreferenceSet("preference.set." + categoryName + ".title", viewer);
            parentSet.viewer = viewer;
            category = new DefaultMutableTreeNode(parentSet);
            top.add(category);
            PPreferenceSetsBuilder.addParentElements(categoryName, parentSet, parentElements, viewer);
            PPreferenceSetsBuilder.createCategoryWithChildren(categoryName, category, childElements, viewer);
        }
    }

    static void createCategoryWithChildren(String categoryName, DefaultMutableTreeNode category, String pages, CMBGenericDocViewer viewer) {
        StringTokenizer tokPages = new StringTokenizer(pages, VIEWER_CONFIG_DELIM);
        CMBPreferenceSet ps = null;
        DefaultMutableTreeNode page = null;
        while (tokPages.hasMoreTokens()) {
            String pageName = tokPages.nextToken();
            ps = PPreferenceSetsBuilder.getPreferenceSetFor(categoryName, pageName, 3L, viewer);
            page = new DefaultMutableTreeNode(ps);
            category.add(page);
        }
    }

    static void addParentElements(String categoryName, PParentPreferenceSet parentSet, String elements, CMBGenericDocViewer viewer) {
        StringTokenizer tokElements = new StringTokenizer(elements, VIEWER_CONFIG_DELIM);
        CMBPreferenceSet elementSet = null;
        while (tokElements.hasMoreTokens()) {
            String elementName = tokElements.nextToken();
            elementSet = PPreferenceSetsBuilder.getPreferenceSetFor(categoryName, elementName, 0L, viewer);
            parentSet.addChildPreferenceSet(elementSet);
        }
        parentSet.createView(3L);
    }

    static CMBPreferenceSet getPreferenceSetFor(String categoryName, String pageName, long buttonFlags, CMBGenericDocViewer viewer) {
        CMBPreferenceSet ps = null;
        if (categoryName.equalsIgnoreCase("general")) {
            if (pageName.equalsIgnoreCase("ps.general.common")) {
                ps = new PPreferenceSetGeneralCommon(pageName, "preference.set.general.title", viewer);
            }
            if (pageName.equalsIgnoreCase("ps.document")) {
                ps = new PPreferenceSetGeneralDocument(pageName, "preference.set.document.title", viewer);
            } else if (pageName.equalsIgnoreCase("ps.toolbars")) {
                ps = new PPreferenceSetGeneralToolbars(pageName, "preference.set.toolbars.title", viewer);
            } else if (pageName.equalsIgnoreCase("ps.thumbnails")) {
                ps = new PPreferenceSetGeneralThumbnails(pageName, "preference.set.thumbnails.title", viewer);
            } else if (pageName.equalsIgnoreCase("ps.printing")) {
                ps = new PPreferenceSetPrinting(pageName, "preference.set.printing.title", viewer);
            } else if (pageName.equalsIgnoreCase("ps.appearance.doc.indicator")) {
                ps = new PPreferenceSetAppearanceDocIndicator(pageName, "preference.set.appearance.doc.indicator.title", viewer);
            }
            if (ps != null) {
                ((PPreferenceSet)ps).createView(buttonFlags);
            }
        } else if (categoryName.equalsIgnoreCase("annotation")) {
            if (pageName.equalsIgnoreCase("ps.arrow")) {
                ps = new PPreferenceSetAnnotation(pageName, "preference.item.arrow", viewer, new CMBArrowAnnotation());
            } else if (pageName.equalsIgnoreCase("ps.circle")) {
                ps = new PPreferenceSetAnnotation(pageName, "preference.item.circle", viewer, new CMBCircleAnnotation());
            } else if (pageName.equalsIgnoreCase("ps.highlight")) {
                ps = new PPreferenceSetAnnotation(pageName, "preference.item.highlight", viewer, new CMBHighlightAnnotation());
            } else if (pageName.equalsIgnoreCase("ps.line")) {
                ps = new PPreferenceSetAnnotation(pageName, "preference.item.line", viewer, new CMBLineAnnotation());
            } else if (pageName.equalsIgnoreCase("ps.note")) {
                ps = new PPreferenceSetAnnotation(pageName, "preference.item.note", viewer, new CMBNoteAnnotation());
            } else if (pageName.equalsIgnoreCase("ps.pen")) {
                ps = new PPreferenceSetAnnotation(pageName, "preference.item.pen", viewer, new CMBPenAnnotation());
            } else if (pageName.equalsIgnoreCase("ps.rectangle")) {
                ps = new PPreferenceSetAnnotation(pageName, "preference.item.rectangle", viewer, new CMBRectAnnotation());
            } else if (pageName.equalsIgnoreCase("ps.text")) {
                ps = new PPreferenceSetAnnotation(pageName, "preference.item.text", viewer, new CMBTextAnnotation());
            } else if (pageName.equalsIgnoreCase("ps.stamp")) {
                ps = new PPreferenceSetAnnotation(pageName, "preference.item.stamp", viewer, new CMBStampAnnotation());
            } else if (pageName.equalsIgnoreCase("ps.annotation.common")) {
                ps = new PPreferenceSetAnnotationCommon(pageName, "preference.set.annotation.title", viewer);
            }
            if (ps != null) {
                ((PPreferenceSet)ps).createView(buttonFlags);
            }
        } else if (categoryName.equalsIgnoreCase("custom")) {
            ps = (CMBPreferenceSet)viewer.customPreferenceSets.get(pageName);
        }
        return ps;
    }
}

