/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBPreferenceSet;
import com.ibm.mm.viewer.CMBPreferenceSetView;
import com.ibm.mm.viewer.CMBViewerToolbar;
import com.ibm.mm.viewer.PPreferenceSet;
import com.ibm.mm.viewer.PPropertyDescriptor;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;

class PPreferenceSetGeneralToolbars
extends PPreferenceSet {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private long savedButtonFlags = 0L;
    private Hashtable myToolbars = new Hashtable();

    PPreferenceSetGeneralToolbars(String name, String displayName, CMBGenericDocViewer viewer) {
        super(name, displayName, viewer);
    }

    void createView(long buttonFlags) {
        PPreferenceSetToolbarsView view = new PPreferenceSetToolbarsView(this, buttonFlags);
        this.setComponent(view);
        this.savedButtonFlags = buttonFlags;
    }

    void updateView() {
        CMBPreferenceSetView psView = this.getComponent();
        if (psView.getParent() != null) {
            Container c = psView.getParent();
            Component[] components = c.getComponents();
            int index = -1;
            for (int i = 0; i < components.length; ++i) {
                if (!components[i].equals(psView)) continue;
                index = i;
            }
            c.remove(psView);
            this.createPropertyDescrs();
            this.createView(this.savedButtonFlags);
            if (index != -1) {
                c.add((Component)this.getComponent(), index);
            } else {
                c.add(this.getComponent());
            }
            c.validate();
        }
    }

    void getToolbars() {
        this.myToolbars = new Hashtable();
        JToolBar[] toolbars = this.viewer.getAllToolbars();
        for (int i = 0; i < toolbars.length; ++i) {
            MyToolbar tb = new MyToolbar();
            tb.keyName = this.viewer.getToolBarName(toolbars[i]);
            tb.displayName = toolbars[i].getName();
            if (tb.displayName == null) {
                tb.displayName = tb.keyName;
            }
            tb.toolbar = (CMBViewerToolbar)this.viewer.getToolBar(tb.keyName);
            this.myToolbars.put(tb.keyName, tb);
        }
    }

    void createPropertyDescrs() {
        this.getToolbars();
        Enumeration en = this.myToolbars.elements();
        Vector<PPropertyDescriptor> pds = new Vector<PPropertyDescriptor>();
        while (en.hasMoreElements()) {
            MyToolbar tb = (MyToolbar)en.nextElement();
            String showMsgKey = "preference." + tb.keyName + ".show";
            String posMsgKey = "preference." + tb.keyName + ".position";
            if (PViewerUtilities.getMessage(showMsgKey).equalsIgnoreCase(showMsgKey)) {
                showMsgKey = this.viewer.getConfigPropertyOrMessage(showMsgKey);
            }
            if (PViewerUtilities.getMessage(posMsgKey).equalsIgnoreCase(posMsgKey)) {
                posMsgKey = this.viewer.getConfigPropertyOrMessage(posMsgKey);
            }
            PPropertyDescriptor pdShow = new PPropertyDescriptor(tb.keyName + ".show", showMsgKey, Boolean.class, new Object[]{new Boolean(this.viewer.isToolbarVisible(tb.keyName))});
            Object[] positionObjects = new Object[]{new PPropertyDescriptor.Tuple("north", TOP), new PPropertyDescriptor.Tuple("south", BOTTOM), new PPropertyDescriptor.Tuple("west", LEFT), new PPropertyDescriptor.Tuple("east", RIGHT)};
            PPropertyDescriptor pdPosition = new PPropertyDescriptor(tb.keyName + ".position", posMsgKey, JComboBox.class, new Object[]{positionObjects, tb.toolbar.getPosition()});
            pdShow.setSibling(pdPosition);
            pds.add(pdShow);
        }
        this.propertyDescrs = pds.toArray(new PPropertyDescriptor[0]);
    }

    class MyToolbar {
        CMBViewerToolbar toolbar = null;
        String displayName = null;
        String keyName = null;

        MyToolbar() {
        }
    }

    class PPreferenceSetToolbarsView
    extends CMBPreferenceSetView {
        public PPreferenceSetToolbarsView(CMBPreferenceSet model, long buttonFlags) {
            super(model, buttonFlags);
            this.setCenterPanel(this.makePanel());
        }

        private JPanel makePanel() {
            JPanel c = null;
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(3));
            JPanel p1 = new JPanel();
            p1.setLayout(new BorderLayout());
            p1.setBorder(new TitledBorder(PViewerUtilities.getMessage(PPreferenceSetGeneralToolbars.this.getDisplayName())));
            JPanel p2 = new JPanel();
            p2.setLayout(new GridLayout(0, 1));
            for (int i = 0; i < PPreferenceSetGeneralToolbars.this.getPropertyDescrs().length; ++i) {
                PPropertyDescriptor pdShow = PPreferenceSetGeneralToolbars.this.getPropertyDescrs()[i];
                PPropertyDescriptor pdPos = pdShow.getSibling();
                JPanel tbPanel = new JPanel();
                tbPanel.setLayout(new BorderLayout());
                c = pdShow.getPanel();
                tbPanel.add((Component)c, "Before");
                Component[] list = c.getComponents();
                for (int j = 0; j < list.length; ++j) {
                    if (!(list[j] instanceof JCheckBox)) continue;
                    list[j].getAccessibleContext().setAccessibleParent(p1);
                }
                JPanel tempPanel = new JPanel();
                tempPanel.setLayout(new FlowLayout(3));
                c = pdPos.getPanel();
                tempPanel.add(c);
                list = c.getComponents();
                for (int j = 0; j < list.length; ++j) {
                    if (!(list[j] instanceof JComboBox)) continue;
                    list[j].getAccessibleContext().setAccessibleParent(p1);
                    list[j].getAccessibleContext().setAccessibleName(PViewerUtilities.getMessage(pdShow.getDisplayName()));
                }
                tbPanel.add((Component)tempPanel, "After");
                p2.add(tbPanel);
            }
            if (PPreferenceSetGeneralToolbars.this.getPropertyDescrs().length > 4) {
                JScrollPane scrollPane = new JScrollPane(p2);
                scrollPane.getVerticalScrollBar().setFocusable(false);
                Dimension originalPreferredSize = scrollPane.getViewport().getPreferredSize();
                scrollPane.getViewport().setPreferredSize(new Dimension(originalPreferredSize.width, 125));
                p1.add((Component)scrollPane, "Center");
            } else {
                p1.add((Component)p2, "Center");
            }
            panel.add(p1);
            return panel;
        }
    }
}

