/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBPreferenceSet;
import com.ibm.mm.viewer.CMBPreferenceSetView;
import com.ibm.mm.viewer.PPropertyDescriptor;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JPanel;

abstract class PPreferenceSet
extends CMBPreferenceSet {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    PPropertyDescriptor[] propertyDescrs = null;
    static final String[] preferenceKeys = new String[]{"Annotations.show", "Annotations.immediatePreview", "Annotations.visibleWhileDrag", "Stamp.maintainAspectRatio", "History.queue", "Zoom.factor", "Zoom.default", "Document.rotate", "Document.enhance", "Document.invert", "Thumbnailbar.position", "Thumbnailbar.show", "Thumbnails.dock", "ThumbnailSize", "ThumbnailSize.width", "ThumbnailSize.height", "Printing.annotations.include", "Printing.centerOnPage", "Printing.fitToPage", "Printing.zoom", "Appearance.tab.indicate", "Appearance.tab.delay", "Appearance.tab.fontstyle", "Appearance.tab.color", "AnnotationTool.sticky"};
    static final String LEFT = PViewerUtilities.getMessage("preference.location.Left");
    static final String RIGHT = PViewerUtilities.getMessage("preference.location.Right");
    static final String TOP = PViewerUtilities.getMessage("preference.location.Top");
    static final String BOTTOM = PViewerUtilities.getMessage("preference.location.Bottom");
    static final String SMALL = PViewerUtilities.getMessage("preference.size.Small");
    static final String MEDIUM = PViewerUtilities.getMessage("preference.size.Medium");
    static final String LARGE = PViewerUtilities.getMessage("preference.size.Large");
    static final String RENDER_AHEAD = PViewerUtilities.getMessage("preference.render.ahead");
    static final String RENDER_VISIBLE = PViewerUtilities.getMessage("preference.render.visible");
    static final String RENDER_ALL = PViewerUtilities.getMessage("preference.render.all");
    static final String ITALIC = PViewerUtilities.getMessage("Font.italic");
    static final String BOLD = PViewerUtilities.getMessage("Font.bold");
    static final String BOLD_ITALIC = PViewerUtilities.getMessage("Font.bolditalic");
    static final String PLAIN = PViewerUtilities.getMessage("Font.plain");
    static final int HISTORY_QUEUE_MIN = 0;
    static final int HISTORY_QUEUE_MAX = 100;
    static final int HISTORY_QUEUE_INC = 1;
    static final int ZOOMFACTOR_MIN = 1;
    static final int ZOOMFACTOR_MAX = 99;
    static final int ZOOMFACTOR_INC = 1;
    static final int PRINT_ZOOM_MIN = 25;
    static final int PRINT_ZOOM_MAX = 500;
    static final int PRINT_ZOOM_DEFAULT = 100;
    static final int PRINT_ZOOM_INC = 1;
    static final int TAB_SECONDS_MIN = 0;
    static final int TAB_SECONDS_MAX = 1024;
    static final int TAB_SECONDS_INC = 1;
    static final String[] ZOOM_DEFAULT_VALUES = new String[]{"500%", "200%", "100%", "75%", "50%", "25%", "fit_in_window", "fit_width", "fit_height", "fit_actual"};
    static final String[] DOCUMENT_ROTATE_VALUES = new String[]{"rotate_0", "rotate_90", "rotate_180", "rotate_270"};
    static final String[] POSITION_VALUES = new String[]{"east", "west", "north", "south"};
    static final String[] RELATIVE_SIZE_VALUES = new String[]{"small", "medium", "large"};
    static final String[] FONT_STYLE_VALUES = new String[]{"bold", "italic", "bold_italic", "plain"};

    PPreferenceSet(String name, String displayName, CMBGenericDocViewer viewer) {
        super(name, displayName);
        this.viewer = viewer;
    }

    abstract void createPropertyDescrs();

    PPropertyDescriptor[] getPropertyDescrs() {
        if (this.propertyDescrs == null) {
            this.createPropertyDescrs();
        }
        return this.propertyDescrs;
    }

    public String toString() {
        return PViewerUtilities.getMessage(this.getDisplayName());
    }

    public void applyAction() {
        for (int i = 0; i < this.getPropertyDescrs().length; ++i) {
            PPropertyDescriptor pd = this.getPropertyDescrs()[i];
            PPropertyDescriptor pdSibling = pd.getSibling();
            if (pdSibling != null) {
                this.viewer.putClientProperty(pdSibling.getPropertyName(), pdSibling.getPropertyValue());
            }
            this.viewer.putClientProperty(pd.getPropertyName(), pd.getPropertyValue());
        }
    }

    public void importAction(Properties properties) {
        for (int i = 0; i < this.getPropertyDescrs().length; ++i) {
            String propName;
            String propValue;
            PPropertyDescriptor pd = this.getPropertyDescrs()[i];
            String propName2 = pd.getPropertyName();
            String propValue2 = properties.getProperty(propName2);
            if (propValue2 != null && pd.isValueValid(propValue2)) {
                pd.setPropertyValue(propValue2);
            } else {
                System.out.println(PViewerUtilities.getMessage("preference.InvalidValue", new Object[]{propName2}));
            }
            PPropertyDescriptor pdSibling = pd.getSibling();
            if (pdSibling == null || (propValue = properties.getProperty(propName = pdSibling.getPropertyName())) == null) continue;
            pdSibling.setPropertyValue(propValue);
        }
    }

    public Properties exportAction() {
        Properties exportProperties = new Properties();
        for (int i = 0; i < this.getPropertyDescrs().length; ++i) {
            String propName;
            Object propValue;
            PPropertyDescriptor pdSibling;
            PPropertyDescriptor pd = this.getPropertyDescrs()[i];
            String propName2 = pd.getPropertyName();
            Object propValue2 = this.viewer.getClientProperty(propName2);
            if (propValue2 != null) {
                exportProperties.setProperty(propName2, String.valueOf(propValue2));
            }
            if ((pdSibling = pd.getSibling()) == null || (propValue = this.viewer.getClientProperty(propName = pdSibling.getPropertyName())) == null) continue;
            exportProperties.setProperty(propName, String.valueOf(propValue));
        }
        return exportProperties;
    }

    public void restoreDefaultsAction() {
        Properties properties = this.viewer.getSystemProperties();
        this.importAction(properties);
    }

    void updateView() {
        for (int i = 0; i < this.getPropertyDescrs().length; ++i) {
            String propName;
            Object propValue;
            PPropertyDescriptor pdSibling;
            PPropertyDescriptor pd = this.getPropertyDescrs()[i];
            String propName2 = pd.getPropertyName();
            Object propValue2 = this.viewer.getClientProperty(propName2);
            if (propValue2 != null) {
                pd.setPropertyValue(propValue2);
            }
            if ((pdSibling = pd.getSibling()) == null || (propValue = this.viewer.getClientProperty(propName = pdSibling.getPropertyName())) == null) continue;
            pdSibling.setPropertyValue(propValue);
        }
    }

    void createView(long buttonFlags) {
        PPreferenceSetView view = new PPreferenceSetView(this, buttonFlags);
        this.setComponent(view);
    }

    class PPreferenceSetView
    extends CMBPreferenceSetView {
        public PPreferenceSetView(CMBPreferenceSet model, long buttonFlags) {
            super(model, buttonFlags);
            this.setCenterPanel(this.makePanel());
        }

        private JPanel makePanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(3));
            JPanel p1 = new JPanel();
            p1.setLayout(new BorderLayout());
            JPanel p2 = new JPanel();
            Box box = new Box(1);
            for (int i = 0; i < PPreferenceSet.this.getPropertyDescrs().length; ++i) {
                PPropertyDescriptor pd = PPreferenceSet.this.getPropertyDescrs()[i];
                box.add(pd.getPanel());
                box.add(Box.createVerticalGlue());
            }
            p2.add(box);
            p1.add((Component)p2, "Center");
            panel.add(p1);
            return panel;
        }
    }
}

