/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PAbstractTask;
import com.ibm.mm.viewer.PClippedPages;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PTaskManager;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.datatransfer.Transferable;
import javax.swing.JOptionPane;

class PPastePagesTask
extends PAbstractTask {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBGenericDocViewer viewer = null;
    private int page;
    private int nPagesPasted;
    private PClippedPages unPastedPages;

    PPastePagesTask(PTaskManager taskManager, CMBGenericDocViewer viewer, int page) {
        super(taskManager);
        this.viewer = viewer;
        this.page = page;
        this.getManager().invokeTask(this, true);
    }

    public boolean doIt() {
        String methodName = "doIt";
        try {
            PPageModel model = (PPageModel)this.viewer.getSelectedModel();
            if (this.unPastedPages != null) {
                model.insertPages(this.unPastedPages, this.page);
            } else {
                Transferable content = this.viewer.localClipboard.getContents(this);
                if (content != null) {
                    if (content.isDataFlavorSupported(PClippedPages.clippedPagesFlavor)) {
                        PClippedPages clippedPages = (PClippedPages)content.getTransferData(PClippedPages.clippedPagesFlavor);
                        boolean ocrDoc = (Boolean)this.viewer.getClientProperty("Document.ocr");
                        if (!ocrDoc) {
                            model.document.setOCRValid(false);
                        }
                        model.insertPages(clippedPages, this.page);
                        this.nPagesPasted = clippedPages.getPageCount();
                    } else {
                        System.out.println(PViewerUtilities.getMessage("DocumentViewer.clipboardFailure"));
                    }
                }
            }
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            JOptionPane.showMessageDialog(this.viewer, PViewerUtilities.getMessage("DocumentViewer.pagesNotPasted", new String[]{e.getMessage()}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
            return false;
        }
        return true;
    }

    public boolean undoIt() {
        String methodName = "undoIt";
        try {
            PPageModel model = (PPageModel)this.viewer.getSelectedModel();
            int[] pages = new int[this.nPagesPasted];
            for (int i = 0; i < pages.length; ++i) {
                pages[i] = this.page + 1 + i;
            }
            this.unPastedPages = new PClippedPages(this.viewer.getDocServices(), this.viewer.getAnnotationServices());
            this.unPastedPages.setThumbnailSize(this.viewer.getThumbnailsSize());
            model.deletePages(pages, this.unPastedPages);
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            JOptionPane.showMessageDialog(this.viewer, PViewerUtilities.getMessage("DocumentViewer.pagesNotDeleted", new String[]{e.getMessage()}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
            return false;
        }
        return true;
    }

    public String getDescription() {
        return PViewerUtilities.getMessage("pastePagesTask.description");
    }
}

