/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.PCreateAnnotationTask;
import com.ibm.mm.viewer.PFullSizePageView;
import com.ibm.mm.viewer.PFullSizeView;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PTaskManager;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

class PPasteAnnotationTask
extends PCreateAnnotationTask {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private Point point = null;
    private int pageNumber = 1;

    PPasteAnnotationTask(PTaskManager taskManager, CMBGenericDocViewer viewer) {
        super(taskManager);
        this.viewer = viewer;
        if (viewer.getSelectedModel() != null) {
            this.pageNumber = viewer.getSelectedModel().getCurrentPageNumber();
        }
        if (!this.setAnnoLocation()) {
            return;
        }
        this.getManager().invokeTask(this, true);
    }

    PPasteAnnotationTask(PTaskManager taskManager, CMBGenericDocViewer viewer, Point point) {
        super(taskManager);
        this.viewer = viewer;
        this.point = point;
        if (viewer.getSelectedModel() != null) {
            this.pageNumber = viewer.getSelectedModel().getCurrentPageNumber();
        }
        if (!this.setAnnoLocation()) {
            return;
        }
        this.getManager().invokeTask(this, true);
    }

    PPasteAnnotationTask(PTaskManager taskManager, CMBGenericDocViewer viewer, Point point, int pageNumber) {
        super(taskManager);
        this.viewer = viewer;
        this.point = point;
        this.pageNumber = pageNumber;
        if (!this.setAnnoLocation()) {
            return;
        }
        this.getManager().invokeTask(this, true);
    }

    boolean setAnnoLocation() {
        block20: {
            String methodName = "setAnnoLocation";
            try {
                if (this.viewer.getSelectedAnnotationSet() != null && !this.viewer.getSelectedAnnotationSet().getPrivilege(8)) {
                    return false;
                }
            }
            catch (CMBAnnotationEngineException e) {
                ViewerLogger.logError((Object)this, methodName, e);
                return false;
            }
            Transferable content = this.viewer.localClipboard.getContents(this);
            if (content != null) {
                try {
                    if (content.isDataFlavorSupported(CMBPageAnnotation.pageAnnotationFlavor)) {
                        Properties configProperties;
                        CMBPageAnnotation data = (CMBPageAnnotation)content.getTransferData(CMBPageAnnotation.pageAnnotationFlavor);
                        CMBPageAnnotation newAnno = (CMBPageAnnotation)data.clone();
                        newAnno.setCanDelete(true);
                        newAnno.setCanHide(true);
                        newAnno.setCanShow(true);
                        newAnno.setCanUpdate(true);
                        newAnno.setPageNumber(this.pageNumber);
                        int xOffset = 0;
                        int yOffset = 0;
                        newAnno.setRotation(this.viewer.getSelectedAnnotationSet().getRotation());
                        newAnno.setAnnotationRotation(0);
                        PFullSizeView docView = this.viewer.getSelectedView();
                        if (docView != null) {
                            PPageModel thePageModel = (PPageModel)docView.getDocModel();
                            CMBPage page = thePageModel.getPage(this.pageNumber);
                            newAnno.setRotation(page.getRotation());
                            newAnno.setAnnotationRotation(0);
                            Point newPoint = this.point;
                            if (newPoint != null) {
                                Point oldPoint = new Point(newAnno.getDrawRect().x, newAnno.getDrawRect().y);
                                ((PFullSizePageView)docView).scalePoint(newPoint);
                                ((PFullSizePageView)docView).rotatePoint(newPoint, newAnno.getAnnoDrawRect().width, newAnno.getAnnoDrawRect().height, this.pageNumber);
                                switch (newAnno.getRotation()) {
                                    case 0: {
                                        xOffset = newPoint.x - oldPoint.x;
                                        yOffset = newPoint.y - oldPoint.y;
                                        break;
                                    }
                                    case 1: {
                                        xOffset = oldPoint.y - newPoint.y;
                                        yOffset = newPoint.x - oldPoint.x;
                                        break;
                                    }
                                    case 2: {
                                        xOffset = oldPoint.x - newPoint.x;
                                        yOffset = oldPoint.y - newPoint.y;
                                        break;
                                    }
                                    case 3: {
                                        xOffset = newPoint.y - oldPoint.y;
                                        yOffset = oldPoint.x - newPoint.x;
                                    }
                                }
                            }
                        }
                        if (xOffset == 0 && yOffset == 0 && (configProperties = this.viewer.getConfigProperties()) != null) {
                            String pasteOffsetProp = configProperties.getProperty("Annotation.pasteoffset", "0,0");
                            StringTokenizer stzOffsetProp = new StringTokenizer(pasteOffsetProp, ",");
                            try {
                                xOffset = new Integer(stzOffsetProp.nextToken());
                                yOffset = new Integer(stzOffsetProp.nextToken());
                            }
                            catch (NoSuchElementException e) {
                                System.out.println(PViewerUtilities.getMessage("DocumentViewer.InvalidPropertyValue", new Object[]{"Annotation.pasteoffset"}));
                            }
                            catch (NumberFormatException e) {
                                System.out.println(PViewerUtilities.getMessage("DocumentViewer.InvalidPropertyValue", new Object[]{"Annotation.pasteoffset"}));
                            }
                        }
                        if (xOffset != 0 && yOffset != 0) {
                            newAnno.translateBy(xOffset, yOffset);
                        }
                        this.anno = newAnno;
                        break block20;
                    }
                    System.out.println(PViewerUtilities.getMessage("DocumentViewer.clipboardFailure"));
                }
                catch (Exception e) {
                    ViewerLogger.logError((Object)this, methodName, e);
                    return false;
                }
            }
        }
        return true;
    }

    public String getDescription() {
        return PViewerUtilities.getMessage("pasteAnnotationTask.description");
    }
}

