/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PAbstractTask;
import com.ibm.mm.viewer.PClippedPages;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PPageSelection;
import com.ibm.mm.viewer.PTaskManager;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import javax.swing.JOptionPane;

class PPageTransferTask
extends PAbstractTask {
    private CMBGenericDocViewer _viewer;
    private PPageSelection _pagesToTransfer;
    private CMBDocument _destDoc;
    private CMBAnnotationSet _destAnnoSet;
    private int _destPage;
    private int _taskType = 0;
    private PPageModel _destModel;
    private PClippedPages _clippedPages;
    private int[] _sourcePageNumbers;

    PPageTransferTask(PTaskManager taskManager, CMBGenericDocViewer viewer, PPageSelection pageSelection) {
        super(taskManager);
        this._viewer = viewer;
        this._pagesToTransfer = pageSelection;
    }

    public boolean doIt() {
        String methodName = "doIt";
        try {
            this._sourcePageNumbers = (int[])this._pagesToTransfer.getPageNumbers().clone();
            PPageModel model = (PPageModel)this._viewer.getSelectedModel();
            this._clippedPages = new PClippedPages(this._viewer.getDocServices(), this._viewer.getAnnotationServices());
            this._clippedPages.setThumbnailSize(this._viewer.getThumbnailsSize());
            if (this._taskType == 2) {
                model.deletePages(this._sourcePageNumbers, this._clippedPages);
            } else {
                model.copyPages(this._sourcePageNumbers, this._clippedPages);
                this._clippedPages.setThumbnailSize(this._viewer.getThumbnailsSize());
            }
            int[] destPageNumbers = new int[this._sourcePageNumbers.length];
            int offset = 0;
            if (this._taskType == 2 && this._sourcePageNumbers[0] < this._destPage) {
                offset = this._sourcePageNumbers.length;
            }
            model.insertPages(this._clippedPages, this._destPage - offset);
            return true;
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            if (this._taskType == 1) {
                JOptionPane.showMessageDialog(this._viewer, PViewerUtilities.getMessage("DocumentViewer.pagesNotCopied", new String[]{e.getMessage()}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
            } else {
                JOptionPane.showMessageDialog(this._viewer, PViewerUtilities.getMessage("DocumentViewer.pagesNotMoved", new String[]{e.getMessage()}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
            }
            return false;
        }
    }

    public boolean undoIt() {
        String methodName = "undoIt";
        try {
            PPageModel model = (PPageModel)this._viewer.getSelectedModel();
            int[] pages = new int[this._clippedPages.getPageCount()];
            int offset = 0;
            offset = this._taskType == 2 ? (this._sourcePageNumbers[0] > this._destPage ? 1 : 1 - this._sourcePageNumbers.length) : 1;
            for (int i = 0; i < pages.length; ++i) {
                pages[i] = this._destPage + offset + i;
            }
            int eventType = 14;
            PClippedPages clippedPages2 = new PClippedPages(this._viewer.getDocServices(), this._viewer.getAnnotationServices());
            clippedPages2.setThumbnailSize(this._viewer.getThumbnailsSize());
            model.deletePages(pages, clippedPages2);
            if (this._taskType == 2) {
                int[] restorePageNumbers = (int[])this._pagesToTransfer.getPageNumbers().clone();
                eventType = 15;
                model.restorePages(this._clippedPages, restorePageNumbers);
            }
            return true;
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            if (this._taskType == 1) {
                JOptionPane.showMessageDialog(this._viewer, PViewerUtilities.getMessage("DocumentViewer.pagesNotDeleted", new String[]{e.getMessage()}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
            } else {
                JOptionPane.showMessageDialog(this._viewer, PViewerUtilities.getMessage("DocumentViewer.pagesNotMoved", new String[]{e.getMessage()}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
            }
            return false;
        }
    }

    public String getDescription() {
        return PViewerUtilities.getMessage("pageTransfer.description");
    }

    public int getTaskType() {
        return this._taskType;
    }

    public void setTaskType(int actionType) {
        this._taskType = actionType;
    }

    public int getDestPage() {
        return this._destPage;
    }

    public void setDestPage(int destPage) {
        this._destPage = destPage;
    }
}

