/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PDeletePagesTask;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PPageSelection;
import com.ibm.mm.viewer.PPageTransferTask;
import com.ibm.mm.viewer.PThumbnailListView;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

class PPageTransferHandler
extends TransferHandler {
    private CMBGenericDocViewer _viewer;
    private PPageTransferTask currentTask;
    private JComponent dragSource = null;
    private JComponent dropTarget;
    private static boolean _isDragging = false;
    private int[] selectionAtDragStart = null;

    public PPageTransferHandler() {
    }

    public PPageTransferHandler(CMBGenericDocViewer viewer) {
        this._viewer = viewer;
    }

    public boolean canImport(JComponent c, DataFlavor[] df) {
        if (!_isDragging) {
            _isDragging = true;
        }
        boolean canImport = false;
        for (int i = 0; i < df.length; ++i) {
            if (!(c instanceof PThumbnailListView.PThumbnailList)) continue;
            if (df[i].equals(PPageSelection.localPageSelectionFlavor)) {
                canImport = true;
            }
            if (!df[i].equals(PPageSelection.remotePageSelectionFlavor)) continue;
            canImport = true;
        }
        if (canImport && c instanceof PThumbnailListView.PThumbnailList) {
            c.requestFocus();
        }
        return canImport;
    }

    protected Transferable createTransferable(JComponent c) {
        if (c instanceof PThumbnailListView.PThumbnailList) {
            PPageModel thePageModel = (PPageModel)this._viewer.getSelectedModel();
            PPageSelection pageSelection = new PPageSelection(thePageModel.getDocument(), thePageModel.getAnnotationSet(), thePageModel.getSelectedPages());
            pageSelection.setDocServices(this._viewer.getDocServices());
            pageSelection.setAnnoServices(this._viewer.getAnnotationServices());
            return pageSelection;
        }
        return null;
    }

    public void exportAsDrag(JComponent c, InputEvent event, int action) {
        this.dragSource = c;
        PPageModel thePageModel = (PPageModel)this._viewer.getSelectedModel();
        boolean allowDrag = false;
        if (action == 1 && thePageModel.getPrivilege(3)) {
            allowDrag = true;
        } else if (action == 2 && (thePageModel.getPrivilege(2) && thePageModel.getPrivilege(3) || thePageModel.getPrivilege(5))) {
            allowDrag = true;
        }
        if (allowDrag) {
            if (c instanceof PThumbnailListView.PThumbnailList) {
                JList dragList = (JList)c;
                this.selectionAtDragStart = dragList.getSelectedIndices();
            }
            _isDragging = true;
            super.exportAsDrag(c, event, action);
        }
    }

    protected void exportDone(JComponent c, Transferable t, int action) {
        JList dragList;
        if (action != 0) {
            PPageModel thePageModel = (PPageModel)this._viewer.getSelectedModel();
            boolean allowDrop = false;
            if (action == 1 && thePageModel.getPrivilege(3)) {
                allowDrop = true;
            } else if (action == 2 && (thePageModel.getPrivilege(2) && thePageModel.getPrivilege(3) || thePageModel.getPrivilege(5))) {
                allowDrop = true;
            }
            if (allowDrop) {
                try {
                    Object td;
                    if (this.dropTarget != null) {
                        this.currentTask.setTaskType(action);
                        this.currentTask.getManager().invokeTask(this.currentTask, true);
                        this._viewer.updateToolStates();
                    } else if (action == 2 && (td = t.getTransferData(PPageSelection.localPageSelectionFlavor)) instanceof PPageSelection) {
                        PPageSelection pagesSelected = (PPageSelection)td;
                        PDeletePagesTask task = new PDeletePagesTask(thePageModel.getTaskManager(), this._viewer, pagesSelected.getPageNumbers());
                    }
                }
                catch (Exception e) {
                    System.out.println("Caught Exception" + e);
                }
            }
        } else if (c instanceof PThumbnailListView.PThumbnailList) {
            dragList = (JList)c;
            dragList.setSelectedIndices(this.selectionAtDragStart);
        }
        if (c instanceof PThumbnailListView.PThumbnailList) {
            dragList = (JList)c;
            dragList.setDragEnabled(false);
        }
        _isDragging = false;
        this.dragSource = null;
        this.dropTarget = null;
    }

    public void exportToClipboard(JComponent arg0, Clipboard arg1, int arg2) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean importData(JComponent c, Transferable t) {
        try {
            this.dropTarget = c;
            PPageModel thePageModel = (PPageModel)this._viewer.getSelectedModel();
            if (this.dragSource != null) {
                if (!this.validateLocalDropAfterPage(c)) return false;
                Object td = t.getTransferData(PPageSelection.localPageSelectionFlavor);
                if (!(td instanceof PPageSelection)) return true;
                PPageSelection pagesSelected = (PPageSelection)td;
                this.currentTask = new PPageTransferTask(thePageModel.getTaskManager(), this._viewer, pagesSelected);
                this.currentTask.setTaskType(1);
                this.currentTask.setDestPage(thePageModel.getPageNumber(((PThumbnailListView.PThumbnailList)c).getDropIndex() + 1));
                return true;
            } else {
                Object td = t.getTransferData(PPageSelection.remotePageSelectionFlavor);
                if (!(td instanceof PPageSelection)) return true;
                PPageSelection pagesSelected = (PPageSelection)td;
                pagesSelected.setDocServices(this._viewer.getDocServices());
                pagesSelected.setAnnoServices(this._viewer.getAnnotationServices());
                pagesSelected.readDocumentFromByteArray();
                this.currentTask = new PPageTransferTask(thePageModel.getTaskManager(), this._viewer, pagesSelected);
                this.currentTask.setTaskType(1);
                this.currentTask.setDestPage(thePageModel.getPageNumber(((PThumbnailListView.PThumbnailList)c).getDropIndex() + 1));
                this.currentTask.getManager().invokeTask(this.currentTask, true);
                this._viewer.updateToolStates();
                _isDragging = false;
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Caught Exception" + e);
            return false;
        }
    }

    public int getSourceActions(JComponent c) {
        return 3;
    }

    public static boolean isDragging() {
        return _isDragging;
    }

    public boolean validateLocalDropAfterPage(JComponent target) {
        if (target instanceof PThumbnailListView.PThumbnailList) {
            int[] draggedPages;
            PThumbnailListView.PThumbnailList dropList = (PThumbnailListView.PThumbnailList)target;
            PPageModel thePageModel = (PPageModel)this._viewer.getSelectedModel();
            int destPagePosition = dropList.getDropIndex() + 1;
            return destPagePosition < thePageModel.getPagePosition((draggedPages = thePageModel.getSelectedPages())[0]) - 1 || destPagePosition > thePageModel.getPagePosition(draggedPages[draggedPages.length - 1]);
        }
        return false;
    }
}

