/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PThumbnailsView;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

class PPageThumbnailView
extends PThumbnailsView
implements MouseListener,
MouseMotionListener {
    private static boolean _trace = false;
    private CMBAnnotationView thumbAnnView;
    private Dimension thumbnailSize;
    private Dimension thumbnailOffsets;
    private int thumbnailsCount = 0;
    private int pageCountFromModel = -1;
    private Hashtable thumbnails;
    private Vector thumbImageScale;
    private boolean bGotoSelected = false;
    private MediaTracker tracker = new MediaTracker(this);
    private thumbnailBuilder currThumbnailBuilder = null;
    private static final byte TS_STOP = 0;
    private static final byte TS_PAUSE = 1;
    private static final byte TS_RUN = 2;
    private static final byte TS_INIT = 3;
    private static final byte TS_RESET = 4;
    private static final byte TS_JUMPTO = 5;
    private Rectangle currImageRect = null;
    private Rectangle redRectangle = null;
    private Rectangle redRectangleHandle = null;
    private boolean redRectClicked = false;
    private boolean scalingRedRect = false;
    private Point ptInRedRect;
    private Point ptInRedRectHandle;
    private Point ptRedRectTopDisplacement = null;
    private float redRectAspect;
    private JPopupMenu thumbPopupMenu = null;
    private static final int WD_OFFSET = 30;
    private static final int HT_OFFSET = 30;
    private static final int STD_THUMBNAIL_WIDTH = 60;
    private static final int STD_THUMBNAIL_HEIGHT = 100;
    private boolean bMultiSelectAllowed = false;
    private int lastClickedPagePosition = 1;

    PPageThumbnailView(PSingleDocViewer viewer, PDocModel model) {
        super(viewer, model);
        this.thumbnailSize = new Dimension(60, 100);
        this.thumbnailOffsets = new Dimension(30, 30);
        this.thumbnails = new Hashtable();
        Border border = BorderFactory.createRaisedBevelBorder();
        this.setBorder(border);
        Insets borderInsets = border.getBorderInsets(this);
        this.setPreferredSize(new Dimension(this.thumbnailSize.width + this.thumbnailOffsets.width + borderInsets.left + borderInsets.right, this.thumbnailSize.height + this.thumbnailOffsets.height + borderInsets.top + borderInsets.bottom));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void setAnnotationView(CMBAnnotationView annView) {
        this.thumbAnnView = annView;
    }

    void setThumbnailSize(Dimension size) {
        this.thumbnailSize = size;
    }

    void setThumbnailSize(int width, int height) {
        this.thumbnailSize = new Dimension();
        this.thumbnailSize.width = width;
        this.thumbnailSize.height = height;
    }

    Dimension getThumbnailSize() {
        return this.thumbnailSize;
    }

    Dimension getThumbnailOffsets() {
        return this.thumbnailOffsets;
    }

    void setThumbnailOffsets(Dimension offsets) {
        this.thumbnailOffsets = offsets;
    }

    public boolean isMultiSelectAllowed() {
        return this.bMultiSelectAllowed;
    }

    public void setMultiSelectAllowed(boolean bMultiSelectAllowed) {
        this.bMultiSelectAllowed = bMultiSelectAllowed;
    }

    public JPopupMenu getPopupMenu(String menuName) {
        if (menuName.equalsIgnoreCase("thumbPopup")) {
            return this.thumbPopupMenu;
        }
        return null;
    }

    public void setPopupMenu(JPopupMenu pMenu, String menuName) {
        if (menuName.equalsIgnoreCase("thumbPopup")) {
            this.setThumbPopupMenu(pMenu);
        }
    }

    void setThumbPopupMenu(JPopupMenu popupMenu) {
        this.thumbPopupMenu = popupMenu;
    }

    void buildThumbnails() throws IOException, CMBDocumentEngineException {
        if (this.currThumbnailBuilder == null) {
            this.currThumbnailBuilder = new thumbnailBuilder("ThumbnailBuilder");
            this.currThumbnailBuilder.setPriority(1);
            this.currThumbnailBuilder.byCurrThreadState = (byte)3;
            try {
                this.currThumbnailBuilder.setDaemon(true);
            }
            catch (SecurityException e) {
                // empty catch block
            }
            this.currThumbnailBuilder.start();
        } else if (!this.currThumbnailBuilder.isAlive()) {
            this.currThumbnailBuilder = new thumbnailBuilder("ThumbnailBuilder");
            this.traceOut("in buildThumbnails THREAD " + this.currThumbnailBuilder.getName() + " is not alive, starting it now");
            this.currThumbnailBuilder.byCurrThreadState = (byte)3;
            this.currThumbnailBuilder.setPriority(1);
            this.currThumbnailBuilder.start();
        } else {
            if (this.currThumbnailBuilder.byCurrThreadState == 2) {
                PPageModel thePageModel = (PPageModel)this.getDocModel();
                this.currThumbnailBuilder.jumpPagePosition = thePageModel.getCurrentPagePosition();
                this.currThumbnailBuilder.byCurrThreadState = (byte)5;
            }
            if (this.currThumbnailBuilder.byCurrThreadState == 1) {
                this.currThumbnailBuilder.byCurrThreadState = (byte)2;
            }
        }
    }

    void display() {
        PPageModel thePageModel = (PPageModel)this.getDocModel();
        this.pageCountFromModel = thePageModel.getPageCount();
        if (this.pageCountFromModel != -1) {
            this.thumbnailsCount = this.pageCountFromModel;
        }
        Insets borderInsets = this.getBorder().getBorderInsets(this);
        if (this.getOrientation() == 1) {
            this.setPreferredSize(new Dimension(this.thumbnailSize.width + this.thumbnailOffsets.width + borderInsets.left + borderInsets.right, (this.thumbnailSize.height + this.thumbnailOffsets.height) * this.thumbnailsCount + borderInsets.top + borderInsets.bottom));
        } else {
            this.setPreferredSize(new Dimension((this.thumbnailSize.width + this.thumbnailOffsets.width) * this.thumbnailsCount + borderInsets.left + borderInsets.right, this.thumbnailSize.height + this.thumbnailOffsets.height + borderInsets.top + borderInsets.bottom));
        }
        this.bGotoSelected = true;
        this.revalidate();
        this.repaint();
    }

    void updateThumbnails(int startPage, int endPage) {
        int currPagePosition = ((PPageModel)this.getDocModel()).getCurrentPagePosition();
        if (startPage == 0 && endPage == 0) {
            startPage = currPagePosition;
            endPage = currPagePosition;
        }
        if (startPage == 0 && endPage == -1) {
            startPage = 1;
            endPage = this.thumbnailsCount;
        }
        if (currPagePosition < startPage || currPagePosition > endPage) {
            int currPageNumber = ((PPageModel)this.getDocModel()).getCurrentPageNumber();
            this.thumbnails.remove(new Integer(currPageNumber - 1));
        }
        for (int index = startPage - 1; index < endPage; ++index) {
            int pageNumber = ((PPageModel)this.getDocModel()).getPageNumber(index + 1) - 1;
            this.thumbnails.remove(new Integer(pageNumber));
        }
        this.redRectangle = null;
        this.redRectangleHandle = null;
        if (this.currThumbnailBuilder != null && this.currThumbnailBuilder.isAlive()) {
            this.traceOut("In updateThumbnails THREAD " + this.currThumbnailBuilder.getName() + " is alive, in state " + this.currThumbnailBuilder.byCurrThreadState);
            this.currThumbnailBuilder.byCurrThreadState = (byte)4;
        }
    }

    boolean canFitHeight() {
        return false;
    }

    boolean canFitInWindow() {
        return false;
    }

    boolean canFitWidth() {
        return false;
    }

    void fitHeight() {
    }

    void fitInWindow() {
    }

    void fitWidth() {
    }

    private void scaleRedRectangle(Rectangle viewRect) {
        double thumbScale = 0.0;
        if (this.redRectangle == null) {
            this.redRectangle = new Rectangle();
            this.redRectangleHandle = new Rectangle();
        }
        if (viewRect == null) {
            return;
        }
        int currPagePosition = ((PPageModel)this.getDocModel()).getCurrentPagePosition();
        int currPageNumber = ((PPageModel)this.getDocModel()).getCurrentPageNumber();
        thumbScale = ((Float)this.thumbImageScale.elementAt(currPageNumber - 1)).floatValue();
        this.traceOut("scaleRedRectangle() - thumbnail scale set to :" + thumbScale);
        double scale = this.getDocModel().getScale();
        int newX = (int)((double)viewRect.x * thumbScale / scale);
        int newY = (int)((double)viewRect.y * thumbScale / scale);
        int newWidth = (int)((double)viewRect.width * thumbScale / scale);
        int newHeight = (int)((double)viewRect.height * thumbScale / scale);
        this.redRectangle.setBounds(newX, newY, newWidth, newHeight);
        this.redRectangleHandle.setBounds(newX + newWidth - 5, newY + newHeight - 5, 5, 5);
    }

    void setCurrentViewRect() {
        int currPagePosition = ((PPageModel)this.getDocModel()).getCurrentPagePosition();
        int currPageNumber = ((PPageModel)this.getDocModel()).getCurrentPageNumber();
        double docScale = this.getDocModel().getDocument().getPreferredScale();
        Rectangle modelRect = new Rectangle(((PPageModel)this.getDocModel()).getCurrentViewRectangle());
        double thumbScale = ((Float)this.thumbImageScale.elementAt(currPageNumber - 1)).floatValue();
        if (this.redRectClicked) {
            int newX = (int)((double)(this.redRectangle.x - this.ptRedRectTopDisplacement.x) / thumbScale * docScale);
            int newY = (int)((double)(this.redRectangle.y - this.ptRedRectTopDisplacement.y) / thumbScale * docScale);
            modelRect.setLocation(newX, newY);
        }
        if (this.scalingRedRect) {
            double newWidth = (double)this.redRectangle.width / thumbScale;
            double newHeight = (double)this.redRectangle.height / thumbScale;
            double widthScale = (double)modelRect.width / newWidth;
            double heightScale = (double)modelRect.height / newHeight;
            double newScale = Math.min(widthScale, heightScale);
            ((PPageModel)this.getDocModel()).setScale(newScale);
            return;
        }
        int currPageImageWidth = (int)((double)this.currImageRect.width / thumbScale);
        int currPageImageHeight = (int)((double)this.currImageRect.height / thumbScale);
        ((PPageModel)this.getDocModel()).setCurrentViewRectangle(modelRect);
    }

    public void paint(Graphics g) {
        int x = 15;
        int y = 15;
        int pageNumY = this.getHeight() - this.thumbnailOffsets.width;
        int currImgWidth = 0;
        int currImgHeight = 0;
        int currPagePosition = ((PPageModel)this.getDocModel()).getCurrentPagePosition();
        Image thumbImage = null;
        Image offScreenImage = null;
        JViewport currViewPort = (JViewport)this.getParent();
        Point viewTopLeft = currViewPort.getViewPosition();
        Dimension viewExtent = currViewPort.getExtentSize();
        Rectangle viewRect = new Rectangle(viewTopLeft, viewExtent);
        int newXpos = 0;
        Font currFont = g.getFont();
        PPageModel thePageModel = (PPageModel)this.getDocModel();
        for (int i = 0; i < this.thumbnailsCount; ++i) {
            int thumbImageLeft = x;
            int thumbImageTop = y + 15;
            int pageNum = thePageModel.getPageNumber(i + 1);
            if (currPagePosition == i + 1) {
                g.setColor(SystemColor.textHighlight);
                for (int q = 7; q > 3; --q) {
                    g.drawRect(thumbImageLeft - q, thumbImageTop - q, this.thumbnailSize.width + 1 + 2 * (q - 1), this.thumbnailSize.height + 1 + 2 * (q - 1));
                }
                if (this.bGotoSelected && !viewRect.contains(x - 1, y + 14, this.thumbnailSize.width, this.thumbnailSize.height)) {
                    if (x <= viewTopLeft.x) {
                        newXpos = x - 15;
                    } else if (x + this.thumbnailSize.width >= viewTopLeft.x + viewExtent.width) {
                        newXpos = x + currImgWidth + 10 - viewExtent.width;
                    }
                    currViewPort.setViewPosition(new Point(newXpos, y - 15));
                }
                g.fillRect(x + this.thumbnailSize.width / 2 - 15, y - 5, 30, 15);
                g.setColor(SystemColor.textHighlightText);
            } else if (thePageModel.isPageSelected(pageNum)) {
                g.setColor(SystemColor.textHighlight);
                for (int r = 6; r > 4; --r) {
                    g.drawRect(thumbImageLeft - r, thumbImageTop - r, this.thumbnailSize.width + 1 + 2 * (r - 1), this.thumbnailSize.height + 1 + 2 * (r - 1));
                }
            }
            String strPageNum = "0";
            strPageNum = pageNum < 10 ? strPageNum + String.valueOf(pageNum) : String.valueOf(pageNum);
            Font newFont = new Font(currFont.getName(), 1, 15);
            g.setFont(newFont);
            g.drawString(strPageNum, x + this.thumbnailSize.width / 2 - 5, y + 10);
            g.setFont(currFont);
            g.setColor(Color.gray);
            g.fillRect(thumbImageLeft - 1, thumbImageTop - 1, this.thumbnailSize.width + 1, this.thumbnailSize.height + 1);
            g.setColor(Color.black);
            g.drawRect(thumbImageLeft - 1, thumbImageTop - 1, this.thumbnailSize.width + 1, this.thumbnailSize.height + 1);
            thumbImage = (Image)this.thumbnails.get(new Integer(pageNum - 1));
            if (thumbImage != null) {
                currImgWidth = thumbImage.getWidth(this);
                currImgHeight = thumbImage.getHeight(this);
                int ptX = (this.thumbnailSize.width - currImgWidth) / 2;
                int ptY = (this.thumbnailSize.height - currImgHeight) / 2;
                double docScale = this.getDocModel().getDocument().getPreferredScale();
                if (currImgWidth > 0 && currImgHeight > 0) {
                    if (offScreenImage != null) {
                        offScreenImage.flush();
                    }
                    offScreenImage = this.createImage(currImgWidth, currImgHeight);
                    Graphics2D thumbGraphics = (Graphics2D)offScreenImage.getGraphics();
                    thumbGraphics.drawImage(thumbImage, 0, 0, this);
                    double thumbScale = 0.0;
                    thumbScale = ((Float)this.thumbImageScale.elementAt(pageNum - 1)).floatValue();
                    CMBDocument document = this.getDocModel().getDocument();
                    CMBPage page = ((PPageModel)this.getDocModel()).getPage(pageNum);
                    thumbGraphics.scale(thumbScale / (double)page.getPageXResolution() * (double)document.getDisplayResolution(), thumbScale / (double)page.getPageXResolution() * (double)document.getDisplayResolution());
                    if (this.thumbAnnView != null) {
                        this.thumbAnnView.paintAnnotations(thumbGraphics, pageNum, false);
                    }
                    g.drawImage(offScreenImage, x + ptX, y + 15 + ptY, this);
                } else {
                    g.drawImage(thumbImage, x + ptX, y + 15 + ptY, this);
                }
                if (currPagePosition == i + 1) {
                    this.currImageRect = new Rectangle(x + ptX, y + 15 + ptY, currImgWidth, currImgHeight);
                    if (this.bGotoSelected) {
                        Rectangle currViewRect = ((PPageModel)this.getDocModel()).getCurrentViewRectangle();
                        this.scaleRedRectangle(currViewRect);
                        this.ptRedRectTopDisplacement = new Point(x + ptX, y + 15 + ptY);
                        this.redRectangle.setLocation(this.redRectangle.x + x + ptX, this.redRectangle.y + y + 15 + ptY);
                        this.bGotoSelected = false;
                    }
                    if (!this.currImageRect.contains(this.redRectangle)) {
                        this.redRectangle = (Rectangle)this.currImageRect.createIntersection(this.redRectangle);
                    }
                    this.redRectangleHandle.setBounds(this.redRectangle.x + this.redRectangle.width - 5, this.redRectangle.y + this.redRectangle.height - 5, 5, 5);
                    Stroke oldStroke = ((Graphics2D)g).getStroke();
                    ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
                    ((Graphics2D)g).setColor(Color.cyan);
                    Rectangle InnerRectHandle = new Rectangle(this.redRectangleHandle.x - 1, this.redRectangleHandle.y - 1, this.redRectangleHandle.width, this.redRectangleHandle.height);
                    Rectangle InnerRectangle = new Rectangle(this.redRectangle.x + 1, this.redRectangle.y + 1, this.redRectangle.width, this.redRectangle.height);
                    ((Graphics2D)g).fill(this.redRectangleHandle);
                    ((Graphics2D)g).draw(InnerRectangle);
                    ((Graphics2D)g).setColor(Color.red);
                    ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
                    ((Graphics2D)g).draw(this.redRectangle);
                    ((Graphics2D)g).draw(InnerRectHandle);
                    ((Graphics2D)g).setStroke(oldStroke);
                }
            } else {
                try {
                    this.buildThumbnails();
                }
                catch (Exception e) {
                    System.out.println("Thumbnails not built. Caught exception :" + e);
                }
            }
            super.paint(g);
            if ((x += this.thumbnailSize.width + this.thumbnailOffsets.width) + this.thumbnailSize.width + this.thumbnailOffsets.width / 2 <= this.getWidth()) continue;
            x = this.thumbnailOffsets.width / 2;
            y += this.thumbnailSize.height + this.thumbnailOffsets.height;
        }
        if (!this.thumbnails.containsKey(new Integer(this.pageCountFromModel - 1)) && this.currThumbnailBuilder != null && this.currThumbnailBuilder.byCurrThreadState != 0) {
            String loadingMesg = PViewerUtilities.getMessage("DocumentViewer.LoadingThumbnails");
            g.setColor(SystemColor.textText);
            FontRenderContext fRenderContext = ((Graphics2D)g).getFontRenderContext();
            Rectangle2D stringRect = currFont.getStringBounds(loadingMesg, fRenderContext);
            int line = 1;
            int margin = 5;
            StringBuffer sb = new StringBuffer();
            FontMetrics fm = g.getFontMetrics();
            line = (viewTopLeft.y + viewExtent.height) / fm.getHeight() - 2;
            StringTokenizer st = new StringTokenizer(loadingMesg);
            while (st.hasMoreTokens()) {
                String nextword = st.nextToken();
                if (fm.stringWidth(sb.toString() + nextword) + margin < this.getSize().width) {
                    sb.append(nextword);
                    sb.append(' ');
                    continue;
                }
                if (sb.length() == 0) {
                    g.drawString(nextword, viewTopLeft.x + viewExtent.width - fm.stringWidth(nextword) - 5, line * fm.getHeight());
                    ++line;
                    continue;
                }
                g.drawString(sb.toString(), viewTopLeft.x + viewExtent.width - fm.stringWidth(sb.toString()) - 5, line * fm.getHeight());
                sb = new StringBuffer(nextword + " ");
                ++line;
            }
            if (sb.length() > 0) {
                g.drawString(sb.toString(), viewTopLeft.x + viewExtent.width - fm.stringWidth(sb.toString()) - 5, line * fm.getHeight());
                ++line;
            }
        }
    }

    void dispose() {
        if (this.currThumbnailBuilder != null && this.currThumbnailBuilder.isAlive()) {
            this.currThumbnailBuilder.byCurrThreadState = 0;
            try {
                this.currThumbnailBuilder.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.currThumbnailBuilder = null;
        }
        this.redRectangle = null;
        this.redRectangleHandle = null;
        this.thumbPopupMenu = null;
        this.currImageRect = null;
        this.thumbAnnView = null;
        this.thumbImageScale = null;
        this.thumbnails.clear();
        this.thumbnails = null;
    }

    private void showPopupMenu(MouseEvent e) {
        if (this.thumbPopupMenu != null) {
            this.thumbPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void traceOut(String message) {
        if (_trace) {
            System.out.println(message);
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (this.isShowing()) {
            MouseEvent mEvent = SwingUtilities.convertMouseEvent((JComponent)event.getSource(), event, this);
            Point ptClick = mEvent.getPoint();
            if (mEvent.isPopupTrigger()) {
                this.showPopupMenu(mEvent);
            }
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent mEvent) {
    }

    public void mouseDragged(MouseEvent event) {
        if (this.isShowing()) {
            MouseEvent mEvent = SwingUtilities.convertMouseEvent((JComponent)event.getSource(), event, this);
            Point ptClick = mEvent.getPoint();
            if ((mEvent.getModifiers() & 0x10) == 16) {
                int yDelta;
                int xDelta;
                if (this.scalingRedRect) {
                    xDelta = ptClick.x - this.ptInRedRectHandle.x;
                    yDelta = ptClick.y - this.ptInRedRectHandle.y;
                    if (xDelta != 0 || yDelta != 0) {
                        this.ptInRedRectHandle.x = ptClick.x;
                        this.ptInRedRectHandle.y = ptClick.y;
                        int newWidth = this.redRectangle.width + xDelta;
                        int newHeight = this.redRectangle.height + yDelta;
                        if (newWidth < 7) {
                            newWidth = 7;
                        }
                        if (newHeight < 7) {
                            newHeight = 7;
                        }
                        if (this.redRectangle.x + newWidth > this.currImageRect.x + this.currImageRect.width) {
                            newWidth = this.currImageRect.x + this.currImageRect.width - this.redRectangle.x;
                        }
                        if (this.redRectangle.y + newHeight > this.currImageRect.y + this.currImageRect.height) {
                            newHeight = this.currImageRect.y + this.currImageRect.height - this.redRectangle.y;
                        }
                        if ((float)newWidth / (float)newHeight != this.redRectAspect) {
                            if ((double)this.redRectAspect < 1.0) {
                                newHeight = (int)((float)newWidth / this.redRectAspect);
                            } else {
                                newWidth = (int)((float)newHeight * this.redRectAspect);
                            }
                        }
                        this.redRectangle.setSize(newWidth, newHeight);
                        this.redRectangleHandle.setLocation(this.redRectangle.x + this.redRectangle.width - 5, this.redRectangle.y + this.redRectangle.height - 5);
                        this.repaint();
                    }
                }
                if (this.redRectClicked) {
                    xDelta = ptClick.x - this.ptInRedRect.x;
                    yDelta = ptClick.y - this.ptInRedRect.y;
                    if (xDelta != 0 || yDelta != 0) {
                        this.ptInRedRect.x = ptClick.x;
                        this.ptInRedRect.y = ptClick.y;
                        int newX = this.redRectangle.x + xDelta;
                        int newY = this.redRectangle.y + yDelta;
                        if (newX < this.currImageRect.x) {
                            newX = this.currImageRect.x;
                        }
                        if (newY < this.currImageRect.y) {
                            newY = this.currImageRect.y;
                        }
                        if (newX + this.redRectangle.width > this.currImageRect.x + this.currImageRect.width) {
                            newX = this.currImageRect.x + this.currImageRect.width - this.redRectangle.width - 1;
                        }
                        if (newY + this.redRectangle.height > this.currImageRect.y + this.currImageRect.height) {
                            newY = this.currImageRect.y + this.currImageRect.height - this.redRectangle.height - 1;
                        }
                        this.redRectangle.setLocation(newX, newY);
                        this.redRectangleHandle.setLocation(this.redRectangle.x + this.redRectangle.width - 5, this.redRectangle.y + this.redRectangle.height - 5);
                        this.repaint();
                    }
                }
            }
        }
    }

    public void mouseMoved(MouseEvent event) {
        if (this.isShowing()) {
            MouseEvent mEvent = SwingUtilities.convertMouseEvent((JComponent)event.getSource(), event, this);
            Point ptClick = mEvent.getPoint();
            if (this.redRectangle == null) {
                return;
            }
            if (this.redRectangleHandle.contains(ptClick)) {
                this.setCursor(Cursor.getPredefinedCursor(5));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void mousePressed(MouseEvent event) {
        if (this.isShowing()) {
            boolean rightButtonPressed;
            MouseEvent mEvent = SwingUtilities.convertMouseEvent((JComponent)event.getSource(), event, this);
            Point ptClick = mEvent.getPoint();
            boolean leftButtonPressed = (mEvent.getModifiers() & 0x10) == 16;
            boolean bl = rightButtonPressed = (mEvent.getModifiers() & 4) == 4;
            if (leftButtonPressed || rightButtonPressed) {
                int pagePosition;
                if (leftButtonPressed && this.redRectangle != null) {
                    if (this.redRectangleHandle.contains(ptClick)) {
                        this.setCursor(Cursor.getPredefinedCursor(5));
                        this.ptInRedRectHandle = ptClick;
                        this.scalingRedRect = true;
                        this.redRectAspect = (float)this.redRectangle.width / (float)this.redRectangle.height;
                        return;
                    }
                    if (this.redRectangle.contains(ptClick)) {
                        this.setCursor(Cursor.getPredefinedCursor(12));
                        this.ptInRedRect = ptClick;
                        this.redRectClicked = true;
                        return;
                    }
                }
                if ((pagePosition = this.getPagePositionFromPoint(ptClick)) < 1 || pagePosition > this.thumbnailsCount) {
                    return;
                }
                PPageModel thePageModel = (PPageModel)this.getDocModel();
                int pageNumber = thePageModel.getPageNumber(pagePosition);
                Object selectedPages = null;
                if (this.bMultiSelectAllowed && (mEvent.getModifiersEx() & 0x40) == 64) {
                    int startPosition = Math.min(pagePosition, this.lastClickedPagePosition);
                    int endPosition = Math.max(pagePosition, this.lastClickedPagePosition);
                    int[] multiPage = new int[endPosition - startPosition + 1];
                    for (int i = 0; i <= endPosition - startPosition; ++i) {
                        int selectedPageNumber = thePageModel.getPageNumber(startPosition + i);
                        if (!thePageModel.isPageValid(selectedPageNumber)) continue;
                        multiPage[i] = selectedPageNumber;
                    }
                    thePageModel.setSelectedPages(multiPage);
                } else if (this.bMultiSelectAllowed && (mEvent.getModifiersEx() & 0x80) == 128) {
                    if (!thePageModel.isPageSelected(pageNumber)) {
                        thePageModel.addToSelectedPages(new int[]{pageNumber});
                    } else {
                        thePageModel.removeFromSelectedPages(new int[]{pageNumber});
                    }
                    this.lastClickedPagePosition = pagePosition;
                } else {
                    thePageModel.setCurrentPagePosition(pagePosition);
                    this.lastClickedPagePosition = pagePosition;
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            if (mEvent.isPopupTrigger()) {
                this.showPopupMenu(mEvent);
            }
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.isShowing()) {
            MouseEvent mEvent = SwingUtilities.convertMouseEvent((JComponent)event.getSource(), event, this);
            Point ptClick = mEvent.getPoint();
            if (mEvent.isPopupTrigger()) {
                this.showPopupMenu(mEvent);
            }
            if ((mEvent.getModifiers() & 0x10) == 16 && (this.redRectClicked || this.scalingRedRect)) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.setCurrentViewRect();
                if (this.currThumbnailBuilder != null && this.currThumbnailBuilder.isAlive() && this.currThumbnailBuilder.byCurrThreadState == 2) {
                    this.updateThumbnails(0, 0);
                }
                this.redRectClicked = false;
                this.scalingRedRect = false;
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private int getPagePositionFromPoint(Point ptClick) {
        int numColumns = this.getWidth() / (this.thumbnailSize.width + this.thumbnailOffsets.width);
        if (numColumns == 0) {
            numColumns = 1;
        }
        int pageColumnIndex = ptClick.x / (this.thumbnailSize.width + this.thumbnailOffsets.width);
        int pageRowIndex = ptClick.y / (this.thumbnailSize.height + this.thumbnailOffsets.height);
        int pagePosition = pageRowIndex * numColumns + pageColumnIndex + 1;
        int remainingYpixels = ptClick.y % (this.thumbnailSize.height + this.thumbnailOffsets.height);
        if (remainingYpixels > this.thumbnailOffsets.width && remainingYpixels < this.thumbnailOffsets.width + this.thumbnailSize.height) {
            int remainingXpixels = ptClick.x % (this.thumbnailSize.width + this.thumbnailOffsets.width);
            PPageModel thePageModel = (PPageModel)this.getDocModel();
            int pageNumber = thePageModel.getPageNumber(pagePosition);
            Object selectedPages = null;
            if (remainingXpixels > this.thumbnailOffsets.width / 2 && remainingXpixels < this.thumbnailOffsets.width / 2 + this.thumbnailSize.width) {
                return pagePosition;
            }
        }
        return 0;
    }

    private class thumbnailPainter
    implements Runnable {
        private thumbnailPainter() {
        }

        public void run() {
            PPageThumbnailView.this.display();
        }
    }

    private class thumbnailBuilder
    extends Thread {
        public int currPagePosition;
        public int jumpPagePosition;
        public byte byCurrThreadState;

        public thumbnailBuilder(String name) {
            super(name);
            this.currPagePosition = 0;
            this.jumpPagePosition = 0;
            this.byCurrThreadState = 1;
        }

        public void run() {
            PPageModel thePageModel = (PPageModel)PPageThumbnailView.this.getDocModel();
            Image thumbImage = null;
            while (this.byCurrThreadState != 0) {
                switch (this.byCurrThreadState) {
                    case 1: {
                        this.byCurrThreadState = (byte)2;
                        break;
                    }
                    case 4: {
                        PPageThumbnailView.this.thumbnails.clear();
                        this.currPagePosition = 1;
                        this.byCurrThreadState = 1;
                        break;
                    }
                    case 5: {
                        int jumpPageNumber = ((PPageModel)PPageThumbnailView.this.getDocModel()).getPageNumber(this.jumpPagePosition);
                        try {
                            if (PPageThumbnailView.this.thumbnails.containsKey(new Integer(jumpPageNumber - 1))) {
                                this.byCurrThreadState = (byte)2;
                                break;
                            }
                            double jumpScale = thePageModel.getScaleToFit(jumpPageNumber, PPageThumbnailView.this.thumbnailSize, 0, 0, 3);
                            thumbnailBuilder.yield();
                            thumbImage = thePageModel.getThumbnailImage(this.jumpPagePosition, jumpScale);
                            PPageThumbnailView.this.thumbImageScale.insertElementAt(new Float(jumpScale), jumpPageNumber - 1);
                            if (jumpPageNumber < PPageThumbnailView.this.thumbImageScale.size()) {
                                PPageThumbnailView.this.thumbImageScale.remove(jumpPageNumber);
                            }
                            try {
                                PPageThumbnailView.this.tracker.addImage(thumbImage, 0);
                                PPageThumbnailView.this.tracker.waitForID(0);
                            }
                            catch (InterruptedException e) {}
                        }
                        catch (Exception ex) {
                        }
                        catch (OutOfMemoryError memError) {
                            System.out.println("Getting pageImage:" + memError);
                            this.byCurrThreadState = 1;
                            break;
                        }
                        if (thumbImage != null) {
                            PPageThumbnailView.this.thumbnails.put(new Integer(jumpPageNumber - 1), thumbImage);
                            SwingUtilities.invokeLater(new thumbnailPainter());
                        }
                        this.byCurrThreadState = (byte)2;
                        break;
                    }
                    case 3: {
                        thumbImage = null;
                        if (PPageThumbnailView.this.pageCountFromModel <= 0) {
                            PPageThumbnailView.this.thumbnailsCount = 0;
                        } else {
                            PPageThumbnailView.this.thumbnailsCount = PPageThumbnailView.this.pageCountFromModel;
                        }
                        if (PPageThumbnailView.this.thumbImageScale == null) {
                            PPageThumbnailView.this.thumbImageScale = new Vector();
                        }
                        this.currPagePosition = 1;
                        this.byCurrThreadState = (byte)2;
                    }
                    case 2: {
                        int currPageNumber = ((PPageModel)PPageThumbnailView.this.getDocModel()).getPageNumber(this.currPagePosition);
                        if (this.currPagePosition < 1 || PPageThumbnailView.this.pageCountFromModel != -1 && this.currPagePosition > PPageThumbnailView.this.pageCountFromModel) {
                            this.byCurrThreadState = 0;
                            break;
                        }
                        try {
                            if (PPageThumbnailView.this.thumbnails.containsKey(new Integer(currPageNumber - 1))) {
                                ++this.currPagePosition;
                                break;
                            }
                            double currScale = thePageModel.getScaleToFit(currPageNumber, PPageThumbnailView.this.thumbnailSize, 0, 0, 3);
                            thumbnailBuilder.yield();
                            thumbImage = thePageModel.getThumbnailImage(this.currPagePosition, currScale);
                            PPageThumbnailView.this.thumbImageScale.insertElementAt(new Float(currScale), currPageNumber - 1);
                            if (currPageNumber < PPageThumbnailView.this.thumbImageScale.size()) {
                                PPageThumbnailView.this.thumbImageScale.remove(currPageNumber);
                            }
                            try {
                                PPageThumbnailView.this.tracker.addImage(thumbImage, 0);
                                PPageThumbnailView.this.tracker.waitForID(0);
                            }
                            catch (InterruptedException e) {}
                        }
                        catch (Exception ex) {
                            this.byCurrThreadState = 0;
                            break;
                        }
                        catch (OutOfMemoryError memError) {
                            System.out.println("Getting pageImage:" + memError);
                            this.byCurrThreadState = 1;
                            break;
                        }
                        if (thumbImage != null) {
                            PPageThumbnailView.this.thumbnails.put(new Integer(currPageNumber - 1), thumbImage);
                            if (PPageThumbnailView.this.pageCountFromModel == -1 && PPageThumbnailView.this.thumbnailsCount < this.currPagePosition) {
                                PPageThumbnailView.this.thumbnailsCount++;
                            }
                            SwingUtilities.invokeLater(new thumbnailPainter());
                        }
                        ++this.currPagePosition;
                        if (thumbImage != null && (PPageThumbnailView.this.pageCountFromModel == -1 || this.currPagePosition <= PPageThumbnailView.this.pageCountFromModel)) break;
                        if (PPageThumbnailView.this.pageCountFromModel == -1) {
                            PPageThumbnailView.this.pageCountFromModel = thePageModel.getPageCount();
                            if (PPageThumbnailView.this.pageCountFromModel != -1) {
                                PPageThumbnailView.this.thumbnailsCount = PPageThumbnailView.this.pageCountFromModel;
                            }
                        }
                        this.byCurrThreadState = 0;
                    }
                }
            }
            SwingUtilities.invokeLater(new thumbnailPainter());
            System.gc();
        }
    }
}

