/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBStreamingDocServices;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class PPageSelection
implements Transferable,
Serializable {
    public static DataFlavor localPageSelectionFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=com.ibm.mm.viewer.PPageSelection", "Local Page Selection");
    public static DataFlavor remotePageSelectionFlavor = new DataFlavor("application/x-java-serialized-object;class=com.ibm.mm.viewer.PPageSelection", "Page Selection Stream");
    private static DataFlavor[] dataFlavors = new DataFlavor[]{localPageSelectionFlavor, remotePageSelectionFlavor};
    private transient CMBStreamingDocServices docServices;
    private transient CMBAnnotationServices annoServices;
    private transient CMBDocument _selectedDoc;
    private transient CMBAnnotationSet _selectedAnno;
    private int[] _pageNumbers;
    private byte[] _docByteArray;
    private byte[] _annoByteArray;
    private transient PPageModel _selectedModel;
    private String _mimeType;
    private String _format;
    private transient Serializable _relatedInfo;
    private byte[] _relatedInfoByteArray;

    public PPageSelection() {
    }

    public PPageSelection(CMBDocument doc, CMBAnnotationSet anno, int[] selectedPageNumbers) {
        this._selectedDoc = doc;
        this._selectedAnno = anno;
        this._pageNumbers = selectedPageNumbers;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return dataFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(localPageSelectionFlavor) || flavor.equals(remotePageSelectionFlavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (flavor.equals(localPageSelectionFlavor)) {
            return this;
        }
        if (flavor.equals(remotePageSelectionFlavor)) {
            this.writeDocumentToByteArray();
            return this;
        }
        return null;
    }

    private void writeDocumentToByteArray() {
        ByteArrayOutputStream docOutStream = new ByteArrayOutputStream();
        ByteArrayOutputStream annoOutStream = new ByteArrayOutputStream();
        try {
            this._mimeType = this._selectedDoc.getMimeType();
            this._format = this._selectedAnno.getAnnotationFormat();
            CMBDocument transferDoc = this.docServices.createDocument(this._mimeType);
            CMBAnnotationSet transferAnno = this.annoServices.loadAnnotationSet(null, this._selectedAnno.getAnnotationFormat(), transferDoc.getAnnotationPosition(), 1, 0);
            for (int pageIndex = 0; pageIndex < this._pageNumbers.length; ++pageIndex) {
                this.docServices.copyPages(this._selectedDoc, this._pageNumbers[pageIndex], this._pageNumbers[pageIndex], transferDoc, pageIndex);
                CMBPageAnnotation[] annotations = this._selectedAnno.getPageAnnotations(this._pageNumbers[pageIndex]);
                for (int i = 0; i < annotations.length; ++i) {
                    CMBPageAnnotation annotation = (CMBPageAnnotation)annotations[i].clone();
                    annotation.setPageNumber(pageIndex + 1);
                    annotation.setCanHide(true);
                    annotation.setCanShow(true);
                    annotation.setCanUpdate(true);
                    annotation.setCanDelete(true);
                    try {
                        transferAnno.addAnnotation(annotation);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            transferDoc.write(docOutStream);
            transferAnno.write(annoOutStream);
        }
        catch (Exception e) {
            // empty catch block
        }
        this._docByteArray = docOutStream.toByteArray();
        this._annoByteArray = annoOutStream.toByteArray();
        if (this._relatedInfo != null) {
            ByteArrayOutputStream relatedInfoOutStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectStream = new ObjectOutputStream(relatedInfoOutStream);
                objectStream.writeObject(this._relatedInfo);
            }
            catch (IOException e) {
                // empty catch block
            }
            this._relatedInfoByteArray = relatedInfoOutStream.toByteArray();
        }
    }

    protected void readDocumentFromByteArray() {
        try {
            ByteArrayInputStream docInStream = new ByteArrayInputStream(this._docByteArray);
            ByteArrayInputStream annoInStream = new ByteArrayInputStream(this._annoByteArray);
            this._selectedDoc = this.docServices.loadDocument(docInStream, 1, this._mimeType, this._mimeType, annoInStream, null);
            this._selectedAnno = this.annoServices.loadAnnotationSet(annoInStream, this._format, this._selectedDoc.getAnnotationPosition(), 1, 0);
            this._pageNumbers = new int[this._selectedDoc.getPageCount()];
            for (int i = 0; i < this._pageNumbers.length; ++i) {
                this._pageNumbers[i] = i + 1;
            }
            if (this._relatedInfoByteArray != null) {
                ByteArrayInputStream relatedInfoInStream = new ByteArrayInputStream(this._relatedInfoByteArray);
                ObjectInputStream objectStream = new ObjectInputStream(relatedInfoInStream);
                this._relatedInfo = (Serializable)objectStream.readObject();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int[] getPageNumbers() {
        return this._pageNumbers;
    }

    public CMBDocument getSelectedDoc() {
        return this._selectedDoc;
    }

    public CMBAnnotationSet getSelectedAnno() {
        return this._selectedAnno;
    }

    public void setSelectedAnno(CMBAnnotationSet selectedAnno) {
        this._selectedAnno = selectedAnno;
    }

    public PPageModel getSelectedModel() {
        return this._selectedModel;
    }

    public void setSelectedModel(PPageModel selectedModel) {
        this._selectedModel = selectedModel;
    }

    public CMBAnnotationServices getAnnoServices() {
        return this.annoServices;
    }

    public CMBStreamingDocServices getDocServices() {
        return this.docServices;
    }

    public void setAnnoServices(CMBAnnotationServices annoServices) {
        this.annoServices = annoServices;
    }

    public void setDocServices(CMBStreamingDocServices docServices) {
        this.docServices = docServices;
    }

    public Serializable getRelatedInfo() {
        return this._relatedInfo;
    }

    public void setRelatedInfo(Serializable relatedInfo) {
        this._relatedInfo = relatedInfo;
    }
}

