/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBCustomPageablePrintable;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.CMBViewerException;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.print.CancelablePrintJob;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import javax.swing.JPanel;

class PPagePrintable
implements Printable,
Pageable {
    private PrintRequestAttributeSet aset = null;
    private CMBGenericDocViewer _viewer;
    private static double PRINTER_GRAPHICS_RESOLUTION = 72.0;
    private CancelablePrintJob _cpj;
    private PageFormat _pageFormat;
    private PPageModel _pageModel;
    private boolean _printAnno;
    private String _printScaleString;
    private boolean _centerOnPage;
    private int cachePageNumber;
    private Image cacheDocImage;
    private BufferedImage cachePrintImage;
    int pageRangeCount = 0;
    ArrayList watermarkPrintables = new ArrayList();

    public PPagePrintable(PPageModel model, PageFormat format, CMBGenericDocViewer viewer) {
        this._pageModel = model;
        this._pageFormat = format;
        this._viewer = viewer;
    }

    public PPagePrintable(PPageModel model, Properties configProps, CMBGenericDocViewer viewer) {
        double topMargin = 0.0;
        double leftMargin = 0.0;
        double bottomMargin = 0.0;
        double rightMargin = 0.0;
        this._pageModel = model;
        this._viewer = viewer;
        String docMimetype = this._pageModel.getDocument().getMimeType();
        String marginsProp = configProps.getProperty("printmargins." + docMimetype, "0,0,0,0");
        StringTokenizer stzMarginsProp = new StringTokenizer(marginsProp, ", ");
        try {
            leftMargin = new Double(stzMarginsProp.nextToken()) * 72.0;
            topMargin = new Double(stzMarginsProp.nextToken()) * 72.0;
            rightMargin = new Double(stzMarginsProp.nextToken()) * 72.0;
            bottomMargin = new Double(stzMarginsProp.nextToken()) * 72.0;
        }
        catch (NumberFormatException nfe) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.InvalidPropertyValue", new Object[]{"printmargins." + docMimetype}));
        }
        catch (NoSuchElementException e) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.InvalidPropertyValue", new Object[]{"printmargins." + docMimetype}));
        }
        leftMargin = leftMargin < 0.0 ? 0.0 : leftMargin;
        topMargin = topMargin < 0.0 ? 0.0 : topMargin;
        rightMargin = rightMargin < 0.0 ? 0.0 : rightMargin;
        bottomMargin = bottomMargin < 0.0 ? 0.0 : bottomMargin;
        PrinterJob pj = PrinterJob.getPrinterJob();
        this._pageFormat = pj.defaultPage();
        Paper paper = this._pageFormat.getPaper();
        if (paper.getWidth() - (leftMargin + rightMargin) < 0.0 || paper.getHeight() - (topMargin + bottomMargin) < 0.0) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.InvalidPropertyValue", new Object[]{"printmargins." + docMimetype}));
        }
        paper.setImageableArea(leftMargin, topMargin, paper.getWidth() - (leftMargin + rightMargin), paper.getHeight() - (topMargin + bottomMargin));
        this._pageFormat.setPaper(paper);
    }

    public void addWatermarkPrintable(CMBCustomPageablePrintable watermarkPrintable) {
        this.watermarkPrintables.add(watermarkPrintable);
    }

    public int print(Graphics g, PageFormat format, int pageIndex) throws PrinterException {
        String methodName = "print";
        PrinterJob pj = ((PrinterGraphics)((Object)g)).getPrinterJob();
        if (pj.isCancelled()) {
            return 1;
        }
        if (pageIndex >= this._pageModel.getNumberOfPages()) {
            return 1;
        }
        format = pj.validatePage(format);
        int pageNumber = this._pageModel.getPageNumber(pageIndex + 1);
        CMBDocument document = this._pageModel.getDocument();
        Image unscaledImage = null;
        double printScale = 1.0;
        double widthScale = 1.0;
        double heightScale = 1.0;
        double imagePageWidth = 0.0;
        double imagePageHeight = 0.0;
        double resolutionFactor = 1.0;
        try {
            CMBPage currPage = document.getPage(pageNumber);
            imagePageWidth = currPage.getWidth() * (double)currPage.getPageResolution();
            imagePageHeight = currPage.getHeight() * (double)currPage.getPageResolution();
            double pageResolution = Math.max((double)currPage.getPageXResolution(), (double)currPage.getPageYResolution());
            resolutionFactor = PRINTER_GRAPHICS_RESOLUTION / pageResolution;
        }
        catch (Exception ioe) {
            ViewerLogger.logError((Object)this, methodName, ioe);
            return 1;
        }
        double printPageWidth = format.getImageableWidth();
        double printPageHeight = format.getImageableHeight();
        if (this._printScaleString.compareToIgnoreCase(this._viewer.getConfigPropertyOrMessage("zoom.item.FitPage")) == 0) {
            if (imagePageWidth <= 0.0 || imagePageHeight <= 0.0 || printPageWidth <= 0.0 || printPageHeight <= 0.0) {
                return 1;
            }
            widthScale = printPageWidth / imagePageWidth;
            heightScale = printPageHeight / imagePageHeight;
            printScale = Math.min(widthScale, heightScale);
        } else if (this._printScaleString.compareToIgnoreCase(this._viewer.getConfigPropertyOrMessage("zoom.item.ActualSize")) == 0) {
            printScale = 1.0 * resolutionFactor;
        } else if (this._printScaleString.compareToIgnoreCase(this._viewer.getConfigPropertyOrMessage("zoom.item.FitHeight")) == 0) {
            printScale = printPageHeight / imagePageHeight;
        } else if (this._printScaleString.compareToIgnoreCase(this._viewer.getConfigPropertyOrMessage("zoom.item.FitWidth")) == 0) {
            printScale = printPageWidth / imagePageWidth;
        } else if (this._printScaleString.endsWith("%")) {
            String zoomString = this._printScaleString.substring(0, this._printScaleString.length() - 1);
            printScale = new Double(zoomString.trim()) / 100.0 * resolutionFactor;
        } else {
            double d = Double.valueOf(this._printScaleString).intValue();
            printScale = d / 100.0 * resolutionFactor;
        }
        boolean currEnhance = document.getEnhance();
        if (document.getCanEnhance()) {
            document.setEnhance(true);
        }
        JPanel jp = new JPanel();
        try {
            double imageCenterY;
            double imageCenterX;
            AffineTransform a;
            if (this.cachePageNumber != pageNumber) {
                CMBPage page = null;
                if (document.getCanPaginate()) {
                    page = document.getPage(pageNumber);
                }
                if (page != null && page.getCanGetImage()) {
                    if (this.cacheDocImage != null) {
                        this.cacheDocImage.flush();
                        this.cacheDocImage = null;
                        System.gc();
                    }
                    this.cacheDocImage = page.getImage(1.0);
                }
                if (this.cacheDocImage == null) {
                    unscaledImage = this._pageModel.getPageImage(pageNumber);
                    try {
                        MediaTracker tracker = new MediaTracker(jp);
                        tracker.addImage(unscaledImage, 0);
                        tracker.waitForID(0);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    int imageWidth = unscaledImage.getWidth(null);
                    int imageHeight = unscaledImage.getHeight(null);
                    double currDocScale = document.getPreferredScale();
                    int printWidth = (int)((double)imageWidth / currDocScale * printScale);
                    int printHeight = (int)((double)imageHeight / currDocScale * printScale);
                    this.cacheDocImage = unscaledImage.getScaledInstance(printWidth, printHeight, 4);
                }
                try {
                    MediaTracker tracker = new MediaTracker(jp);
                    tracker.addImage(this.cacheDocImage, 0);
                    tracker.waitForID(0);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.cacheDocImage == null) {
                    if (document.getCanEnhance()) {
                        document.setEnhance(currEnhance);
                    }
                    return 1;
                }
            }
            Graphics2D g2d = (Graphics2D)g;
            CMBAnnotationSet annoSet = this._pageModel.getAnnotationSet();
            double cachePrintScale = 1.0;
            if (this._printAnno && annoSet != null && annoSet.getPageAnnotations(pageNumber).length > 0) {
                if (this.cachePageNumber != pageNumber) {
                    if (this.cachePrintImage != null) {
                        this.cachePrintImage.flush();
                        this.cachePrintImage = null;
                        System.gc();
                    }
                    if (printScale > 1.0) {
                        this.cachePrintImage = widthScale != heightScale ? new BufferedImage((int)(imagePageWidth * widthScale), (int)(imagePageHeight * heightScale), 2) : new BufferedImage((int)(imagePageWidth * printScale), (int)(imagePageHeight * printScale), 2);
                        cachePrintScale = printScale;
                    } else {
                        this.cachePrintImage = new BufferedImage((int)imagePageWidth, (int)imagePageHeight, 2);
                    }
                    this.cachePageNumber = pageNumber;
                    Graphics2D offscreenGraphics = this.cachePrintImage.createGraphics();
                    AffineTransform at = new AffineTransform();
                    at.setToIdentity();
                    at.scale(cachePrintScale, cachePrintScale);
                    offscreenGraphics.setTransform(at);
                    offscreenGraphics.drawImage(this.cacheDocImage, 0, 0, null);
                    Iterator i = annoSet.getIterator(pageNumber);
                    while (i.hasNext()) {
                        CMBPageAnnotation a2 = (CMBPageAnnotation)i.next();
                        a2.showHandles(false);
                        a2.draw(offscreenGraphics);
                    }
                    offscreenGraphics.dispose();
                    offscreenGraphics = null;
                }
                if (this.isCenterOnPage()) {
                    a = new AffineTransform();
                    a.setToIdentity();
                    double pageCenterX = format.getImageableWidth() / 2.0;
                    double pageCenterY = format.getImageableHeight() / 2.0;
                    imageCenterX = imagePageWidth / 2.0;
                    imageCenterY = imagePageHeight / 2.0;
                    if (widthScale != heightScale) {
                        a.translate(pageCenterX - imageCenterX * widthScale + format.getImageableX(), pageCenterY - imageCenterY * heightScale + format.getImageableY());
                    } else {
                        a.translate(pageCenterX - imageCenterX * printScale + format.getImageableX(), pageCenterY - imageCenterY * printScale + format.getImageableY());
                    }
                    if (printScale < 1.0) {
                        a.scale(printScale, printScale);
                    }
                    g2d.drawImage(this.cachePrintImage, a, null);
                } else {
                    a = new AffineTransform();
                    a.setToIdentity();
                    a.translate(format.getImageableX(), format.getImageableY());
                    if (printScale < 1.0) {
                        a.scale(printScale, printScale);
                    }
                    g2d.drawImage(this.cachePrintImage, a, null);
                }
            } else if (this.isCenterOnPage()) {
                a = new AffineTransform();
                a.setToIdentity();
                double pageCenterX = format.getImageableWidth() / 2.0;
                double pageCenterY = format.getImageableHeight() / 2.0;
                imageCenterX = imagePageWidth / 2.0;
                imageCenterY = imagePageHeight / 2.0;
                if (widthScale != heightScale) {
                    a.translate(pageCenterX - imageCenterX * widthScale + format.getImageableX(), pageCenterY - imageCenterY * heightScale + format.getImageableY());
                } else {
                    a.translate(pageCenterX - imageCenterX * printScale + format.getImageableX(), pageCenterY - imageCenterY * printScale + format.getImageableY());
                }
                a.scale(printScale, printScale);
                g2d.drawImage(this.cacheDocImage, a, null);
            } else {
                a = new AffineTransform();
                a.setToIdentity();
                a.translate(format.getImageableX(), format.getImageableY());
                a.scale(printScale, printScale);
                g2d.drawImage(this.cacheDocImage, a, null);
            }
            this.cachePageNumber = pageNumber;
            System.gc();
            if (document.getCanEnhance()) {
                document.setEnhance(currEnhance);
            }
            for (int i = 0; i < this.watermarkPrintables.size(); ++i) {
                CMBCustomPageablePrintable watermarkPrintable = (CMBCustomPageablePrintable)this.watermarkPrintables.get(i);
                watermarkPrintable.print(g, format, pageIndex);
            }
            if (this._cpj != null) {
                this._viewer.fireCMBDocPrintStatusEvent(4, 1, pageIndex + 1, this._cpj, document);
            } else if (this.aset != null) {
                PageRanges pageRanges = (PageRanges)this.aset.get(PageRanges.class);
                this._viewer.fireCMBDocPrintStatusEvent(4, 1, PPagePrintable.getPageNumberFromPageRange(pageRanges, this._pageModel.getPagePosition(pageNumber)), null, document);
            } else {
                this._viewer.fireCMBDocPrintStatusEvent(4, 1, pageNumber, null, document);
            }
            return 0;
        }
        catch (RuntimeException e) {
            if (document.isDisposed()) {
                return 1;
            }
            ViewerLogger.logError((Object)this, methodName, e);
            return 1;
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return 1;
        }
        catch (OutOfMemoryError oom) {
            ViewerLogger.logError((Object)this, methodName, oom);
            if (this.cachePrintImage != null) {
                this.cachePrintImage.flush();
                this.cachePrintImage = null;
            }
            if (this.cacheDocImage != null) {
                this.cacheDocImage.flush();
                this.cacheDocImage = null;
            }
            PrinterAbortException e = new PrinterAbortException(PViewerUtilities.getMessage("DocumentViewer.outOfMemoryErrorMessage"));
            e.initCause(oom);
            throw e;
        }
    }

    public int getNumberOfPages() {
        return this._pageModel.getNumberOfPages();
    }

    int getNumberOfPagesToPrint() {
        if (this.pageRangeCount > 0) {
            return this.pageRangeCount;
        }
        this.pageRangeCount = this._pageModel.getNumberOfPages();
        return this.pageRangeCount;
    }

    static int getPageNumberFromPageRange(PageRanges pageRanges, int pageNumber) {
        int[][] myMembers = pageRanges.getMembers();
        int n = myMembers.length;
        int returnValue = 0;
        for (int i = 0; i < n; ++i) {
            if (pageNumber >= myMembers[i][0] && pageNumber <= myMembers[i][1]) {
                return returnValue += pageNumber - myMembers[i][0] + 1;
            }
            returnValue += myMembers[i][1] - myMembers[i][0] + 1;
        }
        return returnValue;
    }

    public boolean hasAnnotations() {
        return this._pageModel.getAnnotationSet() != null && this._pageModel.getAnnotationSet().getAnnotationCount() > 0;
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this._pageFormat;
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    void setPageFormat(PageFormat pageFormat) {
        this._pageFormat = pageFormat;
    }

    PPageModel getPageModel() {
        return this._pageModel;
    }

    void setPageModel(PPageModel pageModel) {
        this._pageModel = pageModel;
    }

    boolean isPrintAnno() {
        return this._printAnno;
    }

    String getPrintScaleString() {
        return this._printScaleString;
    }

    void setPrintAnno(boolean printAnno) {
        this._printAnno = printAnno;
    }

    void setPrintScaleString(String printScaleString) {
        this._printScaleString = printScaleString;
    }

    public PrintRequestAttributeSet getAset() {
        return this.aset;
    }

    public void setAset(PrintRequestAttributeSet aset) {
        this.aset = aset;
    }

    public boolean isCenterOnPage() {
        return this._centerOnPage;
    }

    public void setCenterOnPage(boolean b) {
        this._centerOnPage = b;
    }

    public CancelablePrintJob getCpj() {
        return this._cpj;
    }

    public void setCpj(CancelablePrintJob _cpj) {
        this._cpj = _cpj;
    }

    public void dispose() {
        if (this.cacheDocImage != null) {
            this.cacheDocImage.flush();
            this.cacheDocImage = null;
        }
        if (this.cachePrintImage != null) {
            this.cachePrintImage.flush();
            this.cachePrintImage = null;
        }
        if (this.aset != null) {
            this.aset.clear();
            this.aset = null;
        }
    }
}

