/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBBookmark;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.CMBViewerConstants;
import com.ibm.mm.viewer.PClippedPages;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PFullSizeView;
import com.ibm.mm.viewer.POptionPane;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class PPageModel
extends PDocModel
implements CMBViewerConstants {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private static boolean _scaleWithEngine = true;
    private static double DEFAULT_SCALE = 1.0;
    private int currentPagePosition = 1;
    private int pageCount = -1;
    private int fit = 0;
    private int rotation = 0;
    private double zoomFactor = 0.1;
    private int cachePageNumber = -1;
    private BufferedImage cachePrintImage = null;
    private Image cacheDocImage = null;
    private Hashtable pageImages = new Hashtable();
    private int[] viewablePageNumbers = null;
    private Image currentPageImage = null;
    private Rectangle currViewRectangle = null;
    private boolean bPrintAnno = false;
    private double printScale = DEFAULT_SCALE;
    private GetPageCountWorkerThread threadGetCount = null;
    private int[] selectedPages = null;
    private long pageRefreshDelay = 0L;
    private boolean renderAhead = false;
    private RenderAheadThread lastRenderAheadThread = null;
    private int lastRenderAheadPage = 0;
    private boolean pageToTop = false;
    private boolean deletePagesPrivilege = true;
    private boolean addPagesPrivilege = true;
    private boolean movePagesPrivilege = true;
    private boolean rotatePagesPrivilege = true;
    private boolean printPrivilege = true;
    private boolean exportPrivilege = true;
    private boolean callbackPrintPrivilege;
    private boolean callbackPrintPrivilegeDetermined;
    private boolean redactPrivilege = true;
    private boolean modifyBookmarksPrivilege = true;
    private static Object imageMutex = new Object();
    private boolean outOfMemoryErrorShown = false;
    PFullSizeView activeFullSizeView;
    CMBBookmark[] bookmarks;
    static long lastPageGeneratedTime;
    private String[] exportableMimetypes;
    private double oldScale;
    String lastSearchText;
    int[] lastHitPosition;

    PPageModel(CMBDocument doc, CMBAnnotationSet annoSet) {
        super(doc, annoSet);
        if (doc.isNew()) {
            this.currentPagePosition = 0;
        }
        if (doc.getCanPaginate()) {
            this.threadGetCount = new GetPageCountWorkerThread("getCountThread");
            try {
                this.threadGetCount.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.threadGetCount.start();
        }
    }

    boolean isMaxZoomedOut() {
        if (this.pageCount == 0) {
            return true;
        }
        double docScale = this.document.getPreferredScale();
        return docScale <= this.getCurrMinScale();
    }

    boolean isMaxZoomedIn() {
        if (this.pageCount == 0) {
            return true;
        }
        double docScale = this.document.getPreferredScale();
        return docScale >= this.getCurrMaxScale();
    }

    int getPageCount() {
        String methodName = "getPageCount";
        if (this.document == null) {
            return 0;
        }
        if (!this.document.getCanPaginate()) {
            this.pageCount = 1;
            return this.pageCount;
        }
        if (this.viewablePageNumbers != null) {
            this.pageCount = this.viewablePageNumbers.length;
            return this.pageCount;
        }
        try {
            if (this.pageCount > -1 && this.pageCount > this.document.getPageCount()) {
                return this.document.getPageCount();
            }
            return this.pageCount;
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return this.pageCount;
        }
    }

    private void setPageCount(int count) {
        this.pageCount = count;
        if (this.pageCount >= 0 && this.currentPagePosition > this.pageCount) {
            this.setCurrentPagePosition(this.pageCount);
        }
        if (this.pageCount > 0 && this.currentPagePosition <= 0) {
            this.setCurrentPagePosition(1);
        }
        this.fireDocStateChangedEvent(2);
    }

    public int getNumberOfPages() {
        if (this.document.getCanPaginate()) {
            this.pageCount = this.getPageCount();
            return this.pageCount;
        }
        return 1;
    }

    public PageFormat getPageFormat(int index) {
        return this.pageFormat;
    }

    public Printable getPrintable(int index) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Image getPageImage(int pageNumber) throws Exception {
        long startTime = System.currentTimeMillis();
        Hashtable hashtable = this.pageImages;
        synchronized (hashtable) {
            SoftReference sr;
            Object obj;
            String pageKey = "" + pageNumber + "-" + this.getScale(pageNumber);
            this.currentPageImage = !this.pageImages.containsKey(pageKey) ? this.loadPageImage(pageNumber) : ((obj = (sr = (SoftReference)this.pageImages.get(pageKey)).get()) != null ? (Image)obj : this.loadPageImage(pageNumber));
            if (this.currentPageImage != null) {
                this.pageImages.put(pageKey, new SoftReference<Image>(this.currentPageImage));
            }
            if (this.renderAhead) {
                this.renderPageAhead(pageNumber);
            }
            long endTime = System.currentTimeMillis();
            return this.currentPageImage;
        }
    }

    public boolean useDrawPage(int pageNumber) throws IOException {
        CMBPage page = null;
        if (this.document.getCanPaginate()) {
            page = this.document.getPage(pageNumber);
        }
        if (page == null) {
            return false;
        }
        return page.getUseDraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPage(int pageNumber, double scale, Graphics2D graphics) throws IOException {
        CMBPage page = null;
        if (this.document.getCanPaginate()) {
            page = this.document.getPage(pageNumber);
        }
        if (page != null) {
            Object object = imageMutex;
            synchronized (object) {
                page.draw(scale, graphics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPage(int pageNumber, Graphics2D graphics) throws IOException {
        CMBPage page = null;
        if (this.document.getCanPaginate()) {
            page = this.document.getPage(pageNumber);
        }
        if (page != null) {
            Object object = imageMutex;
            synchronized (object) {
                page.draw(graphics);
            }
        }
    }

    private void renderPageAhead(int pageNumber) {
        if (this.lastRenderAheadPage != pageNumber) {
            this.lastRenderAheadPage = pageNumber;
            if (this.lastRenderAheadThread != null) {
                try {
                    this.lastRenderAheadThread.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            this.lastRenderAheadThread = new RenderAheadThread(pageNumber);
        }
    }

    boolean isValidPagePosition(int pagePosition) {
        if (this.pageCount >= 0) {
            return pagePosition <= this.pageCount;
        }
        try {
            int pageNumber = this.getPageNumber(pagePosition);
            CMBPage page = this.document.getPage(pageNumber);
            return page.isValid();
        }
        catch (Exception e) {
            return false;
        }
    }

    double getScaleToFit(int pageNumber, Dimension windowSize, int vScrollBarWidth, int hScrollBarHeight, int fitType) throws IOException {
        double fitScale;
        double imageHeight;
        double imageWidth;
        if (this.document == null) {
            return 1.0;
        }
        CMBPage page = this.document.getPage(pageNumber);
        if (!page.isValid()) {
            return 1.0;
        }
        int rotation = (page.getRotation() + this.getRotation()) % 4;
        if (rotation == 0 || rotation == 2) {
            imageWidth = page.getWidth() * (double)this.document.getDisplayResolution();
            imageHeight = page.getHeight() * (double)this.document.getDisplayResolution();
        } else {
            imageWidth = page.getHeight() * (double)this.document.getDisplayResolution();
            imageHeight = page.getWidth() * (double)this.document.getDisplayResolution();
        }
        if (imageWidth <= 0.0 || imageHeight <= 0.0 || windowSize.width <= 0 || windowSize.height <= 0) {
            return 0.0;
        }
        if (fitType == 1) {
            fitScale = (double)windowSize.width / imageWidth;
            if (imageHeight * fitScale > (double)windowSize.height) {
                fitScale = (double)(windowSize.width - vScrollBarWidth) / imageWidth;
            }
        } else if (fitType == 2) {
            fitScale = (double)windowSize.height / imageHeight;
            if (imageWidth * fitScale > (double)windowSize.width) {
                fitScale = (double)(windowSize.height - hScrollBarHeight) / imageHeight;
            }
        } else {
            double widthScale = (double)windowSize.width / imageWidth;
            double heightScale = (double)windowSize.height / imageHeight;
            fitScale = Math.min(widthScale, heightScale);
        }
        return fitScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void waitTillActiveDone() {
        try {
            Thread.sleep(100L);
            Object object = imageMutex;
            // MONITORENTER : object
            // MONITOREXIT : object
            while (!this.isActiveDocument()) {
                if (System.currentTimeMillis() - lastPageGeneratedTime >= 250L) return;
                Thread.sleep(100L);
                object = imageMutex;
                // MONITORENTER : object
                // MONITOREXIT : object
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    Image getThumbnailImage(int pagePosition, double scale) {
        if (!this.isActiveDocument()) {
            this.waitTillActiveDone();
        }
        Image image = null;
        image = _scaleWithEngine ? this.getThumbnailImageFromEngine(pagePosition, scale) : this.getThumbnailImageFromJava(pagePosition, scale, 4);
        if (this.isActiveDocument()) {
            lastPageGeneratedTime = System.currentTimeMillis();
        }
        return image;
    }

    private Dimension getScaledRotatedPageSize(CMBPage page) {
        double pageWidth = 0.0;
        double pageHeight = 0.0;
        int scaledRotatedWidth = 0;
        int scaledRotatedHeight = 0;
        pageWidth = page.getWidth() * (double)page.getPageResolution();
        pageHeight = page.getHeight() * (double)page.getPageResolution();
        int rotation = (page.getRotation() + this.getRotation()) % 4;
        double scale = this.document.getPreferredScale();
        scaledRotatedWidth = (int)(pageWidth * scale);
        scaledRotatedHeight = (int)(pageHeight * scale);
        Dimension pageSize = new Dimension(scaledRotatedWidth, scaledRotatedHeight);
        if (rotation == 1 || rotation == 3) {
            pageSize.setSize(new Dimension(scaledRotatedHeight, scaledRotatedWidth));
        }
        return pageSize;
    }

    Polygon getScaledPolygon(Polygon selectedPolygon) {
        double scalex = 1.0;
        double scaley = 1.0;
        scalex = this.getScale() * this.getDisplayResolution() / this.getPageXResolution(this.getCurrentPageNumber());
        scaley = this.getScale() * this.getDisplayResolution() / this.getPageYResolution(this.getCurrentPageNumber());
        int[] x = new int[9];
        int[] y = new int[9];
        for (int i = 0; i < selectedPolygon.npoints; ++i) {
            x[i] = (int)((double)selectedPolygon.xpoints[i] * scalex);
            y[i] = (int)((double)selectedPolygon.ypoints[i] * scaley);
        }
        Polygon spoly = new Polygon(x, y, 9);
        return spoly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getThumbnailImageFromEngine(int pagePosition, double scale) {
        int pageNumber = this.getPageNumber(pagePosition);
        Image pageImage = null;
        CMBPage page = null;
        double pageWidth = 0.0;
        double pageHeight = 0.0;
        try {
            if (this.document.getCanPaginate()) {
                page = this.document.getPage(pageNumber);
            }
            if (page != null && page.getCanGetImage()) {
                Object object = imageMutex;
                synchronized (object) {
                    if (this.isActiveDocument()) {
                        lastPageGeneratedTime = System.currentTimeMillis();
                    }
                    boolean oldEnhance = false;
                    if (this.document.getCanEnhance()) {
                        oldEnhance = this.document.getEnhance();
                        this.document.setEnhance(true);
                    }
                    pageImage = page.getImage(scale / (double)Math.max(page.getPageXResolution(), page.getPageYResolution()) * (double)this.document.getDisplayResolution());
                    if (this.document.getCanEnhance()) {
                        this.document.setEnhance(oldEnhance);
                    }
                    if (this.isActiveDocument()) {
                        lastPageGeneratedTime = System.currentTimeMillis();
                    }
                }
            } else {
                pageImage = this.getThumbnailImageFromJava(pagePosition, scale, 4);
            }
            this.outOfMemoryErrorShown = false;
            return pageImage;
        }
        catch (OutOfMemoryError oom) {
            if (!this.outOfMemoryErrorShown) {
                this.outOfMemoryErrorShown = true;
                JOptionPane.showMessageDialog(null, PViewerUtilities.getMessage("DocumentViewer.outOfMemoryErrorMessage"), PViewerUtilities.getMessage("DocumentViewer.outOfMemoryErrorDialogTitle"), 0, null);
            }
        }
        catch (CMBDocumentEngineException cdee) {
            if (cdee.getErrorData() instanceof OutOfMemoryError && !this.outOfMemoryErrorShown) {
                this.outOfMemoryErrorShown = true;
                OutOfMemoryError oome = (OutOfMemoryError)cdee.getErrorData();
                JOptionPane.showMessageDialog(null, PViewerUtilities.getMessage("DocumentViewer.outOfMemoryErrorMessage"), PViewerUtilities.getMessage("DocumentViewer.outOfMemoryErrorDialogTitle"), 0, null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private Image getThumbnailImageFromJava(int pagePosition, double scale, int scaleType) {
        String methodName = "getThumbnailImageFromJava";
        int pageNumber = this.getPageNumber(pagePosition);
        try {
            String pageKey = "" + pageNumber + "-" + this.getScale(pageNumber);
            Image pageImage = null;
            double pageWidth = 0.0;
            double pageHeight = 0.0;
            boolean newWidth = false;
            boolean newHeight = false;
            pageImage = !this.pageImages.containsKey(pageKey) ? this.loadPageImage(pageNumber) : (Image)this.pageImages.get(pageKey);
            try {
                MediaTracker tracker = new MediaTracker(new JPanel());
                tracker.addImage(pageImage, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (pageImage == null) {
                return null;
            }
            pageWidth = (double)pageImage.getWidth(null) / this.document.getPreferredScale();
            pageHeight = (double)pageImage.getHeight(null) / this.document.getPreferredScale();
            pageImage = pageImage.getScaledInstance((int)(pageWidth * scale), (int)(pageHeight * scale), scaleType);
            return pageImage;
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image loadPageImage(int pageNumber) throws Exception {
        Image image = null;
        CMBPage page = null;
        try {
            if (this.document.getCanPaginate()) {
                page = this.document.getPage(pageNumber);
            }
            if (page != null && page.getCanGetImage()) {
                Object object = imageMutex;
                synchronized (object) {
                    if (this.isActiveDocument()) {
                        lastPageGeneratedTime = System.currentTimeMillis();
                    }
                    image = page.getImage();
                    if (this.isActiveDocument()) {
                        lastPageGeneratedTime = System.currentTimeMillis();
                    }
                }
            } else {
                String mimeType;
                ByteArrayOutputStream stream = new ByteArrayOutputStream(1000);
                if (page == null) {
                    mimeType = this.document.getWriteMimeType();
                    this.document.write(stream);
                } else {
                    mimeType = page.getWriteMimeType();
                    page.write(stream);
                }
                if (mimeType.equals("image/gif") || mimeType.equals("image/jpeg")) {
                    image = Toolkit.getDefaultToolkit().createImage(stream.toByteArray());
                }
            }
            return image;
        }
        catch (Exception e) {
            if (image != null) {
                image.flush();
            }
            throw e;
        }
    }

    double getPrintScale() {
        return this.printScale;
    }

    void setPrintScale(double printScale) {
        this.printScale = printScale;
    }

    boolean getPrintAnno() {
        return this.bPrintAnno;
    }

    void setPrintAnno(boolean bPrint) {
        this.bPrintAnno = bPrint;
    }

    boolean canPrint() {
        if (!this.printPrivilege) {
            return false;
        }
        if (this.getCurrentPagePosition() <= 0) {
            return false;
        }
        if (!this.callbackPrintPrivilegeDetermined) {
            this.callbackPrintPrivilege = this.document.getCanPrint();
            this.callbackPrintPrivilegeDetermined = true;
        }
        return this.callbackPrintPrivilege;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(Graphics g, PageFormat format, int pageIndex) {
        String methodName = "print";
        int pageNumber = this.getPageNumber(pageIndex + 1);
        PrinterJob pj = ((PrinterGraphics)((Object)g)).getPrinterJob();
        if (pj.isCancelled()) {
            System.out.println("Print job has been cancelled");
            return 1;
        }
        Image unscaledImage = null;
        double currDocScale = this.document.getPreferredScale();
        boolean currEnhance = this.document.getEnhance();
        if (this.document.getCanEnhance()) {
            this.document.setEnhance(true);
        }
        JPanel jp = new JPanel();
        try {
            if (this.cachePageNumber != pageNumber) {
                if (_scaleWithEngine) {
                    CMBPage page = null;
                    if (this.document.getCanPaginate()) {
                        page = this.document.getPage(pageNumber);
                    }
                    if (page != null && page.getCanGetImage()) {
                        if (this.cacheDocImage != null) {
                            this.cacheDocImage.flush();
                            this.cacheDocImage = null;
                            System.gc();
                        }
                        Object object = imageMutex;
                        synchronized (object) {
                            this.cacheDocImage = page.getImage(1.0);
                        }
                    }
                }
                if (this.cacheDocImage == null) {
                    unscaledImage = this.getPageImage(pageNumber);
                    try {
                        MediaTracker tracker = new MediaTracker(jp);
                        tracker.addImage(unscaledImage, 0);
                        tracker.waitForID(0);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    int imageWidth = unscaledImage.getWidth(null);
                    int imageHeight = unscaledImage.getHeight(null);
                    int printWidth = (int)((double)imageWidth / currDocScale * this.printScale);
                    int printHeight = (int)((double)imageHeight / currDocScale * this.printScale);
                    this.cacheDocImage = unscaledImage.getScaledInstance(printWidth, printHeight, 4);
                }
                try {
                    MediaTracker tracker = new MediaTracker(jp);
                    tracker.addImage(this.cacheDocImage, 0);
                    tracker.waitForID(0);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.cacheDocImage == null) {
                    if (this.document.getCanEnhance()) {
                        this.document.setEnhance(currEnhance);
                    }
                    return 1;
                }
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(format.getImageableX(), format.getImageableY());
            g2d.scale(this.printScale, this.printScale);
            if (this.bPrintAnno && this.annoSet != null && this.annoSet.getPageAnnotations(pageNumber).length > 0) {
                Rectangle r = g2d.getClipBounds();
                if (this.cachePageNumber != pageNumber) {
                    if (this.cachePrintImage != null) {
                        this.cachePrintImage.flush();
                        this.cachePrintImage = null;
                        System.gc();
                    }
                    this.cachePrintImage = new BufferedImage(r.width, r.height, 2);
                    this.cachePageNumber = pageNumber;
                    Graphics2D offscreenGraphics = this.cachePrintImage.createGraphics();
                    offscreenGraphics.drawImage(this.cacheDocImage, 0, 0, null);
                    Iterator i = this.annoSet.getIterator(pageNumber);
                    AffineTransform oldTransform = offscreenGraphics.getTransform();
                    while (i.hasNext()) {
                        CMBPageAnnotation a = (CMBPageAnnotation)i.next();
                        a.showHandles(false);
                        a.draw(offscreenGraphics);
                    }
                    offscreenGraphics.dispose();
                    offscreenGraphics = null;
                }
                g2d.clip(r);
                g2d.drawImage((Image)this.cachePrintImage, 0, 0, null);
            } else {
                g2d.drawImage(this.cacheDocImage, 0, 0, null);
                this.cachePageNumber = pageNumber;
            }
            System.gc();
            if (this.document.getCanEnhance()) {
                this.document.setEnhance(currEnhance);
            }
            return 0;
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return 1;
        }
    }

    public boolean canExport() {
        if (!this.exportPrivilege) {
            return false;
        }
        if (this.getCurrentPageNumber() <= 0) {
            return false;
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkPermission(new FilePermission(System.getProperty("user.home"), "write"));
                security.checkPermission(new FilePermission(System.getProperty("user.home") + File.separator + "-", "write"));
            }
            catch (SecurityException e) {
                return false;
            }
        }
        return this.getExportableMimetypes().length > 0;
    }

    private String[] getExportableMimetypes() {
        if (this.exportableMimetypes == null) {
            String validTypesString = PViewerUtilities.getMessage("exportDialog.SaveAsType.validTypes");
            StringTokenizer tok = new StringTokenizer(validTypesString, ",");
            int count = tok.countTokens();
            ArrayList<String> exportableMimetypesList = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                String validType = tok.nextToken();
                String exportMimeType = PViewerUtilities.getMessage("exportDialog.SaveAsType.validTypes." + validType + ".mimetype");
                if (!this.document.getEngine().canWriteDocument(this.document.getMimeType(), exportMimeType)) continue;
                exportableMimetypesList.add(exportMimeType);
            }
            this.exportableMimetypes = new String[exportableMimetypesList.size()];
            exportableMimetypesList.toArray(this.exportableMimetypes);
        }
        return this.exportableMimetypes;
    }

    int getCurrentPageNumber() {
        if (this.viewablePageNumbers == null) {
            if (this.getPageCount() > -1 & this.currentPagePosition > this.getPageCount()) {
                return this.getPageCount();
            }
            return this.currentPagePosition;
        }
        if (this.viewablePageNumbers.length == 0) {
            return 0;
        }
        if (this.currentPagePosition < 1) {
            return this.viewablePageNumbers[0];
        }
        if (this.currentPagePosition > this.viewablePageNumbers.length) {
            return this.viewablePageNumbers[this.viewablePageNumbers.length - 1];
        }
        return this.viewablePageNumbers[this.currentPagePosition - 1];
    }

    int getCurrentPagePosition() {
        return this.currentPagePosition;
    }

    void setCurrentPagePosition(int position) {
        if (position != this.getCurrentPagePosition()) {
            this.currentPagePosition = position;
            this.fireDocStateChangedEvent(1);
            Rectangle rect = this.getCurrentViewRectangle();
            if (rect != null && !this.pageToTop) {
                this.setCurrentViewRectangle(new Rectangle(rect.x, rect.y, rect.width, rect.height), false);
            } else if (rect != null && this.pageToTop) {
                rect.x = 0;
                rect.y = 0;
                this.setCurrentViewRectangle(new Rectangle(rect.x, rect.y, rect.width, rect.height), true);
            }
        }
        this.setSelectedPages(null);
    }

    void setCurrentPageNumber(int pageNumber) {
        int position = pageNumber;
        int[] viewablePages = this.getViewablePageNumbers();
        if (viewablePages != null ? (position = Arrays.binarySearch(viewablePages, pageNumber) + 1) < 1 : position < 1 || this.getPageCount() >= 0 && position > this.getPageCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.setCurrentPagePosition(position);
    }

    void setCurrentViewRectangle(Rectangle viewRect) {
        this.setCurrentViewRectangle(viewRect, true);
    }

    private void setCurrentViewRectangle(Rectangle viewRect, boolean fireEvent) {
        if (this.currViewRectangle == null || viewRect == null) {
            this.currViewRectangle = viewRect;
            if (fireEvent) {
                this.fireDocStateChangedEvent(9);
            }
            return;
        }
        if (this.currViewRectangle.x != viewRect.x || this.currViewRectangle.y != viewRect.y || this.currViewRectangle.width != viewRect.width || this.currViewRectangle.height != viewRect.height) {
            this.currViewRectangle = viewRect;
            if (fireEvent) {
                this.fireDocStateChangedEvent(9);
            }
        }
    }

    Rectangle getCurrentViewRectangle() {
        if (this.currViewRectangle == null) {
            return null;
        }
        return (Rectangle)this.currViewRectangle.clone();
    }

    void firstPage() {
        this.setCurrentPagePosition(1);
    }

    void lastPage() {
        this.setCurrentPagePosition(this.pageCount);
    }

    void nextPage() {
        if (this.pageCount == -1 || this.pageCount > this.currentPagePosition) {
            this.setCurrentPagePosition(this.currentPagePosition + 1);
        }
    }

    void prevPage() {
        if (this.currentPagePosition > 1) {
            this.setCurrentPagePosition(this.currentPagePosition - 1);
        }
    }

    void gotoPage(CMBGenericDocViewer viewer) {
        int pageNumber;
        if (this.pageCount == 0) {
            this.pageCount = this.getPageCount();
        }
        Object[] optionsList = new Object[this.pageCount];
        for (int i = 0; i < this.pageCount; ++i) {
            optionsList[i] = new Integer(this.getPageNumber(i + 1)).toString();
        }
        Object choice = POptionPane.showInputDialog(viewer, PViewerUtilities.getMessage("DocumentViewer.GoToPageMessage"), PViewerUtilities.getMessage("DocumentViewer.GoToPageTitle"), optionsList, new Integer(this.getCurrentPageNumber()).toString());
        viewer.getSelectedView().requestFocus();
        if (choice == null) {
            return;
        }
        String option = (String)choice;
        int pagePosition = pageNumber = Integer.parseInt(option);
        if (this.viewablePageNumbers != null) {
            pagePosition = Arrays.binarySearch(this.viewablePageNumbers, pageNumber) + 1;
        }
        this.setCurrentPagePosition(pagePosition);
    }

    boolean isPageRangeValid(int startPage, int endPage) {
        boolean value = false;
        if (this.viewablePageNumbers == null) {
            if (this.pageCount <= 0) {
                this.pageCount = this.getPageCount();
            }
            if (startPage <= endPage) {
                if (this.pageCount > -1) {
                    if (startPage >= 0 && endPage <= this.pageCount) {
                        value = true;
                    }
                } else {
                    value = true;
                    for (int i = startPage; i <= endPage; ++i) {
                        if (this.isPageValid(i)) continue;
                        value = false;
                    }
                }
            }
        } else {
            int endPosition;
            int startPosition;
            if (startPage == 0 && endPage == 0) {
                value = true;
            }
            if ((startPosition = this.getPagePosition(startPage)) <= (endPosition = this.getPagePosition(endPage)) && startPosition >= 1 && endPosition <= this.pageCount) {
                value = true;
            }
        }
        return value;
    }

    boolean isPageValid(int pageNumber) {
        boolean value = false;
        int pagePosition = this.getPagePosition(pageNumber);
        if (pagePosition >= 1 && this.isValidPagePosition(pagePosition)) {
            value = true;
        }
        return value;
    }

    void rotatePages(int pageRotation, int[] pages) {
        String methodName = "rotatePages";
        int newPageRotation = 0;
        CMBPage currPage = null;
        try {
            for (int i = 0; i < pages.length; ++i) {
                int pageNumber = pages[i];
                currPage = this.document.getPage(pageNumber);
                newPageRotation = (currPage.getRotation() + pageRotation) % 4;
                currPage.setRotation(newPageRotation);
                if (this.annoSet != null) {
                    this.annoSet.setRotation(newPageRotation, pageNumber);
                }
                this.removeCachedPageImage(pageNumber);
            }
            CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, pages, 3);
            this.fireDocStateChangedEvent(event);
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    void rotatePagesPermanently(int pageRotation, int[] pages) {
        String methodName = "rotatePagesPermanently";
        CMBPage currPage = null;
        try {
            for (int i = 0; i < pages.length; ++i) {
                int pageNumber = pages[i];
                currPage = this.document.getPage(pageNumber);
                if (this.annoSet != null) {
                    double pageResolution = this.getPage(pageNumber).getPageResolution();
                    int wd = (int)(this.getPage(pageNumber).getWidth() * pageResolution);
                    int ht = (int)(this.getPage(pageNumber).getHeight() * pageResolution);
                    CMBPageAnnotation[] annotations = this.annoSet.getPageAnnotations(pageNumber);
                    for (int j = 0; j < annotations.length; ++j) {
                        CMBPageAnnotation annotation = annotations[j];
                        annotation.setImageHeight(ht);
                        annotation.setImageWidth(wd);
                    }
                }
                currPage.rotate(pageRotation);
                if (this.annoSet != null) {
                    this.annoSet.rotate(pageRotation, pageNumber);
                    this.annoSet.setAnnotationPosition(this.document.getAnnotationPosition());
                }
                this.removeCachedPageImage(pageNumber);
            }
            CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, pages, 3);
            this.fireDocStateChangedEvent(event);
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    int getRotation() {
        return this.rotation;
    }

    int getPageRotation(int pageNumber) {
        try {
            CMBPage currPage = this.document.getPage(pageNumber);
            return currPage.combinedRotation();
        }
        catch (Exception e) {
            return 0;
        }
    }

    void setPageRotation(int newRotation, int pageNumber) {
        String methodName = "setPageRotation";
        try {
            CMBPage currPage = this.document.getPage(pageNumber);
            currPage.setRotation(newRotation);
            if (this.annoSet != null) {
                this.annoSet.setRotation(newRotation, pageNumber);
            }
            this.removeCachedPageImage(pageNumber);
            this.fireDocStateChangedEvent(3);
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    void updateAnnoForRotation(int pageNumber) {
        String methodName = "updateAnnoForRotation";
        try {
            CMBPage currPage = this.getPage(pageNumber);
            if (this.annoSet != null && currPage != null) {
                double pageResolution = currPage.getPageResolution();
                int wd = (int)(currPage.getWidth() * pageResolution);
                int ht = (int)(currPage.getHeight() * pageResolution);
                Iterator i = this.annoSet.getIterator(pageNumber);
                while (i.hasNext()) {
                    CMBPageAnnotation a = (CMBPageAnnotation)i.next();
                    if (a.getRotation() == 0 || a.getRotation() == 2) {
                        a.setImageHeight(ht);
                        a.setImageWidth(wd);
                        continue;
                    }
                    a.setImageHeight(wd);
                    a.setImageWidth(ht);
                }
            }
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    void setRotation(int rot) {
        if (rot != this.rotation) {
            this.rotation = rot;
            this.document.setRotation(rot);
            if (this.annoSet != null) {
                this.annoSet.setRotation(rot);
            }
            this.pageImages.clear();
            this.fireDocStateChangedEvent(3);
        }
    }

    double getScale() {
        if (this.getCurrentPage() != null) {
            return this.getCurrentPage().getScale();
        }
        return this.document.getPreferredScale();
    }

    double getScale(int pageNumber) {
        if (this.getPage(pageNumber) != null) {
            return this.getPage(pageNumber).getScale();
        }
        return this.getScale();
    }

    double getPageWidth(int pageNumber) {
        if (this.getPage(pageNumber) != null) {
            return this.getPage(pageNumber).getWidth();
        }
        return 0.0;
    }

    double getPageXResolution(int pageNumber) {
        if (this.getPage(pageNumber) != null) {
            return this.getPage(pageNumber).getPageXResolution();
        }
        return 72.0;
    }

    double getPageHeight(int pageNumber) {
        if (this.getPage(pageNumber) != null) {
            return this.getPage(pageNumber).getHeight();
        }
        return 0.0;
    }

    double getPageYResolution(int pageNumber) {
        if (this.getPage(pageNumber) != null) {
            return this.getPage(pageNumber).getPageYResolution();
        }
        return 72.0;
    }

    double getDisplayResolution() {
        if (this.getDocument() != null) {
            return this.getDocument().getDisplayResolution();
        }
        return 72.0;
    }

    double getCurrMaxScale() {
        String methodName = "getCurrMaxScale";
        try {
            if (this.getCurrentPageNumber() <= 0) {
                return 1.0;
            }
            CMBPage currPage = this.document.getPage(this.getCurrentPageNumber());
            if (!currPage.isValid()) {
                return 1.0;
            }
            return currPage.getMaxScale();
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return 1.0;
        }
    }

    int getFit() {
        return this.fit;
    }

    double getCurrMinScale() {
        String methodName = "getCurrMinScale";
        try {
            if (this.getCurrentPageNumber() <= 0) {
                return 1.0;
            }
            CMBPage currPage = this.document.getPage(this.getCurrentPageNumber());
            if (!currPage.isValid()) {
                return 1.0;
            }
            return currPage.getMinScale();
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return 1.0;
        }
    }

    void setScale(double newscale) {
        this.fit = 0;
        if (newscale != this.getScale() && newscale != 0.0) {
            this.privateSetScale(newscale);
        }
    }

    private void privateSetScale(double newscale) {
        double limitScale = newscale;
        if (limitScale < this.getCurrMinScale()) {
            limitScale = this.getCurrMinScale();
        }
        if (limitScale > this.getCurrMaxScale()) {
            limitScale = this.getCurrMaxScale();
        }
        if (limitScale != this.oldScale) {
            this.oldScale = limitScale;
            if (this.annoSet != null) {
                this.annoSet.setScale((int)(limitScale * 1000.0));
            }
            this.document.setPreferredScale(limitScale);
            if (this.getScale() == 1.0) {
                this.fit = 4;
            }
            this.fireDocStateChangedEvent(9);
        }
    }

    void setZoomFactor(double factor) {
        this.zoomFactor = factor;
    }

    double getZoomFactor() {
        return this.zoomFactor;
    }

    boolean canScale() {
        if (this.getCurrentPagePosition() <= 0) {
            return false;
        }
        boolean value = false;
        if (this.getCurrMinScale() < this.getCurrMaxScale()) {
            value = true;
        }
        return value;
    }

    void zoom(Rectangle selectedRectangle, Rectangle viewRectangle) {
        this.fit = 0;
        double currentScale = this.getScale();
        double newScale = Math.min(currentScale * (double)viewRectangle.width / (double)selectedRectangle.width, currentScale * (double)viewRectangle.height / (double)selectedRectangle.height);
        this.privateSetScale(newScale);
    }

    void zoomIn() {
        this.fit = 0;
        double s = this.document.getPreferredScale();
        double newscale = s + s * this.zoomFactor;
        if (newscale <= 0.0) {
            return;
        }
        this.privateSetScale(newscale);
    }

    void zoomOut() {
        this.fit = 0;
        double currScale = this.document.getPreferredScale();
        double newscale = this.document.getPreferredScale() / (1.0 + this.zoomFactor);
        if (newscale <= 0.0) {
            return;
        }
        this.privateSetScale(newscale);
    }

    void fitWidth(Dimension windowSize, int vScrollBarWidth, int hScrollBarHeight) {
        String methodName = "fitWidth";
        this.fit = 1;
        if (this.currentPagePosition <= 0) {
            return;
        }
        try {
            if (this.getCurrentPagePosition() > 0) {
                double newScale = this.getScaleToFit(this.getCurrentPageNumber(), windowSize, vScrollBarWidth, hScrollBarHeight, 1);
                if (newScale == 0.0) {
                    return;
                }
                this.privateSetScale(newScale);
            }
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return;
        }
    }

    void fitHeight(Dimension windowSize, int vScrollBarWidth, int hScrollBarHeight) {
        String methodName = "fitHeight";
        this.fit = 2;
        if (this.currentPagePosition <= 0) {
            return;
        }
        try {
            if (this.getCurrentPagePosition() > 0) {
                double newScale = this.getScaleToFit(this.getCurrentPageNumber(), windowSize, vScrollBarWidth, hScrollBarHeight, 2);
                if (newScale == 0.0) {
                    return;
                }
                this.privateSetScale(newScale);
            }
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return;
        }
    }

    void fitInWindow(Dimension windowSize, int vScrollBarWidth, int hScrollBarHeight) {
        String methodName = "fitInWindow";
        this.fit = 3;
        if (this.currentPagePosition <= 0) {
            return;
        }
        try {
            if (this.getCurrentPagePosition() > 0) {
                double newScale = this.getScaleToFit(this.getCurrentPageNumber(), windowSize, vScrollBarWidth, hScrollBarHeight, 3);
                if (newScale == 0.0) {
                    return;
                }
                this.privateSetScale(newScale);
            }
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return;
        }
    }

    CMBPage getPage(int pageNumber) {
        String methodName = "getPage";
        try {
            CMBPage page = this.document.getPage(pageNumber);
            if (page.isValid()) {
                return page;
            }
            return null;
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return null;
        }
    }

    private CMBPage getCurrentPage() {
        if (this.getCurrentPageNumber() <= 0) {
            return null;
        }
        return this.getPage(this.getCurrentPageNumber());
    }

    void fitActualSize() {
        this.fit = 4;
        if (this.currentPagePosition <= 0) {
            return;
        }
        this.privateSetScale(1.0);
    }

    void refit(Dimension viewDim, int vScrollBarWidth, int hScrollBarHeight) {
        if (this.fit == 2) {
            this.fitHeight(viewDim, vScrollBarWidth, hScrollBarHeight);
        } else if (this.fit == 1) {
            this.fitWidth(viewDim, vScrollBarWidth, hScrollBarHeight);
        } else if (this.fit == 3) {
            this.fitInWindow(viewDim, vScrollBarWidth, hScrollBarHeight);
        }
    }

    boolean canEnhance() {
        String methodName = "canEnhance";
        try {
            CMBPage page = this.getCurrentPage();
            if (page == null) {
                return false;
            }
            return page.getCanEnhance();
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return false;
        }
    }

    private void enhance() {
        if (this.document.getCanEnhance()) {
            boolean enhance = this.document.getEnhance();
            enhance = !enhance;
            this.document.setEnhance(enhance);
            this.pageImages.clear();
            this.fireDocStateChangedEvent(5);
        }
    }

    private void enhance(boolean enhance) {
        boolean currVal = this.document.getEnhance();
        if (currVal != enhance) {
            this.enhance();
        }
    }

    boolean canRotate() {
        if (this.getCurrentPagePosition() <= 0) {
            return false;
        }
        return this.document.getCanRotate();
    }

    boolean canPaginate() {
        return this.document.getCanPaginate();
    }

    boolean canDeletePages(int cnt) {
        return this.document.getCanDeletePages(cnt);
    }

    boolean canPastePages(int cnt) {
        return this.document.getCanPastePages(cnt);
    }

    boolean canInvert() {
        if (this.getCurrentPagePosition() <= 0) {
            return false;
        }
        return this.document.getCanInvert();
    }

    private void invert() {
        if (this.document.getCanInvert()) {
            boolean invert = this.document.getInvert();
            invert = !invert;
            this.document.setInvert(invert);
            this.pageImages.clear();
            this.fireDocStateChangedEvent(4);
        }
    }

    void invert(boolean invert) {
        boolean currVal = this.document.getInvert();
        if (currVal != invert) {
            this.invert();
        }
    }

    boolean isEnhance() {
        return this.document.getEnhance();
    }

    boolean isInvert() {
        return this.document.getInvert();
    }

    void setEnhance(boolean enhance) {
        this.enhance(enhance);
    }

    void setInvert(boolean invert) {
        this.invert(invert);
    }

    int[] getViewablePageNumbers() {
        return this.viewablePageNumbers;
    }

    void setViewablePageNumbers(int[] _viewablePageNumbers) {
        int position = Arrays.binarySearch(_viewablePageNumbers, this.getCurrentPageNumber()) + 1;
        this.viewablePageNumbers = _viewablePageNumbers;
        if (position <= 0) {
            this.fireDocStateChangedEvent(1);
        }
        this.setCurrentPagePosition(position < 1 ? 1 : position);
        CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, _viewablePageNumbers, 17);
        this.fireDocStateChangedEvent(event);
    }

    void unsetViewablePageNumbers() throws IOException {
        int position = this.getCurrentPageNumber();
        this.viewablePageNumbers = null;
        this.setPageCount(this.document.getPageCount());
        this.setCurrentPagePosition(position < 1 ? 1 : position);
        int[] allpages = new int[this.getPageCount()];
        for (int i = 0; i < this.getPageCount(); ++i) {
            allpages[i] = i;
        }
        CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, allpages, 17);
        this.fireDocStateChangedEvent(event);
    }

    int getPageNumber(int pagePosition) throws ArrayIndexOutOfBoundsException {
        if (this.viewablePageNumbers == null) {
            return pagePosition;
        }
        if (this.viewablePageNumbers.length == 0) {
            return 0;
        }
        if (pagePosition == 0) {
            return 0;
        }
        if (this.viewablePageNumbers != null) {
            return this.viewablePageNumbers[pagePosition - 1];
        }
        return pagePosition;
    }

    int getPagePosition(int pageNumber) {
        if (this.viewablePageNumbers != null) {
            return Arrays.binarySearch(this.viewablePageNumbers, pageNumber) + 1;
        }
        return pageNumber;
    }

    void dispose() {
        super.dispose();
    }

    public void initUsingProperties(Properties properties) {
        if (properties != null) {
            int iVal;
            boolean pageManipEnabled;
            double dVal;
            String val = properties.getProperty("Document.invert");
            if (val != null && this.canInvert()) {
                if (val.equalsIgnoreCase("true")) {
                    this.invert(true);
                } else if (val.equalsIgnoreCase("false")) {
                    this.invert(false);
                }
            }
            if ((val = properties.getProperty("Document.enhance")) != null && this.canEnhance()) {
                if (val.equalsIgnoreCase("true")) {
                    this.enhance(true);
                } else if (val.equalsIgnoreCase("false")) {
                    this.enhance(false);
                }
            }
            if ((val = properties.getProperty("Zoom.factor")) != null && (dVal = new Double(val).doubleValue()) > 0.0 && dVal <= 100.0) {
                this.setZoomFactor(dVal /= 100.0);
            }
            if (!(pageManipEnabled = PViewerUtilities.getBooleanProperty("PageManipulation", properties, false)) && (val = properties.getProperty("Document.rotate")) != null && this.canRotate()) {
                if (val.equalsIgnoreCase("rotate_0")) {
                    this.setRotation(0);
                } else if (val.equalsIgnoreCase("rotate_90")) {
                    this.setRotation(1);
                } else if (val.equalsIgnoreCase("rotate_180")) {
                    this.setRotation(2);
                } else if (val.equalsIgnoreCase("rotate_270")) {
                    this.setRotation(3);
                }
            }
            if ((val = properties.getProperty("Zoom.default")) != null && (this.getDocument().isNew() || this.canScale())) {
                if (val.equalsIgnoreCase("fit_height")) {
                    this.fit = 2;
                } else if (val.equalsIgnoreCase("fit_width")) {
                    this.fit = 1;
                } else if (val.equalsIgnoreCase("fit_in_window")) {
                    this.fit = 3;
                } else if (val.equalsIgnoreCase("fit_actual")) {
                    this.fit = 4;
                } else {
                    String numberString = val.substring(0, val.length() - 1);
                    int newscalePercent = new Integer(numberString.trim());
                    this.setScale((double)newscalePercent / 100.0);
                }
            } else {
                val = properties.getProperty("Page.fit");
                if (val != null && this.canScale()) {
                    if (val.equalsIgnoreCase("fit_width")) {
                        this.fit = 1;
                    } else if (val.equalsIgnoreCase("fit_height")) {
                        this.fit = 2;
                    } else if (val.equalsIgnoreCase("fit_in_window")) {
                        this.fit = 3;
                    } else if (val.equalsIgnoreCase("fit_none")) {
                        this.fit = 0;
                    }
                }
            }
            val = properties.getProperty("RenderAhead");
            if (val != null) {
                if (val.equalsIgnoreCase("true")) {
                    this.renderAhead = true;
                } else if (val.equalsIgnoreCase("false")) {
                    this.renderAhead = false;
                }
            }
            if ((val = properties.getProperty("PageToTop")) != null) {
                if (val.equalsIgnoreCase("true")) {
                    this.pageToTop = true;
                } else if (val.equalsIgnoreCase("false")) {
                    this.pageToTop = false;
                }
            }
            if ((val = properties.getProperty("PageRefreshDelay")) != null && (iVal = new Integer(val).intValue()) > 0) {
                this.setPageRefreshDelay(iVal);
            }
            if ((val = properties.getProperty("History.queue")) != null && (iVal = new Integer(val).intValue()) > 0) {
                this.getTaskManager().setMaxHistoryLength(iVal);
            }
        }
    }

    void setSelectedPages(int[] pages) {
        if (this.selectedPages == pages || pages != null && this.selectedPages != null && this.selectedPages.equals(pages)) {
            return;
        }
        if (pages == null || pages.length == 0) {
            this.selectedPages = null;
        } else {
            for (int i = 0; i < pages.length; ++i) {
                if (this.isPageValid(pages[i])) continue;
                throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentViewer.invalidPageNumber", new Object[]{new Integer(pages[i])}));
            }
            int[] newSelection = (int[])pages.clone();
            Arrays.sort(newSelection);
            for (int i = 0; i < newSelection.length - 1; ++i) {
                if (newSelection[i] != newSelection[i + 1]) continue;
                throw new IllegalArgumentException(PViewerUtilities.getMessage("DocumentViewer.duplicatePageNumber", new Object[]{new Integer(newSelection[i])}));
            }
            boolean inSelectedPages = false;
            for (int i = 0; i < pages.length; ++i) {
                if (this.getCurrentPageNumber() != pages[i]) continue;
                inSelectedPages = true;
            }
            if (!inSelectedPages) {
                this.setCurrentPagePosition(this.getPagePosition(pages[0]));
            }
            this.selectedPages = newSelection;
        }
        CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, this.getSelectedPages(), this.getCurrentPageNumber(), 12);
        this.fireDocStateChangedEvent(event);
    }

    int[] getSelectedPages() {
        if (this.selectedPages == null) {
            return new int[]{this.getCurrentPageNumber()};
        }
        return (int[])this.selectedPages.clone();
    }

    boolean isPageSelected(int pageNumber) {
        int[] selection = this.getSelectedPages();
        for (int i = 0; i < selection.length; ++i) {
            if (selection[i] != pageNumber) continue;
            return true;
        }
        return false;
    }

    void addToSelectedPages(int[] pages) {
        int i;
        int[] selection = this.getSelectedPages();
        int[] newSelection = new int[selection.length + pages.length];
        int k = 0;
        for (i = 0; i < selection.length; ++i) {
            newSelection[k] = selection[i];
            ++k;
        }
        for (i = 0; i < pages.length; ++i) {
            newSelection[k] = pages[i];
            ++k;
        }
        this.setSelectedPages(newSelection);
    }

    void removeFromSelectedPages(int[] pages) {
        int[] selection = this.getSelectedPages();
        int[] newSelection = new int[selection.length - pages.length];
        int k = 0;
        for (int i = 0; i < selection.length; ++i) {
            boolean removePage = false;
            for (int j = 0; j < pages.length; ++j) {
                if (selection[i] != pages[j]) continue;
                removePage = true;
            }
            if (removePage) continue;
            newSelection[k] = selection[i];
            ++k;
        }
        this.setSelectedPages(newSelection);
    }

    void copyPages(int[] pages, PClippedPages clippedPages) throws IOException, CMBAnnotationEngineException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        clippedPages.copyToClippedPages(this.document, this.annoSet, pages);
        CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, pages, this.getCurrentPageNumber(), 18);
        this.fireDocStateChangedEvent(event);
        if (event.getRelatedInfo() != null) {
            clippedPages.setRelatedInfo(event.getRelatedInfo());
        }
        clippedPages.setThumbnailPageImages(event.getPageThumbnails());
    }

    void deletePages(int[] pages, PClippedPages clippedPages) throws IOException, CMBAnnotationEngineException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        clippedPages.moveToClippedPages(this.document, this.annoSet, pages);
        if (this.annoSet != null) {
            this.annoSet.setAnnotationPosition(this.document.getAnnotationPosition());
        }
        this.pageImages.clear();
        this.setPageCount(this.document.getPageCount());
        CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, pages, this.getCurrentPageNumber(), 14);
        if (event.getRelatedInfo() != null) {
            clippedPages.setRelatedInfo(event.getRelatedInfo());
        }
        clippedPages.setThumbnailPageImages(event.getPageThumbnails());
        this.fireDocStateChangedEvent(event);
        this.setSelectedPages(null);
        if (this.viewablePageNumbers != null) {
            int[] newViewablePageNumbers = (int[])this.viewablePageNumbers.clone();
            int viewablePagesDeleted = 0;
            for (int i = 0; i < pages.length; ++i) {
                int j;
                int pos = Arrays.binarySearch(newViewablePageNumbers, pages[i] - viewablePagesDeleted);
                if (pos < 0) continue;
                int[] viewablePageNumbers = new int[newViewablePageNumbers.length - 1];
                for (j = 0; j < pos; ++j) {
                    viewablePageNumbers[j] = newViewablePageNumbers[j];
                }
                for (j = pos; j < viewablePageNumbers.length; ++j) {
                    viewablePageNumbers[j] = newViewablePageNumbers[j + 1] - 1;
                }
                newViewablePageNumbers = viewablePageNumbers;
                ++viewablePagesDeleted;
            }
            this.setViewablePageNumbers(newViewablePageNumbers);
        }
    }

    void restorePages(PClippedPages clippedPages, int[] pages) throws IOException, CMBAnnotationEngineException {
        clippedPages.restoreFromClippedPages(this.document, this.annoSet, pages);
        if (this.annoSet != null) {
            this.annoSet.setAnnotationPosition(this.document.getAnnotationPosition());
        }
        this.pageImages.clear();
        this.setPageCount(this.document.getPageCount());
        CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, pages, this.getCurrentPageNumber(), 15);
        if (clippedPages.getRelatedInfo() != null) {
            event.setRelatedInfo(clippedPages.getRelatedInfo());
        }
        event.setThumbnailsInfo(clippedPages.getThumbnailPageImages(), clippedPages.getThumbnailSize(), clippedPages.getClipDocument());
        this.fireDocStateChangedEvent(event);
        if (this.viewablePageNumbers != null) {
            int i;
            int[] newViewablePageNumbers = new int[this.viewablePageNumbers.length + clippedPages.getPageCount()];
            for (i = 0; i < this.viewablePageNumbers.length; ++i) {
                newViewablePageNumbers[i] = this.viewablePageNumbers[i];
            }
            for (int j = 0; j < pages.length; ++j) {
                for (int i2 = 0; i2 < this.viewablePageNumbers.length; ++i2) {
                    if (this.viewablePageNumbers[i2] < pages[j]) continue;
                    newViewablePageNumbers[i2] = newViewablePageNumbers[i2] + 1;
                }
            }
            for (i = 0; i < pages.length; ++i) {
                newViewablePageNumbers[this.viewablePageNumbers.length + i] = pages[i];
            }
            Arrays.sort(newViewablePageNumbers);
            this.setViewablePageNumbers(newViewablePageNumbers);
        }
    }

    void insertPages(PClippedPages clippedPages, int page) throws IOException, CMBAnnotationEngineException {
        clippedPages.copyFromClippedPages(this.document, this.annoSet, page);
        if (this.annoSet != null) {
            this.annoSet.setAnnotationPosition(this.document.getAnnotationPosition());
        }
        this.pageImages.clear();
        this.setPageCount(this.document.getPageCount());
        int[] addedPages = new int[clippedPages.getPageCount()];
        for (int i = 0; i < addedPages.length; ++i) {
            addedPages[i] = page + 1 + i;
        }
        CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, addedPages, this.getCurrentPageNumber(), 15);
        if (clippedPages.getRelatedInfo() != null) {
            event.setRelatedInfo(clippedPages.getRelatedInfo());
        }
        event.setThumbnailsInfo(clippedPages.getThumbnailPageImages(), clippedPages.getThumbnailSize(), clippedPages.getClipDocument());
        this.fireDocStateChangedEvent(event);
        if (this.viewablePageNumbers != null) {
            int i;
            int[] newViewablePageNumbers = new int[this.viewablePageNumbers.length + clippedPages.getPageCount()];
            for (i = 0; i < this.viewablePageNumbers.length; ++i) {
                newViewablePageNumbers[i] = this.viewablePageNumbers[i] >= page ? this.viewablePageNumbers[i] + clippedPages.getPageCount() : this.viewablePageNumbers[i];
            }
            for (i = 0; i < clippedPages.getPageCount(); ++i) {
                newViewablePageNumbers[this.viewablePageNumbers.length + i] = page + i;
            }
            Arrays.sort(newViewablePageNumbers);
            this.setViewablePageNumbers(newViewablePageNumbers);
        }
        this.setSelectedPages(addedPages);
    }

    long getPageRefreshDelay() {
        return this.pageRefreshDelay;
    }

    void setPageRefreshDelay(long delay) {
        this.pageRefreshDelay = delay;
    }

    public void redact(int pageNumber, Rectangle area) throws IOException {
        CMBPage page = this.getPage(pageNumber);
        page.redact(area);
        this.removeCachedPageImage(pageNumber);
        CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, new int[]{pageNumber}, 13);
        this.fireDocStateChangedEvent(event);
    }

    public void setPrivilege(int privilege, boolean enable) {
        if (privilege == 6) {
            this.printPrivilege = enable;
        }
        if (privilege == 7) {
            this.exportPrivilege = enable;
        }
        if (privilege == 3) {
            this.addPagesPrivilege = enable;
        } else if (privilege == 2) {
            this.deletePagesPrivilege = enable;
        } else if (privilege == 5) {
            this.movePagesPrivilege = enable;
        } else if (privilege == 4) {
            this.rotatePagesPrivilege = enable;
        } else if (privilege == 8) {
            this.redactPrivilege = enable;
        } else if (privilege == 9) {
            this.modifyBookmarksPrivilege = enable;
        }
    }

    public boolean getPrivilege(int privilege) {
        if (privilege == 6) {
            return this.printPrivilege;
        }
        if (privilege == 7) {
            return this.exportPrivilege;
        }
        if (privilege == 3) {
            return this.addPagesPrivilege;
        }
        if (privilege == 2) {
            return this.deletePagesPrivilege;
        }
        if (privilege == 5) {
            return this.movePagesPrivilege;
        }
        if (privilege == 4) {
            return this.rotatePagesPrivilege;
        }
        if (privilege == 8) {
            return this.redactPrivilege;
        }
        if (privilege == 9) {
            return this.modifyBookmarksPrivilege;
        }
        return false;
    }

    void removeCachedPageImage(int pageNumber) {
        Enumeration en = this.pageImages.keys();
        while (en.hasMoreElements()) {
            String pageKey = (String)en.nextElement();
            if (!pageKey.startsWith("" + pageNumber + "-")) continue;
            this.pageImages.remove(pageKey);
        }
    }

    int getBrightness(int pageNumber) {
        try {
            CMBPage currPage = this.document.getPage(pageNumber);
            return currPage.getBrightness();
        }
        catch (Exception e) {
            return 100;
        }
    }

    void setBrightness(int brightnessFactor, int pageNumber) {
        String methodName = "setBrightness";
        try {
            CMBPage currPage = this.document.getPage(pageNumber);
            currPage.setBrightness(brightnessFactor);
            this.removeCachedPageImage(pageNumber);
            this.fireDocStateChangedEvent(19);
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    int getContrast(int pageNumber) {
        try {
            CMBPage currPage = this.document.getPage(pageNumber);
            return currPage.getContrast();
        }
        catch (Exception e) {
            return 100;
        }
    }

    void setContrast(int contrastFactor, int pageNumber) {
        String methodName = "setContrast";
        try {
            CMBPage currPage = this.document.getPage(pageNumber);
            currPage.setContrast(contrastFactor);
            this.removeCachedPageImage(pageNumber);
            this.fireDocStateChangedEvent(19);
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    boolean canBalance() {
        String methodName = "canBalance";
        try {
            CMBPage currPage = this.document.getPage(this.getCurrentPageNumber());
            if (currPage.getUseDraw()) {
                return currPage.getCanBalance();
            }
            return true;
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return false;
        }
    }

    boolean canRedact() {
        String methodName = "canRedact";
        try {
            CMBPage currPage = this.document.getPage(this.getCurrentPageNumber());
            return currPage.getCanRedact();
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return false;
        }
    }

    void setBalance(int brightnessFactor, int contrastFactor, int pageNumber) {
        String methodName = "setBalance";
        try {
            CMBPage currPage = this.document.getPage(pageNumber);
            currPage.setBrightness(brightnessFactor);
            currPage.setContrast(contrastFactor);
            this.removeCachedPageImage(pageNumber);
            this.fireDocStateChangedEvent(19);
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    boolean canFind() {
        return this.getDocument().getCanFind();
    }

    boolean find(String text, boolean matchCase, boolean reverse) {
        int[] position;
        if (text.equals(this.lastSearchText)) {
            position = this.lastHitPosition;
        } else {
            position = new int[6];
            position[0] = this.getCurrentPageNumber();
        }
        boolean found = false;
        while ((found = this.getDocument().find(text, position, matchCase, reverse)) && !this.isPageValid(position[0])) {
        }
        if (!found) {
            this.lastSearchText = null;
            this.lastHitPosition = null;
            this.fireDocStateChangedEvent(21);
        } else {
            this.lastSearchText = text;
            this.lastHitPosition = position;
            int pageNo = position[0];
            if (pageNo != this.getCurrentPageNumber()) {
                this.setCurrentPageNumber(pageNo);
            }
            Rectangle viewRect = this.getCurrentViewRectangle();
            Rectangle hitRect = this.getHitHighlight(this.getCurrentPageNumber());
            double scalex = this.getScale() * this.getDisplayResolution() / this.getPageXResolution(this.getCurrentPageNumber());
            double scaley = this.getScale() * this.getDisplayResolution() / this.getPageYResolution(this.getCurrentPageNumber());
            hitRect.x = (int)((double)hitRect.x * scalex);
            hitRect.y = (int)((double)hitRect.y * scaley);
            hitRect.width = (int)((double)hitRect.width * scalex);
            hitRect.height = (int)((double)hitRect.height * scaley);
            Rectangle intersectRect = viewRect.intersection(hitRect);
            if (intersectRect.width < hitRect.width || intersectRect.height < hitRect.height) {
                int pageWidthPixels = (int)(this.getPageWidth(this.getCurrentPageNumber()) * this.getScale() * this.getDisplayResolution());
                int pageHeightPixels = (int)(this.getPageHeight(this.getCurrentPageNumber()) * this.getScale() * this.getDisplayResolution());
                viewRect.x = hitRect.x;
                viewRect.y = !reverse ? hitRect.y : Math.max(hitRect.y - viewRect.height + hitRect.height, 0);
                if (viewRect.x + viewRect.width > pageWidthPixels) {
                    viewRect.x = pageWidthPixels - viewRect.width - 1;
                }
                if (viewRect.y + viewRect.height > pageHeightPixels) {
                    viewRect.y = pageHeightPixels - viewRect.height - 1;
                }
                this.setCurrentViewRectangle(viewRect);
            }
            this.fireDocStateChangedEvent(21);
        }
        return found;
    }

    public Rectangle getHitHighlight(int pageNumber) {
        if (this.lastHitPosition == null) {
            return null;
        }
        if (pageNumber != this.lastHitPosition[0]) {
            return null;
        }
        return new Rectangle(this.lastHitPosition[2], this.lastHitPosition[3], this.lastHitPosition[4], this.lastHitPosition[5]);
    }

    public CMBBookmark[] getBookmarks() {
        if (this.bookmarks == null) {
            return new CMBBookmark[0];
        }
        return this.bookmarks;
    }

    public void setBookmarks(CMBBookmark[] bookmarks) {
        this.bookmarks = bookmarks;
        this.fireDocStateChangedEvent(22);
    }

    private class GetPageCountWorkerThread
    extends Thread {
        int count;

        public GetPageCountWorkerThread(String name) {
            super(name);
        }

        public void run() {
            String methodName = "GetPageCountWorkerThread:run";
            boolean retry = false;
            do {
                try {
                    this.count = PPageModel.this.document.getPageCount();
                }
                catch (OutOfMemoryError e) {
                    ViewerLogger.logError((Object)this, methodName, e);
                    retry = true;
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {}
                }
                catch (Exception e) {
                    if (PPageModel.this.document != null && !PPageModel.this.document.isDisposed()) {
                        ViewerLogger.logError((Object)this, methodName, e);
                    }
                    this.count = 1;
                }
            } while (retry);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PPageModel.this.setPageCount(GetPageCountWorkerThread.this.count);
                }
            });
        }
    }

    private class RenderAheadThread
    extends Thread {
        int pageNumber;

        RenderAheadThread(int pageNumber) {
            this.pageNumber = pageNumber;
            this.setPriority(1);
            try {
                this.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Image pageImage;
            SoftReference sr;
            Object obj;
            Hashtable hashtable;
            String pageKey;
            try {
                Thread.currentThread();
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                return;
            }
            if (this.pageNumber > 1) {
                PPageModel.this.waitTillActiveDone();
                try {
                    pageKey = "" + (this.pageNumber - 1) + "-" + PPageModel.this.getScale(this.pageNumber);
                    hashtable = PPageModel.this.pageImages;
                    synchronized (hashtable) {
                        pageImage = !PPageModel.this.pageImages.containsKey(pageKey) ? PPageModel.this.loadPageImage(this.pageNumber - 1) : ((obj = (sr = (SoftReference)PPageModel.this.pageImages.get(pageKey)).get()) != null ? (Image)obj : PPageModel.this.loadPageImage(this.pageNumber - 1));
                        if (pageImage != null) {
                            PPageModel.this.pageImages.put(pageKey, new SoftReference<Image>(pageImage));
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.pageNumber < PPageModel.this.pageCount) {
                PPageModel.this.waitTillActiveDone();
                try {
                    pageKey = "" + (this.pageNumber + 1) + "-" + PPageModel.this.getScale(this.pageNumber);
                    hashtable = PPageModel.this.pageImages;
                    synchronized (hashtable) {
                        pageImage = !PPageModel.this.pageImages.containsKey(pageKey) ? PPageModel.this.loadPageImage(this.pageNumber + 1) : ((obj = (sr = (SoftReference)PPageModel.this.pageImages.get(pageKey)).get()) != null ? (Image)obj : PPageModel.this.loadPageImage(this.pageNumber + 1));
                        if (pageImage != null) {
                            PPageModel.this.pageImages.put(pageKey, new SoftReference<Image>(pageImage));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

