/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.CMBViewerException;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PFullSizePageView;
import com.ibm.mm.viewer.PFullSizeView;
import com.ibm.mm.viewer.POutsideInDocModel;
import com.ibm.mm.viewer.POutsideInJNI;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

class POutsideInFullSizeView
extends PFullSizeView
implements CMBGenericDocStateChangedListener {
    static final int STELLENT_BORDER_WIDTH = 18;
    static final int DISPLAY_RESOLUTION = 120;
    static final double PAGE_WIDTH = 8.5;
    static final double PAGE_HEIGHT = 11.0;
    static final double MAX_SCALE = 2.0;
    static final double MIN_SCALE = 0.1;
    private ParentCanvas parentCanvas;
    private JScrollBar vscrollbar;
    private JScrollBar hscrollbar;
    private POutsideInJNI stellentJni;
    private long nativeViewerHandle;
    private int hScrollRangeMin;
    private int hScrollRangeMax;
    private int hScrollPosition;
    private int hScrollPageSize;
    private int vScrollRangeMin;
    private int vScrollRangeMax;
    private int vScrollPosition;
    private int vScrollPageSize;
    private boolean settingPagePosition;
    private AnnotationCanvas annotationCanvas;
    private String lastSearchText;
    private boolean lastMatchCase;
    private boolean withinPaint;
    private JPopupMenu pagePopupMenu;
    private JPopupMenu doctabPopupMenu;
    private JPopupMenu selectAreaPopupMenu;
    int fit = 0;
    private boolean vscrolling;
    private boolean hscrolling;
    private boolean settingViewRectangle;
    private double oldScale = 1.0;
    private boolean inScrollCallback;
    private boolean firstFit = true;
    private boolean inSetScale;
    private boolean inGenericDocStateChanged;

    public POutsideInFullSizeView(PSingleDocViewer viewer, PDocModel model, POutsideInJNI stellentJni, long nativeWindowHandle) {
        super(viewer, model);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.stellentJni = stellentJni;
        this.nativeViewerHandle = nativeWindowHandle;
        this.setLayout(new BorderLayout());
        this.parentCanvas = new ParentCanvas();
        this.add((Component)this.parentCanvas, "Center");
        this.vscrollbar = new VScrollBar();
        this.add((Component)this.vscrollbar, "After");
        this.hscrollbar = new HScrollBar();
        this.add((Component)this.hscrollbar, "South");
        model.addDocStateChangedListener(this);
    }

    public void dispose() {
        this.vscrollbar = null;
        this.hscrollbar = null;
        if (this.getDocModel() != null) {
            this.getDocModel().removeDocStateChangedListener(this);
        }
        super.dispose();
    }

    public void setCursor(Cursor c) {
        this.annotationCanvas.setCursor(c);
    }

    Image getSubImage() throws CMBViewerException {
        return this.annotationCanvas.getSubImage();
    }

    public boolean canFind() {
        return true;
    }

    public boolean find(String text, boolean matchCase, boolean reverse) {
        long result;
        if (text.equals(this.lastSearchText) && this.lastMatchCase == matchCase) {
            result = this.stellentJni.searchNext(this.nativeViewerHandle, reverse);
        } else {
            result = this.stellentJni.search(this.nativeViewerHandle, text, matchCase, reverse);
            this.lastSearchText = text;
            this.lastMatchCase = matchCase;
        }
        return result == 0L;
    }

    public JComponent getAnnotationComponent() {
        return null;
    }

    private double getHScrollPerPage() {
        double pageWidthPixels = 1020.0 * this.getScale();
        double totalSizePixels = pageWidthPixels + 36.0;
        double scrollRange = this.hScrollRangeMax - this.hScrollRangeMin;
        if (scrollRange == 0.0) {
            scrollRange = this.getWidth();
        }
        double pixelsPerScroll = totalSizePixels / scrollRange;
        double pixelsPerPage = pageWidthPixels + 18.0;
        double scrollPerPage = pixelsPerPage / pixelsPerScroll;
        return scrollPerPage;
    }

    private double getVScrollPerPage() {
        POutsideInDocModel model = (POutsideInDocModel)this.getDocModel();
        int pageCount = model.getPageCount();
        if (pageCount <= 0) {
            return 0.0;
        }
        double pageHeightPixels = 1320.0 * this.getScale();
        double actualSizePixels = pageHeightPixels * (double)pageCount + (double)(18 * (pageCount + 1));
        double scrollRange = this.vScrollRangeMax - this.vScrollRangeMin;
        if (scrollRange == 0.0) {
            scrollRange = this.getHeight();
        }
        double pixelsPerScroll = actualSizePixels / scrollRange;
        double pixelsPerPage = pageHeightPixels + 18.0;
        double scrollPerPage = pixelsPerPage / pixelsPerScroll;
        return scrollPerPage;
    }

    double getScale() {
        return this.getDocModel().getScale();
    }

    void onPaint(Rectangle r) {
        if (!this.withinPaint) {
            this.annotationCanvas.repaint(r.x, r.y, r.width, r.height);
        }
    }

    void onVScrollPageSizeChanged(final int pageSize) {
        this.vScrollPageSize = pageSize;
        if (this.vscrollbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (POutsideInFullSizeView.this.annotationCanvas != null) {
                        POutsideInFullSizeView.this.annotationCanvas.updateAnnotationViewScales();
                    }
                    if (POutsideInFullSizeView.this.vscrollbar != null) {
                        POutsideInFullSizeView.this.vscrollbar.setVisibleAmount(pageSize);
                        POutsideInFullSizeView.this.vscrollbar.setBlockIncrement(pageSize);
                    }
                }
            });
        }
    }

    void onVScrollPositionChanged(final int position) {
        this.vScrollPosition = position;
        if (this.vscrollbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int pageCount;
                    POutsideInDocModel model = (POutsideInDocModel)POutsideInFullSizeView.this.getDocModel();
                    if (model != null && (pageCount = model.getPageCount()) > 0) {
                        int newPagePosition = POutsideInFullSizeView.this.vScrollPosition / (int)POutsideInFullSizeView.this.getVScrollPerPage() + 1;
                        if (model.getCurrentPagePosition() != newPagePosition) {
                            POutsideInFullSizeView.this.settingPagePosition = true;
                            model.setCurrentPagePosition(newPagePosition);
                            POutsideInFullSizeView.this.settingPagePosition = false;
                        }
                    }
                    if (POutsideInFullSizeView.this.vscrollbar != null && !POutsideInFullSizeView.this.vscrolling) {
                        POutsideInFullSizeView.this.inScrollCallback = true;
                        POutsideInFullSizeView.this.vscrollbar.setValue(position);
                        POutsideInFullSizeView.this.inScrollCallback = false;
                    }
                }
            });
        }
    }

    void onVScrollMaxChanged(int maxPosition) {
        this.onVScrollRangeChanged(this.vScrollRangeMin, maxPosition);
    }

    void onVScrollMinChanged(int minPosition) {
        this.onVScrollRangeChanged(minPosition, this.vScrollRangeMax);
    }

    void onVScrollRangeChanged(int minPosition, int maxPosition) {
        this.vScrollRangeMin = minPosition;
        this.vScrollRangeMax = maxPosition;
        if (this.vscrollbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (POutsideInFullSizeView.this.vscrollbar != null) {
                        POutsideInFullSizeView.this.vscrollbar.setMinimum(POutsideInFullSizeView.this.vScrollRangeMin);
                        POutsideInFullSizeView.this.vscrollbar.setMaximum(POutsideInFullSizeView.this.vScrollRangeMax);
                    }
                }
            });
        }
    }

    void onVScrollStateChanged(final boolean enabled) {
        if (this.vscrollbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (POutsideInFullSizeView.this.vscrollbar != null) {
                        POutsideInFullSizeView.this.vscrollbar.setEnabled(enabled);
                    }
                }
            });
        }
    }

    void onHScrollPageSizeChanged(final int pageSize) {
        this.hScrollPageSize = pageSize;
        if (this.hscrollbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (POutsideInFullSizeView.this.hscrollbar != null) {
                        POutsideInFullSizeView.this.hscrollbar.setVisibleAmount(pageSize);
                        POutsideInFullSizeView.this.hscrollbar.setBlockIncrement(pageSize);
                    }
                }
            });
        }
    }

    void onHScrollPositionChanged(final int position) {
        this.hScrollPosition = position;
        POutsideInDocModel model = (POutsideInDocModel)this.getDocModel();
        if (this.hscrollbar != null && !this.hscrolling) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (POutsideInFullSizeView.this.hscrollbar != null) {
                        POutsideInFullSizeView.this.inScrollCallback = true;
                        POutsideInFullSizeView.this.hscrollbar.setValue(position);
                        POutsideInFullSizeView.this.inScrollCallback = false;
                    }
                }
            });
        }
    }

    void onHScrollRangeChanged(final int minPosition, final int maxPosition) {
        this.hScrollRangeMin = minPosition;
        this.hScrollRangeMax = maxPosition;
        if (this.hscrollbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (POutsideInFullSizeView.this.hscrollbar != null) {
                        POutsideInFullSizeView.this.hscrollbar.setMinimum(minPosition);
                        POutsideInFullSizeView.this.hscrollbar.setMaximum(maxPosition);
                    }
                }
            });
        }
    }

    void onHScrollStateChanged(final boolean enabled) {
        if (this.hscrollbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (POutsideInFullSizeView.this.hscrollbar != null) {
                        POutsideInFullSizeView.this.hscrollbar.setEnabled(enabled);
                    }
                }
            });
        }
    }

    public void refit() {
        if (this.firstFit) {
            this.fit = ((PPageModel)this.getDocModel()).getFit();
            this.firstFit = false;
        }
        if (this.fit == 4) {
            this.fitActualSize();
        } else if (this.fit == 2) {
            this.fitHeight();
        } else if (this.fit == 3) {
            this.fitInWindow();
        } else if (this.fit == 1) {
            this.fitWidth();
        } else {
            this.setScale(this.getDocModel().getScale());
        }
    }

    void refit(Dimension viewDim, int vScrollBarWidth, int hScrollBarHeight) {
        this.getDocModel().refit(viewDim, vScrollBarWidth, hScrollBarHeight);
        this.refit();
    }

    boolean canFitHeight() {
        return true;
    }

    boolean canFitInWindow() {
        return true;
    }

    boolean canFitWidth() {
        return true;
    }

    boolean canFitActualSize() {
        return true;
    }

    void fitHeight() {
        this.fit = 2;
        double actualSizeHeightPixels = 1320.0;
        double currentHeightPixels = this.annotationCanvas.getHeight() - 18;
        double scale = currentHeightPixels / actualSizeHeightPixels;
        this._setScale(scale);
    }

    void fitInWindow() {
        this.fit = 3;
        double actualSizeWidthPixels = 1020.0;
        double actualSizeHeightPixels = 1320.0;
        double currentWidthPixels = this.annotationCanvas.getWidth() - 36;
        double widthScale = currentWidthPixels / actualSizeWidthPixels;
        double currentHeightPixels = this.annotationCanvas.getHeight() - 18;
        double heightScale = currentHeightPixels / actualSizeHeightPixels;
        double scale = Math.min(widthScale, heightScale);
        this._setScale(scale);
    }

    void fitWidth() {
        this.fit = 1;
        double actualSizeWidthPixels = 1020.0;
        double currentWidthPixels = this.annotationCanvas.getWidth() - 36;
        double scale = currentWidthPixels / actualSizeWidthPixels;
        this._setScale(scale);
    }

    void fitActualSize() {
        this.fit = 4;
        this._setScale(1.0);
    }

    int getFit() {
        return this.fit;
    }

    boolean canZoomIn() {
        return this.getDocModel().getScale() < 2.0;
    }

    boolean canZoomOut() {
        return this.getDocModel().getScale() > 0.1;
    }

    void zoomIn() {
        double newScale = this.getDocModel().getScale() * (1.0 + this.getDocModel().getZoomFactor());
        if (newScale > 2.0) {
            newScale = 2.0;
        }
        this.fit = 0;
        this._setScale(newScale);
    }

    void zoomOut() {
        double newScale = this.getDocModel().getScale() * (1.0 - this.getDocModel().getZoomFactor());
        if (newScale < 0.1) {
            newScale = 0.1;
        }
        this.fit = 0;
        this._setScale(newScale);
    }

    void setScale(double newScale) throws UnsupportedOperationException {
        if (this.inSetScale) {
            return;
        }
        this.fit = 0;
        this._setScale(newScale);
    }

    private void _setScale(double newScale) {
        this.inSetScale = true;
        int s = (int)(newScale * 100.0);
        this.stellentJni.setDWordOption(this.nativeViewerHandle, 337886, 5);
        this.stellentJni.setZoomOption(this.nativeViewerHandle, 337885, s, 100, s, 100);
        this.getDocModel().setScale(newScale);
        this.inSetScale = false;
    }

    public JPopupMenu getPopupMenu(String menuName) {
        if (menuName.equalsIgnoreCase("pagepopup")) {
            return this.pagePopupMenu;
        }
        if (menuName.equalsIgnoreCase("docTabPopup")) {
            return this.doctabPopupMenu;
        }
        if (menuName.equalsIgnoreCase("selectAreaPopup")) {
            return this.selectAreaPopupMenu;
        }
        return null;
    }

    public void setPopupMenu(JPopupMenu pMenu, String menuName) {
        if (menuName.equalsIgnoreCase("pagepopup")) {
            this.pagePopupMenu = pMenu;
        } else if (menuName.equalsIgnoreCase("docTabPopup")) {
            this.doctabPopupMenu = pMenu;
        } else if (menuName.equalsIgnoreCase("selectAreaPopup")) {
            this.selectAreaPopupMenu = pMenu;
        }
    }

    public boolean isTextSelected() {
        return (this.stellentJni.getClipInfo(this.nativeViewerHandle) & 1L) != 0L;
    }

    public void copyTextToClipboard() {
        this.stellentJni.copyToClip(this.nativeViewerHandle);
    }

    public void setViewStateIntoModel() {
    }

    public boolean isSelectedView() {
        return this == this.getViewer().getGdv().getSelectedView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
        String methodName = "genericDocStateChanged";
        if (!this.isSelectedView() && evt.getChangeType() != 3 && evt.getChangeType() != 5 && evt.getChangeType() != 4 && evt.getChangeType() != 15 && evt.getChangeType() != 14 && evt.getChangeType() != 16) {
            return;
        }
        if (this.inGenericDocStateChanged) {
            return;
        }
        this.inGenericDocStateChanged = true;
        try {
            block12: {
                try {
                    if (!this.isDisplayNeeded() || evt.getChangeType() == 2 || evt.getChangeType() == 10) break block12;
                    if (evt.getChangeType() == 3 || evt.getChangeType() == 1 || evt.getChangeType() == 15 || evt.getChangeType() == 14 || evt.getChangeType() == 16) {
                        this.refit();
                    }
                    if (this.settingPagePosition) break block12;
                    POutsideInDocModel model = (POutsideInDocModel)this.getDocModel();
                    int currentPagePosition = model.getCurrentPagePosition();
                    int pageCount = model.getPageCount();
                    if (pageCount <= 0) break block12;
                    Rectangle vr = model.getCurrentViewRectangle();
                    if (vr == null) {
                        vr = new Rectangle();
                    }
                    double xOffset = (double)(vr.x + 18) * this.getHScrollPerPage() / (1020.0 * this.getScale() + 36.0);
                    double yOffset = (double)(vr.y + 18) * this.getVScrollPerPage() / (1320.0 * this.getScale() + 36.0);
                    if (yOffset < 0.0) {
                        yOffset = 0.0;
                    }
                    if (this.settingViewRectangle) break block12;
                    if (this.oldScale != this.getScale()) {
                        this.setScale(this.getScale());
                        this.oldScale = this.getScale();
                    }
                    this.settingPagePosition = true;
                    int newhScrollPosition = (int)xOffset;
                    int newvScrollPosition = (int)((double)(currentPagePosition - 1) * this.getVScrollPerPage() + yOffset);
                    if (Math.abs(this.hScrollPosition - newhScrollPosition) > 16) {
                        this.stellentJni.hScroll(this.nativeViewerHandle, 7, newhScrollPosition);
                        this.hScrollPosition = newhScrollPosition;
                    }
                    if (Math.abs(this.vScrollPosition - newvScrollPosition) > 16) {
                        this.stellentJni.vScroll(this.nativeViewerHandle, 7, newvScrollPosition);
                        this.vScrollPosition = newvScrollPosition;
                    }
                    this.settingPagePosition = false;
                }
                catch (Exception e) {
                    ViewerLogger.logError((Object)this, methodName, e);
                    JOptionPane.showMessageDialog(this, PViewerUtilities.getMessage("DocumentViewer.unexpectedError"), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0);
                    Object var14_13 = null;
                    this.inGenericDocStateChanged = false;
                }
            }
            Object var14_12 = null;
            this.inGenericDocStateChanged = false;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.inGenericDocStateChanged = false;
            throw throwable;
        }
    }

    Rectangle getSelectAreaRectangle() {
        return this.annotationCanvas.getSelectAreaRectangle();
    }

    void setSelectAreaRectangle(Rectangle rect) {
        this.annotationCanvas.setSelectAreaRectangle(rect);
    }

    private class AnnotationPanel
    extends PFullSizePageView
    implements KeyListener {
        boolean pressedSentToOI;

        public AnnotationPanel(PSingleDocViewer viewer, PDocModel model, int pageNum) {
            super(viewer, model);
            this.setLayout(null);
            this.setPageNumber(pageNum);
            this.setPopupMenu(POutsideInFullSizeView.this.selectAreaPopupMenu, "selectAreaPopup");
            if (this.getDocModel().getAnnotationSet() != null) {
                CMBAnnotationView annotationView = this.getAnnotationView();
                annotationView.setCurrentPage(pageNum);
                annotationView.setViewComponent(this);
                try {
                    CMBDocument document = this.getDocModel().getDocument();
                    CMBPage page = document.getPage(pageNum);
                    double displayResolution = document.getDisplayResolution();
                    double pageXResolution = page.getPageXResolution();
                    double pageYResolution = page.getPageYResolution();
                    double pageResolution = Math.max(pageXResolution, pageYResolution);
                    double pageWidth = page.getWidth();
                    double pageHeight = page.getHeight();
                    double aspectRatio = pageXResolution / pageYResolution;
                    annotationView.getModel().setScaleFactor(displayResolution / pageResolution);
                    this.getDocModel().getAnnotationSet().setImageSize((int)(pageXResolution * pageWidth), (int)(pageYResolution * pageHeight), pageNum);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.setDoubleBuffered(false);
            this.setOpaque(false);
            this.setBackground(SystemColor.controlShadow);
            this.setFocusable(true);
            this.setFocusTraversalKeysEnabled(false);
            this.addKeyListener(this);
        }

        public void paint(Graphics g) {
            POutsideInFullSizeView.this.withinPaint = true;
            Rectangle r = g.getClipBounds();
            if (r == null) {
                POutsideInFullSizeView.this.stellentJni.repaint(POutsideInFullSizeView.this.nativeViewerHandle, 0, 0, this.getWidth(), this.getHeight());
            } else {
                r.translate(this.getX(), this.getY());
                POutsideInFullSizeView.this.stellentJni.repaint(POutsideInFullSizeView.this.nativeViewerHandle, r.x, r.y, r.width, r.height);
            }
            if (this.getAnnotationView() != null) {
                this.getAnnotationView().drawAllAnnotations((Graphics2D)g);
            }
            this.paintChildren(g);
            POutsideInFullSizeView.this.withinPaint = false;
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (e.isConsumed()) {
                return;
            }
            if (!(e.getClickCount() < 2 || this.getAnnotationView() != null && this.getAnnotationView().isOverAnnotation(e.getPoint()))) {
                Point p = SwingUtilities.convertPoint(this, e.getPoint(), POutsideInFullSizeView.this.parentCanvas);
                POutsideInFullSizeView.this.stellentJni.sendMouseLButtonDblClk(POutsideInFullSizeView.this.nativeViewerHandle, p.x, p.y);
            }
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isConsumed()) {
                this.pressedSentToOI = false;
                return;
            }
            if (this.getAnnotationView().getModel().getAnnotationServices().getSelectedAnnotationTool() != 0) {
                this.pressedSentToOI = false;
                return;
            }
            if ((e.getModifiers() & 4) == 4) {
                this.pressedSentToOI = false;
                return;
            }
            if (this.getAnnotationView() == null || this.getAnnotationView().getModel().getAnnotationServices().getSelectedAnnotationTool() == 0) {
                this.requestFocus();
            }
            if (this.getAnnotationView() == null || !this.getAnnotationView().isOverAnnotation(e.getPoint())) {
                this.pressedSentToOI = true;
                Point p = SwingUtilities.convertPoint(this, e.getPoint(), POutsideInFullSizeView.this.parentCanvas);
                POutsideInFullSizeView.this.stellentJni.sendMouseLButtonDown(POutsideInFullSizeView.this.nativeViewerHandle, p.x, p.y);
            } else {
                this.pressedSentToOI = false;
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.pressedSentToOI) {
                this.pressedSentToOI = false;
                Point p = SwingUtilities.convertPoint(this, e.getPoint(), POutsideInFullSizeView.this.parentCanvas);
                POutsideInFullSizeView.this.stellentJni.sendMouseLButtonUp(POutsideInFullSizeView.this.nativeViewerHandle, p.x, p.y);
                this.getDocModel().fireDocStateChangedEvent(20);
            } else if ((e.getModifiers() & 4) == 4) {
                if (POutsideInFullSizeView.this.pagePopupMenu != null) {
                    POutsideInFullSizeView.this.pagePopupMenu.show(this, e.getX(), e.getY());
                }
            } else {
                super.mouseReleased(e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.pressedSentToOI) {
                Point p = SwingUtilities.convertPoint(this, e.getPoint(), POutsideInFullSizeView.this.parentCanvas);
                POutsideInFullSizeView.this.stellentJni.sendMouseLDrag(POutsideInFullSizeView.this.nativeViewerHandle, p.x, p.y);
            } else {
                super.mouseDragged(e);
            }
        }

        public void updateAnnotationViewScale() {
            if (this.getAnnotationView() != null) {
                this.getAnnotationView().setScale(this.getScale());
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                Container rootAncestor = this.getFocusCycleRootAncestor();
                FocusTraversalPolicy policy = rootAncestor.getFocusTraversalPolicy();
                if (e.getModifiers() == 1) {
                    Component comp = this;
                    while (comp instanceof AnnotationPanel && (comp = policy.getComponentBefore(rootAncestor, comp)) != this) {
                    }
                    ((Component)comp).requestFocus();
                } else {
                    Component comp = this;
                    while (comp instanceof AnnotationPanel && (comp = policy.getComponentAfter(rootAncestor, comp)) != this) {
                    }
                    ((Component)comp).requestFocus();
                }
            } else {
                POutsideInFullSizeView.this.stellentJni.sendKeyDown(POutsideInFullSizeView.this.nativeViewerHandle, e.getKeyCode());
                this.getDocModel().fireDocStateChangedEvent(20);
            }
        }

        public void keyReleased(KeyEvent e) {
            POutsideInFullSizeView.this.stellentJni.sendKeyUp(POutsideInFullSizeView.this.nativeViewerHandle, e.getKeyCode());
        }

        public void keyTyped(KeyEvent e) {
        }

        public void focusGained(FocusEvent event) {
            super.focusGained(event);
            POutsideInFullSizeView.this.stellentJni.sendActivate(POutsideInFullSizeView.this.nativeViewerHandle);
        }

        public void focusLost(FocusEvent event) {
            super.focusLost(event);
            POutsideInFullSizeView.this.stellentJni.sendDeactivate(POutsideInFullSizeView.this.nativeViewerHandle);
        }

        public void componentResized(ComponentEvent arg0) {
        }

        public boolean isSelectedView() {
            return true;
        }

        void refit() {
        }

        protected void display() {
        }

        public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
            CMBAnnotationView annotationView;
            super.genericDocStateChanged(evt);
            if (evt.getChangeType() == 1 && (annotationView = this.getAnnotationView()) != null) {
                annotationView.setCurrentPage(this.getPageNumber());
            }
        }
    }

    private class AnnotationCanvas
    extends Panel
    implements ComponentListener {
        Hashtable annotationPanels = new Hashtable();

        public AnnotationCanvas() {
            this.setFocusable(false);
            this.setBackground(SystemColor.controlShadow);
            this.setLayout(null);
            this.addComponentListener(this);
            this.positionAnnotationPanels();
        }

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            POutsideInFullSizeView.this.withinPaint = true;
            POutsideInFullSizeView.this.stellentJni.repaint(POutsideInFullSizeView.this.nativeViewerHandle, 0, 0, this.getWidth(), this.getHeight());
            POutsideInFullSizeView.this.withinPaint = false;
            int pageCount = POutsideInFullSizeView.this.getDocModel().getPageCount();
            for (int pageNum = 1; pageNum <= pageCount; ++pageNum) {
                AnnotationPanel annotationPanel = this.getAnnotationPanel(pageNum);
                AffineTransform oldTransform = g2.getTransform();
                g.translate(annotationPanel.getX(), annotationPanel.getY());
                g.setClip(0, 0, annotationPanel.getWidth(), annotationPanel.getHeight());
                annotationPanel.paint(g);
                g2.setTransform(oldTransform);
            }
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            this.positionAnnotationPanels();
        }

        public void componentShown(ComponentEvent e) {
        }

        private AnnotationPanel getAnnotationPanel(int page) {
            AnnotationPanel annotationPanel;
            Integer pageKey = new Integer(page);
            if (this.annotationPanels.containsKey(pageKey)) {
                annotationPanel = (AnnotationPanel)this.annotationPanels.get(pageKey);
            } else {
                annotationPanel = new AnnotationPanel(POutsideInFullSizeView.this.getViewer(), POutsideInFullSizeView.this.getDocModel(), page);
                this.annotationPanels.put(pageKey, annotationPanel);
                this.add(annotationPanel);
            }
            return annotationPanel;
        }

        public void positionAnnotationPanels() {
            if (POutsideInFullSizeView.this.getDocModel() == null) {
                return;
            }
            int pageCount = POutsideInFullSizeView.this.getDocModel().getPageCount();
            for (int pageNum = 1; pageNum <= pageCount; ++pageNum) {
                double vPageOffset;
                double hPageOffset;
                if (POutsideInFullSizeView.this.getDocModel() == null) {
                    hPageOffset = 0.0;
                    vPageOffset = 0.0;
                } else {
                    double hScrollPositionPageLeft = 0.0;
                    double hScrollPosition = POutsideInFullSizeView.this.hscrollbar.getValue();
                    double hScrollOffset = hScrollPositionPageLeft - hScrollPosition;
                    hPageOffset = hScrollOffset / POutsideInFullSizeView.this.getHScrollPerPage();
                    double vScrollPositionPageTop = (double)(pageNum - 1) * POutsideInFullSizeView.this.getVScrollPerPage();
                    double vScrollPosition = POutsideInFullSizeView.this.vscrollbar.getValue();
                    double vScrollOffset = vScrollPositionPageTop - vScrollPosition;
                    vPageOffset = vScrollOffset / POutsideInFullSizeView.this.getVScrollPerPage();
                }
                this.getAnnotationPanel(pageNum).setBounds((int)(18.0 + hPageOffset * 120.0 * 8.5 * POutsideInFullSizeView.this.getScale()), (int)(18.0 + vPageOffset * 120.0 * 11.0 * POutsideInFullSizeView.this.getScale()), (int)(1020.0 * POutsideInFullSizeView.this.getScale() + 18.0), (int)(1320.0 * POutsideInFullSizeView.this.getScale() + 18.0));
                Rectangle b = this.getAnnotationPanel(pageNum).getBounds();
                if (pageNum != POutsideInFullSizeView.this.getDocModel().getCurrentPageNumber()) continue;
                Rectangle ovr = ((PPageModel)POutsideInFullSizeView.this.getDocModel()).getCurrentViewRectangle();
                Rectangle vr = new Rectangle(-b.x, -b.y, this.getWidth(), this.getHeight());
                POutsideInFullSizeView.this.settingViewRectangle = true;
                ((PPageModel)POutsideInFullSizeView.this.getDocModel()).setCurrentViewRectangle(vr);
                POutsideInFullSizeView.this.settingViewRectangle = false;
            }
        }

        public void updateAnnotationViewScales() {
            if (POutsideInFullSizeView.this.getDocModel() == null) {
                return;
            }
            int pageCount = POutsideInFullSizeView.this.getDocModel().getPageCount();
            for (int pageNum = 1; pageNum <= pageCount; ++pageNum) {
                this.getAnnotationPanel(pageNum).updateAnnotationViewScale();
            }
        }

        private int getSelectAreaPage() {
            if (POutsideInFullSizeView.this.getDocModel() == null) {
                return 0;
            }
            int pageCount = POutsideInFullSizeView.this.getDocModel().getPageCount();
            for (int pageNum = 1; pageNum <= pageCount; ++pageNum) {
                Rectangle selectAreaRectangle = this.getAnnotationPanel(pageNum).getSelectAreaRectangle();
                if (selectAreaRectangle.width <= 0) continue;
                return pageNum;
            }
            return 0;
        }

        Rectangle getSelectAreaRectangle() {
            if (POutsideInFullSizeView.this.getDocModel() == null) {
                return new Rectangle(0, 0, 0, 0);
            }
            int page = this.getSelectAreaPage();
            if (page < 1) {
                return new Rectangle(0, 0, 0, 0);
            }
            AnnotationPanel annotationPanel = this.getAnnotationPanel(page);
            Rectangle selectAreaRectangle = annotationPanel.getSelectAreaRectangle();
            return selectAreaRectangle;
        }

        void setSelectAreaRectangle(Rectangle rect) {
            if (POutsideInFullSizeView.this.getDocModel() == null) {
                return;
            }
            int pageCount = POutsideInFullSizeView.this.getDocModel().getPageCount();
            for (int pageNum = 1; pageNum <= pageCount; ++pageNum) {
                this.getAnnotationPanel(pageNum).setSelectAreaRectangle(new Rectangle(0, 0, 0, 0));
            }
            AnnotationPanel annotationPanel = this.getAnnotationPanel(POutsideInFullSizeView.this.getDocModel().getCurrentPageNumber());
            annotationPanel.setSelectAreaRectangle(rect);
        }

        public Image getSubImage() {
            int page = this.getSelectAreaPage();
            if (page < 1) {
                throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.invalidSelectAreaRectangle"));
            }
            AnnotationPanel annotationPanel = this.getAnnotationPanel(page);
            annotationPanel.display();
            Image subimage = annotationPanel.getSubImage();
            annotationPanel.currentPageImage = null;
            return subimage;
        }

        public void setCursor(Cursor c) {
            super.setCursor(c);
            int pageCount = POutsideInFullSizeView.this.getDocModel().getPageCount();
            for (int pageNum = 1; pageNum <= pageCount; ++pageNum) {
                this.getAnnotationPanel(pageNum).setCursor(c);
            }
        }
    }

    private class HScrollBar
    extends JScrollBar
    implements AdjustmentListener {
        public HScrollBar() {
            super(0);
            this.setFocusable(false);
            this.addAdjustmentListener(this);
            this.setUnitIncrement(50);
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            POutsideInFullSizeView.this.hscrolling = true;
            if (!POutsideInFullSizeView.this.inScrollCallback) {
                POutsideInFullSizeView.this.stellentJni.hScroll(POutsideInFullSizeView.this.nativeViewerHandle, 7, e.getValue());
            }
            POutsideInFullSizeView.this.annotationCanvas.positionAnnotationPanels();
            POutsideInFullSizeView.this.hscrolling = false;
        }
    }

    private class VScrollBar
    extends JScrollBar
    implements AdjustmentListener {
        public VScrollBar() {
            this.setFocusable(false);
            this.addAdjustmentListener(this);
            this.setUnitIncrement(50);
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            POutsideInFullSizeView.this.vscrolling = true;
            if (!POutsideInFullSizeView.this.inScrollCallback) {
                POutsideInFullSizeView.this.stellentJni.vScroll(POutsideInFullSizeView.this.nativeViewerHandle, 7, e.getValue());
            }
            POutsideInFullSizeView.this.annotationCanvas.positionAnnotationPanels();
            POutsideInFullSizeView.this.vscrolling = false;
        }
    }

    private class ParentCanvas
    extends Panel
    implements ComponentListener {
        public ParentCanvas() {
            System.getProperty("Background");
            this.setBackground(SystemColor.controlShadow);
            this.setLayout(new BorderLayout());
            this.setFocusable(false);
            this.setPreferredSize(new Dimension(0, 0));
            this.addComponentListener(this);
        }

        public void addNotify() {
            super.addNotify();
            POutsideInFullSizeView.this.stellentJni.setDWordOption(POutsideInFullSizeView.this.nativeViewerHandle, 338484, 9);
            POutsideInFullSizeView.this.stellentJni.resizeViewerWindow(POutsideInFullSizeView.this.nativeViewerHandle, this.getWidth(), this.getHeight());
            POutsideInFullSizeView.this.stellentJni.parentViewerWindow(POutsideInFullSizeView.this.nativeViewerHandle, this);
            if (POutsideInFullSizeView.this.annotationCanvas == null) {
                POutsideInFullSizeView.this.annotationCanvas = new AnnotationCanvas();
            }
            this.add((Component)POutsideInFullSizeView.this.annotationCanvas, "Center");
            this.noDoubleBuffering(POutsideInFullSizeView.this.annotationCanvas);
            POutsideInFullSizeView.this.stellentJni.makeTransparent(POutsideInFullSizeView.this.annotationCanvas);
        }

        public void removeNotify() {
            POutsideInFullSizeView.this.stellentJni.parentViewerWindow(POutsideInFullSizeView.this.nativeViewerHandle, null);
            this.remove(POutsideInFullSizeView.this.annotationCanvas);
            super.removeNotify();
        }

        private void noDoubleBuffering(Component c) {
            while (c != null) {
                if (c instanceof JComponent) {
                    ((JComponent)c).setDoubleBuffered(false);
                }
                c = c.getParent();
            }
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            POutsideInFullSizeView.this.stellentJni.resizeViewerWindow(POutsideInFullSizeView.this.nativeViewerHandle, this.getWidth(), this.getHeight());
            POutsideInFullSizeView.this.refit();
        }

        public void componentShown(ComponentEvent e) {
        }

        public void paint(Graphics g) {
        }

        public void update(Graphics g) {
        }
    }
}

