/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

class POptionPane
extends JOptionPane {
    POptionPane() {
    }

    static int showOptionDialog(CMBGenericDocViewer viewer, String title, Object message, int messageType, int optionType, Icon icon) {
        Frame parentFrame = viewer.getOwningFrame();
        boolean ltr = PViewerUtilities.isLeftToRight();
        ComponentOrientation cOrient = ComponentOrientation.LEFT_TO_RIGHT;
        String ok = PViewerUtilities.getMessage("printDialog.button.OK");
        String cancel = PViewerUtilities.getMessage("printDialog.button.Cancel");
        Object[] options = new Object[]{ok, cancel};
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, ok);
        if (!ltr) {
            cOrient = ComponentOrientation.RIGHT_TO_LEFT;
        }
        pane.setComponentOrientation(cOrient);
        JDialog dialog = pane.createDialog(parentFrame, title);
        dialog.setResizable(true);
        dialog.getContentPane().setComponentOrientation(cOrient);
        dialog.setComponentOrientation(cOrient);
        viewer.setDialogDisplayed(dialog);
        dialog.show();
        viewer.setDialogDisplayed(null);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    public static int showConfirmDialog(CMBGenericDocViewer viewer, Object message, String title, int optionType, int messageType, Icon icon) {
        Frame parentComponent = viewer.getOwningFrame();
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon);
        ComponentOrientation cOrient = ComponentOrientation.LEFT_TO_RIGHT;
        if (!PViewerUtilities.isLeftToRight()) {
            cOrient = ComponentOrientation.RIGHT_TO_LEFT;
        }
        pane.setComponentOrientation(cOrient);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.getContentPane().setComponentOrientation(cOrient);
        dialog.setComponentOrientation(cOrient);
        viewer.setDialogDisplayed(dialog);
        dialog.show();
        viewer.setDialogDisplayed(null);
        Object o = pane.getValue();
        if (o == null || o == UNINITIALIZED_VALUE) {
            return -1;
        }
        int selectedValue = (Integer)pane.getValue();
        return selectedValue;
    }

    static Object showInputDialog(CMBGenericDocViewer viewer, Object message, String title, Object[] selectionValues, Object initialValue) {
        Frame parentComponent = viewer.getOwningFrame();
        boolean ltr = PViewerUtilities.isLeftToRight();
        ComponentOrientation cOrient = ComponentOrientation.LEFT_TO_RIGHT;
        String ok = PViewerUtilities.getMessage("printDialog.button.OK");
        String cancel = PViewerUtilities.getMessage("printDialog.button.Cancel");
        Object[] options = new Object[]{ok, cancel};
        JOptionPane pane = new JOptionPane(message, -1, 2, null, options, ok);
        if (!ltr) {
            cOrient = ComponentOrientation.RIGHT_TO_LEFT;
        }
        pane.setComponentOrientation(cOrient);
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialValue);
        POptionPane.setComboBoxRendererOrientations(pane, cOrient);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.setComponentOrientation(cOrient);
        dialog.getContentPane().setComponentOrientation(cOrient);
        pane.selectInitialValue();
        viewer.setDialogDisplayed(dialog);
        dialog.show();
        viewer.setDialogDisplayed(null);
        Object value = pane.getInputValue();
        Object o = pane.getValue();
        if (value == UNINITIALIZED_VALUE) {
            return null;
        }
        if (o instanceof String) {
            String sVal = o.toString();
            if (sVal.compareToIgnoreCase(cancel) == 0) {
                return null;
            }
            if (sVal.compareToIgnoreCase(ok) == 0) {
                return value;
            }
        }
        return null;
    }

    private static void setComboBoxRendererOrientations(JComponent component, ComponentOrientation orientation) {
        for (int i = 0; i < component.getComponentCount(); ++i) {
            Component subcomponent = component.getComponent(i);
            if (subcomponent instanceof JComboBox) {
                ListCellRenderer renderer = ((JComboBox)subcomponent).getRenderer();
                if (!(renderer instanceof BasicComboBoxRenderer)) continue;
                BasicComboBoxRenderer r = (BasicComboBoxRenderer)renderer;
                r.setComponentOrientation(orientation);
                continue;
            }
            if (!(subcomponent instanceof JComponent)) continue;
            POptionPane.setComboBoxRendererOrientations((JComponent)subcomponent, orientation);
        }
    }
}

