/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocClosedEvent;
import com.ibm.mm.viewer.CMBGenericDocClosedListener;
import com.ibm.mm.viewer.CMBGenericDocOpenedEvent;
import com.ibm.mm.viewer.CMBGenericDocOpenedListener;
import com.ibm.mm.viewer.CMBGenericDocSelectedEvent;
import com.ibm.mm.viewer.CMBGenericDocSelectedListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBViewerAction;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

class POcrDocumentAction
extends CMBViewerAction
implements CMBGenericDocOpenedListener,
CMBGenericDocClosedListener,
CMBGenericDocSelectedListener,
CMBGenericDocStateChangedListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";

    public POcrDocumentAction(CMBGenericDocViewer viewer) {
        super(viewer);
        this.initialize();
    }

    public POcrDocumentAction(CMBGenericDocViewer viewer, String name) {
        super(viewer, name);
        this.initialize();
    }

    public POcrDocumentAction(CMBGenericDocViewer viewer, String name, Icon icon) {
        super(viewer, name, icon);
        this.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        this.getViewer().ocrDocument();
        this.setToolStatus();
    }

    private void initialize() {
        CMBGenericDocViewer viewer = this.getViewer();
        viewer.addDocOpenedListener(this);
        viewer.addDocClosedListener(this);
        viewer.addDocSelectedListener(this);
        viewer.addDocStateChangedListener(this);
        this.setToolStatus();
    }

    private void setToolStatus() {
        CMBGenericDocViewer viewer = this.getViewer();
        boolean isFindActive = false;
        boolean isDocOcrActive = false;
        if (viewer.currentLayout != null && viewer.currentLayout.getFindPanel() != null && viewer.currentLayout.getFindPanel().isShowing()) {
            isFindActive = true;
        }
        if (viewer.getSelectedDocument() != null && viewer.ocrQueue.contains(viewer.getSelectedDocument())) {
            isDocOcrActive = true;
        }
        this.setEnabled(viewer.canOcrDocument() && !isFindActive && !isDocOcrActive);
    }

    public void genericDocOpened(CMBGenericDocOpenedEvent evt) {
        this.setToolStatus();
    }

    public void genericDocClosed(CMBGenericDocClosedEvent evt) {
        this.setToolStatus();
    }

    public void genericDocSelected(CMBGenericDocSelectedEvent evt) {
        this.setToolStatus();
    }

    public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
        this.setToolStatus();
    }
}

