/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocOCRStatusEvent;
import com.ibm.mm.viewer.CMBGenericDocOCRStatusListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBLetters;
import com.ibm.mm.viewer.CMBPage;
import java.io.IOException;

class POCRQueueItem {
    private static Object ocrMutex = new Object();
    private CMBGenericDocViewer viewer = null;
    private CMBDocument document = null;
    private int[] pages = null;
    private boolean active = true;

    POCRQueueItem(CMBGenericDocViewer viewer, CMBDocument document, int[] pages) {
        this.viewer = viewer;
        this.document = document;
        this.pages = pages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeOCR() {
        String methodName = "executeOCR";
        ViewerLogger.logEntry(this, "executeOCR");
        this.viewer.firePropertyChange("OCR_CURR_ITEM_VALID", false, true);
        Object object = ocrMutex;
        synchronized (object) {
            if (this.pages == null) {
                ViewerLogger.logDebug(this, "executeOCR", "-get text for all pages of document");
                if (this.document.getMimeType().equalsIgnoreCase("application/pdf")) {
                    ViewerLogger.logDebug(this, "executeOCR", "--get text for all pages of document:application/pdf");
                    try {
                        for (int i = 1; i <= this.document._getPageCount(); ++i) {
                            CMBPage page = this.document.getPage(i);
                            if (page.getLetters() == null) {
                                ViewerLogger.logDebug(this, "executeOCR", "--call extract text for page: " + page.getPageNumber());
                                page.letters = this.viewer._extractText(page);
                                boolean needOcr = false;
                                if (page.letters == null || page.letters.getLetters() == null || page.letters.getLetters().length == 0) {
                                    if (this.viewer.getDocServices().canOcr(this.document)) {
                                        needOcr = true;
                                        ViewerLogger.logDebug(this, "executeOCR", "--extract text of pdf is empty;  try ocr");
                                    } else {
                                        needOcr = false;
                                        ViewerLogger.logDebug(this, "executeOCR", "--extract text of pdf is empty and there is no ocr engine");
                                        CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, new int[]{page.getPageNumber()}, 26);
                                        this.viewer.getViewer(this.document).getDocModel().fireDocStateChangedEvent(event);
                                    }
                                }
                                if (!needOcr) continue;
                                ViewerLogger.logDebug(this, "executeOCR", "-get text for pdf document page that needs ocr or non pdf document page");
                                page.letters = this.viewer.getDocServices().ocrPage(page, new CMBGenericDocOCRStatusListener(){

                                    public void ocrStatusChanged(CMBGenericDocOCRStatusEvent e) {
                                        if (e.getDocument() == POCRQueueItem.this.document && e.getStatusType() == 1) {
                                            e.getPage().ocrLetters = e.getLetters();
                                            ViewerLogger.logDebug(this, "executeOCR$ocrStatusChanged", "--get text for pdf document");
                                            CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, e.getDocument(), new int[]{e.getPage().getPageNumber()}, 23);
                                            POCRQueueItem.this.viewer.getViewer(e.getDocument()).getDocModel().fireDocStateChangedEvent(event);
                                        }
                                    }
                                });
                                continue;
                            }
                            ViewerLogger.logDebug(this, "executeOCR", "--letters already exist for page, fire page_text event for page: " + page.getPageNumber());
                            CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, new int[]{page.getPageNumber()}, 26);
                            this.viewer.getViewer(this.document).getDocModel().fireDocStateChangedEvent(event);
                        }
                        this.document.setTextValid(true);
                        ViewerLogger.logDebug(this, "executeOCR", "--fire doc_text event for document after extract text for all pdf pages");
                        CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, new int[]{1}, 27);
                        this.viewer.getViewer(this.document).getDocModel().fireDocStateChangedEvent(event);
                    }
                    catch (IOException e) {}
                } else {
                    ViewerLogger.logDebug(this, "executeOCR", "--get text for all pages of document:NOT application/pdf");
                    this.viewer.getDocServices().ocrDocument(this.document, new CMBGenericDocOCRStatusListener(){

                        public void ocrStatusChanged(CMBGenericDocOCRStatusEvent e) {
                            if (e.getDocument() == POCRQueueItem.this.document && e.getStatusType() == 1) {
                                e.getPage().ocrLetters = e.getLetters();
                                CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, POCRQueueItem.this.document, new int[]{e.getPage().getPageNumber()}, 23);
                                POCRQueueItem.this.viewer.getViewer(POCRQueueItem.this.document).getDocModel().fireDocStateChangedEvent(event);
                            } else if (e.getDocument() == POCRQueueItem.this.document && e.getStatusType() == 2) {
                                POCRQueueItem.this.document.setOCRValid(true);
                                CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, POCRQueueItem.this.document, new int[]{1}, 24);
                                POCRQueueItem.this.active = false;
                                POCRQueueItem.this.viewer.getViewer(POCRQueueItem.this.document).getDocModel().fireDocStateChangedEvent(event);
                            } else if (e.getDocument() == POCRQueueItem.this.document && e.getStatusType() == 3) {
                                CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, POCRQueueItem.this.document, new int[]{1}, 25);
                                POCRQueueItem.this.viewer.getViewer(POCRQueueItem.this.document).getDocModel().fireDocStateChangedEvent(event);
                                POCRQueueItem.this.active = false;
                            }
                        }
                    });
                }
            } else {
                ViewerLogger.logDebug(this, "executeOCR", "-get text for specified pages of document");
                for (int i = 0; i < this.pages.length; ++i) {
                    try {
                        CMBPage page = this.document.getPage(this.pages[i]);
                        CMBLetters letters = page.getLetters();
                        boolean needOcr = true;
                        if (this.document.getMimeType().equalsIgnoreCase("application/pdf")) {
                            if (letters == null || letters.getLetters() == null || letters.getLetters().length == 0) {
                                ViewerLogger.logDebug(this, "executeOCR", "--get text for pdf document with extract text ");
                                page.letters = this.viewer._extractText(page);
                            }
                            if ((letters = page.getLetters()) == null || letters.getLetters() == null || letters.getLetters().length == 0) {
                                if (this.viewer.getDocServices().canOcr(this.document)) {
                                    needOcr = true;
                                    ViewerLogger.logDebug(this, "executeOCR", "--extract text of pdf is empty;  try ocr");
                                } else {
                                    needOcr = false;
                                    ViewerLogger.logDebug(this, "executeOCR", "--extract text of pdf is empty and there is no ocr engine");
                                    CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, new int[]{page.getPageNumber()}, 26);
                                    this.viewer.getViewer(this.document).getDocModel().fireDocStateChangedEvent(event);
                                }
                            } else {
                                needOcr = false;
                            }
                        }
                        if (!needOcr && this.document.getMimeType().equalsIgnoreCase("application/pdf")) continue;
                        ViewerLogger.logDebug(this, "executeOCR", "-get text for pdf document page that needs ocr or non pdf document page");
                        letters = this.viewer.getDocServices().ocrPage(page, new CMBGenericDocOCRStatusListener(){

                            public void ocrStatusChanged(CMBGenericDocOCRStatusEvent e) {
                                if (e.getDocument() == POCRQueueItem.this.document && e.getStatusType() == 1) {
                                    e.getPage().ocrLetters = e.getLetters();
                                    ViewerLogger.logDebug(this, "executeOCR$ocrStatusChanged", "--get text for pdf document");
                                    CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, e.getDocument(), new int[]{e.getPage().getPageNumber()}, 23);
                                    POCRQueueItem.this.viewer.getViewer(e.getDocument()).getDocModel().fireDocStateChangedEvent(event);
                                }
                            }
                        });
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }
        ViewerLogger.logExit(this, "executeOCR");
    }

    void executeCancel() {
        if (this.viewer.ocrQueue.currItemOCR != null && this.viewer.ocrQueue.currItemOCR.equals(this)) {
            this.viewer.ocrQueue.currItemOCR = null;
            this.viewer.firePropertyChange("OCR_CURR_ITEM_VALID", true, false);
            this.viewer.cancelOCR(this.document);
        } else {
            this.viewer.firePropertyChange("OCR_CURR_ITEM_VALID", true, false);
        }
    }

    public CMBDocument getDocument() {
        return this.document;
    }

    public String toString() {
        return "POCRQueueItem:" + this.viewer.getDocName(this.document);
    }

    public boolean isActive() {
        return this.active;
    }
}

