/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.POCRQueueItem;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class POCRQueue {
    Vector<POCRQueueItem> items = new Vector();
    POCRQueueItem currItemOCR = null;
    Thread ocrThread = null;

    POCRQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAll() {
        POCRQueue pOCRQueue = this;
        synchronized (pOCRQueue) {
            for (POCRQueueItem r : this.items) {
                r.executeCancel();
            }
            this.items.removeAllElements();
            if (this.currItemOCR != null) {
                this.cancel(this.currItemOCR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(CMBDocument doc) {
        POCRQueue pOCRQueue = this;
        synchronized (pOCRQueue) {
            Vector<POCRQueueItem> foundItems = this.find(doc);
            Enumeration<POCRQueueItem> en = foundItems.elements();
            while (en.hasMoreElements()) {
                POCRQueueItem r = en.nextElement();
                this.cancel(r);
            }
        }
    }

    private void cancel(POCRQueueItem r) {
        if (this.items.contains(r)) {
            this.items.remove(r);
            r.executeCancel();
        } else {
            r.executeCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<POCRQueueItem> find(CMBDocument doc) {
        Vector<POCRQueueItem> foundItems = new Vector<POCRQueueItem>();
        POCRQueue pOCRQueue = this;
        synchronized (pOCRQueue) {
            CMBDocument rDoc;
            if (this.currItemOCR != null && this.currItemOCR.isActive() && (rDoc = this.currItemOCR.getDocument()).equals(doc)) {
                foundItems.add(this.currItemOCR);
            }
            Enumeration<POCRQueueItem> en = this.items.elements();
            while (en.hasMoreElements()) {
                POCRQueueItem r = en.nextElement();
                CMBDocument rDoc2 = r.getDocument();
                if (!rDoc2.equals(doc)) continue;
                foundItems.add(r);
            }
        }
        return foundItems;
    }

    boolean contains(CMBDocument doc) {
        Vector<POCRQueueItem> foundItems = this.find(doc);
        return !foundItems.isEmpty();
    }

    boolean hasDocumentsOCR() {
        if (this.currItemOCR != null && this.currItemOCR.isActive()) {
            return true;
        }
        return !this.items.isEmpty();
    }

    private synchronized void checkToStartThread() {
        if (this.ocrThread == null || !this.ocrThread.isAlive()) {
            this.ocrThread = new Thread((Runnable)new Worker(), "POCRQueue");
            try {
                this.ocrThread.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.ocrThread.start();
        }
    }

    private synchronized boolean checkToEndThread() {
        if (this.items.isEmpty()) {
            this.ocrThread.interrupt();
            this.ocrThread = null;
            this.currItemOCR = null;
            return true;
        }
        return false;
    }

    synchronized void put(POCRQueueItem r) {
        this.checkToStartThread();
        this.items.add(r);
    }

    private synchronized POCRQueueItem take() {
        if (this.items.isEmpty()) {
            return null;
        }
        this.currItemOCR = this.items.firstElement();
        return this.items.remove(0);
    }

    void addListenerForSelectTextAction(CMBGenericDocViewer viewer, CMBDocument document) {
        viewer.addDocStateChangedListener(new SelectTextListener(viewer, document, null));
    }

    void addListenerForSelectTextAction(CMBGenericDocViewer viewer, CMBPage page) {
        viewer.addDocStateChangedListener(new SelectTextListener(viewer, null, page));
    }

    private class SelectTextListener
    implements CMBGenericDocStateChangedListener {
        CMBGenericDocViewer viewer = null;
        CMBDocument document = null;
        CMBPage page = null;

        public SelectTextListener(CMBGenericDocViewer viewer, CMBDocument document, CMBPage page) {
            this.viewer = viewer;
            this.document = document;
            this.page = page;
        }

        public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
            if (evt.getChangeType() == 24 && evt.getDocument() == this.document) {
                this.viewer.setCurrentMode(113);
                this.viewer.setCursor("select_text");
                this.viewer.removeDocStateChangedListener(this);
            } else if (evt.getChangeType() == 23 && this.document == null && evt.getDocument() == this.page.getDocument() && evt.getCurrentPageNumber() == this.page.getPageNumber()) {
                this.viewer.setCurrentMode(113);
                this.viewer.setCursor("select_text");
                this.viewer.removeDocStateChangedListener(this);
            }
        }
    }

    private class Worker
    implements Runnable {
        private boolean done;

        private Worker() {
        }

        public void run() {
            this.done = false;
            while (!this.done) {
                POCRQueueItem r = POCRQueue.this.take();
                if (r == null) {
                    return;
                }
                r.executeOCR();
                this.done = POCRQueue.this.checkToEndThread();
            }
        }
    }
}

