/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBCustomPageablePrintable;
import com.ibm.mm.viewer.CMBGenericDocHelpEvent;
import com.ibm.mm.viewer.CMBGenericDocHelpListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PPrintQueueItem;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.SheetCollate;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

class PNewPrintDialog
extends JDialog
implements ItemListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private boolean printMultiDocuments = false;
    int documentCount = 0;
    int pageCount = 0;
    static final int ALL_PAGES = 0;
    static final int PAGE_RANGE = 1;
    static final int SELECTION = 2;
    static final int ZOOM_MIN = 25;
    static final int ZOOM_MAX = 500;
    static final int ZOOM_DEFAULT = 100;
    static final int COPY_MIN = 1;
    static final int COPY_MAX = 999;
    static final int COPY_DEFAULT = 1;
    static final String printFileSuffix = PViewerUtilities.getMessage("printDialog.printFileFilter.suffix");
    private PrintService[] services = null;
    PrintRequestAttributeSet printRequestAttrSet = new HashPrintRequestAttributeSet();
    int pageRangeScope = 0;
    StringBuffer selectedPageRanges = null;
    int customStartPagePos = 0;
    int customEndPagePos = 0;
    Book book = null;
    protected Vector docHelpListeners = new Vector();
    private ComponentOrientation compOri = null;
    private JPanel mainPanel = null;
    private JPanel buttonPanel = null;
    private JLabel infoLabel = null;
    private JLabel pageCountLabel = null;
    private JLabel docCountLabel = null;
    private JLabel nameLabel = null;
    private JComboBox nameField = null;
    private JButton propertiesButton = null;
    private JCheckBox printToFileCheckbox = null;
    private JLabel statusLabel = null;
    private JLabel statusResultLabel = null;
    private JLabel typeLabel = null;
    private JLabel typeResultLabel = null;
    private JCheckBox centerOnPageCheckbox = null;
    private JCheckBox fitToPageCheckbox = null;
    private JLabel zoomLabel = null;
    private NumericSpinner zoomSpinner = null;
    private JCheckBox annotationsCheckbox = null;
    private JLabel copyLabel = null;
    private NumericSpinner copySpinner = null;
    private JCheckBox collateCheckbox = null;
    private JTextField selPagesText = null;
    private JLabel selPagesInfoAsLabel = null;
    private ButtonGroup bg = null;
    private JRadioButton currPageRB = null;
    private JRadioButton allPagesRB = null;
    private JRadioButton selPagesRB = null;
    private JButton printButton = null;
    private JButton cancelButton = null;
    private JButton setupButton = null;
    private JButton helpButton = null;
    private boolean needToRequestFocus = true;
    Hashtable customPrintables = new Hashtable();
    PrinterJob printerJob = null;
    PageFormat pageFormat = null;
    boolean printButtonSelected = false;
    private CMBGenericDocViewer viewer = null;
    PPrintQueueItem printItem = null;
    PPrintQueueItem[] printItems = null;

    public PNewPrintDialog(Frame owner, PrintService[] services, PPrintQueueItem printItem, Hashtable customPrintables, CMBGenericDocViewer viewer) {
        super(owner, PViewerUtilities.getMessage("printDialog.Title"), true);
        this.setName("PrintDocument");
        this.printMultiDocuments = false;
        this.printItem = printItem;
        this.book = printItem.getBook();
        this.pageFormat = printItem.getPageFormat();
        this.printerJob = printItem.getPj();
        this.customPrintables = customPrintables;
        this.services = services;
        this.viewer = viewer;
        this.setDefaultCloseOperation(1);
    }

    public PNewPrintDialog(Frame owner, String messageKey, PrintService[] services, PPrintQueueItem[] printItems, CMBGenericDocViewer viewer) {
        super(owner, PViewerUtilities.getMessage(messageKey), true);
        this.setName("PrintDocuments");
        this.printMultiDocuments = true;
        this.printItems = printItems;
        this.pageFormat = printItems[0].getPageFormat();
        this.customPrintables = new Hashtable();
        this.printerJob = PrinterJob.getPrinterJob();
        this.services = services;
        this.viewer = viewer;
        this.setDefaultCloseOperation(1);
        this.documentCount = printItems.length;
        this.updatePageCount();
        for (int i = 0; i < printItems.length; ++i) {
            printItems[i].getPagePrintable().getPageModel().addDocStateChangedListener(new CMBGenericDocStateChangedListener(){

                public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
                    if (evt.getChangeType() == 2) {
                        PNewPrintDialog.this.updatePageCount();
                    }
                }
            });
        }
    }

    private void updatePageCount() {
        this.pageCount = 0;
        for (int i = 0; i < this.printItems.length; ++i) {
            int p = this.printItems[i].getPagePrintable().getNumberOfPagesToPrint();
            if (p <= 0) continue;
            this.pageCount += p;
        }
        String labelString = PViewerUtilities.getMessage("printAllDialog.pageCount", new String[]{String.valueOf(this.pageCount)});
        this.getPageCountLabel().setText(labelString);
    }

    public void dispose() {
        if (this.printRequestAttrSet != null) {
            this.printRequestAttrSet.clear();
            this.printRequestAttrSet = null;
        }
        if (this.customPrintables != null) {
            this.customPrintables.clear();
            this.customPrintables = null;
        }
        this.printerJob = null;
        this.pageFormat = null;
        this.book = null;
        super.dispose();
    }

    public void buildLayout() {
        this.getContentPane().add("North", this.makePrinterPanel());
        this.getContentPane().add("Center", this.makeCenterPanel());
        this.getContentPane().add("South", this.makeButtonPanel());
        this.applyComponentOrientation(this.getCompOri());
        AbstractAction EscAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PNewPrintDialog.this.dispatchEvent(new WindowEvent(PNewPrintDialog.this, 201));
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        Object o1 = this.getRootPane().getInputMap().get(ks);
        this.getRootPane().getInputMap(2).put(ks, "escape");
        this.getRootPane().getActionMap().put("escape", EscAction);
        this.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent we) {
                if (PNewPrintDialog.this.needToRequestFocus) {
                    PNewPrintDialog.this.getNameField().requestFocus();
                    PNewPrintDialog.this.needToRequestFocus = false;
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                PNewPrintDialog.this.needToRequestFocus = true;
            }
        });
    }

    private JPanel makeTopPanel() {
        if (this.printMultiDocuments) {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)this.makeDocInfoPanel(), "First");
            panel.add((Component)this.makePrinterPanel(), "Center");
            return panel;
        }
        return this.makePrinterPanel();
    }

    private JPanel makeDocInfoPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(3));
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(0, 1, 10, 5));
        p3.add(this.getDocCountLabel());
        p3.add(this.getPageCountLabel());
        p3.setComponentOrientation(this.getCompOri());
        p2.add((Component)p3, "Before");
        panel.add((Component)p2, "Center");
        panel.setComponentOrientation(this.getCompOri());
        return panel;
    }

    private JPanel makePrinterPanel() {
        JComponent c = null;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new TitledBorder(PViewerUtilities.getMessage("printDialog.printer.title")));
        JPanel p6 = new JPanel();
        p6.setLayout(new BorderLayout());
        JPanel p5 = new JPanel();
        p5.setLayout(new BorderLayout());
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(0, 1, 5, 5));
        p1.add(this.getNameLabel());
        p1.add(this.getStatusLabel());
        JPanel p2 = new JPanel();
        p2.setBorder(new EmptyBorder(0, 5, 0, 5));
        p2.setLayout(new GridLayout(0, 1, 5, 5));
        c = this.getNameField();
        p2.add(c);
        c.getAccessibleContext().setAccessibleParent(panel);
        p2.add(this.getStatusResultLabel());
        p5.add((Component)p1, "Before");
        p5.add((Component)p2, "Center");
        if (!this.printMultiDocuments) {
            JPanel p5b = new JPanel(new BorderLayout());
            c = this.getPrintToFileCheckbox();
            p5b.add((Component)c, "After");
            c.getAccessibleContext().setAccessibleParent(panel);
            p5.add((Component)p5b, "South");
        }
        p6.add((Component)p5, "Center");
        panel.add((Component)p6, "North");
        panel.setComponentOrientation(this.getCompOri());
        this.getNameLabel().setLabelFor(this.getNameField());
        this.getStatusLabel().setLabelFor(panel);
        this.getStatusResultLabel().setLabelFor(panel);
        return panel;
    }

    private JPanel makeCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.makeCenterLeftPanel(), "Center");
        panel.add((Component)this.makeCenterRightPanel(), "After");
        return panel;
    }

    private JPanel makeCenterLeftPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        if (this.printMultiDocuments) {
            panel.add((Component)this.makePageCopyPanel(), "North");
            panel.add((Component)this.makeDocInfoPanel(), "Center");
        } else {
            panel.add((Component)this.makePageRangePanel(), "North");
            panel.add((Component)this.makePageCopyPanel(), "Center");
        }
        return panel;
    }

    private JPanel makeCenterRightPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(0, 1, 0, 0));
        p2.add(this.makeOptionPanel());
        JPanel includePanel = this.makeIncludePanel();
        if (includePanel != null) {
            p2.add(includePanel);
        }
        panel.add((Component)p2, "Center");
        return panel;
    }

    private JPanel makeOptionPanel() {
        JCheckBox c = null;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new TitledBorder(PViewerUtilities.getMessage("printDialog.printOptions.title")));
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(3));
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(0, 1, 0, 0));
        c = this.getCenterOnPageCheckbox();
        p3.add(c);
        ((Component)c).getAccessibleContext().setAccessibleParent(panel);
        c = this.getFitToPageCheckbox();
        p3.add(c);
        ((Component)c).getAccessibleContext().setAccessibleParent(panel);
        JPanel p4 = new JPanel();
        p4.setLayout(new FlowLayout(3, 5, 0));
        JLabel spinLabel = this.getZoomLabel();
        p4.add(spinLabel);
        NumericSpinner spinner = this.getZoomSpinner();
        p4.add(spinner);
        spinner.setAccessibility(spinLabel, panel);
        p3.add(p4);
        p3.setComponentOrientation(this.getCompOri());
        p2.add((Component)p3, "Before");
        panel.add((Component)p2, "Center");
        panel.setComponentOrientation(this.getCompOri());
        return panel;
    }

    private JPanel makeIncludePanel() {
        if (this.viewer.getAnnotationServices() == null && this.customPrintables.size() == 0) {
            return null;
        }
        JCheckBox c = null;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new TitledBorder(PViewerUtilities.getMessage("printDialog.include.title")));
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(3));
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(0, 1, 0, 0));
        if (this.viewer.getAnnotationServices() != null) {
            c = this.getAnnotationsCheckbox();
            p3.add(c);
            ((Component)c).getAccessibleContext().setAccessibleParent(panel);
        }
        Enumeration en = this.customPrintables.elements();
        while (en.hasMoreElements()) {
            CMBCustomPageablePrintable customCheckbox = (CMBCustomPageablePrintable)en.nextElement();
            p3.add(customCheckbox);
            customCheckbox.getAccessibleContext().setAccessibleParent(panel);
        }
        p3.setComponentOrientation(this.getCompOri());
        p2.add((Component)p3, "Before");
        panel.add((Component)p2, "Center");
        panel.setComponentOrientation(this.getCompOri());
        return panel;
    }

    private JPanel makePageRangePanel() {
        JTextField c = null;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new TitledBorder(PViewerUtilities.getMessage("printDialog.printRange.title")));
        ButtonGroup bg = this.getBg();
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(0, 1, 5, 0));
        p3.getAccessibleContext().setAccessibleName(PViewerUtilities.getMessage("printDialog.printRange.title"));
        Enumeration<AbstractButton> enumRadioButtons = bg.getElements();
        while (enumRadioButtons.hasMoreElements()) {
            JRadioButton rb = (JRadioButton)enumRadioButtons.nextElement();
            p3.add(rb);
        }
        JPanel p4 = new JPanel();
        p4.setLayout(new GridLayout(0, 1, 5, 0));
        p4.add(new JLabel());
        p4.add(new JLabel());
        c = this.getSelPagesText();
        p4.add(c);
        ((Component)c).getAccessibleContext().setAccessibleDescription(PViewerUtilities.getMessage("printDialog.printRange.pages.info"));
        p2.add((Component)p3, "Before");
        p2.add((Component)p4, "Center");
        p1.add((Component)p2, "North");
        JPanel p7 = new JPanel();
        p7.setLayout(new BorderLayout());
        p7.setBorder(new EmptyBorder(5, 5, 5, 5));
        p7.add((Component)this.getSelPagesInfoAsLabel(), "Center");
        this.getSelPagesInfoAsLabel().setLabelFor(p7);
        p1.add((Component)p7, "Center");
        panel.add((Component)p1, "Center");
        panel.setComponentOrientation(this.getCompOri());
        return panel;
    }

    private JPanel makePageCopyPanel() {
        JCheckBox c = null;
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(3));
        panel.setBorder(new TitledBorder(PViewerUtilities.getMessage("printDialog.copies.title")));
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(0, 1, 0, 0));
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 0, 5, 5));
        JLabel spinLabel = this.getCopyLabel();
        p2.add(spinLabel);
        NumericSpinner spinner = this.getCopySpinner();
        p2.add(spinner);
        spinner.setAccessibility(spinLabel, panel);
        p1.add(p2);
        c = this.getCollateCheckbox();
        p1.add(c);
        ((Component)c).getAccessibleContext().setAccessibleParent(panel);
        panel.add((Component)p1, "Before");
        panel.setComponentOrientation(this.getCompOri());
        return panel;
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(4));
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 0, 5, 5));
        p2.add(this.getPrintButton());
        p2.add(this.getCancelButton());
        p2.add(this.getSetupButton());
        if (!this.docHelpListeners.isEmpty()) {
            p2.add(this.getHelpButton());
        }
        p2.setComponentOrientation(this.getCompOri());
        panel.add((Component)p2, "After");
        panel.setComponentOrientation(this.getCompOri());
        return panel;
    }

    public JLabel getNameLabel() {
        if (this.nameLabel == null) {
            this.nameLabel = new JLabel(PViewerUtilities.getMessage("printDialog.printer.name"));
            this.nameLabel.setDisplayedMnemonic(PViewerUtilities.getMessage("printDialog.printer.name.mnemonic").charAt(0));
        }
        return this.nameLabel;
    }

    public JComboBox getNameField() {
        if (this.nameField == null) {
            PrintServicesComboBoxModel m = new PrintServicesComboBoxModel(this.services);
            this.nameField = new JComboBox(m);
            this.nameField.setSelectedIndex(-1);
            this.nameField.setRenderer(new PrintServicesComboBoxRenderer());
            this.nameField.setEnabled(true);
            this.nameField.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        PrintService printService = (PrintService)e.getItem();
                        PNewPrintDialog.this.updateAttributesFromPrintService(printService);
                        try {
                            if (PNewPrintDialog.this.printItem != null) {
                                PNewPrintDialog.this.printItem.setPrintService(printService);
                            } else if (PNewPrintDialog.this.printItems != null) {
                                for (int i = 0; i < PNewPrintDialog.this.printItems.length; ++i) {
                                    PNewPrintDialog.this.printItems[i].setPrintService(printService);
                                }
                            }
                        }
                        catch (PrinterException e1) {
                            System.err.println(PViewerUtilities.getMessage("DocumentViewer.printError") + e1);
                        }
                        PrinterIsAcceptingJobs attr = printService.getAttribute(PrinterIsAcceptingJobs.class);
                        if (attr.equals(PrinterIsAcceptingJobs.ACCEPTING_JOBS)) {
                            PNewPrintDialog.this.getStatusResultLabel().setText(PViewerUtilities.getMessage("printDialog.status.acceptingJobs"));
                            PNewPrintDialog.this.nameField.getAccessibleContext().setAccessibleDescription(PViewerUtilities.getMessage("printDialog.status.acceptingJobs"));
                        } else {
                            PNewPrintDialog.this.getStatusResultLabel().setText(PViewerUtilities.getMessage("printDialog.status.notAcceptingJobs"));
                            PNewPrintDialog.this.nameField.getAccessibleContext().setAccessibleDescription(PViewerUtilities.getMessage("printDialog.status.notAcceptingJobs"));
                        }
                    }
                }
            });
            PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
            this.nameField.getModel().setSelectedItem(defaultPrintService);
            if (this.nameField.getModel().getSelectedItem() == null) {
                this.nameField.setSelectedIndex(0);
            }
            this.initializePrintSettings();
        }
        return this.nameField;
    }

    public JButton getPropertiesButton() {
        if (this.propertiesButton == null) {
            this.propertiesButton = new JButton(PViewerUtilities.getMessage("printDialog.printer.properties"));
            this.propertiesButton.setMnemonic(PViewerUtilities.getMessage("printDialog.printer.properties.mnemonic").charAt(0));
            this.propertiesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String methodName = "getPropertiesButton().actionPerformed";
                    String printerName = ((PrintService)PNewPrintDialog.this.nameField.getModel().getSelectedItem()).getName();
                    String cmd = "RUNDLL32 PRINTUI.DLL,PrintUIEntry /e /n \"" + printerName + "\"";
                    try {
                        Runtime.getRuntime().exec(cmd);
                    }
                    catch (Exception exc) {
                        ViewerLogger.logError((Object)this, methodName, exc);
                    }
                }
            });
        }
        return this.propertiesButton;
    }

    public JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel(PViewerUtilities.getMessage("printDialog.printer.status"));
        }
        return this.statusLabel;
    }

    public JLabel getStatusResultLabel() {
        if (this.statusResultLabel == null) {
            this.statusResultLabel = new JLabel();
        }
        return this.statusResultLabel;
    }

    public JLabel getCopyLabel() {
        if (this.copyLabel == null) {
            this.copyLabel = new JLabel(PViewerUtilities.getMessage("printDialog.numberOfCopies"));
            this.copyLabel.setDisplayedMnemonic(PViewerUtilities.getMessage("printDialog.numberOfCopies.mnemonic").charAt(0));
        }
        return this.copyLabel;
    }

    public JCheckBox getCollateCheckbox() {
        if (this.collateCheckbox == null) {
            this.collateCheckbox = new JCheckBox(PViewerUtilities.getMessage("printDialog.collate"));
            this.collateCheckbox.setMnemonic(PViewerUtilities.getMessage("printDialog.collate.mnemonic").charAt(0));
            this.collateCheckbox.setSelected(false);
        }
        return this.collateCheckbox;
    }

    public JLabel getZoomLabel() {
        if (this.zoomLabel == null) {
            this.zoomLabel = new JLabel(PViewerUtilities.getMessage("printDialog.printOptions.zoom"));
            this.zoomLabel.setDisplayedMnemonic(PViewerUtilities.getMessage("printDialog.printOptions.zoom.mnemonic").charAt(0));
            if (this.getFitToPageCheckbox().isSelected()) {
                this.zoomLabel.setEnabled(false);
            } else {
                this.zoomLabel.setEnabled(true);
            }
        }
        return this.zoomLabel;
    }

    public JLabel getDocCountLabel() {
        if (this.docCountLabel == null) {
            String labelString = PViewerUtilities.getMessage("printAllDialog.docCount", new String[]{String.valueOf(this.documentCount)});
            this.docCountLabel = new JLabel(labelString);
        }
        return this.docCountLabel;
    }

    public JLabel getPageCountLabel() {
        if (this.pageCountLabel == null) {
            String labelString = PViewerUtilities.getMessage("printAllDialog.pageCount", new String[]{String.valueOf(this.pageCount)});
            this.pageCountLabel = new JLabel(labelString);
        }
        return this.pageCountLabel;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(PViewerUtilities.getMessage("printDialog.button.Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PNewPrintDialog.this.setVisible(false);
                    PNewPrintDialog.this.dispatchEvent(new WindowEvent(PNewPrintDialog.this, 201));
                }
            });
        }
        return this.cancelButton;
    }

    public JButton getSetupButton() {
        if (this.setupButton == null) {
            this.setupButton = new JButton(PViewerUtilities.getMessage("printDialog.button.PageSetup"));
            this.setupButton.setMnemonic(PViewerUtilities.getMessage("printDialog.button.PageSetup.mnemonic").charAt(0));
            this.setupButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageFormat retPageFormat;
                    if (PNewPrintDialog.this.pageFormat == null) {
                        PNewPrintDialog.this.pageFormat = PNewPrintDialog.this.printerJob.defaultPage();
                    }
                    if ((retPageFormat = PNewPrintDialog.this.printerJob.pageDialog(PNewPrintDialog.this.getPrintRequestAttrSet())) != null) {
                        PNewPrintDialog.this.pageFormat = retPageFormat;
                    }
                }
            });
        }
        return this.setupButton;
    }

    public JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton(PViewerUtilities.getMessage("printDialog.button.Help"));
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PNewPrintDialog.this.fireCMBDocHelpEvent();
                }
            });
        }
        return this.helpButton;
    }

    public JButton getPrintButton() {
        if (this.printButton == null) {
            this.printButton = new JButton(PViewerUtilities.getMessage("printDialog.button.OK"));
            this.getRootPane().setDefaultButton(this.printButton);
            this.printButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PNewPrintDialog.this.printMultiDocuments) {
                        PNewPrintDialog.this.printMultiAction();
                    } else {
                        PNewPrintDialog.this.printAction();
                    }
                }
            });
        }
        return this.printButton;
    }

    void printAction() {
        this.printButtonSelected = true;
        if (this.pageFormat != null) {
            this.printItem.setPageFormat(this.pageFormat);
        }
        this.customStartPagePos = 0;
        this.customEndPagePos = 0;
        for (int i = 0; i < this.printItem.getPagePrintable().getNumberOfPages(); ++i) {
            this.book.append(this.printItem.getPagePrintable().getPrintable(i), this.printItem.getPagePrintable().getPageFormat(i));
        }
        Enumeration en = this.customPrintables.elements();
        while (en.hasMoreElements()) {
            CMBCustomPageablePrintable customPageablePrintable = (CMBCustomPageablePrintable)en.nextElement();
            if (!customPageablePrintable.isSelected()) continue;
            if (customPageablePrintable.isWatermark()) {
                this.printItem.getPagePrintable().addWatermarkPrintable(customPageablePrintable);
                continue;
            }
            this.customStartPagePos = this.printItem.getPagePrintable().getNumberOfPages() + 1;
            customPageablePrintable.setBookStartIndex(this.book.getNumberOfPages());
            for (int i = 0; i < customPageablePrintable.getNumberOfPages(); ++i) {
                PageFormat pf = customPageablePrintable.getPageFormat(i);
                this.book.append(customPageablePrintable, pf);
                this.customEndPagePos = this.book.getNumberOfPages();
            }
        }
        this.printerJob.setPageable(this.book);
        try {
            this.printItem.setPrintService(this.getSelectedPrintService());
        }
        catch (PrinterException e1) {
            System.err.println(PViewerUtilities.getMessage("DocumentViewer.printError") + e1);
            return;
        }
        try {
            this.finalizePrintSettings();
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(null, PViewerUtilities.getMessage("printDialog.printRange.pages.errorMessage"), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
            return;
        }
        if (this.getPrintToFileCheckbox().isSelected()) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
            chooser.setFileSelectionMode(0);
            PrintFileFilter fileFilter = new PrintFileFilter();
            chooser.addChoosableFileFilter(fileFilter);
            chooser.setFileFilter(fileFilter);
            chooser.setComponentOrientation(this.getCompOri());
            int ret = chooser.showSaveDialog(this);
            if (ret == 0) {
                int option;
                File printFile;
                String filename = chooser.getSelectedFile().getAbsolutePath();
                if (chooser.getFileFilter() instanceof PrintFileFilter && !filename.endsWith(printFileSuffix)) {
                    filename = filename + "." + printFileSuffix;
                }
                if ((printFile = new File(filename)).exists() && (option = JOptionPane.showConfirmDialog(this, PViewerUtilities.getMessage("printDialog.overwriteWarning.message"), PViewerUtilities.getMessage("printDialog.overwriteWarning.title"), 0)) == 1) {
                    return;
                }
                URI printURI = printFile.toURI();
                this.printRequestAttrSet.add(new Destination(printURI));
            } else {
                this.printButtonSelected = false;
                return;
            }
        }
        this.printItem.getPagePrintable().setPrintAnno(this.isIncludeAnnotations());
        this.printItem.getPagePrintable().setCenterOnPage(this.isCenterOnPage());
        this.printItem.getPagePrintable().setAset(new HashPrintRequestAttributeSet(this.printRequestAttrSet));
        if (this.isFitToPage()) {
            this.printItem.getPagePrintable().setPrintScaleString(this.viewer.getConfigPropertyOrMessage("zoom.item.FitPage"));
        } else {
            Integer value = this.getZoomValue();
            this.printItem.getPagePrintable().setPrintScaleString(value.toString());
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    void printMultiAction() {
        int i;
        this.printButtonSelected = true;
        try {
            for (i = 0; i < this.printItems.length; ++i) {
                this.printItems[i].setPrintService(this.getSelectedPrintService());
            }
        }
        catch (PrinterException e1) {
            System.err.println(PViewerUtilities.getMessage("DocumentViewer.printError") + e1);
            return;
        }
        this.finalizePrintSettings();
        for (i = 0; i < this.printItems.length; ++i) {
            if (this.pageFormat != null) {
                this.printItems[i].setPageFormat(this.pageFormat);
            }
            this.printItems[i].getPagePrintable().setPrintAnno(this.isIncludeAnnotations());
            this.printItems[i].getPagePrintable().setCenterOnPage(this.isCenterOnPage());
            this.printItems[i].getPagePrintable().setAset(new HashPrintRequestAttributeSet(this.printRequestAttrSet));
            if (this.isFitToPage()) {
                this.printItems[i].getPagePrintable().setPrintScaleString(this.viewer.getConfigPropertyOrMessage("zoom.item.FitPage"));
                continue;
            }
            Integer value = this.getZoomValue();
            this.printItems[i].getPagePrintable().setPrintScaleString(value.toString());
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void initializePrintSettings() {
        Object o;
        PrintService printService = (PrintService)this.nameField.getModel().getSelectedItem();
        try {
            o = printService.getDefaultAttributeValue(Copies.class);
            if (o != null) {
                int value = ((IntegerSyntax)o).getValue();
                this.getCopySpinner().setValue(new Integer(value));
            } else {
                this.getCopySpinner().setValue(new Integer(1));
            }
        }
        catch (IllegalArgumentException e) {
            this.getCopySpinner().setValue(new Integer(1));
        }
        try {
            o = printService.getDefaultAttributeValue(SheetCollate.class);
            if (o != null) {
                if (o.equals(SheetCollate.COLLATED)) {
                    this.getCollateCheckbox().setSelected(true);
                } else {
                    this.getCollateCheckbox().setSelected(false);
                }
            } else {
                this.getCollateCheckbox().setSelected(true);
            }
        }
        catch (IllegalArgumentException e) {
            this.getCollateCheckbox().setSelected(true);
        }
        this.updateAttributesFromPrintService(printService);
        this.printRequestAttrSet.add(new MediaPrintableArea((float)(this.pageFormat.getPaper().getImageableX() / 72.0), (float)(this.pageFormat.getPaper().getImageableY() / 72.0), (float)(this.pageFormat.getPaper().getImageableWidth() / 72.0), (float)(this.pageFormat.getPaper().getImageableHeight() / 72.0), 25400));
    }

    private void updateAttributesFromPrintService(PrintService printService) {
        Object o;
        try {
            o = printService.getDefaultAttributeValue(OrientationRequested.class);
            if (o != null) {
                if (o.equals(OrientationRequested.REVERSE_LANDSCAPE)) {
                    this.pageFormat.setOrientation(2);
                    this.printRequestAttrSet.add(OrientationRequested.REVERSE_LANDSCAPE);
                } else if (o.equals(OrientationRequested.PORTRAIT)) {
                    this.pageFormat.setOrientation(1);
                    this.printRequestAttrSet.add(OrientationRequested.PORTRAIT);
                } else {
                    this.pageFormat.setOrientation(0);
                    this.printRequestAttrSet.add(OrientationRequested.LANDSCAPE);
                }
            } else {
                this.pageFormat.setOrientation(1);
            }
        }
        catch (IllegalArgumentException e) {
            this.pageFormat.setOrientation(1);
        }
        o = (Attribute)printService.getDefaultAttributeValue(Media.class);
        if (o != null) {
            this.printRequestAttrSet.add((Attribute)o);
        }
    }

    private void finalizePrintSettings() throws IllegalArgumentException {
        if (!this.printMultiDocuments) {
            PageRanges pageRanges = null;
            switch (this.pageRangeScope) {
                case 1: {
                    this.selectedPageRanges = new StringBuffer(this.getSelPagesText().getText());
                    pageRanges = new PageRanges(this.selectedPageRanges.toString());
                    int next = pageRanges.next(this.printItem.getPagePrintable().getPageModel().getNumberOfPages());
                    if (next == -1 || this.printItem.getPagePrintable().getPageModel().isValidPagePosition(next)) break;
                    throw new IllegalArgumentException(PViewerUtilities.getMessage("printDialog.printRange.pages.errorMessage"));
                }
                case 0: {
                    this.selectedPageRanges = new StringBuffer("1-" + this.printItem.getPagePrintable().getPageModel().getNumberOfPages());
                    break;
                }
                default: {
                    this.selectedPageRanges = new StringBuffer(new Integer(this.printItem.getPagePrintable().getPageModel().getCurrentPagePosition()).toString());
                }
            }
            if (this.customEndPagePos > 0) {
                if (this.selectedPageRanges == null || this.selectedPageRanges.length() == 0) {
                    this.selectedPageRanges = new StringBuffer(this.customStartPagePos + "-" + this.customEndPagePos);
                } else {
                    this.selectedPageRanges.append("," + this.customStartPagePos + "-" + this.customEndPagePos);
                }
            }
            pageRanges = new PageRanges(this.selectedPageRanges.toString());
            int[][] myMembers = pageRanges.getMembers();
            int n = myMembers.length;
            int totalCount = 0;
            for (int i = 0; i < n; ++i) {
                totalCount += myMembers[i][1] - myMembers[i][0] + 1;
            }
            this.printItem.getPagePrintable().pageRangeCount = totalCount;
            this.printRequestAttrSet.add(pageRanges);
        }
        int copyValue = (Integer)this.getCopySpinner().getValue();
        this.printRequestAttrSet.add(new Copies(copyValue));
        if (this.getCollateCheckbox().isSelected()) {
            this.printRequestAttrSet.add(SheetCollate.COLLATED);
        } else {
            this.printRequestAttrSet.add(SheetCollate.UNCOLLATED);
        }
        this.printRequestAttrSet.add(new MediaPrintableArea((float)(this.pageFormat.getPaper().getImageableX() / 72.0), (float)(this.pageFormat.getPaper().getImageableY() / 72.0), (float)(this.pageFormat.getPaper().getImageableWidth() / 72.0), (float)(this.pageFormat.getPaper().getImageableHeight() / 72.0), 25400));
    }

    public JCheckBox getPrintToFileCheckbox() {
        if (this.printToFileCheckbox == null) {
            this.printToFileCheckbox = new JCheckBox(PViewerUtilities.getMessage("printDialog.printToFile"));
            this.printToFileCheckbox.setMnemonic(PViewerUtilities.getMessage("printDialog.printToFile.mnemonic").charAt(0));
            this.printToFileCheckbox.setSelected(false);
            this.printToFileCheckbox.setEnabled(true);
        }
        return this.printToFileCheckbox;
    }

    public JCheckBox getCenterOnPageCheckbox() {
        if (this.centerOnPageCheckbox == null) {
            this.centerOnPageCheckbox = new JCheckBox(PViewerUtilities.getMessage("printDialog.printOptions.center"));
            this.centerOnPageCheckbox.setMnemonic(PViewerUtilities.getMessage("printDialog.printOptions.center.mnemonic").charAt(0));
            boolean b = (Boolean)this.viewer.getClientProperty("Printing.centerOnPage");
            this.centerOnPageCheckbox.setSelected(b);
            this.centerOnPageCheckbox.setEnabled(true);
        }
        return this.centerOnPageCheckbox;
    }

    public JCheckBox getFitToPageCheckbox() {
        if (this.fitToPageCheckbox == null) {
            this.fitToPageCheckbox = new JCheckBox(PViewerUtilities.getMessage("printDialog.printOptions.fitToPage"));
            this.fitToPageCheckbox.setMnemonic(PViewerUtilities.getMessage("printDialog.printOptions.fitToPage.mnemonic").charAt(0));
            this.fitToPageCheckbox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (PNewPrintDialog.this.getFitToPageCheckbox().isSelected()) {
                        PNewPrintDialog.this.getZoomLabel().setEnabled(false);
                        PNewPrintDialog.this.getZoomSpinner().setEnabled(false);
                    } else {
                        PNewPrintDialog.this.getZoomLabel().setEnabled(true);
                        PNewPrintDialog.this.getZoomSpinner().setEnabled(true);
                    }
                }
            });
            boolean b = (Boolean)this.viewer.getClientProperty("Printing.fitToPage");
            this.fitToPageCheckbox.setSelected(b);
        }
        return this.fitToPageCheckbox;
    }

    public JCheckBox getAnnotationsCheckbox() {
        if (this.annotationsCheckbox == null) {
            this.annotationsCheckbox = new JCheckBox(PViewerUtilities.getMessage("printDialog.include.annotations"));
            this.annotationsCheckbox.setMnemonic(PViewerUtilities.getMessage("printDialog.included.annotations.mnemonic").charAt(0));
            boolean b = (Boolean)this.viewer.getClientProperty("Printing.annotations.include");
            this.annotationsCheckbox.setSelected(b);
        }
        if (this.printMultiDocuments) {
            boolean hasAnnotations = false;
            for (int i = 0; i < this.printItems.length; ++i) {
                if (this.printItems[i].getPagePrintable() == null || !this.printItems[i].getPagePrintable().hasAnnotations()) continue;
                hasAnnotations = true;
            }
            if (!hasAnnotations) {
                this.annotationsCheckbox.setSelected(false);
                this.annotationsCheckbox.setEnabled(false);
            }
        } else if (this.printItem.getPagePrintable() != null && !this.printItem.getPagePrintable().hasAnnotations()) {
            this.annotationsCheckbox.setSelected(false);
            this.annotationsCheckbox.setEnabled(false);
        }
        return this.annotationsCheckbox;
    }

    public NumericSpinner getZoomSpinner() {
        if (this.zoomSpinner == null) {
            int i = (Integer)this.viewer.getClientProperty("Printing.zoom");
            SpinnerNumberModel model = new SpinnerNumberModel(i, 25, 500, 1);
            this.zoomSpinner = new NumericSpinner(model);
            if (this.getFitToPageCheckbox().isSelected()) {
                this.zoomSpinner.setEnabled(false);
            } else {
                this.zoomSpinner.setEnabled(true);
            }
        }
        return this.zoomSpinner;
    }

    public NumericSpinner getCopySpinner() {
        if (this.copySpinner == null) {
            SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 999, 1);
            this.copySpinner = new NumericSpinner(model);
            this.copySpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    int copyValue = (Integer)PNewPrintDialog.this.getCopySpinner().getValue();
                    if (copyValue > 1) {
                        PNewPrintDialog.this.getCollateCheckbox().setEnabled(true);
                    } else {
                        PNewPrintDialog.this.getCollateCheckbox().setEnabled(false);
                    }
                }
            });
        }
        return this.copySpinner;
    }

    public JTextField getSelPagesText() {
        if (this.selPagesText == null) {
            this.selPagesText = new JTextField();
        }
        return this.selPagesText;
    }

    public JLabel getSelPagesInfoAsLabel() {
        if (this.selPagesInfoAsLabel == null) {
            this.selPagesInfoAsLabel = new JLabel("<html>" + PViewerUtilities.getMessage("printDialog.printRange.pages.info") + "</html>"){

                public Dimension getPreferredSize() {
                    return new Dimension(150, 50);
                }
            };
            this.selPagesInfoAsLabel.setVerticalAlignment(0);
            this.selPagesInfoAsLabel.setHorizontalAlignment(10);
        }
        return this.selPagesInfoAsLabel;
    }

    public ButtonGroup getBg() {
        if (this.bg == null) {
            this.bg = new ButtonGroup();
            this.bg.add(this.getCurrPageRB());
            this.bg.add(this.getAllPagesRB());
            this.bg.add(this.getSelPagesRB());
        }
        return this.bg;
    }

    public JRadioButton getCurrPageRB() {
        if (this.currPageRB == null) {
            this.currPageRB = new JRadioButton(PViewerUtilities.getMessage("printDialog.printRange.currentPage"));
            this.currPageRB.setMnemonic(PViewerUtilities.getMessage("printDialog.printRange.currentPage.mnemonic").charAt(0));
            this.currPageRB.addItemListener(this);
        }
        return this.currPageRB;
    }

    public JRadioButton getAllPagesRB() {
        if (this.allPagesRB == null) {
            this.allPagesRB = new JRadioButton(PViewerUtilities.getMessage("printDialog.printRange.allPages"));
            this.allPagesRB.setMnemonic(PViewerUtilities.getMessage("printDialog.printRange.allPages.mnemonic").charAt(0));
            this.allPagesRB.addItemListener(this);
            this.allPagesRB.setSelected(true);
        }
        return this.allPagesRB;
    }

    public JRadioButton getSelPagesRB() {
        if (this.selPagesRB == null) {
            this.selPagesRB = new JRadioButton(PViewerUtilities.getMessage("printDialog.printRange.pages"));
            this.selPagesRB.setMnemonic(PViewerUtilities.getMessage("printDialog.printRange.pages.mnemonic").charAt(0));
            if (this.printItem.getPagePrintable().getPageModel().getNumberOfPages() <= 1) {
                this.selPagesRB.setEnabled(false);
            }
            this.selPagesRB.addItemListener(this);
        }
        return this.selPagesRB;
    }

    public ComponentOrientation getCompOri() {
        if (this.compOri == null) {
            boolean ltr = PViewerUtilities.isLeftToRight();
            this.compOri = ComponentOrientation.LEFT_TO_RIGHT;
            if (!ltr) {
                this.compOri = ComponentOrientation.RIGHT_TO_LEFT;
            }
        }
        return this.compOri;
    }

    public void addDocHelpListener(CMBGenericDocHelpListener listener) {
        this.docHelpListeners.addElement(listener);
    }

    public void removeDocHelpListener(CMBGenericDocHelpListener listener) {
        this.docHelpListeners.removeElement(listener);
    }

    public void fireCMBDocHelpEvent() {
        CMBGenericDocHelpEvent docHelpEvent = new CMBGenericDocHelpEvent(this);
        for (int i = 0; i < this.docHelpListeners.size(); ++i) {
            CMBGenericDocHelpListener listener = (CMBGenericDocHelpListener)this.docHelpListeners.elementAt(i);
            listener.onHelp(docHelpEvent);
        }
    }

    void dumpAttributes(PrintService printService) {
        System.out.println("printService.getName: " + printService.getName());
        Object o = printService.getDefaultAttributeValue(PrinterInfo.class);
        System.out.println("o printerinfo: " + o);
        Attribute[] attrs = printService.getAttributes().toArray();
        for (int i = 0; i < attrs.length; ++i) {
            System.out.println("***i: " + i + " Category: " + attrs[i].getCategory());
            System.out.println("\tattr: " + attrs[i]);
            System.out.println("\tname: " + attrs[i].getName());
            System.out.println("\tvalue: " + attrs[i].toString());
        }
        Class<?>[] classes = printService.getSupportedAttributeCategories();
        System.out.println("Supported Atrribute Categories");
        for (int i = 0; i < classes.length; ++i) {
            System.out.println("***i: " + i + " Category: " + classes[i].getName());
            System.out.println("\tdefaultvalue: " + printService.getDefaultAttributeValue(classes[i]));
        }
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.getAllPagesRB().isSelected()) {
            this.pageRangeScope = 0;
            this.getSelPagesText().setEnabled(false);
        }
        if (this.getSelPagesRB().isSelected()) {
            this.pageRangeScope = 1;
            this.getSelPagesText().setEnabled(true);
            this.getSelPagesText().requestFocus();
        }
        if (this.getCurrPageRB().isSelected()) {
            this.pageRangeScope = 2;
            this.getSelPagesText().setEnabled(false);
        }
    }

    boolean isCenterOnPage() {
        return this.getCenterOnPageCheckbox().isSelected();
    }

    boolean isFitToPage() {
        return this.getFitToPageCheckbox().isSelected();
    }

    boolean isIncludeAnnotations() {
        return this.getAnnotationsCheckbox().isSelected();
    }

    PrintService getSelectedPrintService() {
        return (PrintService)this.getNameField().getModel().getSelectedItem();
    }

    Integer getZoomValue() {
        return (Integer)this.getZoomSpinner().getValue();
    }

    public PrintRequestAttributeSet getPrintRequestAttrSet() {
        return this.printRequestAttrSet;
    }

    class PrintFileFilter
    extends FileFilter {
        PrintFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String suffix = this.getSuffix(f);
            return suffix != null && suffix.equals(printFileSuffix);
        }

        public String getSuffix(File f) {
            String suffix = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                suffix = s.substring(i + 1).toLowerCase();
            }
            return suffix;
        }

        public String getDescription() {
            return PViewerUtilities.getMessage("printDialog.printFileFilter.description");
        }
    }

    public class NumericSpinner
    extends JSpinner
    implements Accessible {
        public NumericSpinner(SpinnerModel model) {
            super(model);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJSpinner();
            }
            return this.accessibleContext;
        }

        public void setAccessibility(JLabel label, JPanel panel) {
            JSpinner.NumberEditor ne = (JSpinner.NumberEditor)this.getEditor();
            ne.getTextField().getAccessibleContext().setAccessibleParent(panel);
            this.getAccessibleContext().setAccessibleParent(panel);
            label.setLabelFor(ne.getTextField());
        }

        protected class AccessibleJSpinner
        extends JComponent.AccessibleJComponent
        implements AccessibleValue,
        ChangeListener {
            private Object oldModelValue;

            protected AccessibleJSpinner() {
                super(NumericSpinner.this);
                this.oldModelValue = null;
                this.oldModelValue = NumericSpinner.this.getModel().getValue();
                NumericSpinner.this.addChangeListener(this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.SPIN_BOX;
            }

            public void setAccessibleName(String s) {
                super.setAccessibleName(s);
            }

            public AccessibleValue getAccessibleValue() {
                return this;
            }

            public Number getCurrentAccessibleValue() {
                return this.getCurrentAccessibleValue();
            }

            public boolean setCurrentAccessibleValue(Number n) {
                if (n instanceof Integer) {
                    ((SpinnerNumberModel)NumericSpinner.this.getModel()).setValue(n);
                    return true;
                }
                return false;
            }

            public Number getMinimumAccessibleValue() {
                Comparable<?> c = ((SpinnerNumberModel)NumericSpinner.this.getModel()).getMinimum();
                return (Number)((Object)c);
            }

            public Number getMaximumAccessibleValue() {
                Comparable<?> c = ((SpinnerNumberModel)NumericSpinner.this.getModel()).getMaximum();
                return (Number)((Object)c);
            }

            public void stateChanged(ChangeEvent e) {
                if (e == null) {
                    throw new NullPointerException();
                }
                Object newModelValue = NumericSpinner.this.getModel().getValue();
                this.firePropertyChange("AccessibleValue", this.oldModelValue, newModelValue);
                this.oldModelValue = newModelValue;
            }
        }
    }

    class PrintServicesComboBoxModel
    extends DefaultComboBoxModel {
        public PrintServicesComboBoxModel(Object[] items) {
            super(items);
        }

        public void setSelectedItem(PrintService anObject) {
            boolean ignoreCase = PViewerUtilities.getBooleanProperty("printDialog.printServiceName.ignoreCase", PNewPrintDialog.this.viewer.getConfigProperties(), false);
            if (ignoreCase && anObject != null) {
                for (int i = 0; i < this.getSize(); ++i) {
                    PrintService ps = (PrintService)this.getElementAt(i);
                    if (!ps.getName().equalsIgnoreCase(anObject.getName())) continue;
                    anObject = ps;
                }
            }
            super.setSelectedItem(anObject);
        }

        public void setSelectedItem(Object anObject) {
            this.setSelectedItem((PrintService)anObject);
        }
    }

    class PrintServicesComboBoxRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer {
        PrintServicesComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                PrintService service = (PrintService)value;
                this.setText(service.getName());
            }
            this.setComponentOrientation(PNewPrintDialog.this.getCompOri());
            return this;
        }
    }
}

