/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBBookmark;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

final class PManageBookmarksDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private CMBGenericDocViewer gdv;
    private ArrayList editedBookmarks;
    private JLabel instructions;
    private JButton deleteButton;
    private BookmarksTableModel bookmarksTableModel;
    private JTable bookmarksTable;
    private JButton okButton;
    private JButton cancelButton;
    private JButton deleteAllButton;
    private boolean bookmarksEdited;

    public PManageBookmarksDialog(Frame owner, CMBGenericDocViewer gdv) throws HeadlessException {
        super(owner, PViewerUtilities.getMessage("manageBookmarksDialog.title"), true);
        this.gdv = gdv;
        this.initialize();
        this.setSize(500, 300);
        this.setLocationRelativeTo(gdv);
    }

    private void initialize() {
        CMBBookmark[] bookmarks = this.gdv.getBookmarks();
        this.editedBookmarks = new ArrayList();
        for (int i = 0; i < bookmarks.length; ++i) {
            this.editedBookmarks.add(bookmarks[i].clone());
        }
        this.instructions = new JLabel("<html>" + PViewerUtilities.getMessage("manageBookmarksDialog.instructions") + "</html>");
        this.deleteButton = new JButton(this.gdv.getImageIcon("DeleteBookmark_normal.gif"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.setToolTipText(PViewerUtilities.getMessage("manageBookmarksDialog.deleteTooltip"));
        this.bookmarksTableModel = new BookmarksTableModel();
        this.bookmarksTable = new JTable(this.bookmarksTableModel);
        JTextField editorTextField = new JTextField(){

            public void setText(String text) {
                super.setText(text);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        this.selectAll();
                    }
                });
            }
        };
        editorTextField.setBorder(null);
        DefaultCellEditor editor = new DefaultCellEditor(editorTextField);
        this.bookmarksTable.setDefaultEditor(String.class, editor);
        this.okButton = new JButton(PViewerUtilities.getMessage("DocumentViewer.ok"));
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(PViewerUtilities.getMessage("DocumentViewer.cancel"));
        this.deleteAllButton = new JButton(PViewerUtilities.getMessage("manageBookmarksDialog.deleteAll"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel upperButtonPanel = new JPanel(new FlowLayout(3));
        JToolBar upperToolBar = new JToolBar();
        upperToolBar.setFloatable(false);
        upperToolBar.add(this.deleteButton);
        upperButtonPanel.add(upperToolBar);
        JPanel upperPanel = new JPanel(new BorderLayout());
        this.instructions.setBorder(new EmptyBorder(5, 5, 0, 5));
        upperPanel.add((Component)this.instructions, "North");
        upperPanel.add((Component)upperButtonPanel, "Center");
        contentPane.add((Component)upperPanel, "North");
        JScrollPane tableScrollPane = new JScrollPane(this.bookmarksTable);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)tableScrollPane, "Center");
        centerPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        contentPane.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.deleteAllButton);
        contentPane.add((Component)buttonPanel, "South");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PManageBookmarksDialog.this.deleteSelectedBookmarks();
            }
        });
        this.bookmarksTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                PManageBookmarksDialog.this.updateEnablement();
            }
        });
        this.bookmarksTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PManageBookmarksDialog.this.updateEnablement();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PManageBookmarksDialog.this.updateBookmarks();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PManageBookmarksDialog.this.dispose();
            }
        });
        this.deleteAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PManageBookmarksDialog.this.deleteAllBookmarks();
            }
        });
        AbstractAction EscAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PManageBookmarksDialog.this.dispose();
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        Object o1 = this.getRootPane().getInputMap().get(ks);
        this.getRootPane().getInputMap(2).put(ks, "escape");
        this.getRootPane().getActionMap().put("escape", EscAction);
        this.getRootPane().setDefaultButton(this.okButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent we) {
                PManageBookmarksDialog.this.requestFocus();
            }
        });
    }

    private void updateEnablement() {
        this.deleteButton.setEnabled(this.bookmarksTable.getSelectedRowCount() > 0);
        this.okButton.setEnabled(this.bookmarksEdited);
        this.deleteAllButton.setEnabled(this.editedBookmarks.size() > 0);
    }

    private void deleteSelectedBookmarks() {
        int[] selectedRows = this.bookmarksTable.getSelectedRows();
        int rowsDeleted = 0;
        for (int i = 0; i < selectedRows.length; ++i) {
            this.editedBookmarks.remove(selectedRows[i] - rowsDeleted);
            ++rowsDeleted;
        }
        this.bookmarksEdited = true;
        this.bookmarksTableModel.fireTableDataChanged();
    }

    private void deleteAllBookmarks() {
        this.editedBookmarks.clear();
        this.bookmarksEdited = true;
        this.bookmarksTableModel.fireTableDataChanged();
    }

    public void show() {
        this.gdv.setCursor(Cursor.getPredefinedCursor(3));
        boolean lockFailed = this.gdv.fireBookmarksBeginEditingEvent(this.gdv.getSelectedDocument());
        this.gdv.setCursor(Cursor.getDefaultCursor());
        if (lockFailed) {
            return;
        }
        super.show();
    }

    private void updateBookmarks() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        CMBBookmark[] newBookmarks = new CMBBookmark[this.editedBookmarks.size()];
        for (int i = 0; i < newBookmarks.length; ++i) {
            newBookmarks[i] = (CMBBookmark)this.editedBookmarks.get(i);
        }
        boolean saveFailed = this.gdv.fireBookmarksEndEditingEvent(this.gdv.getSelectedDocument(), newBookmarks);
        this.setCursor(Cursor.getDefaultCursor());
        if (!saveFailed) {
            this.dispose();
            this.gdv.setBookmarks(newBookmarks);
        }
    }

    private class BookmarksTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        DateFormat dateFormat = DateFormat.getDateTimeInstance();

        private BookmarksTableModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return PManageBookmarksDialog.this.editedBookmarks.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            CMBBookmark bookmark = (CMBBookmark)PManageBookmarksDialog.this.editedBookmarks.get(rowIndex);
            if (columnIndex == 0) {
                return String.valueOf(bookmark.getPageNumber());
            }
            if (columnIndex == 1) {
                return bookmark.getName();
            }
            return this.dateFormat.format(new Date(bookmark.getTimestamp()));
        }

        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return PViewerUtilities.getMessage("manageBookmarksDialog.pageNumber");
            }
            if (columnIndex == 1) {
                return PViewerUtilities.getMessage("manageBookmarksDialog.bookmarkName");
            }
            return PViewerUtilities.getMessage("manageBookmarksDialog.date");
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            CMBBookmark bookmark = (CMBBookmark)PManageBookmarksDialog.this.editedBookmarks.get(rowIndex);
            bookmark.setName((String)aValue);
            bookmark.setTimestamp(System.currentTimeMillis());
            PManageBookmarksDialog.this.bookmarksEdited = true;
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }
    }
}

