/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBBookmark;
import com.ibm.mm.viewer.CMBGenericDocClosedEvent;
import com.ibm.mm.viewer.CMBGenericDocClosedListener;
import com.ibm.mm.viewer.CMBGenericDocOpenedEvent;
import com.ibm.mm.viewer.CMBGenericDocOpenedListener;
import com.ibm.mm.viewer.CMBGenericDocSelectedEvent;
import com.ibm.mm.viewer.CMBGenericDocSelectedListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBViewerAction;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PManageBookmarksDialog;
import com.ibm.mm.viewer.PPageModel;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

final class PManageBookmarksAction
extends CMBViewerAction
implements CMBGenericDocOpenedListener,
CMBGenericDocClosedListener,
CMBGenericDocSelectedListener,
CMBGenericDocStateChangedListener {
    public PManageBookmarksAction(CMBGenericDocViewer viewer) {
        super(viewer);
        this.initialize();
    }

    public PManageBookmarksAction(CMBGenericDocViewer viewer, String name) {
        super(viewer, name);
        this.initialize();
    }

    public PManageBookmarksAction(CMBGenericDocViewer viewer, String name, Icon icon) {
        super(viewer, name, icon);
        this.initialize();
    }

    private void initialize() {
        CMBGenericDocViewer viewer = this.getViewer();
        viewer.addDocOpenedListener(this);
        viewer.addDocClosedListener(this);
        viewer.addDocSelectedListener(this);
        viewer.addDocStateChangedListener(this);
        this.updateEnablement();
    }

    private void updateEnablement() {
        CMBBookmark[] bookmarks;
        CMBGenericDocViewer gdv = this.getViewer();
        PDocModel model = gdv.getSelectedModel();
        if (model != null && model instanceof PPageModel && (bookmarks = ((PPageModel)model).getBookmarks()) != null && bookmarks.length > 0) {
            this.setEnabled(model.getPrivilege(9));
            return;
        }
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent event) {
        CMBGenericDocViewer viewer = this.getViewer();
        PManageBookmarksDialog manageBookmarksDialog = new PManageBookmarksDialog(viewer.getOwningFrame(), viewer);
        manageBookmarksDialog.show();
        viewer.updateToolStates();
        viewer.getSelectedView().requestFocus();
    }

    public void genericDocOpened(CMBGenericDocOpenedEvent evt) {
        this.updateEnablement();
    }

    public void genericDocClosed(CMBGenericDocClosedEvent evt) {
        this.updateEnablement();
    }

    public void genericDocSelected(CMBGenericDocSelectedEvent evt) {
        this.updateEnablement();
    }

    public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
        this.updateEnablement();
    }
}

