/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocClosedEvent;
import com.ibm.mm.viewer.CMBGenericDocClosedListener;
import com.ibm.mm.viewer.CMBGenericDocOpenedEvent;
import com.ibm.mm.viewer.CMBGenericDocOpenedListener;
import com.ibm.mm.viewer.CMBGenericDocSelectedEvent;
import com.ibm.mm.viewer.CMBGenericDocSelectedListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBViewerAction;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

class PLockViewsAction
extends CMBViewerAction
implements CMBGenericDocOpenedListener,
CMBGenericDocClosedListener,
CMBGenericDocSelectedListener,
CMBGenericDocStateChangedListener {
    public PLockViewsAction(CMBGenericDocViewer viewer) {
        super(viewer);
        this.initialize();
    }

    public PLockViewsAction(CMBGenericDocViewer viewer, String name) {
        super(viewer, name);
        this.initialize();
    }

    public PLockViewsAction(CMBGenericDocViewer viewer, String name, Icon icon) {
        super(viewer, name, icon);
        this.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        this.getViewer().lockScrolling();
        this.setToolStatus();
    }

    private void initialize() {
        CMBGenericDocViewer viewer = this.getViewer();
        viewer.addDocOpenedListener(this);
        viewer.addDocClosedListener(this);
        viewer.addDocSelectedListener(this);
        viewer.addDocStateChangedListener(this);
        this.setToolStatus();
    }

    private void setToolStatus() {
        CMBGenericDocViewer viewer = this.getViewer();
        this.setEnabled(viewer.canLockScrolling());
        this.setSelected(viewer.getSelectedModel() != null && viewer.isScrollingLocked() && (viewer.getViewerLayout() == 2 || viewer.getViewerLayout() == 1));
        if (viewer.canLockScrolling()) {
            if (viewer.isScrollingLocked()) {
                this.putValue("ShortDescription", PViewerUtilities.getMessage("scroll_lock.toggle_on.tooltip"));
            } else {
                this.putValue("ShortDescription", PViewerUtilities.getMessage("scroll_lock.toggle_off.tooltip"));
            }
        } else {
            this.putValue("ShortDescription", PViewerUtilities.getMessage("scroll_lock.tooltip"));
        }
    }

    public void genericDocOpened(CMBGenericDocOpenedEvent evt) {
        this.setToolStatus();
    }

    public void genericDocClosed(CMBGenericDocClosedEvent evt) {
        this.setToolStatus();
    }

    public void genericDocSelected(CMBGenericDocSelectedEvent evt) {
        this.setToolStatus();
    }

    public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
        this.setToolStatus();
    }
}

