/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

class PLargeObjIndexParser {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private int numseg = 0;
    private int numpages_per_segment = 0;
    private int numpages_in_last_seg = 0;
    private byte[] array;
    private int current;

    public void parseLargeObjectIndex(byte[] blob) {
        this.array = blob;
        this.current = 0;
        this.moveInt();
        this.moveByte();
        this.moveInt();
        this.numseg = this.readInt();
        this.numpages_per_segment = this.readInt();
        this.numpages_in_last_seg = this.readInt();
    }

    public int getNumSegments() {
        return this.numseg;
    }

    public int getNumPagesPerSeg() {
        return this.numpages_per_segment;
    }

    public int getNumPagesLastSeg() {
        return this.numpages_in_last_seg;
    }

    private void moveInt() {
        if (this.current + 4 <= this.array.length) {
            this.current += 4;
        }
    }

    private void moveByte() {
        if (this.current + 1 <= this.array.length) {
            ++this.current;
        }
    }

    private int readInt() {
        int start = this.current;
        int ui = this.array[start] << 24 | (this.array[start + 1] & 0xFF) << 16 | (this.array[start + 2] & 0xFF) << 8 | this.array[start + 3] & 0xFF;
        this.moveInt();
        return ui;
    }
}

