/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.PDataAccessInterface;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;

final class PHttpContentAccess
implements PDataAccessInterface {
    private static final int MIN_BUFFER_SIZE = 65536;
    private URL contentUrl;
    private int contentLength;
    private LinkedList bufferList = new LinkedList();

    public PHttpContentAccess(URL contentUrl, int contentLength) {
        this.contentUrl = contentUrl;
        this.contentLength = contentLength;
    }

    public void dispose() {
    }

    public boolean getBigEndian() {
        throw new UnsupportedOperationException();
    }

    public byte getByte(int offset) throws IOException {
        byte[] onebyte = new byte[1];
        int len = this.getByteArray(offset, 1, onebyte, 0);
        if (len <= 0) {
            return -1;
        }
        return onebyte[0];
    }

    public byte[] getByteArray(int offset, int length) {
        throw new UnsupportedOperationException();
    }

    public byte[] getByteArray(int offset, int length, boolean invertBits) {
        throw new UnsupportedOperationException();
    }

    public int getByteArray(int offset, int length, byte[] returnData, int returnDataOffset) throws IOException {
        int actualLength = Math.min(length, this.contentLength - offset);
        Buffer buffer = this.getBuffer(offset, actualLength);
        for (int i = 0; i < actualLength; ++i) {
            returnData[i + returnDataOffset] = buffer.data[offset - buffer.offset + i];
        }
        return actualLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Buffer getBuffer(int offset, int length) throws IOException {
        ListIterator iterator = this.bufferList.listIterator();
        while (iterator.hasNext()) {
            Buffer buffer = (Buffer)iterator.next();
            if (buffer.offset > offset || buffer.offset + buffer.length < offset + length) continue;
            return buffer;
        }
        PHttpContentAccess pHttpContentAccess = this;
        synchronized (pHttpContentAccess) {
            Buffer buffer;
            iterator = this.bufferList.listIterator();
            while (iterator.hasNext()) {
                buffer = (Buffer)iterator.next();
                if (buffer.offset > offset || buffer.offset + buffer.length < offset + length) continue;
                return buffer;
            }
            buffer = this.loadBuffer(offset, length);
            this.bufferList.add(buffer);
            return buffer;
        }
    }

    private Buffer loadBuffer(int offset, int length) throws IOException {
        String methodName = "loadBuffer";
        Buffer buffer = new Buffer();
        try {
            buffer.offset = Math.max(Math.min(offset, this.contentLength - 65536), 0);
            buffer.length = Math.min(Math.max(length, 65536), this.contentLength - buffer.offset);
            buffer.data = new byte[buffer.length];
            HttpURLConnection connection = (HttpURLConnection)this.contentUrl.openConnection();
            connection.setRequestProperty("Range", "bytes=" + buffer.offset + "-" + (buffer.offset + buffer.length - 1));
            connection.setRequestProperty("Request-Range", "bytes=" + buffer.offset + "-" + (buffer.offset + buffer.length - 1));
            InputStream contentInputStream = connection.getInputStream();
            for (int readLength = 0; readLength < buffer.length; readLength += contentInputStream.read(buffer.data, readLength, buffer.length - readLength)) {
            }
            contentInputStream.close();
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        return buffer;
    }

    public InputStream getInputStream() {
        return new HttpContentAccessInputStream();
    }

    public int getInt(int offset) {
        throw new UnsupportedOperationException();
    }

    public int[] getIntArray(int offset, int length) {
        throw new UnsupportedOperationException();
    }

    public int getShort(int offset) {
        throw new UnsupportedOperationException();
    }

    public int[] getShortArray(int offset, int length) {
        throw new UnsupportedOperationException();
    }

    public boolean isValidOffset(int offset) {
        return offset >= 0 && offset < this.contentLength;
    }

    public void setBigEndian(boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    private class HttpContentAccessInputStream
    extends InputStream {
        int location;
        int markedLocation;

        private HttpContentAccessInputStream() {
        }

        public int read() throws IOException {
            try {
                int readByte = PHttpContentAccess.this.getByte(this.location) & 0xFF;
                ++this.location;
                return readByte;
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
            catch (NullPointerException e) {
                return -1;
            }
        }

        public int available() throws IOException {
            return PHttpContentAccess.this.contentLength - this.location;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            int actualLengthRead = PHttpContentAccess.this.getByteArray(this.location, len, b, off);
            this.location += actualLengthRead;
            if (actualLengthRead == 0 && len > 0) {
                return -1;
            }
            return actualLengthRead;
        }

        public boolean markSupported() {
            return true;
        }

        public synchronized void mark(int readlimit) {
            this.markedLocation = this.location;
        }

        public synchronized void reset() throws IOException {
            this.location = this.markedLocation;
        }

        public long skip(long n) throws IOException {
            if ((long)this.location + n > (long)PHttpContentAccess.this.contentLength) {
                n = PHttpContentAccess.this.contentLength - this.location;
            }
            if (n < 0L) {
                return 0L;
            }
            this.location = (int)((long)this.location + n);
            return n;
        }
    }

    private class Buffer {
        int offset;
        int length;
        byte[] data;

        private Buffer() {
        }
    }
}

