/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocClosedEvent;
import com.ibm.mm.viewer.CMBGenericDocClosedListener;
import com.ibm.mm.viewer.CMBGenericDocOpenedEvent;
import com.ibm.mm.viewer.CMBGenericDocOpenedListener;
import com.ibm.mm.viewer.CMBGenericDocSelectedEvent;
import com.ibm.mm.viewer.CMBGenericDocSelectedListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.JTextField;

class PGotoPageTool
extends JPanel {
    private CMBGenericDocViewer gdv;
    private JTextField gotoPageTextField = new JTextField(){

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            ++d.width;
            return d;
        }
    };

    public PGotoPageTool(CMBGenericDocViewer gdv) {
        super(new GridBagLayout());
        this.gdv = gdv;
        this.add(this.gotoPageTextField);
        this.gotoPageTextField.setEnabled(false);
        this.gotoPageTextField.setColumns(8);
        this.gotoPageTextField.addFocusListener(new GotoPageFocusListener());
        this.gotoPageTextField.addKeyListener(new GotoPageKeyListener());
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PGotoPageTool.this.gotoPageTextField.requestFocus();
            }
        });
        gdv.addDocStateChangedListener(new GotoPageDocStateChangedListener());
        gdv.addDocSelectedListener(new GotoPageDocSelectedListener());
        gdv.addDocClosedListener(new GotoPageDocClosedListener());
        gdv.addDocOpenedListener(new GotoPageDocOpenedListener());
        this.updateText();
    }

    private void updateText() {
        if (this.gdv.getSelectedDocument() == null) {
            this.gotoPageTextField.setText("");
            this.gotoPageTextField.setEnabled(false);
            return;
        }
        this.gotoPageTextField.setEnabled(true);
        int pageNumber = this.gdv.getCurrentPageNumber();
        if (this.gdv.isPageCountDetermined()) {
            int pageCount = this.gdv.getPageCount();
            this.gotoPageTextField.setText(PViewerUtilities.getMessage("goto_page.text", new Object[]{new Integer(pageNumber), new Integer(pageCount)}));
        } else {
            this.gotoPageTextField.setText(Integer.toString(pageNumber));
        }
    }

    private class GotoPageFocusListener
    implements FocusListener {
        private GotoPageFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            PGotoPageTool.this.gotoPageTextField.selectAll();
        }

        public void focusLost(FocusEvent e) {
            try {
                String text = PGotoPageTool.this.gotoPageTextField.getText();
                int pageNumber = Integer.parseInt(text);
                if (PGotoPageTool.this.gdv.isPageCountDetermined() && PGotoPageTool.this.gdv.getPageCount() > 0 && pageNumber > PGotoPageTool.this.gdv.getPageCount()) {
                    pageNumber = PGotoPageTool.this.gdv.getPageCount();
                }
                PGotoPageTool.this.gdv.setCurrentPageNumber(pageNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            PGotoPageTool.this.updateText();
        }
    }

    private class GotoPageKeyListener
    extends KeyAdapter {
        private GotoPageKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getModifiers() == 0) {
                if (e.getKeyCode() == 39) {
                    Container c = PGotoPageTool.this.getFocusCycleRootAncestor();
                    c.getFocusTraversalPolicy().getComponentAfter(c, PGotoPageTool.this.gotoPageTextField).requestFocus();
                } else if (e.getKeyCode() == 37) {
                    Container c = PGotoPageTool.this.getFocusCycleRootAncestor();
                    c.getFocusTraversalPolicy().getComponentBefore(c, PGotoPageTool.this).requestFocus();
                }
            }
        }
    }

    private class GotoPageDocOpenedListener
    implements CMBGenericDocOpenedListener {
        private GotoPageDocOpenedListener() {
        }

        public void genericDocOpened(CMBGenericDocOpenedEvent evt) {
            PGotoPageTool.this.updateText();
        }
    }

    private class GotoPageDocClosedListener
    implements CMBGenericDocClosedListener {
        private GotoPageDocClosedListener() {
        }

        public void genericDocClosed(CMBGenericDocClosedEvent evt) {
            PGotoPageTool.this.updateText();
        }
    }

    private class GotoPageDocSelectedListener
    implements CMBGenericDocSelectedListener {
        private GotoPageDocSelectedListener() {
        }

        public void genericDocSelected(CMBGenericDocSelectedEvent evt) {
            PGotoPageTool.this.updateText();
        }
    }

    private class GotoPageDocStateChangedListener
    implements CMBGenericDocStateChangedListener {
        private GotoPageDocStateChangedListener() {
        }

        public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
            if (evt.getChangeType() != 9) {
                PGotoPageTool.this.updateText();
            }
        }
    }
}

