/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBBookmark;
import com.ibm.mm.viewer.CMBGenericDocClosedEvent;
import com.ibm.mm.viewer.CMBGenericDocClosedListener;
import com.ibm.mm.viewer.CMBGenericDocSelectedEvent;
import com.ibm.mm.viewer.CMBGenericDocSelectedListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class PGotoBookmarkTool
extends JPanel {
    private CMBGenericDocViewer gdv;
    private JLabel gotoBookmarkLabel;
    private JComboBox gotoBookmarkComboBox;
    private boolean ignoreItemStateChanged;

    public PGotoBookmarkTool(CMBGenericDocViewer gdv) {
        this.gdv = gdv;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(5, 0));
        this.gotoBookmarkLabel = new JLabel(PViewerUtilities.getMessage("goto_bookmark.label"));
        this.add((Component)this.gotoBookmarkLabel, "Before");
        this.gotoBookmarkComboBox = new JComboBox(){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = 160;
                return size;
            }
        };
        this.gotoBookmarkLabel.setLabelFor(this.gotoBookmarkComboBox);
        this.gotoBookmarkComboBox.setEnabled(false);
        this.gotoBookmarkComboBox.setEditable(false);
        this.populateList();
        this.add((Component)this.gotoBookmarkComboBox, "Center");
        if (this.gotoBookmarkComboBox.getComponentCount() == 3) {
            Component editTextField = this.gotoBookmarkComboBox.getComponent(2);
            editTextField.addFocusListener(new GotoBookmarkFocusListener());
        }
        this.gotoBookmarkComboBox.addItemListener(new GotoBookmarkItemListener());
        this.gotoBookmarkComboBox.getEditor().addActionListener(new GotoBookmarkActionListener());
        this.gdv.addDocStateChangedListener(new GotoBookmarkDocStateChangedListener());
        this.gdv.addDocSelectedListener(new GotoBookmarkDocSelectedListener());
        this.gdv.addDocClosedListener(new GotoBookmarkDocClosedListener());
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PGotoBookmarkTool.this.gotoBookmarkComboBox.requestFocus();
            }
        });
    }

    private void populateList() {
        this.ignoreItemStateChanged = true;
        DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)this.gotoBookmarkComboBox.getModel();
        comboBoxModel.removeAllElements();
        CMBBookmark[] bookmarks = null;
        PDocModel model = this.gdv.getSelectedModel();
        if (model != null && model instanceof PPageModel) {
            bookmarks = ((PPageModel)model).getBookmarks();
        }
        if (bookmarks == null || bookmarks.length == 0) {
            comboBoxModel.addElement(" ");
            this.gotoBookmarkComboBox.setEnabled(false);
        } else {
            for (int i = 0; i < bookmarks.length; ++i) {
                comboBoxModel.addElement(PViewerUtilities.getMessage("goto_bookmark.text", new String[]{String.valueOf(bookmarks[i].getPageNumber()), bookmarks[i].getName()}));
            }
            this.gotoBookmarkComboBox.setEnabled(true);
            this.updateSelectedBookmark();
        }
        this.ignoreItemStateChanged = false;
    }

    public boolean isEnabled() {
        return this.gotoBookmarkComboBox.isEnabled();
    }

    private void gotoBookmark() {
        int i = this.gotoBookmarkComboBox.getSelectedIndex();
        if (this.gdv.getSelectedModel() != null && i > -1 && this.gdv.getBookmarks() != null) {
            int pageNumber = this.gdv.getBookmarks()[i].getPageNumber();
            if (!this.gdv.isPageCountDetermined()) {
                this.gdv.setCursor(new Cursor(3));
                this.gdv.setCurrentPageNumber(pageNumber);
                this.gdv.setCursor(Cursor.getDefaultCursor());
            } else {
                this.gdv.setCurrentPageNumber(pageNumber);
            }
        }
    }

    private void updateSelectedBookmark() {
        int pageNumber = this.gdv.getCurrentPageNumber();
        CMBBookmark[] bookmarks = this.gdv.getBookmarks();
        for (int i = 0; i < bookmarks.length; ++i) {
            if (bookmarks[i].getPageNumber() != pageNumber) continue;
            this.gotoBookmarkComboBox.setSelectedIndex(i);
            return;
        }
        this.gotoBookmarkComboBox.setSelectedIndex(-1);
    }

    private class GotoBookmarkActionListener
    implements ActionListener {
        private GotoBookmarkActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PGotoBookmarkTool.this.gotoBookmark();
        }
    }

    private class GotoBookmarkItemListener
    implements ItemListener {
        private GotoBookmarkItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (!PGotoBookmarkTool.this.ignoreItemStateChanged) {
                PGotoBookmarkTool.this.gotoBookmark();
            }
        }
    }

    private class GotoBookmarkFocusListener
    implements FocusListener {
        private GotoBookmarkFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            PGotoBookmarkTool.this.gotoBookmarkComboBox.getEditor().selectAll();
        }

        public void focusLost(FocusEvent e) {
            PGotoBookmarkTool.this.gotoBookmark();
        }
    }

    private class GotoBookmarkDocClosedListener
    implements CMBGenericDocClosedListener {
        private GotoBookmarkDocClosedListener() {
        }

        public void genericDocClosed(CMBGenericDocClosedEvent evt) {
            PGotoBookmarkTool.this.populateList();
        }
    }

    private class GotoBookmarkDocSelectedListener
    implements CMBGenericDocSelectedListener {
        private GotoBookmarkDocSelectedListener() {
        }

        public void genericDocSelected(CMBGenericDocSelectedEvent evt) {
            PGotoBookmarkTool.this.populateList();
        }
    }

    private class GotoBookmarkDocStateChangedListener
    implements CMBGenericDocStateChangedListener {
        private GotoBookmarkDocStateChangedListener() {
        }

        public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
            if (evt.getChangeType() == 22) {
                PGotoBookmarkTool.this.populateList();
            } else if (evt.getChangeType() == 1) {
                PGotoBookmarkTool.this.updateSelectedBookmark();
            }
        }
    }
}

