/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PDocView;
import com.ibm.mm.viewer.PFullSizePageView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;

class PFullSizeViewScrollAction
extends AbstractAction {
    protected int orientation;
    protected int direction;
    private boolean block;
    private CMBGenericDocViewer gdv;

    protected PFullSizeViewScrollAction(CMBGenericDocViewer gdv, String name, int orientation, int direction, boolean block) {
        super(name);
        this.gdv = gdv;
        this.orientation = orientation;
        this.direction = direction;
        this.block = block;
    }

    boolean scroll(PDocView docView, boolean canPage) {
        Component view;
        boolean pageChanged = false;
        JScrollPane scrollpane = (JScrollPane)docView.getParent().getParent();
        JViewport vp = scrollpane.getViewport();
        if (vp != null && (view = vp.getView()) != null) {
            Rectangle visRect = vp.getViewRect();
            Dimension vSize = view.getSize();
            int amount = view instanceof Scrollable ? (this.block ? ((Scrollable)((Object)view)).getScrollableBlockIncrement(visRect, this.orientation, this.direction) : ((Scrollable)((Object)view)).getScrollableUnitIncrement(visRect, this.orientation, this.direction)) : (this.block ? (this.orientation == 1 ? visRect.height : 0) : 10);
            if (this.orientation == 1) {
                visRect.y += amount * this.direction;
                if (visRect.y + visRect.height > vSize.height) {
                    visRect.y = vSize.height - visRect.height;
                }
                if (visRect.y < 0) {
                    visRect.y = 0;
                }
            }
            Point oldViewPosition = vp.getViewPosition();
            if (oldViewPosition.y == visRect.y && canPage) {
                if (this.direction < 0) {
                    if (this.gdv.canPrevPage()) {
                        this.gdv.prevPage();
                        pageChanged = true;
                        visRect = vp.getViewRect();
                        visRect.y = vSize.height - visRect.height;
                        ((PFullSizePageView)docView).scrollRectToVisible(visRect);
                    }
                } else if (this.gdv.canNextPage()) {
                    visRect.y = 0;
                    ((PFullSizePageView)docView).scrollRectToVisible(visRect);
                    this.gdv.nextPage();
                    pageChanged = true;
                    visRect = vp.getViewRect();
                    visRect.y = 0;
                    ((PFullSizePageView)docView).scrollRectToVisible(visRect);
                }
            } else {
                ((PFullSizePageView)docView).scrollRectToVisible(visRect);
                vp.revalidate();
            }
        }
        return pageChanged;
    }

    public void actionPerformed(ActionEvent e) {
        boolean pageChanged = this.scroll(this.gdv.getSelectedView(), true);
        if (this.gdv.isScrollingLocked()) {
            if (pageChanged) {
                Rectangle visRect = this.gdv.getSelectedView().getVisibleRect();
                ((PFullSizePageView)this.gdv.getOtherView()).scrollRectToVisible(visRect);
            } else {
                this.gdv.setSelectedViewTemporary(true);
                this.scroll(this.gdv.getOtherView(), false);
                this.gdv.setSelectedViewTemporary(false);
            }
        }
    }
}

