/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBLetters;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.CMBViewerConstants;
import com.ibm.mm.viewer.CMBViewerException;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PDocView;
import com.ibm.mm.viewer.PFullSizeView;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PResizeHandles;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSelectedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationSelectedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBAnnotationView;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBSelectedAnnotationToolChangedEvent;
import com.ibm.mm.viewer.annotation.CMBSelectedAnnotationToolChangedListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.MatchResult;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

class PFullSizePageView
extends PFullSizeView
implements MouseListener,
MouseMotionListener,
FocusListener,
CMBAnnotationSelectedListener,
CMBSelectedAnnotationToolChangedListener,
CMBGenericDocStateChangedListener,
ChangeListener,
ComponentListener,
CMBViewerConstants {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    protected Image currentPageImage;
    private CMBAnnotationView annView;
    private JPopupMenu pagePopupMenu = null;
    private JPopupMenu doctabPopupMenu = null;
    KeyBinding[] commonBindings = null;
    private Color viewBackground = null;
    private Color viewOutline = null;
    private Color viewSelected = null;
    private SelectTextCursor selectTextCursor = null;
    private boolean findTextCursorActive = false;
    private PResizeHandles resizeHandles = null;
    private Rectangle dragRect = new Rectangle(0, 0, 0, 0);
    private Point originalPoint;
    private static int OFFSET = 2;
    private boolean justStartedDragging = true;
    private JPopupMenu selectAreaPopupMenu;
    private boolean selectedView = true;
    private int fit;
    private double scale;
    private int pageNumber;
    private Rectangle viewRectangle;
    private boolean displayedOnce;
    private boolean drawExceptionEncountered;
    private boolean containsViewSpecificValues;
    private boolean inGenericDocStateChanged;

    public PFullSizePageView(PSingleDocViewer viewer, PDocModel model) {
        super(viewer, model);
        this.setFocusable(true);
        this.defineKeyBindings();
        this.registerKeyBindings();
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
        if (viewer.getGdv().getAnnotationServices() != null) {
            viewer.getGdv().getAnnotationServices().addAnnotationToolListener(this);
            if (model.getAnnotationSet() != null) {
                this.annView = viewer.getGdv().getAnnotationServices().prepareAnnotationView(this.getAnnotationComponent(), model.getAnnotationSet());
                this.getAnnotationView().setCurrentPage(model.getCurrentPageNumber());
                this.annView.getModel().addAnnSelectedListener(this);
            }
        }
        model.addDocStateChangedListener(this);
        this.selectTextCursor = new SelectTextCursor(this);
        this.addMouseListener(this.selectTextCursor);
        this.addMouseMotionListener(this.selectTextCursor);
        this.display();
        this.getAccessibleContext().setAccessibleDescription(PViewerUtilities.getMessage("DocumentViewer.fullSizePageAltText"));
    }

    private Color getViewBackground() {
        if (this.viewBackground == null) {
            Color b = this.getBackground();
            if (b == null) {
                b = Color.gray;
            }
            String s = PViewerUtilities.getColorProperty("View.background.color", this.getViewer().getGdv().getConfigProperties(), b);
            this.viewBackground = Color.decode(s);
        }
        return this.viewBackground;
    }

    private Color getViewOutline() {
        if (this.viewOutline == null) {
            String s = PViewerUtilities.getColorProperty("View.outline.color", this.getViewer().getGdv().getConfigProperties(), SystemColor.controlShadow);
            this.viewOutline = Color.decode(s);
        }
        return this.viewOutline;
    }

    private Color getViewSelected() {
        if (this.viewSelected == null) {
            String s = PViewerUtilities.getColorProperty("View.selected.color", this.getViewer().getGdv().getConfigProperties(), SystemColor.controlShadow);
            this.viewSelected = Color.decode(s);
        }
        return this.viewSelected;
    }

    CMBAnnotationView getAnnotationView() {
        return this.annView;
    }

    void prevPage() {
        int position;
        PPageModel model = (PPageModel)this.getDocModel();
        if (model.isPageValid(model.getPageNumber((position = model.getPagePosition(this.pageNumber)) - 1))) {
            this.pageNumber = model.getPageNumber(position - 1);
            this.refit();
            this.display();
        }
    }

    void nextPage() {
        int position;
        PPageModel model = (PPageModel)this.getDocModel();
        if (model.isPageValid(model.getPageNumber((position = model.getPagePosition(this.pageNumber)) + 1))) {
            this.pageNumber = model.getPageNumber(position + 1);
            this.refit();
            this.display();
        }
    }

    void firstPage() {
        int position;
        PPageModel model = (PPageModel)this.getDocModel();
        if (model.isPageValid(model.getPageNumber(position = model.getPagePosition(1)))) {
            this.pageNumber = model.getPageNumber(position);
            this.refit();
            this.display();
        }
    }

    void lastPage() {
        int position;
        PPageModel model = (PPageModel)this.getDocModel();
        if (model.isPageValid(model.getPageNumber(position = model.getPagePosition(model.getPageCount())))) {
            this.pageNumber = model.getPageNumber(position);
            this.refit();
            this.display();
        }
    }

    void refit() {
        int oldFit = this.getDocModel().getFit();
        double oldScale = this.getDocModel().getScale();
        int oldPageNumber = this.getDocModel().getCurrentPageNumber();
        PFullSizeView oldActiveFullSizeView = ((PPageModel)this.getDocModel()).activeFullSizeView;
        if (!this.isSelectedView() || ((PPageModel)this.getDocModel()).activeFullSizeView != this) {
            this.setViewStateIntoModel();
        }
        ((PPageModel)this.getDocModel()).activeFullSizeView = this;
        ((PPageModel)this.getDocModel()).refit(this.getViewDimension(), this.getVScrollBarWidth(), this.getHScrollBarHeight());
        if (this.getAnnotationView() != null) {
            this.getAnnotationView().setScale(this.getDocModel().getScale());
        }
        this.fit = this.getDocModel().getFit();
        this.scale = this.getDocModel().getScale();
        this.pageNumber = this.getDocModel().getCurrentPageNumber();
        this.containsViewSpecificValues = true;
        if (!this.isSelectedView()) {
            if (oldFit == 4) {
                this.getDocModel().fitActualSize();
            } else if (oldFit == 2) {
                this.fitHeight();
            } else if (oldFit == 3) {
                this.fitInWindow();
            } else if (oldFit == 1) {
                this.fitWidth();
            } else {
                this.getDocModel().setScale(oldScale);
            }
            ((PPageModel)this.getDocModel()).activeFullSizeView = oldActiveFullSizeView;
            try {
                this.getDocModel().setCurrentPageNumber(oldPageNumber);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
    }

    protected void display() {
        String methodName = "display";
        if (!this.isShowing()) {
            return;
        }
        this.displayedOnce = true;
        int oldFit = this.getDocModel().getFit();
        double oldScale = this.getDocModel().getScale();
        int oldPagePosition = this.getDocModel().getCurrentPagePosition();
        Rectangle oldViewRectangle = ((PPageModel)this.getDocModel()).getCurrentViewRectangle();
        PFullSizeView oldActiveFullSizeView = ((PPageModel)this.getDocModel()).activeFullSizeView;
        if (!this.isSelectedView() || ((PPageModel)this.getDocModel()).activeFullSizeView != this) {
            this.setViewStateIntoModel();
        }
        ((PPageModel)this.getDocModel()).activeFullSizeView = this;
        Cursor currCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Rectangle currViewRect;
            int pageNumber = ((PPageModel)this.getDocModel()).getCurrentPageNumber();
            if (pageNumber <= 0) {
                this.currentPageImage = null;
                this.setPreferredSize(new Dimension(0, 0));
                this.revalidate();
                this.repaint();
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            if (((PPageModel)this.getDocModel()).useDrawPage(pageNumber)) {
                this.currentPageImage = null;
            } else {
                try {
                    this.currentPageImage = ((PPageModel)this.getDocModel()).getPageImage(pageNumber);
                    try {
                        MediaTracker tracker = new MediaTracker(this);
                        tracker.addImage(this.currentPageImage, 0);
                        tracker.waitForID(0);
                    }
                    catch (InterruptedException e) {}
                }
                catch (OutOfMemoryError e) {
                    this.currentPageImage = null;
                    this.setPreferredSize(new Dimension(0, 0));
                    this.revalidate();
                    this.repaint();
                    JOptionPane.showMessageDialog(this, PViewerUtilities.getMessage("DocumentViewer.outOfMemoryPageImage"), PViewerUtilities.getMessage("DocumentViewer.outOfMemoryErrorDialogTitle"), 0, null);
                }
            }
            int wd = this.getImageWidth();
            int ht = this.getImageHeight();
            double aspectRatio = 1.0;
            this.setPreferredSize(new Dimension(wd, ht));
            this.setVisible(true);
            this.revalidate();
            if (this.annView != null) {
                try {
                    double displayResolution = ((PPageModel)this.getDocModel()).getDocument().getDisplayResolution();
                    double pageXResolution = ((PPageModel)this.getDocModel()).getPage(pageNumber).getPageXResolution();
                    double pageYResolution = ((PPageModel)this.getDocModel()).getPage(pageNumber).getPageYResolution();
                    double pageResolution = Math.max(pageXResolution, pageYResolution);
                    aspectRatio = pageXResolution / pageYResolution;
                    this.annView.getModel().setScaleFactor(displayResolution / pageResolution);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.annView.getModel().setRotation(((PPageModel)this.getDocModel()).getPageRotation(pageNumber), pageNumber);
                this.annView.setScale(this.getDocModel().getScale());
                this.annView.getModel().setImageSize(wd, ht, pageNumber);
            }
            if ((currViewRect = ((PPageModel)this.getDocModel()).getCurrentViewRectangle()) != null && !currViewRect.equals(oldViewRectangle) && this.getParent() != null && this.getParent() instanceof JViewport) {
                JViewport currViewPort = (JViewport)this.getParent();
                currViewPort.setViewPosition(currViewRect.getLocation());
            }
            this.repaint();
            if (this.getViewer().getGdv().currentLayout.getSelectedFullSizeView() == this) {
                this.setCurrentViewRect();
            }
            this.setCursor(currCursor);
            this.fit = this.getDocModel().getFit();
            this.scale = this.getDocModel().getScale();
            pageNumber = this.getDocModel().getCurrentPageNumber();
            this.viewRectangle = ((PPageModel)this.getDocModel()).getCurrentViewRectangle();
            this.containsViewSpecificValues = true;
            if (!this.isSelectedView()) {
                this.getDocModel().setFireChangeEvents(false);
                this.getDocModel().setCurrentPagePosition(oldPagePosition);
                if (oldFit == 4) {
                    this.getDocModel().fitActualSize();
                } else if (oldFit == 2) {
                    this.fitHeight();
                } else if (oldFit == 3) {
                    this.fitInWindow();
                } else if (oldFit == 1) {
                    this.fitWidth();
                } else {
                    this.getDocModel().setScale(oldScale);
                }
                ((PPageModel)this.getDocModel()).setCurrentViewRectangle(oldViewRectangle);
                this.getDocModel().setFireChangeEvents(true);
                ((PPageModel)this.getDocModel()).activeFullSizeView = oldActiveFullSizeView;
            }
        }
        catch (Exception ex) {
            ViewerLogger.logError((Object)this, methodName, ex);
            this.currentPageImage = null;
            this.setPreferredSize(new Dimension(0, 0));
            this.revalidate();
            this.repaint();
            JOptionPane.showMessageDialog(this, PViewerUtilities.getMessage("DocumentViewer.unexpectedError"), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0);
        }
    }

    public boolean isOpaque() {
        return true;
    }

    public void paintComponent(Graphics g) {
        int pageNumber;
        block14: {
            String methodName = "paintComponent";
            if (!this.displayedOnce) {
                return;
            }
            pageNumber = this.getPageNumber();
            if (pageNumber <= 0) {
                g.setColor(this.getViewBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                return;
            }
            try {
                if (this.getImageWidth() < this.getWidth()) {
                    g.setColor(this.getViewBackground());
                    g.fillRect(this.getImageWidth(), 0, this.getWidth() - this.getImageWidth(), this.getHeight());
                }
                if (this.getImageHeight() < this.getHeight()) {
                    g.setColor(this.getViewBackground());
                    g.fillRect(0, this.getImageHeight(), this.getWidth(), this.getHeight() - this.getImageHeight());
                }
                if (((PPageModel)this.getDocModel()).useDrawPage(pageNumber)) {
                    block13: {
                        this.currentPageImage = null;
                        try {
                            ((PPageModel)this.getDocModel()).drawPage(pageNumber, this.scale, (Graphics2D)g);
                        }
                        catch (Exception e) {
                            if (!this.drawExceptionEncountered) {
                                ViewerLogger.logError((Object)this, methodName, e);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        JOptionPane.showMessageDialog(PFullSizePageView.this, PViewerUtilities.getMessage("DocumentViewer.unexpectedError"), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0);
                                    }
                                });
                                this.drawExceptionEncountered = true;
                            }
                        }
                        catch (OutOfMemoryError e) {
                            if (this.drawExceptionEncountered) break block13;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(PFullSizePageView.this, PViewerUtilities.getMessage("DocumentViewer.outOfMemoryPageImage"), PViewerUtilities.getMessage("DocumentViewer.outOfMemoryErrorDialogTitle"), 0);
                                }
                            });
                            this.drawExceptionEncountered = true;
                        }
                    }
                    g.setColor(this.getViewOutline());
                    g.drawRect(0, 0, this.getImageWidth() - 1, this.getImageHeight() - 1);
                    break block14;
                }
                if (this.currentPageImage != null) {
                    g.drawImage(this.currentPageImage, 0, 0, this);
                    g.setColor(this.getViewOutline());
                    g.drawRect(0, 0, this.getImageWidth() - 1, this.getImageHeight() - 1);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.annView != null) {
            this.annView.paintAnnotations((Graphics2D)g, pageNumber, true);
        }
        this.drawHitHighlight(g);
        this.drawSelectArea(g);
        this.drawSelectText(g);
        this.drawFindText(g);
    }

    boolean isHitActive() {
        CMBPage currPage;
        boolean isHitActive = true;
        if (!this.findTextCursorActive) {
            return false;
        }
        try {
            currPage = this.getDocModel().getDocument().getPage(this.pageNumber);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        CMBLetters letters = currPage.getLetters();
        if (letters == null || letters.getLetters() == null || letters.getLetters().length == 0) {
            return false;
        }
        if (currPage.matchResults == null) {
            return false;
        }
        int hitIndex = currPage.hitIndex;
        if (hitIndex < 0 || hitIndex >= currPage.matchResults.size()) {
            return false;
        }
        return isHitActive;
    }

    void drawFindText(Graphics g) {
        CMBPage currPage;
        if (!this.isHitActive()) {
            return;
        }
        try {
            currPage = this.getDocModel().getDocument().getPage(this.pageNumber);
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
        int hitIndex = currPage.hitIndex;
        MatchResult result = currPage.matchResults.get(hitIndex);
        this.selectTextCursor.dot = result.start();
        this.selectTextCursor.mark = result.end() - 1;
        this.selectTextCursor.selectedPolygon = this.selectTextCursor.getSelectedPolygon();
        this.selectTextCursor.setVisible(true);
        this.selectTextCursor.drawSelectedPolygon(g);
    }

    void drawSelectText(Graphics g) {
        if (this.getViewer().getGdv().getCurrentMode() == 113 && this.selectTextCursor.isVisible && !this.selectTextCursor.isAdjusting) {
            this.selectTextCursor.drawSelectedPolygon(g);
        }
    }

    void drawSelectArea(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Color oldColor = g2.getColor();
        Stroke oldStroke = g2.getStroke();
        if (!(this.resizeHandles != null && !this.resizeHandles.getSelectedRect().isEmpty() && this.resizeHandles.isVisible() || this.getViewer().getGdv().getCurrentMode() == 111 || this.dragRect == null || this.dragRect.isEmpty())) {
            g2.setStroke(new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{5.0f, 5.0f}, 0.0f));
            g2.drawRect(this.dragRect.x, this.dragRect.y, this.dragRect.width, this.dragRect.height);
        }
        g2.setColor(oldColor);
        g2.setStroke(oldStroke);
    }

    void drawHitHighlight(Graphics g) {
        PPageModel pageModel = (PPageModel)this.getDocModel();
        Rectangle hitHighlight = pageModel.getHitHighlight(pageModel.getCurrentPageNumber());
        if (hitHighlight == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Color oldColor = g2.getColor();
        Composite oldComposite = g2.getComposite();
        g2.setColor(Color.blue);
        g2.setXORMode(Color.white);
        double scalex = pageModel.getScale() * pageModel.getDisplayResolution() / pageModel.getPageXResolution(pageModel.getCurrentPageNumber());
        double scaley = pageModel.getScale() * pageModel.getDisplayResolution() / pageModel.getPageYResolution(pageModel.getCurrentPageNumber());
        g2.fillRect((int)((double)hitHighlight.x * scalex), (int)((double)hitHighlight.y * scaley), (int)((double)hitHighlight.width * scalex), (int)((double)hitHighlight.height * scaley));
        g2.setColor(oldColor);
        g2.setComposite(oldComposite);
    }

    int getImageHeight() {
        if (this.currentPageImage != null) {
            return this.currentPageImage.getHeight(this);
        }
        int pageNumber = this.getPageNumber();
        if (pageNumber <= 0) {
            return 0;
        }
        PPageModel pageModel = (PPageModel)this.getDocModel();
        double vscale = this.scale;
        if (this.isSelectedView() && ((PPageModel)this.getDocModel()).activeFullSizeView == this) {
            vscale = pageModel.getScale(pageNumber);
        }
        if (pageModel.getPageRotation(pageNumber) == 0 || pageModel.getPageRotation(pageNumber) == 2) {
            double actualSizeHeight = pageModel.getPageHeight(pageNumber) * pageModel.getDisplayResolution();
            return (int)(actualSizeHeight * vscale);
        }
        double actualSizeWidth = pageModel.getPageWidth(pageNumber) * pageModel.getDisplayResolution();
        return (int)(actualSizeWidth * vscale);
    }

    int getImageWidth() {
        if (this.currentPageImage != null) {
            return this.currentPageImage.getWidth(this);
        }
        int pageNumber = this.getPageNumber();
        if (pageNumber <= 0) {
            return 0;
        }
        PPageModel pageModel = (PPageModel)this.getDocModel();
        double vscale = this.scale;
        if (this.isSelectedView() && ((PPageModel)this.getDocModel()).activeFullSizeView == this) {
            vscale = pageModel.getScale(pageNumber);
        }
        if (pageModel.getPageRotation(pageNumber) == 0 || pageModel.getPageRotation(pageNumber) == 2) {
            double actualSizeWidth = pageModel.getPageWidth(pageNumber) * pageModel.getDisplayResolution();
            return (int)(actualSizeWidth * vscale);
        }
        double actualSizeHeight = pageModel.getPageHeight(pageNumber) * pageModel.getDisplayResolution();
        return (int)(actualSizeHeight * vscale);
    }

    void setCurrentViewRect() {
        Rectangle currVisibleRect = this.getVisibleRect();
        Rectangle currImageRect = new Rectangle(0, 0, this.getImageWidth() - 1, this.getImageHeight() - 1);
        if (!currImageRect.contains(currVisibleRect)) {
            currVisibleRect = (Rectangle)currImageRect.createIntersection(currVisibleRect);
        }
        if (this.isSelectedView()) {
            this.setDisplayNeeded(false);
            ((PPageModel)this.getDocModel()).setCurrentViewRectangle(currVisibleRect);
            this.setDisplayNeeded(true);
            this.viewRectangle = currVisibleRect;
        }
    }

    void moveCurrentViewRect(int x, int y) {
        Rectangle modelRect = new Rectangle(((PPageModel)this.getDocModel()).getCurrentViewRectangle());
        modelRect.setLocation(x, y);
        ((PPageModel)this.getDocModel()).setCurrentViewRectangle(modelRect);
    }

    public JPopupMenu getPopupMenu(String menuName) {
        if (menuName.equalsIgnoreCase("pagepopup")) {
            return this.pagePopupMenu;
        }
        if (menuName.equalsIgnoreCase("docTabPopup")) {
            return this.doctabPopupMenu;
        }
        if (menuName.equalsIgnoreCase("selectAreaPopup")) {
            return this.selectAreaPopupMenu;
        }
        return null;
    }

    public void setPopupMenu(JPopupMenu pMenu, String menuName) {
        if (menuName.equalsIgnoreCase("pagepopup")) {
            this.pagePopupMenu = pMenu;
        } else if (menuName.equalsIgnoreCase("docTabPopup")) {
            this.doctabPopupMenu = pMenu;
        } else if (menuName.equalsIgnoreCase("selectAreaPopup")) {
            this.selectAreaPopupMenu = pMenu;
        }
    }

    void setPagePopupMenu(JPopupMenu popupMenu) {
        this.pagePopupMenu = popupMenu;
    }

    void setDoctabPopupMenu(JPopupMenu popupMenu) {
        this.doctabPopupMenu = popupMenu;
    }

    private void defineKeyBindings() {
        AbstractAction createAction = new AbstractAction("createAction"){

            public void actionPerformed(ActionEvent e) {
                if (PFullSizePageView.this.getViewer().getGdv().getCurrentMode() == 112) {
                    Rectangle vRect = new Rectangle(0, 0, 25, 25);
                    PFullSizePageView.this.setSelectAreaRectangle(vRect);
                }
                if (PFullSizePageView.this.getViewer().getGdv().getCurrentMode() == 113) {
                    PFullSizePageView.this.selectTextCursor.createAction();
                }
            }
        };
        AbstractAction popupAction = new AbstractAction("popupAction"){

            public void actionPerformed(ActionEvent e) {
                PFullSizePageView.this.invokePopupMenu();
            }
        };
        AbstractAction moveLeftAction = new AbstractAction("moveLeftAction"){

            public void actionPerformed(ActionEvent e) {
                PFullSizePageView.this.selectTextCursor.moveLeft();
            }
        };
        AbstractAction moveRightAction = new AbstractAction("moveRightAction"){

            public void actionPerformed(ActionEvent e) {
                PFullSizePageView.this.selectTextCursor.moveRight();
            }
        };
        AbstractAction resizeLeftAction = new AbstractAction("resizeLeftAction"){

            public void actionPerformed(ActionEvent e) {
                PFullSizePageView.this.selectTextCursor.resizeLeft();
            }
        };
        AbstractAction resizeRightAction = new AbstractAction("resizeRightAction"){

            public void actionPerformed(ActionEvent e) {
                PFullSizePageView.this.selectTextCursor.resizeRight();
            }
        };
        AbstractAction ignoreAction = new AbstractAction("ignoreAction"){

            public void actionPerformed(ActionEvent e) {
            }
        };
        KeyBinding[] bindings = new KeyBinding[]{new KeyBinding(createAction, KeyStroke.getKeyStroke(113, 8, false)), new KeyBinding(popupAction, KeyStroke.getKeyStroke(121, 1, false)), new KeyBinding(moveLeftAction, KeyStroke.getKeyStroke(37, 8, false)), new KeyBinding(moveRightAction, KeyStroke.getKeyStroke(39, 8, false)), new KeyBinding(resizeLeftAction, KeyStroke.getKeyStroke(37, 1, false)), new KeyBinding(resizeRightAction, KeyStroke.getKeyStroke(39, 1, false)), new KeyBinding(ignoreAction, KeyStroke.getKeyStroke(38, 8, false)), new KeyBinding(ignoreAction, KeyStroke.getKeyStroke(40, 8, false)), new KeyBinding(ignoreAction, KeyStroke.getKeyStroke(38, 1, false)), new KeyBinding(ignoreAction, KeyStroke.getKeyStroke(40, 1, false))};
        this.commonBindings = bindings;
    }

    private void registerKeyBindings() {
        for (KeyBinding binding : this.commonBindings) {
            this.getInputMap(1).put(binding.key, binding.action.getValue("Name"));
            this.getInputMap(2).put(binding.key, binding.action.getValue("Name"));
            this.getActionMap().put(binding.action.getValue("Name"), binding.action);
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent mEvent) {
    }

    public void mouseClicked(MouseEvent event) {
        MouseEvent mEvent;
        this.popupPoint = null;
        if (event.getClickCount() == 2) {
            return;
        }
        if (this.getViewer() != null && this.getViewer().getGdv() != null && this.getViewer().getGdv().getCurrentMode() == 113) {
            if ((event.getModifiers() & 4) == 4) {
                if (this.isShowing()) {
                    mEvent = SwingUtilities.convertMouseEvent((JComponent)event.getSource(), event, this);
                    if (event.getSource() == this) {
                        this.popupPoint = event.getPoint();
                        this.showPopupMenu(mEvent, this.pagePopupMenu);
                        event.consume();
                        return;
                    }
                }
            } else {
                this.selectTextCursor.dot = -1;
                this.selectTextCursor.mark = -1;
                this.getViewer().getGdv().setSelectedAnnotationTool(0);
                event.consume();
                return;
            }
        }
        if (this.getDocModel() == null) {
            return;
        }
        if (this.getDocModel().isActiveDocument() && event.getSource().equals(this)) {
            this.requestFocus();
        }
        if (this.isShowing()) {
            mEvent = SwingUtilities.convertMouseEvent((JComponent)event.getSource(), event, this);
            if ((mEvent.getModifiers() & 4) == 4) {
                if (this.isPointinAnnotation(event)) {
                    this.popupPoint = event.getPoint();
                    return;
                }
                if (event.getSource() == this) {
                    this.popupPoint = event.getPoint();
                    this.showPopupMenu(mEvent, this.pagePopupMenu);
                } else {
                    this.showPopupMenu(mEvent, this.doctabPopupMenu);
                }
            }
            if (this.resizeHandles != null) {
                this.resizeHandles.setVisible(false);
            }
            this.revalidate();
            return;
        }
    }

    public void focusGained(FocusEvent event) {
        if (!event.isTemporary()) {
            this.setBorder(BorderFactory.createLineBorder(this.getViewSelected(), 3));
        }
    }

    public void focusLost(FocusEvent event) {
        if (!event.isTemporary()) {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    void scalePoint(Point p) {
        if (this.annView != null) {
            double scaler = 1.0 / this.annView.getScale() / this.annView.getModel().getScaleFactor();
            p.x = (int)((double)p.x * scaler);
            p.y = (int)((double)p.y * scaler);
        }
    }

    void rotatePoint(Point p, int width, int height, int pageNumber) {
        int oldx = p.x;
        int oldy = p.y;
        CMBAnnotationSet annModel = this.annView.getModel();
        PPageModel thePageModel = (PPageModel)this.getDocModel();
        CMBPage page = thePageModel.getPage(pageNumber);
        switch (page.getRotation()) {
            case 0: {
                break;
            }
            case 1: {
                p.x = oldy;
                p.y = (int)(page.getHeight() * (double)page.getPageResolution()) - (oldx + width);
                break;
            }
            case 2: {
                p.x = (int)(page.getWidth() * (double)page.getPageResolution()) - (oldx + width);
                p.y = (int)(page.getHeight() * (double)page.getPageResolution()) - (oldy + height);
                break;
            }
            case 3: {
                p.x = (int)(page.getWidth() * (double)page.getPageResolution()) - (oldy + height);
                p.y = oldx;
            }
        }
    }

    private boolean isPointinAnnotation(MouseEvent mEvent) {
        if (this.annView == null) {
            return false;
        }
        CMBAnnotationSet annModel = this.annView.getModel();
        if (annModel == null) {
            return false;
        }
        int pageNumber = ((PPageModel)this.getDocModel()).getCurrentPageNumber();
        Iterator i = annModel.getIterator(pageNumber);
        Point p = mEvent.getPoint();
        double scaler = 1.0 / (this.getScale() * annModel.getScaleFactor());
        p.x = (int)((double)p.x * scaler);
        p.y = (int)((double)p.y * scaler);
        while (i.hasNext()) {
            CMBPageAnnotation a = (CMBPageAnnotation)i.next();
            if (!a.isShowing() || !a.contains(p)) continue;
            return true;
        }
        return false;
    }

    void dispose() {
        this.getDocModel().removeDocStateChangedListener(this);
        if (this.getViewer().getGdv().getAnnotationServices() != null) {
            this.getViewer().getGdv().getAnnotationServices().removeAnnotationToolListener(this);
            if (this.getAnnotationView() != null) {
                this.getAnnotationView().getModel().removeAnnSelectedListener(this);
                this.getAnnotationView().dispose();
                this.annView = null;
            }
        }
        if (this.currentPageImage != null) {
            this.currentPageImage.flush();
            this.currentPageImage = null;
        }
        if (((PPageModel)this.getDocModel()).activeFullSizeView == this) {
            ((PPageModel)this.getDocModel()).activeFullSizeView = null;
        }
        super.dispose();
    }

    private void showPopupMenu(MouseEvent e, JPopupMenu popupMenu) {
        if (popupMenu != null) {
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void invokePopupMenu() {
        if (this.pagePopupMenu != null) {
            this.pagePopupMenu.show(this, 0, 0);
            this.popupPoint = new Point(0, 0);
        }
    }

    public void mousePressed(MouseEvent event) {
        if (event.getSource() != this) {
            return;
        }
        this.requestFocus();
        if (this.getViewer().getGdv().getCurrentMode() == 111) {
            return;
        }
        if (this.getViewer().getGdv().getCurrentMode() == 113) {
            this.findTextCursorActive = false;
            return;
        }
        this.originalPoint = event.getPoint();
        if (this.resizeHandles != null) {
            this.resizeHandles.setVisible(false);
        }
        event.consume();
    }

    public void mouseReleased(MouseEvent event) {
        if (event.getSource() != this) {
            return;
        }
        if (this.getViewer().getGdv().getCurrentMode() == 111) {
            return;
        }
        if (this.getViewer().getGdv().getCurrentMode() == 113) {
            return;
        }
        this.setSelectAreaRectangle(this.dragRect);
        event.consume();
    }

    public void mouseDragged(MouseEvent event) {
        if (event.getSource() != this) {
            return;
        }
        if (this.getViewer().getGdv().getCurrentMode() == 111) {
            return;
        }
        if (this.getViewer().getGdv().getCurrentMode() == 113) {
            return;
        }
        Point newPoint = event.getPoint();
        if (this.justStartedDragging) {
            this.paintImmediately(this.dragRect);
            this.drawRectInXOR();
            this.justStartedDragging = false;
        }
        this.drawRectInXOR();
        this.dragRect.setLocation(Math.min(this.originalPoint.x, newPoint.x), Math.min(this.originalPoint.y, newPoint.y));
        this.dragRect.setSize(Math.abs(newPoint.x - this.originalPoint.x), Math.abs(newPoint.y - this.originalPoint.y));
        this.drawRectInXOR();
        event.consume();
    }

    void drawRectInXOR() {
        Graphics g = this.getGraphics();
        g.setXORMode(Color.white);
        this.drawSelectArea(g);
        g.setPaintMode();
    }

    public void mouseMoved(MouseEvent event) {
    }

    Image getSubImage() throws CMBViewerException {
        Rectangle rect = null;
        if (this.resizeHandles != null) {
            rect = this.resizeHandles.getSelectedRect();
        }
        return this.getSubImage(rect);
    }

    Image getSubImage(Rectangle subImageRectangle) throws CMBViewerException {
        if (subImageRectangle == null) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.invalidSelectAreaRectangle", new Object[]{subImageRectangle}));
        }
        BufferedImage pageImage = new BufferedImage(this.getImageWidth(), this.getImageHeight(), 1);
        BufferedImage subImage = null;
        Graphics2D pageImageG2D = pageImage.createGraphics();
        try {
            if (((PPageModel)this.getDocModel()).useDrawPage(this.pageNumber)) {
                pageImageG2D.setClip(0, 0, this.getImageWidth(), this.getImageHeight());
                ((PPageModel)this.getDocModel()).drawPage(this.pageNumber, pageImageG2D);
            } else {
                pageImageG2D.drawImage(this.currentPageImage, 0, 0, this);
            }
        }
        catch (IOException e) {
            throw new CMBViewerException(e.getMessage(), (Object)e);
        }
        if (this.annView != null) {
            this.annView.paintAnnotations(pageImageG2D, ((PPageModel)this.getDocModel()).getCurrentPageNumber(), true);
        }
        Rectangle pageImageRectangle = new Rectangle(0, 0, this.getImageWidth(), this.getImageHeight());
        Rectangle rectWithinBounds = pageImageRectangle.intersection(subImageRectangle);
        subImage = pageImage.getSubimage(rectWithinBounds.x, rectWithinBounds.y, rectWithinBounds.width, rectWithinBounds.height);
        pageImage.flush();
        pageImage = null;
        return subImage;
    }

    void setSelectAreaRectangle(Rectangle rect) throws IllegalArgumentException {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        if (this.resizeHandles == null) {
            this.resizeHandles = new PResizeHandles(rect.x, rect.y, rect.width, rect.height);
            this.resizeHandles.setNextFocusableComponent(this);
            this.add(this.resizeHandles);
            this.resizeHandles.setVisible(true);
        }
        if (this.selectAreaPopupMenu != null) {
            this.resizeHandles.setPopupMenu(this.selectAreaPopupMenu);
        }
        this.resizeHandles.setSelectedRect(rect);
        this.resizeHandles.setVisible(true);
        this.resizeHandles.requestFocus();
        this.dragRect.setBounds(0, 0, 0, 0);
        this.repaint();
        this.getDocModel().fireDocStateChangedEvent(11);
    }

    Rectangle getSelectAreaRectangle() {
        if (this.resizeHandles != null && this.resizeHandles.isVisible() && this.getViewer().getGdv().getCurrentMode() == 112) {
            return (Rectangle)this.resizeHandles.getSelectedRect().clone();
        }
        return new Rectangle(0, 0, 0, 0);
    }

    boolean canFitHeight() {
        PPageModel pmodel = (PPageModel)this.getDocModel();
        try {
            if (pmodel.getCurrentPagePosition() <= 0) {
                return false;
            }
            return pmodel.getScale() != pmodel.getScaleToFit(pmodel.getCurrentPageNumber(), this.getViewDimension(), this.getVScrollBarWidth(), this.getHScrollBarHeight(), 2);
        }
        catch (IOException e) {
            return false;
        }
    }

    boolean canFitWidth() {
        PPageModel pmodel = (PPageModel)this.getDocModel();
        try {
            if (pmodel.getCurrentPagePosition() <= 0) {
                return false;
            }
            return pmodel.getScale() != pmodel.getScaleToFit(pmodel.getCurrentPageNumber(), this.getViewDimension(), this.getVScrollBarWidth(), this.getHScrollBarHeight(), 1);
        }
        catch (IOException e) {
            return false;
        }
    }

    boolean canFitInWindow() {
        PPageModel pmodel = (PPageModel)this.getDocModel();
        try {
            if (pmodel.getCurrentPagePosition() <= 0) {
                return false;
            }
            return pmodel.getScale() != pmodel.getScaleToFit(pmodel.getCurrentPageNumber(), this.getViewDimension(), this.getVScrollBarWidth(), this.getHScrollBarHeight(), 3);
        }
        catch (IOException e) {
            return false;
        }
    }

    boolean canFitActualSize() {
        PPageModel pmodel = (PPageModel)this.getDocModel();
        if (pmodel.getCurrentPagePosition() <= 0) {
            return false;
        }
        boolean value = false;
        if (pmodel.getScale() != 1.0 && 1.0 <= pmodel.getCurrMaxScale() && 1.0 >= pmodel.getCurrMinScale()) {
            value = true;
        }
        return value;
    }

    void setViewRectangleLocation(int x, int y) {
        this.viewRectangle.x = x;
        this.viewRectangle.y = y;
    }

    void setViewFit(int fit) {
        this.fit = fit;
    }

    void setViewScale(double scale) {
        this.scale = scale;
        if (scale == 1.0) {
            this.setViewFit(4);
        } else {
            this.setViewFit(0);
        }
    }

    void fitHeight() {
        PDocModel model = this.getDocModel();
        if (model != null && model instanceof PPageModel) {
            ((PPageModel)model).fitHeight(this.getViewDimension(), this.getVScrollBarWidth(), this.getHScrollBarHeight());
        }
    }

    void fitWidth() {
        PDocModel model = this.getDocModel();
        if (model != null && model instanceof PPageModel) {
            ((PPageModel)model).fitWidth(this.getViewDimension(), this.getVScrollBarWidth(), this.getHScrollBarHeight());
        }
    }

    void fitInWindow() {
        PDocModel model = this.getDocModel();
        if (model != null && model instanceof PPageModel) {
            ((PPageModel)model).fitInWindow(this.getViewDimension(), this.getVScrollBarWidth(), this.getHScrollBarHeight());
        }
    }

    void fitActualSize() {
        PDocModel model = this.getDocModel();
        if (model != null && model instanceof PPageModel) {
            ((PPageModel)model).fitActualSize();
        }
    }

    int getFit() {
        PDocModel model = this.getDocModel();
        if (model != null && model instanceof PPageModel) {
            return ((PPageModel)model).getFit();
        }
        return 0;
    }

    boolean canScale() {
        boolean value = false;
        if (this.getDocModel() != null) {
            value = this.getDocModel().canScale();
        }
        return value;
    }

    boolean canZoomIn() {
        boolean value = false;
        if (this.getDocModel() != null) {
            value = !this.getDocModel().isMaxZoomedIn();
        }
        return value;
    }

    boolean canZoomOut() {
        boolean value = false;
        if (this.getDocModel() != null) {
            value = !this.getDocModel().isMaxZoomedOut();
        }
        return value;
    }

    void zoomInOtherView() {
        double newscale = this.scale + this.scale * this.getDocModel().getZoomFactor();
        this.setViewScale(newscale);
    }

    void zoomOutOtherView() {
        double newscale = this.scale / (1.0 + this.getDocModel().getZoomFactor());
        this.setViewScale(newscale);
    }

    void zoomIn() {
        PDocModel model = this.getDocModel();
        if (model != null && model instanceof PPageModel) {
            ((PPageModel)model).zoomIn();
        }
    }

    void zoomOut() {
        PDocModel model = this.getDocModel();
        if (model != null && model instanceof PPageModel) {
            ((PPageModel)model).zoomOut();
        }
    }

    double getScale() {
        PDocModel model = this.getDocModel();
        if (model != null) {
            return model.getScale();
        }
        throw new UnsupportedOperationException();
    }

    void setScale(double newScale) throws UnsupportedOperationException {
        PDocModel model = this.getDocModel();
        if (model == null) {
            throw new UnsupportedOperationException();
        }
        model.setScale(newScale);
    }

    private Dimension getViewDimension() {
        if (this.getParent() == null) {
            return new Dimension(0, 0);
        }
        if (!(this.getParent().getParent() instanceof JScrollPane)) {
            return this.getSize();
        }
        JScrollPane scrollPane = (JScrollPane)this.getParent().getParent();
        JScrollBar horizontalScrollBar = scrollPane.getHorizontalScrollBar();
        JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
        int viewHt = scrollPane.getViewport().getHeight();
        if (horizontalScrollBar.isVisible()) {
            viewHt += horizontalScrollBar.getHeight();
        }
        int viewWd = scrollPane.getViewport().getWidth();
        if (verticalScrollBar.isVisible()) {
            viewWd += verticalScrollBar.getWidth();
        }
        return new Dimension(viewWd, viewHt);
    }

    private int getVScrollBarWidth() {
        if (this.getParent() == null) {
            return 0;
        }
        if (!(this.getParent().getParent() instanceof JScrollPane)) {
            return 0;
        }
        JScrollPane scrollPane = (JScrollPane)this.getParent().getParent();
        JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
        return verticalScrollBar.getPreferredSize().width;
    }

    private int getHScrollBarHeight() {
        if (this.getParent() == null) {
            return 0;
        }
        if (!(this.getParent().getParent() instanceof JScrollPane)) {
            return 0;
        }
        JScrollPane scrollPane = (JScrollPane)this.getParent().getParent();
        JScrollBar horizontalScrollBar = scrollPane.getHorizontalScrollBar();
        return horizontalScrollBar.getPreferredSize().height;
    }

    public void componentHidden(ComponentEvent arg0) {
    }

    public void componentMoved(ComponentEvent arg0) {
    }

    public void componentResized(ComponentEvent arg0) {
        this.refit();
        this.display();
    }

    public void componentShown(ComponentEvent arg0) {
        if (this.getDocModel() == null || this.getDocModel().getDocument() == null) {
            return;
        }
        this.refit();
        this.display();
    }

    public void annotationSelected(CMBAnnotationSelectedEvent evt) {
        if (evt.getAnnotation() == null) {
            for (KeyBinding binding : this.commonBindings) {
                if (binding.action.getValue("Name") != "popupAction") continue;
                this.getInputMap(2).put(binding.key, binding.action.getValue("Name"));
                this.getInputMap(1).put(binding.key, binding.action.getValue("Name"));
                this.getInputMap(0).put(binding.key, binding.action.getValue("Name"));
                this.getActionMap().put(binding.action.getValue("Name"), binding.action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
        String methodName = "genericDocStateChanged";
        if (!this.isSelectedView() && evt.getChangeType() != 3 && evt.getChangeType() != 5 && evt.getChangeType() != 4 && evt.getChangeType() != 15 && evt.getChangeType() != 14 && evt.getChangeType() != 16 && evt.getChangeType() != 19 && evt.getChangeType() != 1 && evt.getChangeType() != 17) {
            return;
        }
        if (evt.getChangeType() == 10) {
            this.selectTextCursor.reset();
            if (this.resizeHandles != null) {
                this.resizeHandles.setVisible(false);
            }
            this.revalidate();
        }
        if (evt.getChangeType() == 11) {
            int mode = this.getViewer().getGdv().getCurrentMode();
            if (mode == 112) {
                this.selectTextCursor.reset();
            }
            if (mode == 113) {
                if (this.resizeHandles != null) {
                    this.resizeHandles.setVisible(false);
                }
                this.revalidate();
            }
        }
        if (evt.getChangeType() == 1) {
            this.selectTextCursor.reset();
        }
        if (evt.getChangeType() == 21) {
            this.findTextCursorActive = true;
        } else if (evt.getChangeType() == 20) {
            this.findTextCursorActive = false;
        }
        if (this.inGenericDocStateChanged) {
            return;
        }
        this.inGenericDocStateChanged = true;
        try {
            block21: {
                try {
                    if (!this.isDisplayNeeded() || evt.getChangeType() == 2 || evt.getChangeType() == 10) break block21;
                    if (evt.getChangeType() == 1) {
                        this.viewRectangle = ((PPageModel)this.getDocModel()).getCurrentViewRectangle();
                        if (this.annView != null) {
                            this.annView.setCurrentPage(evt.getCurrentPageNumber());
                            this.annView.setScale(this.getDocModel().getScale());
                        }
                    }
                    if (evt.getChangeType() == 9) {
                        this.viewRectangle = ((PPageModel)this.getDocModel()).getCurrentViewRectangle();
                        if (this.viewRectangle != null) {
                            this.scrollRectToVisible(((PPageModel)this.getDocModel()).getCurrentViewRectangle());
                        }
                    }
                    if (evt.getChangeType() == 3 || evt.getChangeType() == 1 || evt.getChangeType() == 15 || evt.getChangeType() == 14 || evt.getChangeType() == 16) {
                        this.refit();
                    }
                    this.display();
                }
                catch (Exception e) {
                    ViewerLogger.logError((Object)this, methodName, e);
                    JOptionPane.showMessageDialog(this, PViewerUtilities.getMessage("DocumentViewer.unexpectedError"), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0);
                    Object var5_6 = null;
                    this.inGenericDocStateChanged = false;
                }
            }
            Object var5_5 = null;
            this.inGenericDocStateChanged = false;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.inGenericDocStateChanged = false;
            throw throwable;
        }
    }

    public void stateChanged(ChangeEvent cEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (PFullSizePageView.this.getDocModel() != null) {
                    PFullSizePageView.this.setCurrentViewRect();
                }
            }
        });
    }

    public void setViewStateIntoModel() {
        if (this.containsViewSpecificValues) {
            if (!this.isSelectedView()) {
                this.getDocModel().setFireChangeEvents(false);
            }
            try {
                this.getDocModel().setCurrentPageNumber(this.pageNumber);
                if (this.fit == 4) {
                    this.getDocModel().fitActualSize();
                } else if (this.fit == 2) {
                    this.fitHeight();
                } else if (this.fit == 3) {
                    this.fitInWindow();
                } else if (this.fit == 1) {
                    this.fitWidth();
                } else {
                    this.getDocModel().setScale(this.scale);
                }
                ((PPageModel)this.getDocModel()).setCurrentViewRectangle(this.viewRectangle);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            this.getDocModel().setFireChangeEvents(true);
        }
    }

    public boolean isSelectedView() {
        return this == this.getViewer().getGdv().getSelectedView();
    }

    public boolean isOtherView() {
        return this == this.getViewer().getGdv().getOtherView();
    }

    public void annotationToolChanged(CMBSelectedAnnotationToolChangedEvent e) {
        int mode = this.getViewer().getGdv().getCurrentMode();
        if (mode == 111) {
            if (this.resizeHandles != null) {
                this.resizeHandles.setVisible(false);
            }
            if (this.selectTextCursor != null) {
                this.selectTextCursor.reset();
            }
            this.revalidate();
        } else if (mode == 112) {
            this.registerKeyBindings();
        } else if (mode == 113) {
            this.registerKeyBindings();
            if (this.resizeHandles != null) {
                this.resizeHandles.setVisible(false);
            }
        }
    }

    public boolean canFind() {
        return ((PPageModel)this.getDocModel()).canFind();
    }

    public boolean find(String text, boolean matchCase, boolean reverse) {
        return ((PPageModel)this.getDocModel()).find(text, matchCase, reverse);
    }

    public int getPageNumber() {
        if (this.pageNumber == 0) {
            this.pageNumber = ((PPageModel)this.getDocModel()).getCurrentPageNumber();
        }
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleFullSizePageView();
        }
        return this.accessibleContext;
    }

    public String toString() {
        String s = PViewerUtilities.showName(this);
        s = s + " scale: " + this.scale;
        s = s + " page number: " + this.pageNumber;
        s = s + " fit: " + this.fit;
        s = s + " view rect: " + this.viewRectangle;
        return s + super.toString();
    }

    private String getSelectedText() {
        return this.selectTextCursor.getSelectedText();
    }

    public boolean isTextSelected() {
        if (this.selectTextCursor == null) {
            return false;
        }
        return this.getSelectedText() != null && this.getSelectedText().length() > 0 || this.isHitActive();
    }

    public void copyTextToClipboard() {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(this.getSelectedText());
        systemClipboard.setContents(contents, null);
    }

    private class SelectTextCursor
    implements MouseListener,
    MouseMotionListener {
        PFullSizePageView viewComponent;
        Point dotPoint = null;
        Point markPoint = null;
        int dot = -1;
        int mark = -1;
        Polygon selectedPolygon = null;
        int drawcnt = 0;
        double scalex = 1.0;
        double scaley = 1.0;
        double scalem = 1.0;
        private boolean isVisible = false;
        private boolean isAdjusting = false;

        public SelectTextCursor(PFullSizePageView viewComponent) {
            this.viewComponent = viewComponent;
        }

        void createAction() {
            int dot = 0;
            int mark = 0;
            if (PFullSizePageView.this.selectTextCursor.validLetterRequest(dot, mark)) {
                PFullSizePageView.this.selectTextCursor.setSelectedPolygon(dot, mark);
            }
        }

        void moveLeft() {
            if (PFullSizePageView.this.getViewer().getGdv().getCurrentMode() == 113 && this.validLetterRequest(this.dot - 1, this.mark - 1)) {
                this.setSelectedPolygon(this.dot - 1, this.mark - 1);
            }
        }

        void moveRight() {
            if (PFullSizePageView.this.getViewer().getGdv().getCurrentMode() == 113 && this.validLetterRequest(this.dot + 1, this.mark + 1)) {
                this.setSelectedPolygon(this.dot + 1, this.mark + 1);
            }
        }

        void resizeLeft() {
            if (PFullSizePageView.this.getViewer().getGdv().getCurrentMode() == 113 && this.validLetterRequest(this.dot, this.mark - 1)) {
                this.setSelectedPolygon(this.dot, this.mark - 1);
            }
        }

        void resizeRight() {
            if (PFullSizePageView.this.getViewer().getGdv().getCurrentMode() == 113 && this.validLetterRequest(this.dot, this.mark + 1)) {
                this.setSelectedPolygon(this.dot, this.mark + 1);
            }
        }

        Position.Bias getDirection() {
            if (this.dotPoint == null || this.markPoint == null) {
                return Position.Bias.Forward;
            }
            if (this.dotPoint.x == this.markPoint.x) {
                if (this.markPoint.y < this.dotPoint.y) {
                    return Position.Bias.Backward;
                }
                return Position.Bias.Forward;
            }
            if (this.dotPoint.x < this.markPoint.x) {
                if (this.markPoint.y < this.dotPoint.y) {
                    return Position.Bias.Backward;
                }
                return Position.Bias.Forward;
            }
            if (this.dotPoint.x > this.markPoint.x) {
                if (this.markPoint.y > this.dotPoint.y) {
                    return Position.Bias.Forward;
                }
                return Position.Bias.Backward;
            }
            return Position.Bias.Forward;
        }

        void drawSelectedPolygon(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.selectedPolygon != null) {
                Color oldColor = g2.getColor();
                Composite oldComposite = g2.getComposite();
                Color c = UIManager.getColor("TextPane.selectionBackground");
                Color y = new Color(c.getRed(), c.getGreen(), c.getBlue(), 128);
                g2.setColor(y);
                g2.setXORMode(Color.white);
                g2.fillPolygon(this.getScaledPolygon());
                g2.setColor(oldColor);
                g2.setComposite(oldComposite);
                g2.setPaintMode();
            }
        }

        void reset() {
            if (this.selectedPolygon != null && this.isVisible()) {
                this.setVisible(false);
                this.drawSelectedPolygon(this.viewComponent.getGraphics());
            }
            this.selectedPolygon = null;
            this.dot = -1;
            this.mark = -1;
            this.dotPoint = null;
            this.markPoint = null;
            this.isVisible = false;
            this.isAdjusting = false;
        }

        Polygon getScaledPolygon() {
            PPageModel pageModel = (PPageModel)this.viewComponent.getDocModel();
            return pageModel.getScaledPolygon(this.selectedPolygon);
        }

        void setSelectedPolygon(int dot, int mark) {
            this.dot = dot;
            this.mark = mark;
            Graphics g = this.viewComponent.getGraphics();
            if (this.selectedPolygon != null && this.isVisible()) {
                this.setVisible(false);
                this.drawSelectedPolygon(g);
            }
            this.selectedPolygon = this.getSelectedPolygon();
            this.setVisible(true);
            this.drawSelectedPolygon(g);
            this.viewComponent.getDocModel().fireDocStateChangedEvent(20);
        }

        Polygon getSelectedPolygon() {
            if (this.dot == -1) {
                return null;
            }
            try {
                CMBPage currPage = this.viewComponent.getDocModel().getDocument().getPage(this.viewComponent.pageNumber);
                CMBLetters letters = currPage.getLetters();
                return letters.getPolygonBounds(this.dot, this.mark);
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        boolean validLetterRequest(int start, int end) {
            boolean valid = true;
            try {
                CMBPage currPage = this.viewComponent.getDocModel().getDocument().getPage(this.viewComponent.pageNumber);
                CMBLetters letters = currPage.getLetters();
                letters.get(start);
                letters.get(end);
            }
            catch (Exception e) {
                valid = false;
            }
            return valid;
        }

        String getSelectedText() {
            String methodName = "getSelectedText";
            String s = null;
            try {
                if (this.viewComponent.getDocModel() != null && ((PPageModel)this.viewComponent.getDocModel()).isValidPagePosition(this.viewComponent.pageNumber)) {
                    CMBPage currPage = this.viewComponent.getDocModel().getDocument().getPage(this.viewComponent.pageNumber);
                    if (PFullSizePageView.this.getViewer().getGdv().getCurrentMode() != 113 && currPage.matchResults == null) {
                        return null;
                    }
                    CMBLetters letters = currPage.getLetters();
                    if (letters != null && this.validLetterRequest(this.dot, this.mark)) {
                        s = letters.getSelectedText(this.dot, this.mark);
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
            catch (IOException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
            catch (BadLocationException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
            return s;
        }

        public String toString() {
            String s = PViewerUtilities.showName(this) + " ";
            return s + super.toString();
        }

        public boolean isAdjusting() {
            return this.isAdjusting;
        }

        public void setAdjusting(boolean isAdjusting) {
            this.isAdjusting = isAdjusting;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public void setVisible(boolean isVisible) {
            this.isVisible = isVisible;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            String methodName = "mousePressed";
            if (e.isConsumed()) {
                return;
            }
            if (this.viewComponent.getViewer().getGdv().getCurrentMode() == 111) {
                return;
            }
            if (this.viewComponent.getViewer().getGdv().getCurrentMode() == 112) {
                return;
            }
            if ((e.getModifiers() & 4) == 4) {
                return;
            }
            Graphics g = this.viewComponent.getGraphics();
            PPageModel pageModel = (PPageModel)this.viewComponent.getDocModel();
            this.scalex = pageModel.getScale() * pageModel.getDisplayResolution() / pageModel.getPageXResolution(pageModel.getCurrentPageNumber());
            this.scaley = pageModel.getScale() * pageModel.getDisplayResolution() / pageModel.getPageYResolution(pageModel.getCurrentPageNumber());
            this.scalem = pageModel.getScale();
            int x = (int)((double)e.getPoint().x * 1.0 / this.scalex);
            int y = (int)((double)e.getPoint().y * 1.0 / this.scaley);
            Point newPoint = new Point(x, y);
            try {
                CMBPage currPage = this.viewComponent.getDocModel().getDocument().getPage(this.viewComponent.pageNumber);
                CMBLetters letters = currPage.getLetters();
                if (letters == null || letters.getLetters() == null || letters.getLetters().length == 0) {
                    return;
                }
                int position = letters.indexOf(newPoint);
                this.setAdjusting(true);
                this.dot = -1;
                this.mark = -1;
                this.dot = position;
                this.mark = position;
                this.dotPoint = newPoint;
                this.markPoint = newPoint;
                if (this.selectedPolygon != null && this.isVisible()) {
                    this.setVisible(false);
                    this.drawSelectedPolygon(g);
                }
            }
            catch (IndexOutOfBoundsException e1) {
                ViewerLogger.logError((Object)this, methodName, e1);
            }
            catch (IOException e1) {
                ViewerLogger.logError((Object)this, methodName, e1);
            }
        }

        public void mouseReleased(MouseEvent e) {
            String methodName = "mouseReleased";
            if (e.isConsumed()) {
                return;
            }
            if (this.viewComponent.getViewer().getGdv().getCurrentMode() == 111) {
                return;
            }
            if (this.viewComponent.getViewer().getGdv().getCurrentMode() == 112) {
                return;
            }
            if ((e.getModifiers() & 4) == 4) {
                return;
            }
            Graphics g = this.viewComponent.getGraphics();
            int x = (int)((double)e.getPoint().x * 1.0 / this.scalex);
            int y = (int)((double)e.getPoint().y * 1.0 / this.scaley);
            Point newPoint = new Point(x, y);
            try {
                CMBPage currPage = this.viewComponent.getDocModel().getDocument().getPage(this.viewComponent.pageNumber);
                CMBLetters letters = currPage.getLetters();
                if (letters == null || letters.getLetters() == null || letters.getLetters().length == 0) {
                    return;
                }
                this.markPoint = newPoint;
                int position = letters.indexOf(newPoint, this.dotPoint, this.getDirection());
                if (position == this.dot) {
                    this.reset();
                    return;
                }
                if (position >= 0) {
                    this.mark = position;
                }
                if (this.mark < 0 || this.dot < 0) {
                    this.reset();
                    return;
                }
                if (this.selectedPolygon != null && this.isVisible()) {
                    this.setVisible(false);
                    this.drawSelectedPolygon(g);
                }
                this.selectedPolygon = this.getSelectedPolygon();
                this.setAdjusting(false);
                this.setVisible(true);
                this.drawSelectedPolygon(g);
            }
            catch (IndexOutOfBoundsException e1) {
                ViewerLogger.logError((Object)this, methodName, e1);
            }
            catch (IOException e1) {
                ViewerLogger.logError((Object)this, methodName, e1);
            }
            this.viewComponent.getDocModel().fireDocStateChangedEvent(20);
        }

        public void mouseDragged(MouseEvent e) {
            String methodName = "mouseDragged";
            if (e.isConsumed()) {
                return;
            }
            if (this.viewComponent.getViewer().getGdv().getCurrentMode() == 111) {
                return;
            }
            if (this.viewComponent.getViewer().getGdv().getCurrentMode() == 112) {
                return;
            }
            if ((e.getModifiers() & 4) == 4) {
                return;
            }
            Graphics g = this.viewComponent.getGraphics();
            int x = (int)((double)e.getPoint().x * 1.0 / this.scalex);
            int y = (int)((double)e.getPoint().y * 1.0 / this.scaley);
            Point newPoint = new Point(x, y);
            try {
                CMBPage currPage = this.viewComponent.getDocModel().getDocument().getPage(this.viewComponent.pageNumber);
                CMBLetters letters = currPage.getLetters();
                if (letters == null || letters.getLetters() == null || letters.getLetters().length == 0) {
                    return;
                }
                this.markPoint = newPoint;
                int position = letters.indexOf(newPoint, this.dotPoint, this.getDirection());
                if (position >= 0) {
                    if (this.dot == -1) {
                        this.dot = letters.indexOf(this.dotPoint);
                        this.dot = this.getDirection() == Position.Bias.Backward ? letters.indexOf(this.dotPoint, this.markPoint, Position.Bias.Forward) : letters.indexOf(this.dotPoint, this.markPoint, Position.Bias.Backward);
                    }
                    if (this.mark != position) {
                        this.mark = this.getDirection() == Position.Bias.Forward ? (position >= this.dot ? position : this.dot) : (position <= this.dot ? position : this.dot);
                        if (this.selectedPolygon != null && this.isVisible()) {
                            this.setVisible(false);
                            this.drawSelectedPolygon(g);
                        }
                        this.selectedPolygon = this.getSelectedPolygon();
                        this.setVisible(true);
                        this.drawSelectedPolygon(g);
                    }
                }
            }
            catch (IndexOutOfBoundsException e1) {
                ViewerLogger.logError((Object)this, methodName, e1);
            }
            catch (IOException e1) {
                ViewerLogger.logError((Object)this, methodName, e1);
            }
        }
    }

    class KeyBinding {
        public KeyStroke key;
        public Action action;

        public KeyBinding(Action action, KeyStroke key) {
            this.key = key;
            this.action = action;
        }

        public String toString() {
            return super.toString() + "key: " + this.key.toString() + " action: " + this.action.getValue("Name");
        }
    }

    protected class AccessibleFullSizePageView
    extends PDocView.AccessiblePDocView {
        protected AccessibleFullSizePageView() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST_ITEM;
        }

        public String getAccessibleName() {
            String msgName = PViewerUtilities.getMessage("DocumentViewer.fullSizePageNameText", new Object[]{new Integer(PFullSizePageView.this.getDocModel().getCurrentPageNumber()), new Integer(PFullSizePageView.this.getDocModel().getNumberOfPages()), PViewerUtilities.stripHtml(PFullSizePageView.this.getViewer().getGdv().getDocName(PFullSizePageView.this.getDocModel().getDocument()))});
            this.setAccessibleName(msgName);
            return msgName;
        }
    }
}

