/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocSelectedEvent;
import com.ibm.mm.viewer.CMBGenericDocSelectedListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.POCRQueueItem;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PFindResultsCard
extends JPanel
implements TreeSelectionListener,
CMBGenericDocStateChangedListener {
    private JTree tree;
    private JScrollPane treeView;
    private JButton nextButton = null;
    private JButton prevButton = null;
    private CMBGenericDocViewer viewer = null;
    private ArrayList<CMBDocument> docHits = null;
    private Pattern pattern = null;
    private int[] pageNumbers = null;
    DefaultMutableTreeNode top;
    protected DefaultTreeModel treeModel;
    private static int PROGRESS_MIN = 0;
    private ComponentOrientation compOri = null;
    private Color viewSelected = null;
    ResultsCardFocusTraversalPolicy focusPolicy = new ResultsCardFocusTraversalPolicy();

    public PFindResultsCard(CMBGenericDocViewer viewer, CMBDocument document, int[] pageNumbers, Pattern pattern) {
        super(new BorderLayout());
        this.viewer = viewer;
        this.pattern = pattern;
        this.pageNumbers = pageNumbers;
        this.docHits = new ArrayList();
        this.initialize();
        if (document.isOCRValid() || document.isTextValid()) {
            this.getDocHits(document, pageNumbers);
        } else {
            this.getPageHits(document, pageNumbers);
        }
    }

    public PFindResultsCard(CMBGenericDocViewer viewer, Pattern pattern, CMBDocument document) {
        super(new BorderLayout());
        this.viewer = viewer;
        this.pattern = pattern;
        this.docHits = new ArrayList();
        String methodName = "PFindResultsCard";
        this.initialize();
        if (document.isOCRValid() || document.isTextValid()) {
            this.getDocHits(document);
        } else {
            POCRQueueItem item = new POCRQueueItem(viewer, document, null);
            viewer.ocrQueue.put(item);
            int pageCount = 0;
            try {
                pageCount = document.getPageCount();
            }
            catch (IOException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
            DocOCRProgressBar progressBar = this.createProgressBar(pageCount);
            DefaultMutableTreeNode docnode = new DefaultMutableTreeNode(new DocTreeObject(document, progressBar));
            this.treeModel.insertNodeInto(docnode, this.top, this.top.getChildCount());
            this.treeModel.reload(this.top);
        }
    }

    public PFindResultsCard(CMBGenericDocViewer viewer, Pattern pattern, ArrayList<CMBDocument> docList) {
        super(new BorderLayout());
        this.viewer = viewer;
        this.pattern = pattern;
        this.docHits = new ArrayList();
        String methodName = "PFindResultsCard";
        this.initialize();
        if (docList != null && docList.size() > 0) {
            for (CMBDocument document : docList) {
                if (document.isOCRValid() || document.isTextValid()) {
                    this.getDocHits(document);
                    continue;
                }
                POCRQueueItem item = new POCRQueueItem(viewer, document, null);
                viewer.ocrQueue.put(item);
                int pageCount = 0;
                try {
                    pageCount = document.getPageCount();
                }
                catch (IOException e) {
                    ViewerLogger.logError((Object)this, methodName, e);
                }
                DocOCRProgressBar progressBar = this.createProgressBar(pageCount);
                DefaultMutableTreeNode docnode = new DefaultMutableTreeNode(new DocTreeObject(document, progressBar));
                this.treeModel.insertNodeInto(docnode, this.top, this.top.getChildCount());
                this.treeModel.reload(this.top);
            }
        }
    }

    private void initialize() {
        String msg = PViewerUtilities.getMessage("findPanel.results.title", new Object[]{this.pattern.pattern()});
        JLabel titleLabel = new JLabel(msg);
        this.add((Component)titleLabel, "First");
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(3));
        this.tree = new JTree();
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent arg0) {
                TreePath path = arg0.getPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                DocTreeObject docObject = (DocTreeObject)node.getUserObject();
                docObject.isExpanded = false;
            }

            public void treeExpanded(TreeExpansionEvent arg0) {
                TreePath path = arg0.getPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                DocTreeObject docObject = (DocTreeObject)node.getUserObject();
                docObject.isExpanded = true;
            }
        });
        InputMap iMap = this.tree.getInputMap();
        ActionMap aMap = this.tree.getActionMap();
        ActionMap uiAMap = aMap.getParent();
        uiAMap.remove(iMap.get(KeyStroke.getKeyStroke("ctrl C")));
        uiAMap.remove(iMap.get(KeyStroke.getKeyStroke("ctrl X")));
        uiAMap.remove(iMap.get(KeyStroke.getKeyStroke("ctrl V")));
        titleLabel.setLabelFor(this.tree);
        this.tree.setName("PMatchResultsTree");
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.top = new DefaultMutableTreeNode("Root");
        this.treeModel = new DefaultTreeModel(this.top);
        this.treeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent arg0) {
            }

            public void treeNodesInserted(TreeModelEvent arg0) {
                try {
                    TreePath path = arg0.getTreePath();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    DocTreeObject docObject = (DocTreeObject)node.getUserObject();
                    if (PFindResultsCard.this.tree.isExpanded(path) != docObject.isExpanded) {
                        PFindResultsCard.this.expandNode(node, docObject.isExpanded);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void treeNodesRemoved(TreeModelEvent arg0) {
            }

            public void treeStructureChanged(TreeModelEvent arg0) {
            }
        });
        this.tree.setModel(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setShowsRootHandles(true);
        IndicatorTreeCellRenderer renderer = new IndicatorTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        this.tree.setCellRenderer(renderer);
        this.tree.addTreeSelectionListener(this);
        if (this.docHits != null && this.docHits.size() > 0) {
            for (CMBDocument doc : this.docHits) {
                this.addDocHit(doc);
            }
        }
        this.treeView = new JScrollPane(this.tree){

            public Dimension getPreferredSize() {
                return new Dimension(450, 150);
            }
        };
        this.treeView.getVerticalScrollBar().setFocusable(false);
        this.treeView.getHorizontalScrollBar().setFocusable(false);
        this.treeView.getViewport().setFocusable(false);
        this.tree.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                if (!event.isTemporary() && PFindResultsCard.this.tree != null) {
                    PFindResultsCard.this.tree.setBorder(BorderFactory.createLineBorder(PFindResultsCard.this.getViewSelected(), 3));
                }
            }

            public void focusLost(FocusEvent event) {
                if (!event.isTemporary() && PFindResultsCard.this.tree != null) {
                    PFindResultsCard.this.tree.setBorder(BorderFactory.createEmptyBorder());
                }
            }
        });
        p.add(this.treeView);
        p.add(this.makeButtonPanel());
        this.add((Component)p, "Center");
        this.viewer.addDocStateChangedListener(this);
        this.applyComponentOrientation(this.getCompOri());
    }

    private void expandNode(DefaultMutableTreeNode docnode, boolean expand) {
        TreePath path = new TreePath(this.treeModel.getPathToRoot(docnode));
        if (expand) {
            this.tree.expandPath(path);
        } else {
            this.tree.collapsePath(path);
        }
    }

    public ComponentOrientation getCompOri() {
        if (this.compOri == null) {
            boolean ltr = PViewerUtilities.isLeftToRight();
            this.compOri = ComponentOrientation.LEFT_TO_RIGHT;
            if (!ltr) {
                this.compOri = ComponentOrientation.RIGHT_TO_LEFT;
            }
        }
        return this.compOri;
    }

    private Color getViewSelected() {
        if (this.viewSelected == null) {
            String s = PViewerUtilities.getColorProperty("View.selected.color", this.viewer.getConfigProperties(), SystemColor.controlShadow);
            this.viewSelected = Color.decode(s);
        }
        return this.viewSelected;
    }

    private JPanel makeButtonPanel() {
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(3));
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1, 5, 5));
        panel.add(this.getPrevButton());
        panel.add(this.getNextButton());
        p1.add(panel);
        return p1;
    }

    private void setButtonStates() {
        if (this.tree.getRowCount() > 0) {
            if (this.viewer.ocrQueue.hasDocumentsOCR()) {
                this.nextButton.setEnabled(false);
                this.prevButton.setEnabled(false);
            } else {
                this.nextButton.setEnabled(this.canNextMatch());
                this.prevButton.setEnabled(this.canPrevMatch());
            }
        } else {
            this.nextButton.setEnabled(false);
            this.prevButton.setEnabled(false);
        }
    }

    public JButton getNextButton() {
        if (this.nextButton == null) {
            this.nextButton = new JButton(PViewerUtilities.getMessage("findPanel.button.NextMatch"));
            this.nextButton.setMnemonic(PViewerUtilities.getMessage("findPanel.button.NextMatch.mnemonic").charAt(0));
            this.nextButton.setEnabled(false);
            this.nextButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PFindResultsCard.this.viewer.getCurrentMode() != 111) {
                        PFindResultsCard.this.viewer.setCurrentMode(111);
                    }
                    PFindResultsCard.this.nextMatchAction();
                }
            });
        }
        return this.nextButton;
    }

    private boolean canNextMatch() {
        if (this.tree.getSelectionModel().getSelectionPath() == null) {
            return false;
        }
        DefaultMutableTreeNode docNode = this.getLastDocNodeWithHit();
        if (docNode == null) {
            return false;
        }
        int docNodeIndex = this.tree.getModel().getIndexOfChild(docNode.getParent(), docNode);
        DocTreeObject currDocTreeObject = (DocTreeObject)docNode.getUserObject();
        CMBDocument doc = currDocTreeObject.doc;
        DefaultMutableTreeNode selDocNode = this.getDocNodeFor(this.viewer.getSelectedDocument());
        if (selDocNode == null) {
            return false;
        }
        int selDocNodeIndex = this.tree.getModel().getIndexOfChild(selDocNode.getParent(), selDocNode);
        if (selDocNodeIndex > docNodeIndex) {
            return false;
        }
        if (selDocNodeIndex < docNodeIndex) {
            return true;
        }
        DefaultMutableTreeNode pageNode = this.getLastPageNode(docNode);
        if (pageNode == null) {
            return false;
        }
        PageTreeObject pageTreeObject = (PageTreeObject)pageNode.getUserObject();
        CMBPage page = pageTreeObject.page;
        int pagenumber = this.viewer.getViewer(doc).getDocModel().getCurrentPageNumber();
        if (pagenumber < page.getPageNumber()) {
            return true;
        }
        if (pagenumber > page.getPageNumber()) {
            return false;
        }
        return page.hitIndex + 1 < page.matchResults.size();
    }

    private boolean canPrevMatch() {
        if (this.tree.getSelectionModel().getSelectionPath() == null) {
            return false;
        }
        DefaultMutableTreeNode docNode = this.getFirstDocNodeWithHit();
        if (docNode == null) {
            return false;
        }
        int docNodeIndex = this.tree.getModel().getIndexOfChild(docNode.getParent(), docNode);
        DocTreeObject currDocTreeObject = (DocTreeObject)docNode.getUserObject();
        CMBDocument doc = currDocTreeObject.doc;
        DefaultMutableTreeNode selDocNode = this.getDocNodeFor(this.viewer.getSelectedDocument());
        if (selDocNode == null) {
            return false;
        }
        int selDocNodeIndex = this.tree.getModel().getIndexOfChild(selDocNode.getParent(), selDocNode);
        if (selDocNodeIndex < docNodeIndex) {
            return false;
        }
        if (selDocNodeIndex > docNodeIndex) {
            return true;
        }
        DefaultMutableTreeNode pageNode = this.getFirstPageNode(docNode);
        if (pageNode == null) {
            return false;
        }
        PageTreeObject pageTreeObject = (PageTreeObject)pageNode.getUserObject();
        CMBPage page = pageTreeObject.page;
        int pagenumber = this.viewer.getViewer(doc).getDocModel().getCurrentPageNumber();
        if (pagenumber > page.getPageNumber()) {
            return true;
        }
        if (pagenumber < page.getPageNumber()) {
            return false;
        }
        return page.hitIndex > 0;
    }

    private void nextMatchAction() {
        DefaultMutableTreeNode currDocNode = this.getCurrentDocNode();
        CMBDocument document = this.viewer.getSelectedDocument();
        int pagenumber = this.viewer.getCurrentPageNumber();
        boolean matchCase = (this.pattern.flags() & 2) == 0;
        boolean hitFound = false;
        do {
            if ((hitFound = this.viewer.findOnPage(document, pagenumber, this.pattern.pattern(), matchCase, false, false)) || (currDocNode = this.getNextDocNode(currDocNode)) == null) continue;
            DocTreeObject currDocTreeObject = (DocTreeObject)currDocNode.getUserObject();
            document = currDocTreeObject.doc;
            TreePath path = new TreePath(currDocNode.getPath());
            this.tree.getSelectionModel().setSelectionPath(path);
            pagenumber = 1;
            try {
                CMBPage page = document.getPage(pagenumber);
                page.hitIndex = -1;
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        } while (!hitFound && currDocNode != null);
    }

    private void prevMatchAction() {
        DefaultMutableTreeNode currDocNode = this.getCurrentDocNode();
        CMBDocument document = this.viewer.getSelectedDocument();
        int pagenumber = this.viewer.getCurrentPageNumber();
        boolean matchCase = (this.pattern.flags() & 2) == 0;
        boolean hitFound = false;
        do {
            if ((hitFound = this.viewer.findOnPage(document, pagenumber, this.pattern.pattern(), matchCase, true, false)) || (currDocNode = this.getPrevDocNode(currDocNode)) == null) continue;
            DocTreeObject currDocTreeObject = (DocTreeObject)currDocNode.getUserObject();
            document = currDocTreeObject.doc;
            TreePath path = new TreePath(currDocNode.getPath());
            this.tree.getSelectionModel().setSelectionPath(path);
            try {
                pagenumber = document.getPageCount();
                CMBPage page = document.getPage(pagenumber);
                page.hitIndex = Integer.MAX_VALUE;
            }
            catch (IOException e) {
                // empty catch block
            }
        } while (!hitFound && currDocNode != null);
    }

    public JButton getPrevButton() {
        if (this.prevButton == null) {
            this.prevButton = new JButton(PViewerUtilities.getMessage("findPanel.button.PrevMatch"));
            this.prevButton.setMnemonic(PViewerUtilities.getMessage("findPanel.button.PrevMatch.mnemonic").charAt(0));
            this.prevButton.setEnabled(false);
            this.prevButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PFindResultsCard.this.viewer.getCurrentMode() != 111) {
                        PFindResultsCard.this.viewer.setCurrentMode(111);
                    }
                    PFindResultsCard.this.prevMatchAction();
                }
            });
        }
        return this.prevButton;
    }

    public void getPageHits(CMBDocument doc, int[] pageNumbers) {
        String methodName = "getPageHits";
        ViewerLogger.logEntry(this, methodName);
        int countPagesWithOcr = 0;
        for (int i = 0; i < pageNumbers.length; ++i) {
            try {
                CMBPage page = doc.getPage(pageNumbers[i]);
                if (page.getLetters() != null) {
                    ++countPagesWithOcr;
                    continue;
                }
                ViewerLogger.logDebug(this, methodName, "put page number: " + pageNumbers[i] + " on the ocr queue");
                POCRQueueItem item = new POCRQueueItem(this.viewer, doc, new int[]{pageNumbers[i]});
                this.viewer.ocrQueue.put(item);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        DefaultMutableTreeNode docnode = this.getDocNodeFor(doc);
        if (docnode == null) {
            int pageCountForOcr = pageNumbers.length - countPagesWithOcr;
            DocOCRProgressBar progressBar = null;
            if (pageCountForOcr > 0) {
                progressBar = this.createProgressBar(pageCountForOcr);
            }
            docnode = new DefaultMutableTreeNode(new DocTreeObject(doc, progressBar));
            this.treeModel.insertNodeInto(docnode, this.top, this.top.getChildCount());
            this.treeModel.nodeChanged(docnode);
            if (progressBar == null) {
                if (pageNumbers != null) {
                    this.getDocHits(doc, pageNumbers);
                }
                this.setButtonStates();
            }
        } else {
            DocTreeObject docTreeObject = (DocTreeObject)docnode.getUserObject();
            int pageCountForOcr = pageNumbers.length - countPagesWithOcr;
            DocOCRProgressBar progressBar = null;
            if (pageCountForOcr > 0) {
                progressBar = this.createProgressBar(pageCountForOcr);
            }
            docTreeObject.setProgressBar(progressBar);
            if (progressBar == null) {
                if (pageNumbers != null) {
                    this.getDocHits(doc, pageNumbers);
                }
                this.setButtonStates();
            }
            this.treeModel.nodeChanged(docnode);
        }
        ViewerLogger.logExit(this, methodName);
    }

    void addDocHit(CMBDocument doc) {
        String methodName = "addDocHit";
        ViewerLogger.logEntry(this, methodName);
        DefaultMutableTreeNode docnode = this.getDocNodeFor(doc);
        if (docnode == null) {
            ViewerLogger.logDebug(this, methodName, "create doc node");
            docnode = new DefaultMutableTreeNode(new DocTreeObject(doc, null));
            this.treeModel.insertNodeInto(docnode, this.top, this.top.getChildCount());
            this.treeModel.nodeChanged(this.top);
        } else {
            docnode.removeAllChildren();
            this.treeModel.reload(docnode);
        }
        try {
            for (int i = 1; i <= doc.getPageCount(); ++i) {
                CMBPage page = doc.getPage(i);
                if (page.matchResults == null || page.matchResults.size() <= 0 || page.findPattern == null || !page.findPattern.pattern().equals(this.pattern.pattern()) || page.findPattern.flags() != this.pattern.flags()) continue;
                ViewerLogger.logDebug(this, methodName, "create page tree object for page: " + page.getPageNumber());
                PageTreeObject pageTreeObject = new PageTreeObject(page);
                DefaultMutableTreeNode hitnode = new DefaultMutableTreeNode(pageTreeObject);
                this.treeModel.insertNodeInto(hitnode, docnode, docnode.getChildCount());
                this.treeModel.nodeChanged(docnode);
            }
            if (!this.docHits.contains(doc)) {
                this.docHits.add(doc);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            this.setButtonStates();
            return;
        }
        if (node.getUserObject() instanceof DocTreeObject) {
            DocTreeObject docNode = (DocTreeObject)node.getUserObject();
            CMBDocument doc = docNode.doc;
            if (this.viewer.getSelectedDocument() != doc) {
                this.viewer.activateDocument(doc);
            }
            int pagenumber = this.viewer.getViewer(doc).getDocModel().getCurrentPageNumber();
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                PageTreeObject pageNode = (PageTreeObject)child.getUserObject();
                if (pageNode.page.getPageNumber() != pagenumber) continue;
            }
        }
        if (node.getUserObject() instanceof PageTreeObject) {
            PageTreeObject pageNode = (PageTreeObject)node.getUserObject();
            CMBPage page = pageNode.page;
            TreePath path = new TreePath(node.getPath());
            if (this.tree.getSelectionModel().getSelectionPath() != path) {
                this.tree.getSelectionModel().setSelectionPath(path);
                this.tree.scrollPathToVisible(path);
            }
            if (this.viewer.getSelectedDocument() != page.getDocument()) {
                this.tree.removeTreeSelectionListener(this);
                this.viewer.activateDocument(page.getDocument());
                this.tree.addTreeSelectionListener(this);
            }
            this.viewer.setCurrentPageNumber(page.getPageNumber());
            if (page.hitIndex > page.matchResults.size()) {
                page.hitIndex = -1;
            }
            if (page.hitIndex < 0) {
                this.nextMatchAction();
            } else {
                MatchResult result = page.matchResults.get(page.hitIndex);
                Polygon selectedPolygon = page.getLetters().getPolygonBounds(result.start(), result.end() - 1);
                PPageModel pageModel = (PPageModel)this.viewer.getSelectedModel();
                Polygon scaledPolygon = pageModel.getScaledPolygon(selectedPolygon);
                try {
                    this.viewer.moveCurrentViewRectangle(scaledPolygon.getBounds().x, scaledPolygon.getBounds().y);
                }
                catch (UnsupportedOperationException e1) {
                    // empty catch block
                }
                pageModel.fireDocStateChangedEvent(21);
            }
        }
        this.setButtonStates();
    }

    void getDocHits(CMBDocument document) {
        String methodName = "getDocHits";
        boolean matchCase = (this.pattern.flags() & 2) == 0;
        try {
            int matchCount = this.viewer.findAll(document, this.pattern.pattern(), matchCase);
            this.addDocHit(document);
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    void getDocHits(CMBDocument document, int[] pageNumbers) {
        ViewerLogger.logDebug(this, "getDocHits", "pageNumbers.length: " + pageNumbers.length);
        boolean matchCase = (this.pattern.flags() & 2) == 0;
        for (int i = 0; i < pageNumbers.length; ++i) {
            int matchcount = this.viewer.findAllOnPage(document, pageNumbers[i], this.pattern.pattern(), matchCase);
        }
        this.addDocHit(document);
    }

    @Override
    public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
        this.setButtonStates();
    }

    void dispose() {
        this.viewer.removeDocStateChangedListener(this);
        for (int i = 0; i < this.top.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.top.getChildAt(i);
            DocTreeObject docTreeObject = (DocTreeObject)child.getUserObject();
            this.viewer.removeDocStateChangedListener(docTreeObject);
            this.viewer.removeDocSelectedListener(docTreeObject);
            docTreeObject.doc.clearFind();
        }
        this.tree = null;
        this.top = null;
        this.treeModel = null;
    }

    void refreshForPage(CMBDocument document, int pageNumber) {
        try {
            CMBPage page = document.getPage(pageNumber);
            boolean matchCase = (this.pattern.flags() & 2) == 0;
            page.find(this.pattern.pattern(), matchCase);
            ViewerLogger.logDebug(this, "refreshForPage", "pageNumber: " + pageNumber);
            this.getDocHits(document, new int[]{pageNumber});
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean includes(int pageNumber) {
        for (int i = 0; i < this.pageNumbers.length; ++i) {
            if (this.pageNumbers[i] != pageNumber) continue;
            return true;
        }
        return false;
    }

    CMBDocument getDocFor(DefaultMutableTreeNode docNode) {
        if (docNode == null) {
            return null;
        }
        DocTreeObject docObject = (DocTreeObject)docNode.getUserObject();
        return docObject.doc;
    }

    DefaultMutableTreeNode getDocNodeFor(CMBDocument doc) {
        DefaultMutableTreeNode docNode = null;
        for (int i = 0; i < this.top.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.top.getChildAt(i);
            DocTreeObject docTreeObject = (DocTreeObject)child.getUserObject();
            if (!docTreeObject.doc.equals(doc)) continue;
            docNode = child;
        }
        return docNode;
    }

    DefaultMutableTreeNode getPageNodeFor(DefaultMutableTreeNode docNode, int pagenumber) {
        DefaultMutableTreeNode pageNode = null;
        for (int i = 0; i < docNode.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)docNode.getChildAt(i);
            PageTreeObject pageTreeObject = (PageTreeObject)child.getUserObject();
            if (pageTreeObject.page.getPageNumber() != pagenumber) continue;
            pageNode = child;
        }
        return pageNode;
    }

    DefaultMutableTreeNode getCurrentDocNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if (node.getUserObject() instanceof DocTreeObject) {
            return node;
        }
        if (node.getUserObject() instanceof PageTreeObject) {
            return (DefaultMutableTreeNode)node.getParent();
        }
        return null;
    }

    DefaultMutableTreeNode getFirstDocNodeWithHit() {
        DefaultMutableTreeNode docNode = (DefaultMutableTreeNode)this.top.getChildAt(0);
        boolean hitFound = false;
        do {
            if (docNode.getChildCount() > 0) {
                hitFound = true;
            }
            if (hitFound) continue;
            docNode = this.getNextDocNode(docNode);
        } while (!hitFound && docNode != null);
        return docNode;
    }

    DefaultMutableTreeNode getLastDocNodeWithHit() {
        DefaultMutableTreeNode docNode = (DefaultMutableTreeNode)this.top.getChildAt(this.top.getChildCount() - 1);
        boolean hitFound = false;
        do {
            if (docNode.getChildCount() > 0) {
                hitFound = true;
            }
            if (hitFound) continue;
            docNode = this.getPrevDocNode(docNode);
        } while (!hitFound && docNode != null);
        return docNode;
    }

    DefaultMutableTreeNode getNextDocNode(DefaultMutableTreeNode currDocNode) {
        DocTreeObject currDocTreeObject = (DocTreeObject)currDocNode.getUserObject();
        CMBDocument currDoc = currDocTreeObject.doc;
        DefaultMutableTreeNode nextDocNode = null;
        for (int i = 0; i < this.top.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.top.getChildAt(i);
            DocTreeObject docTreeObject = (DocTreeObject)child.getUserObject();
            if (!docTreeObject.doc.equals(currDoc) || i + 1 >= this.top.getChildCount()) continue;
            nextDocNode = (DefaultMutableTreeNode)this.top.getChildAt(i + 1);
        }
        return nextDocNode;
    }

    DefaultMutableTreeNode getPrevDocNode(DefaultMutableTreeNode currDocNode) {
        DocTreeObject currDocTreeObject = (DocTreeObject)currDocNode.getUserObject();
        CMBDocument currDoc = currDocTreeObject.doc;
        DefaultMutableTreeNode prevDocNode = null;
        boolean found = false;
        for (int i = 0; i < this.top.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.top.getChildAt(i);
            DocTreeObject docTreeObject = (DocTreeObject)child.getUserObject();
            if (docTreeObject.doc.equals(currDoc)) {
                found = true;
            }
            if (found) continue;
            prevDocNode = child;
        }
        return prevDocNode;
    }

    DefaultMutableTreeNode getCurrentPageNode(DefaultMutableTreeNode parentNode) {
        DocTreeObject docTreeObject = (DocTreeObject)parentNode.getUserObject();
        CMBDocument doc = docTreeObject.doc;
        int pagenumber = this.viewer.getViewer(doc).getDocModel().getCurrentPageNumber();
        DefaultMutableTreeNode pageNode = null;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            PageTreeObject pageTreeObject = (PageTreeObject)child.getUserObject();
            if (pageTreeObject.page.getPageNumber() != pagenumber) continue;
            pageNode = child;
        }
        return pageNode;
    }

    DefaultMutableTreeNode getPrevPageNode(DefaultMutableTreeNode currDocNode, DefaultMutableTreeNode currPageNode) {
        PageTreeObject currPageTreeObject = (PageTreeObject)currPageNode.getUserObject();
        CMBPage page = currPageTreeObject.page;
        int pagenumber = page.getPageNumber();
        DefaultMutableTreeNode prevPageNode = null;
        boolean found = false;
        for (int i = 0; i < currDocNode.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)currDocNode.getChildAt(i);
            PageTreeObject pageTreeObject = (PageTreeObject)child.getUserObject();
            if (pageTreeObject.page.getPageNumber() == pagenumber) {
                found = true;
            }
            if (found) continue;
            prevPageNode = child;
        }
        return prevPageNode;
    }

    DefaultMutableTreeNode getNextPageNode(DefaultMutableTreeNode currDocNode, DefaultMutableTreeNode currPageNode) {
        PageTreeObject currPageTreeObject = (PageTreeObject)currPageNode.getUserObject();
        CMBPage page = currPageTreeObject.page;
        int pagenumber = page.getPageNumber();
        DefaultMutableTreeNode nextPageNode = null;
        for (int i = 0; i < currDocNode.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)currDocNode.getChildAt(i);
            PageTreeObject pageTreeObject = (PageTreeObject)child.getUserObject();
            if (pageTreeObject.page.getPageNumber() != pagenumber || i + 1 >= currDocNode.getChildCount()) continue;
            nextPageNode = (DefaultMutableTreeNode)currDocNode.getChildAt(i + 1);
        }
        return nextPageNode;
    }

    DefaultMutableTreeNode getFirstPageNode(DefaultMutableTreeNode currDocNode) {
        if (currDocNode.getChildCount() == 0) {
            return null;
        }
        DefaultMutableTreeNode firstPageNode = (DefaultMutableTreeNode)currDocNode.getChildAt(0);
        return firstPageNode;
    }

    DefaultMutableTreeNode getLastPageNode(DefaultMutableTreeNode currDocNode) {
        DefaultMutableTreeNode lastPageNode = (DefaultMutableTreeNode)currDocNode.getChildAt(currDocNode.getChildCount() - 1);
        return lastPageNode;
    }

    protected DocOCRProgressBar createProgressBar(int pageCount) {
        DocOCRProgressBar progressBar = new DocOCRProgressBar(0, PROGRESS_MIN, pageCount);
        progressBar.setStringPainted(true);
        return progressBar;
    }

    class IndicatorTreeCellRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon ocrConfidentIcon;
        ImageIcon ocrConfidentLowIcon;

        IndicatorTreeCellRenderer() {
            this.ocrConfidentIcon = PFindResultsCard.this.viewer.getImageIcon("OcrConfidenceHigh.png");
            this.ocrConfidentLowIcon = PFindResultsCard.this.viewer.getImageIcon("OcrConfidenceLow.png");
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf) {
                this.setIcon(this.isConfident(value));
            }
            return this;
        }

        protected ImageIcon isConfident(Object value) {
            ImageIcon i = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof PageTreeObject) {
                PageTreeObject nodeInfo = (PageTreeObject)node.getUserObject();
                CMBPage page = nodeInfo.page;
                int ocrConfidentLevel = page.getConfidenceLevel();
                if (ocrConfidentLevel == 2) {
                    i = this.ocrConfidentIcon;
                }
                if (ocrConfidentLevel == 1) {
                    i = this.ocrConfidentLowIcon;
                }
            }
            return i;
        }
    }

    class ResultsCardFocusTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        ResultsCardFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(PFindResultsCard.this.treeView)) {
                return PFindResultsCard.this.tree;
            }
            if (aComponent.equals(PFindResultsCard.this.tree)) {
                if (PFindResultsCard.this.getPrevButton().isEnabled()) {
                    return PFindResultsCard.this.getPrevButton();
                }
                if (PFindResultsCard.this.getNextButton().isEnabled()) {
                    return PFindResultsCard.this.getNextButton();
                }
            } else if (aComponent.equals(PFindResultsCard.this.getPrevButton()) && PFindResultsCard.this.getNextButton().isEnabled()) {
                return PFindResultsCard.this.getNextButton();
            }
            return null;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(PFindResultsCard.this.getNextButton())) {
                if (PFindResultsCard.this.getPrevButton().isEnabled()) {
                    return PFindResultsCard.this.getPrevButton();
                }
                return PFindResultsCard.this.tree;
            }
            if (aComponent.equals(PFindResultsCard.this.getPrevButton())) {
                return PFindResultsCard.this.tree;
            }
            return null;
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return PFindResultsCard.this.tree;
        }

        public Component getLastComponent(Container focusCycleRoot) {
            if (PFindResultsCard.this.getNextButton().isEnabled()) {
                return PFindResultsCard.this.getNextButton();
            }
            if (PFindResultsCard.this.getPrevButton().isEnabled()) {
                return PFindResultsCard.this.getPrevButton();
            }
            return PFindResultsCard.this.tree;
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            return PFindResultsCard.this.tree;
        }
    }

    private class DocOCRProgressBar
    extends JProgressBar {
        public DocOCRProgressBar(int horizontal, int min, int max) {
            super(horizontal, min, max);
        }

        public synchronized void addProgress(int newValue) {
            int i = this.getValue();
            this.setValue(i + 1);
        }
    }

    private class PageTreeObject {
        CMBPage page;

        public PageTreeObject(CMBPage page) {
            this.page = page;
        }

        public String toString() {
            int pagecount = this.page.matchResults.size();
            String msg = pagecount == 1 ? PViewerUtilities.getMessage("findPanel.pageMatchMessage", new Object[]{new Integer(this.page.getPageNumber())}) : PViewerUtilities.getMessage("findPanel.pageMatchesMessage", new Object[]{new Integer(this.page.getPageNumber()), new Integer(pagecount)});
            return msg;
        }
    }

    private class DocTreeObject
    implements CMBGenericDocStateChangedListener,
    CMBGenericDocSelectedListener {
        CMBDocument doc;
        DocOCRProgressBar progressBar;
        boolean inProgress = true;
        boolean isExpanded = false;

        public DocTreeObject(CMBDocument doc, DocOCRProgressBar progressBar) {
            this.doc = doc;
            this.progressBar = progressBar;
            if (progressBar == null) {
                this.inProgress = false;
            }
            PFindResultsCard.this.viewer.addDocStateChangedListener(this);
            PFindResultsCard.this.viewer.addDocSelectedListener(this);
        }

        public void setProgressBar(DocOCRProgressBar progressBar) {
            this.progressBar = progressBar;
            this.inProgress = progressBar != null;
        }

        public void genericDocSelected(CMBGenericDocSelectedEvent evt) {
            DefaultMutableTreeNode docNode = PFindResultsCard.this.getDocNodeFor(evt.getDocument());
            if (docNode == null) {
                PFindResultsCard.this.tree.getSelectionModel().setSelectionPath(null);
            } else {
                TreePath path = new TreePath(docNode.getPath());
                PFindResultsCard.this.tree.getSelectionModel().setSelectionPath(path);
            }
        }

        public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
            DefaultMutableTreeNode node;
            String progressMsg;
            String methodName = "genericDocStateChanged";
            ViewerLogger.logEntry(this, methodName);
            if (!evt.getDocument().equals(this.doc)) {
                return;
            }
            if (evt.getChangeType() == 23 && this.progressBar != null && this.inProgress) {
                progressMsg = PViewerUtilities.getMessage("progressORCDialog.progress", new Object[]{new Integer(evt.getCurrentPageNumber()), this.progressBar.getMaximum()});
                this.progressBar.setString(progressMsg);
                this.progressBar.addProgress(evt.getCurrentPageNumber());
                PFindResultsCard.this.revalidate();
                if (this.progressBar.getPercentComplete() == 1.0) {
                    this.inProgress = false;
                    if (PFindResultsCard.this.pageNumbers != null) {
                        PFindResultsCard.this.getDocHits(evt.getDocument(), PFindResultsCard.this.pageNumbers);
                    }
                    PFindResultsCard.this.setButtonStates();
                }
            }
            if (evt.getChangeType() == 26) {
                ViewerLogger.logDebug(this, methodName, "change type PAGE_TEXT");
                if (this.progressBar != null && this.inProgress) {
                    ViewerLogger.logDebug(this, methodName, "-in progress");
                    progressMsg = PViewerUtilities.getMessage("progressORCDialog.progress", new Object[]{new Integer(evt.getCurrentPageNumber()), this.progressBar.getMaximum()});
                    this.progressBar.setString(progressMsg);
                    this.progressBar.addProgress(evt.getCurrentPageNumber());
                    PFindResultsCard.this.revalidate();
                    if (this.progressBar.getPercentComplete() == 1.0) {
                        this.inProgress = false;
                        if (PFindResultsCard.this.pageNumbers != null) {
                            ViewerLogger.logDebug(this, methodName, "--get doc hits");
                            PFindResultsCard.this.getDocHits(evt.getDocument(), PFindResultsCard.this.pageNumbers);
                        }
                        PFindResultsCard.this.setButtonStates();
                    }
                }
            }
            if (evt.getChangeType() == 24) {
                this.inProgress = false;
            }
            if (evt.getChangeType() == 27) {
                this.inProgress = false;
            }
            if (evt.getChangeType() == 1 && (node = (DefaultMutableTreeNode)PFindResultsCard.this.tree.getLastSelectedPathComponent()) != null && node.getUserObject() instanceof PageTreeObject) {
                PageTreeObject pageNode = (PageTreeObject)node.getUserObject();
                CMBPage page = pageNode.page;
                if (page.getPageNumber() != evt.getCurrentPageNumber()) {
                    DefaultMutableTreeNode docNode = (DefaultMutableTreeNode)node.getParent();
                    DefaultMutableTreeNode changetoPageNode = PFindResultsCard.this.getPageNodeFor(docNode, evt.getCurrentPageNumber());
                    if (changetoPageNode == null) {
                        if (docNode != null) {
                            TreePath path = new TreePath(docNode.getPath());
                            if (PFindResultsCard.this.tree.getSelectionModel().getSelectionPath() != path) {
                                PFindResultsCard.this.tree.getSelectionModel().setSelectionPath(path);
                                PFindResultsCard.this.tree.scrollPathToVisible(path);
                            }
                        }
                    } else {
                        TreePath path = new TreePath(changetoPageNode.getPath());
                        if (PFindResultsCard.this.tree.getSelectionModel().getSelectionPath() != path) {
                            PFindResultsCard.this.tree.getSelectionModel().setSelectionPath(path);
                            PFindResultsCard.this.tree.scrollPathToVisible(path);
                        }
                    }
                }
            }
            ViewerLogger.logExit(this, methodName);
        }

        public Component getDisplayComponent() {
            if (this.inProgress) {
                return this.progressBar;
            }
            return new JLabel(this.toString());
        }

        public String toString() {
            int doccount;
            String msg = this.inProgress ? (this.doc.getMimeType().equalsIgnoreCase("application/pdf") ? PViewerUtilities.getMessage("findPanel.pdfDocMatchInProgress", new Object[]{PFindResultsCard.this.viewer.getDocName(this.doc), new Integer(this.progressBar.getValue()), this.progressBar.getMaximum()}) : PViewerUtilities.getMessage("findPanel.docMatchInProgress", new Object[]{PFindResultsCard.this.viewer.getDocName(this.doc), new Integer(this.progressBar.getValue()), this.progressBar.getMaximum()})) : ((doccount = this.doc.getMatchCount(PFindResultsCard.this.pattern)) == 0 ? PViewerUtilities.getMessage("findPanel.zero.docMatchMessage", new Object[]{PFindResultsCard.this.viewer.getDocName(this.doc)}) : (doccount == 1 ? PViewerUtilities.getMessage("findPanel.docMatchMessage", new Object[]{PFindResultsCard.this.viewer.getDocName(this.doc)}) : PViewerUtilities.getMessage("findPanel.docMatchesMessage", new Object[]{PFindResultsCard.this.viewer.getDocName(this.doc), new Integer(doccount)})));
            return msg;
        }
    }
}

