/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocClosedEvent;
import com.ibm.mm.viewer.CMBGenericDocClosedListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PFindCard;
import com.ibm.mm.viewer.PFindResultsCard;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class PFindPanel
extends JPanel {
    private ComponentOrientation compOri = null;
    private FindFocusTraversalPolicy focusPolicy = new FindFocusTraversalPolicy();
    private JButton actionButton = null;
    private JButton cancelButton = null;
    JPanel cards = null;
    CardLayout cardLayout = null;
    private PFindCard findCard = null;
    private PFindResultsCard resultsCard = null;
    private CMBGenericDocViewer viewer = null;
    private boolean findActive = true;
    private static final int FOCUS_BORDER_WIDTH = 2;

    public PFindPanel(CMBGenericDocViewer viewer) {
        super(new BorderLayout());
        this.viewer = viewer;
        this.findCard = new PFindCard(viewer);
        this.initialize();
    }

    private void initialize() {
        Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.setBorder(border);
        this.cards = new JPanel();
        this.cardLayout = new CardLayout();
        this.cards.setLayout(this.cardLayout);
        this.cards.add((Component)this.findCard, "find");
        this.cardLayout.show(this.cards, "find");
        this.add((Component)this.cards, "Center");
        this.add((Component)this.makeButtonPanel(), "After");
        this.applyComponentOrientation(this.getCompOri());
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                if (!event.isTemporary()) {
                    PFindPanel.this.setBorder(BorderFactory.createLineBorder(SystemColor.controlShadow, 2));
                }
            }

            public void focusLost(FocusEvent event) {
                if (!event.isTemporary()) {
                    PFindPanel.this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                }
            }
        });
        this.setFocusTraversalPolicy(this.focusPolicy);
        this.setFocusTraversalPolicyProvider(true);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                PFindPanel.this.setFocusTraversalPolicyProvider(false);
                if (PFindPanel.this.resultsCard != null) {
                    PFindPanel.this.resultsCard.dispose();
                    PFindPanel.this.cards.remove(PFindPanel.this.resultsCard);
                    PFindPanel.this.resultsCard = null;
                }
            }

            public void componentShown(ComponentEvent e) {
                PFindPanel.this.setFocusTraversalPolicyProvider(true);
                if (PFindPanel.this.findCard != null) {
                    PFindPanel.this.findCard.requestFocusInWindow();
                }
            }
        });
        this.viewer.addDocClosedListener(new CMBGenericDocClosedListener(){

            public void genericDocClosed(CMBGenericDocClosedEvent evt) {
                if (!PFindPanel.this.findActive && PFindPanel.this.resultsCard != null && evt.getDocument() == PFindPanel.this.resultsCard.getDocFor(PFindPanel.this.resultsCard.getDocNodeFor(evt.getDocument()))) {
                    PFindPanel.this.resultAction();
                }
            }
        });
        this.viewer.addDocStateChangedListener(new CMBGenericDocStateChangedListener(){

            public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
                if (PFindPanel.this.findActive || PFindPanel.this.resultsCard == null) {
                    return;
                }
                if (evt.getChangeType() == 15) {
                    if (PFindPanel.this.findCard.getCurrPageRB().isSelected() || PFindPanel.this.findCard.getPagesRB().isSelected()) {
                        PFindPanel.this.resultAction();
                    } else if (!PFindPanel.this.viewer.getSelectedDocument().isOCRValid()) {
                        try {
                            PFindPanel.this.resultsCard.getPageHits(evt.getDocument(), evt.getPageNumbers());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else {
                        PFindPanel.this.resultAction();
                        PFindPanel.this.findAction();
                    }
                }
                if (evt.getChangeType() == 14) {
                    if (PFindPanel.this.findCard.getCurrPageRB().isSelected() || PFindPanel.this.findCard.getPagesRB().isSelected()) {
                        PFindPanel.this.resultAction();
                    } else {
                        PFindPanel.this.resultAction();
                        PFindPanel.this.findAction();
                    }
                }
                if (evt.getChangeType() == 3) {
                    if (PFindPanel.this.resultsCard.getDocNodeFor(evt.getDocument()) == null) {
                        return;
                    }
                    if (PFindPanel.this.findCard.getCurrPageRB().isSelected() || PFindPanel.this.findCard.getPagesRB().isSelected()) {
                        if (evt.getDocument() == PFindPanel.this.resultsCard.getDocFor(PFindPanel.this.resultsCard.getDocNodeFor(evt.getDocument())) && PFindPanel.this.resultsCard.includes(evt.getCurrentPageNumber())) {
                            PFindPanel.this.resultAction();
                        }
                    } else {
                        PFindPanel.this.resultAction();
                    }
                }
                if (evt.getChangeType() == 23 || evt.getChangeType() == 26) {
                    if (PFindPanel.this.findCard.getCurrPageRB().isSelected()) {
                        if (evt.getDocument() == PFindPanel.this.resultsCard.getDocFor(PFindPanel.this.resultsCard.getDocNodeFor(evt.getDocument())) && PFindPanel.this.resultsCard.includes(evt.getCurrentPageNumber())) {
                            PFindPanel.this.resultsCard.refreshForPage(evt.getDocument(), evt.getCurrentPageNumber());
                        }
                    } else if (PFindPanel.this.findCard.getPagesRB().isSelected()) {
                        if (evt.getDocument() == PFindPanel.this.resultsCard.getDocFor(PFindPanel.this.resultsCard.getDocNodeFor(evt.getDocument())) && PFindPanel.this.resultsCard.includes(evt.getCurrentPageNumber())) {
                            PFindPanel.this.resultsCard.refreshForPage(evt.getDocument(), evt.getCurrentPageNumber());
                        }
                    } else if (PFindPanel.this.findCard.getCurrDocRB().isSelected()) {
                        if (evt.getDocument() == PFindPanel.this.resultsCard.getDocFor(PFindPanel.this.resultsCard.getDocNodeFor(evt.getDocument()))) {
                            PFindPanel.this.resultsCard.refreshForPage(evt.getDocument(), evt.getCurrentPageNumber());
                        }
                    } else if (PFindPanel.this.findCard.getAllDocsRB().isSelected()) {
                        PFindPanel.this.resultsCard.refreshForPage(evt.getDocument(), evt.getCurrentPageNumber());
                    }
                }
            }
        });
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(PViewerUtilities.getMessage("findPanel.button.Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ((PFindPanel)PFindPanel.this).viewer.currentLayout.showFindPanel(false);
                    PFindPanel.this.resultAction();
                }
            });
        }
        return this.cancelButton;
    }

    public JButton getActionButton() {
        if (this.actionButton == null) {
            this.actionButton = new JButton(PViewerUtilities.getMessage("findPanel.button.Find"));
            this.actionButton.setMnemonic(PViewerUtilities.getMessage("findPanel.button.Find.mnemonic").charAt(0));
            this.actionButton.setEnabled(false);
            this.actionButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PFindPanel.this.viewer.getCurrentMode() != 111) {
                        PFindPanel.this.viewer.setCurrentMode(111);
                    }
                    if (PFindPanel.this.findActive) {
                        PFindPanel.this.findAction();
                    } else {
                        PFindPanel.this.resultAction();
                    }
                }
            });
        }
        return this.actionButton;
    }

    private void resultAction() {
        if (!this.findActive && this.viewer.ocrQueue.hasDocumentsOCR()) {
            this.viewer.ocrQueue.cancelAll();
        }
        this.findActive = true;
        if (this.resultsCard != null) {
            this.resultsCard.dispose();
            this.cards.remove(this.resultsCard);
            this.resultsCard = null;
        }
        this.actionButton.setText(PViewerUtilities.getMessage("findPanel.button.Find"));
        this.actionButton.setMnemonic(PViewerUtilities.getMessage("findPanel.button.Find.mnemonic").charAt(0));
        this.cardLayout.show(this.cards, "find");
    }

    private void findAction() {
        this.findActive = false;
        String regx = this.findCard.getFindTextField().getText();
        if (this.findCard.getOptionWordCB().isSelected()) {
            regx = "\\b" + regx + "\\b";
        }
        Pattern pattern = this.findCard.getOptionCaseCB().isSelected() ? Pattern.compile(regx) : Pattern.compile(regx, 2);
        try {
            if (this.findCard.getAllDocsRB().isSelected()) {
                ArrayList<CMBDocument> docList = new ArrayList<CMBDocument>();
                for (int i = 0; i < this.viewer.getViewerCount(); ++i) {
                    PSingleDocViewer pageViewer = this.viewer.getViewer(i);
                    CMBDocument document = pageViewer.getDocModel().getDocument();
                    if (!this.viewer.getDocServices().canOcr(document) && !document.getCanFind()) continue;
                    docList.add(document);
                }
                this.resultsCard = new PFindResultsCard(this.viewer, pattern, docList);
                this.cards.add((Component)this.resultsCard, "results");
                this.cardLayout.show(this.cards, "results");
                this.resultsCard.treeModel.reload();
                this.actionButton.setText(PViewerUtilities.getMessage("findPanel.button.ReturnToFind"));
                this.actionButton.setMnemonic(PViewerUtilities.getMessage("findPanel.button.ReturnToFind.mnemonic").charAt(0));
                this.cards.revalidate();
            } else if (this.findCard.getCurrDocRB().isSelected()) {
                if (this.viewer.getViewablePageNumbers() == null) {
                    this.resultsCard = new PFindResultsCard(this.viewer, pattern, this.viewer.getSelectedDocument());
                    this.cards.add((Component)this.resultsCard, "results");
                    this.cardLayout.show(this.cards, "results");
                    this.resultsCard.treeModel.reload();
                    this.actionButton.setText(PViewerUtilities.getMessage("findPanel.button.ReturnToFind"));
                    this.actionButton.setMnemonic(PViewerUtilities.getMessage("findPanel.button.ReturnToFind.mnemonic").charAt(0));
                    this.cards.revalidate();
                } else {
                    int[] pageNumbers = this.viewer.getViewablePageNumbers();
                    this.resultsCard = new PFindResultsCard(this.viewer, this.viewer.getSelectedDocument(), pageNumbers, pattern);
                    this.cards.add((Component)this.resultsCard, "results");
                    this.cardLayout.show(this.cards, "results");
                    this.resultsCard.treeModel.reload();
                    this.actionButton.setText(PViewerUtilities.getMessage("findPanel.button.ReturnToFind"));
                    this.actionButton.setMnemonic(PViewerUtilities.getMessage("findPanel.button.ReturnToFind.mnemonic").charAt(0));
                    this.cards.revalidate();
                }
            } else if (this.findCard.getCurrPageRB().isSelected()) {
                this.resultsCard = new PFindResultsCard(this.viewer, this.viewer.getSelectedDocument(), new int[]{this.viewer.getCurrentPageNumber()}, pattern);
                this.cards.add((Component)this.resultsCard, "results");
                this.cardLayout.show(this.cards, "results");
                this.resultsCard.treeModel.reload();
                this.actionButton.setText(PViewerUtilities.getMessage("findPanel.button.ReturnToFind"));
                this.actionButton.setMnemonic(PViewerUtilities.getMessage("findPanel.button.ReturnToFind.mnemonic").charAt(0));
                this.cards.revalidate();
            } else if (this.findCard.getPagesRB().isSelected()) {
                if (!this.findCard.validatePageRange()) {
                    this.findActive = true;
                    JOptionPane.showMessageDialog(null, PViewerUtilities.getMessage("printDialog.printRange.pages.errorMessage"), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
                } else {
                    int[] pageNumbers = new int[this.findCard.getPageRangeCount()];
                    int i = -1;
                    int j = -1;
                    while ((i = this.findCard.getPageRanges().next(i)) != -1) {
                        pageNumbers[++j] = ((PPageModel)this.viewer.getSelectedModel()).getPageNumber(i);
                    }
                    this.resultsCard = new PFindResultsCard(this.viewer, this.viewer.getSelectedDocument(), pageNumbers, pattern);
                    this.cards.add((Component)this.resultsCard, "results");
                    this.cardLayout.show(this.cards, "results");
                    this.resultsCard.treeModel.reload();
                    this.actionButton.setText(PViewerUtilities.getMessage("findPanel.button.ReturnToFind"));
                    this.actionButton.setMnemonic(PViewerUtilities.getMessage("findPanel.button.ReturnToFind.mnemonic").charAt(0));
                    this.cards.revalidate();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JPanel makeButtonPanel() {
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(3));
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1, 5, 5));
        panel.add(this.getActionButton());
        panel.add(this.getCancelButton());
        panel.setComponentOrientation(this.getCompOri());
        p1.add(panel);
        return p1;
    }

    public ComponentOrientation getCompOri() {
        if (this.compOri == null) {
            boolean ltr = PViewerUtilities.isLeftToRight();
            this.compOri = ComponentOrientation.LEFT_TO_RIGHT;
            if (!ltr) {
                this.compOri = ComponentOrientation.RIGHT_TO_LEFT;
            }
        }
        return this.compOri;
    }

    void setActionButtonStates(boolean b) {
        this.getActionButton().setEnabled(b);
    }

    private class FindFocusTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        private FindFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(PFindPanel.this.getActionButton())) {
                return PFindPanel.this.getCancelButton();
            }
            if (aComponent.equals(PFindPanel.this.getCancelButton())) {
                return null;
            }
            Component c = null;
            c = PFindPanel.this.findActive ? ((PFindPanel)PFindPanel.this).findCard.focusPolicy.getComponentAfter(focusCycleRoot, aComponent) : ((PFindPanel)PFindPanel.this).resultsCard.focusPolicy.getComponentAfter(focusCycleRoot, aComponent);
            if (c == null) {
                if (PFindPanel.this.getActionButton().isEnabled()) {
                    return PFindPanel.this.getActionButton();
                }
                return PFindPanel.this.getCancelButton();
            }
            return c;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(PFindPanel.this.getCancelButton())) {
                if (PFindPanel.this.getActionButton().isEnabled()) {
                    return PFindPanel.this.getActionButton();
                }
                if (PFindPanel.this.findActive) {
                    return ((PFindPanel)PFindPanel.this).findCard.focusPolicy.getLastComponent(focusCycleRoot);
                }
                return ((PFindPanel)PFindPanel.this).resultsCard.focusPolicy.getLastComponent(focusCycleRoot);
            }
            if (aComponent.equals(PFindPanel.this.getActionButton())) {
                if (PFindPanel.this.findActive) {
                    return ((PFindPanel)PFindPanel.this).findCard.focusPolicy.getLastComponent(focusCycleRoot);
                }
                return ((PFindPanel)PFindPanel.this).resultsCard.focusPolicy.getLastComponent(focusCycleRoot);
            }
            if (PFindPanel.this.findActive) {
                return ((PFindPanel)PFindPanel.this).findCard.focusPolicy.getComponentBefore(focusCycleRoot, aComponent);
            }
            return ((PFindPanel)PFindPanel.this).resultsCard.focusPolicy.getComponentBefore(focusCycleRoot, aComponent);
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            if (PFindPanel.this.findActive) {
                return ((PFindPanel)PFindPanel.this).findCard.focusPolicy.getDefaultComponent(focusCycleRoot);
            }
            return ((PFindPanel)PFindPanel.this).resultsCard.focusPolicy.getDefaultComponent(focusCycleRoot);
        }

        public Component getLastComponent(Container focusCycleRoot) {
            return PFindPanel.this.getCancelButton();
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            if (PFindPanel.this.findActive) {
                return ((PFindPanel)PFindPanel.this).findCard.focusPolicy.getFirstComponent(focusCycleRoot);
            }
            return ((PFindPanel)PFindPanel.this).resultsCard.focusPolicy.getFirstComponent(focusCycleRoot);
        }
    }
}

