/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

class PFindDialog
extends JDialog {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBGenericDocViewer viewer = null;
    private JTextField searchTextField;
    private JCheckBox matchCaseCheckbox;
    JRadioButton upRadioButton;
    JRadioButton downRadioButton;
    JButton findButton;

    public PFindDialog(Frame owner, CMBGenericDocViewer viewer) {
        super(owner, PViewerUtilities.getMessage(PViewerUtilities.getMessage("findDialog.title")), false);
        this.viewer = viewer;
        this.setDefaultCloseOperation(1);
        this.makeControls();
        this.addEventHandlers();
        this.pack();
        this.setLocationRelativeTo(viewer);
    }

    public void setSearchText(String text) {
        this.searchTextField.setText(text);
        this.searchTextField.setSelectionStart(0);
        this.searchTextField.setSelectionEnd(text.length() - 1);
    }

    private void makeControls() {
        JPanel centerPanel = this.makeCenterPanel();
        JPanel buttonPanel = this.makeButtonPanel();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)centerPanel, "North");
        contentPane.add((Component)buttonPanel, "South");
    }

    private JPanel makeCenterPanel() {
        JPanel searchPanel = this.makeSearchPanel();
        JCheckBox matchCaseCheckbox = this.makeMatchCaseCheckbox();
        JPanel directionPanel = this.makeDirectionPanel();
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)searchPanel, "Center");
        JPanel subcenterPanel = new JPanel();
        subcenterPanel.add(matchCaseCheckbox);
        subcenterPanel.add(directionPanel);
        centerPanel.add((Component)subcenterPanel, "South");
        return centerPanel;
    }

    private JPanel makeButtonPanel() {
        this.findButton = this.makeFindButton();
        JButton closeButton = this.makeCloseButton();
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.findButton);
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    private JPanel makeSearchPanel() {
        JLabel searchLabel = new JLabel(PViewerUtilities.getMessage("findDialog.searchFor"));
        JPanel searchPanel = new JPanel(new BorderLayout(5, 5));
        searchPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.searchTextField = new JTextField(25);
        searchPanel.add((Component)searchLabel, "Before");
        searchPanel.add((Component)this.searchTextField, "Center");
        searchLabel.setDisplayedMnemonic(PViewerUtilities.getMessage("findDialog.searchFor.mnemonic").charAt(0));
        searchLabel.setLabelFor(this.searchTextField);
        return searchPanel;
    }

    private JCheckBox makeMatchCaseCheckbox() {
        this.matchCaseCheckbox = new JCheckBox(PViewerUtilities.getMessage("findDialog.matchCase"));
        this.matchCaseCheckbox.setMnemonic(PViewerUtilities.getMessage("findDialog.matchCase.mnemonic").charAt(0));
        return this.matchCaseCheckbox;
    }

    private JPanel makeDirectionPanel() {
        this.upRadioButton = new JRadioButton(PViewerUtilities.getMessage("findDialog.up"));
        this.upRadioButton.setMnemonic(PViewerUtilities.getMessage("findDialog.up.mnemonic").charAt(0));
        this.downRadioButton = new JRadioButton(PViewerUtilities.getMessage("findDialog.down"));
        this.downRadioButton.setMnemonic(PViewerUtilities.getMessage("findDialog.down.mnemonic").charAt(0));
        ButtonGroup directionButtonGroup = new ButtonGroup();
        directionButtonGroup.add(this.upRadioButton);
        directionButtonGroup.add(this.downRadioButton);
        this.downRadioButton.setSelected(true);
        JPanel directionPanel = new JPanel(new FlowLayout(1, 0, 0));
        directionPanel.setBorder(new TitledBorder(PViewerUtilities.getMessage("findDialog.direction")));
        directionPanel.add(this.upRadioButton);
        directionPanel.add(this.downRadioButton);
        return directionPanel;
    }

    private JButton makeFindButton() {
        JButton findButton = new JButton(PViewerUtilities.getMessage("findDialog.find"));
        findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PFindDialog.this.find();
            }
        });
        findButton.setEnabled(false);
        return findButton;
    }

    private JButton makeCloseButton() {
        JButton closeButton = new JButton(PViewerUtilities.getMessage("findDialog.close"));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PFindDialog.this.close();
            }
        });
        return closeButton;
    }

    private void addEventHandlers() {
        AbstractAction EscAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PFindDialog.this.close();
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        Object o1 = this.getRootPane().getInputMap().get(ks);
        this.getRootPane().getInputMap(2).put(ks, "escape");
        this.getRootPane().getActionMap().put("escape", EscAction);
        this.searchTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (PFindDialog.this.searchTextField.getText().length() > 0) {
                    PFindDialog.this.findButton.setEnabled(true);
                } else {
                    PFindDialog.this.findButton.setEnabled(false);
                }
            }
        });
        this.getRootPane().setDefaultButton(this.findButton);
    }

    private void find() {
        boolean found = this.viewer.find(this.searchTextField.getText(), this.matchCaseCheckbox.isSelected(), this.upRadioButton.isSelected());
        if (!found) {
            JOptionPane.showMessageDialog(this, PViewerUtilities.getMessage("findDialog.stringNotFound", new String[]{this.searchTextField.getText()}), PViewerUtilities.getMessage("findDialog.title"), 0, null);
        }
    }

    private void close() {
        this.setVisible(false);
    }

    public void show() {
        super.show();
        this.searchTextField.requestFocus();
        this.searchTextField.selectAll();
    }
}

