/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PFindPanel;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.print.attribute.standard.PageRanges;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PFindCard
extends JPanel
implements ItemListener,
DocumentListener {
    private ComponentOrientation compOri = null;
    FindCardFocusTraversalPolicy focusPolicy = new FindCardFocusTraversalPolicy();
    private JLabel findTextLabel = null;
    private JTextField findTextField = null;
    private JCheckBox optionWordCB = null;
    private JCheckBox optionCaseCB = null;
    private ButtonGroup bg = null;
    private JRadioButton allDocsRB = null;
    private JRadioButton currDocRB = null;
    private JRadioButton currPageRB = null;
    private JRadioButton pagesRB = null;
    private JTextField selPagesTextField = null;
    private JLabel selPagesInfoAsLabel = null;
    private CMBGenericDocViewer viewer = null;
    static final int MAX_FIELD_WIDTH = 150;

    public PFindCard(CMBGenericDocViewer viewer) {
        super(new BorderLayout());
        this.viewer = viewer;
        this.initialize();
    }

    private void initialize() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(3));
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(0, 1, 0, 0));
        p1.add(this.makeFindStringPanel());
        p1.add(this.makeOptionPanel());
        p.add(p1);
        p.add(this.makeScopePanel());
        this.add((Component)p, "Center");
        this.applyComponentOrientation(this.getCompOri());
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                if (!event.isTemporary()) {
                    PFindCard.this.getFindTextField().requestFocusInWindow();
                }
            }

            public void focusLost(FocusEvent event) {
            }
        });
    }

    public JLabel getFindTextLabel() {
        if (this.findTextLabel == null) {
            this.findTextLabel = new JLabel(PViewerUtilities.getMessage("findPanel.findText"));
            this.findTextLabel.setDisplayedMnemonic(PViewerUtilities.getMessage("findPanel.findText.mnemonic").charAt(0));
        }
        return this.findTextLabel;
    }

    public JTextField getFindTextField() {
        if (this.findTextField == null) {
            this.findTextField = new JTextField(){

                public Dimension getPreferredSize() {
                    return new Dimension(150, super.getPreferredSize().height);
                }
            };
            this.findTextField.getDocument().addDocumentListener(this);
        }
        return this.findTextField;
    }

    private JPanel makeFindStringPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(10, 5, 10, 5));
        panel.setLayout(new BorderLayout());
        JPanel p6 = new JPanel();
        p6.setLayout(new BorderLayout());
        JPanel p5 = new JPanel();
        p5.setLayout(new BorderLayout());
        p5.add((Component)this.getFindTextLabel(), "Before");
        p5.add((Component)this.getFindTextField(), "Center");
        p6.add((Component)p5, "Center");
        panel.add((Component)p6, "North");
        panel.setComponentOrientation(this.getCompOri());
        this.getFindTextLabel().setLabelFor(this.getFindTextField());
        return panel;
    }

    public JCheckBox getOptionWordCB() {
        if (this.optionWordCB == null) {
            this.optionWordCB = new JCheckBox(PViewerUtilities.getMessage("findPanel.option.word"));
            this.optionWordCB.setMnemonic(PViewerUtilities.getMessage("findPanel.option.word.mnemonic").charAt(0));
            this.optionWordCB.setSelected(false);
            this.optionWordCB.setEnabled(true);
        }
        return this.optionWordCB;
    }

    public JCheckBox getOptionCaseCB() {
        if (this.optionCaseCB == null) {
            this.optionCaseCB = new JCheckBox(PViewerUtilities.getMessage("findPanel.option.case"));
            this.optionCaseCB.setMnemonic(PViewerUtilities.getMessage("findPanel.option.case.mnemonic").charAt(0));
            this.optionCaseCB.setSelected(false);
            this.optionCaseCB.setEnabled(true);
        }
        return this.optionCaseCB;
    }

    private JPanel makeOptionPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(PViewerUtilities.getMessage("findPanel.option.title")));
        panel.setLayout(new FlowLayout(3));
        panel.add(this.getOptionCaseCB());
        panel.add(this.getOptionWordCB());
        panel.setComponentOrientation(this.getCompOri());
        return panel;
    }

    public ButtonGroup getBg() {
        if (this.bg == null) {
            this.bg = new ButtonGroup();
            this.bg.add(this.getAllDocsRB());
            this.bg.add(this.getCurrDocRB());
            this.bg.add(this.getCurrPageRB());
            this.bg.add(this.getPagesRB());
        }
        return this.bg;
    }

    public JRadioButton getAllDocsRB() {
        if (this.allDocsRB == null) {
            this.allDocsRB = new JRadioButton(PViewerUtilities.getMessage("findPanel.scope.allDocs"));
            this.allDocsRB.setMnemonic(PViewerUtilities.getMessage("findPanel.scope.allDocs.mnemonic").charAt(0));
            this.allDocsRB.addItemListener(this);
        }
        return this.allDocsRB;
    }

    public JRadioButton getCurrDocRB() {
        if (this.currDocRB == null) {
            this.currDocRB = new JRadioButton(PViewerUtilities.getMessage("findPanel.scope.currDoc"));
            this.currDocRB.setMnemonic(PViewerUtilities.getMessage("findPanel.scope.currDoc.mnemonic").charAt(0));
            this.currDocRB.addItemListener(this);
            this.currDocRB.setSelected(true);
        }
        return this.currDocRB;
    }

    public JRadioButton getCurrPageRB() {
        if (this.currPageRB == null) {
            this.currPageRB = new JRadioButton(PViewerUtilities.getMessage("findPanel.scope.currPage"));
            this.currPageRB.setMnemonic(PViewerUtilities.getMessage("findPanel.scope.currPage.mnemonic").charAt(0));
            this.currPageRB.addItemListener(this);
        }
        return this.currPageRB;
    }

    public JRadioButton getPagesRB() {
        if (this.pagesRB == null) {
            this.pagesRB = new JRadioButton(PViewerUtilities.getMessage("findPanel.scope.pages"));
            this.pagesRB.setMnemonic(PViewerUtilities.getMessage("findPanel.scope.pages.mnemonic").charAt(0));
            this.pagesRB.addItemListener(this);
        }
        return this.pagesRB;
    }

    public JTextField getSelPagesText() {
        if (this.selPagesTextField == null) {
            this.selPagesTextField = new JTextField(){

                public Dimension getPreferredSize() {
                    return new Dimension(150, super.getPreferredSize().height);
                }
            };
        }
        return this.selPagesTextField;
    }

    public JLabel getSelPagesInfoAsLabel() {
        if (this.selPagesInfoAsLabel == null) {
            this.selPagesInfoAsLabel = new JLabel("<html>" + PViewerUtilities.getMessage("findPanel.scope.pages.info") + "</html>"){

                public Dimension getPreferredSize() {
                    return new Dimension(150, super.getPreferredSize().height);
                }
            };
            this.selPagesInfoAsLabel.setVerticalAlignment(0);
            this.selPagesInfoAsLabel.setHorizontalAlignment(10);
        }
        return this.selPagesInfoAsLabel;
    }

    private JPanel makeScopePanel() {
        JTextField c = null;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new TitledBorder(PViewerUtilities.getMessage("findPanel.scope.title")));
        ButtonGroup bg = this.getBg();
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(0, 1, 5, 0));
        p3.getAccessibleContext().setAccessibleName(PViewerUtilities.getMessage("findPanel.scope.title"));
        Enumeration<AbstractButton> enumRadioButtons = bg.getElements();
        while (enumRadioButtons.hasMoreElements()) {
            JRadioButton rb = (JRadioButton)enumRadioButtons.nextElement();
            p3.add(rb);
        }
        JPanel p4 = new JPanel();
        p4.setLayout(new GridLayout(0, 1, 5, 0));
        p4.add(new JLabel());
        p4.add(new JLabel());
        c = this.getSelPagesText();
        p4.add(c);
        ((Component)c).getAccessibleContext().setAccessibleDescription(PViewerUtilities.getMessage("findPanel.scope.pages.info"));
        p2.add((Component)p3, "Before");
        p2.add((Component)p4, "Center");
        p1.add((Component)p2, "North");
        JPanel p7 = new JPanel();
        p7.setLayout(new BorderLayout());
        p7.setBorder(new EmptyBorder(5, 5, 5, 5));
        p7.add((Component)this.getSelPagesInfoAsLabel(), "Center");
        this.getSelPagesInfoAsLabel().setLabelFor(p7);
        p1.add((Component)p7, "Center");
        panel.add((Component)p1, "Center");
        panel.setComponentOrientation(this.getCompOri());
        return panel;
    }

    public ComponentOrientation getCompOri() {
        if (this.compOri == null) {
            boolean ltr = PViewerUtilities.isLeftToRight();
            this.compOri = ComponentOrientation.LEFT_TO_RIGHT;
            if (!ltr) {
                this.compOri = ComponentOrientation.RIGHT_TO_LEFT;
            }
        }
        return this.compOri;
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.getPagesRB().isSelected()) {
            this.getSelPagesText().setEnabled(true);
            this.getSelPagesText().requestFocus();
        } else {
            this.getSelPagesText().setEnabled(false);
        }
    }

    private void setButtonStates() {
        if (this.getParent().getParent() instanceof PFindPanel) {
            ((PFindPanel)this.getParent().getParent()).setActionButtonStates(this.getFindTextField().getDocument().getLength() > 0);
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.setButtonStates();
    }

    public void insertUpdate(DocumentEvent e) {
        this.setButtonStates();
    }

    public void removeUpdate(DocumentEvent e) {
        this.setButtonStates();
    }

    public boolean validatePageRange() {
        if (!(this.viewer.getSelectedModel() instanceof PPageModel)) {
            return false;
        }
        PPageModel model = (PPageModel)this.viewer.getSelectedModel();
        StringBuffer selectedPageRanges = new StringBuffer(this.getSelPagesText().getText());
        try {
            PageRanges pageRanges = new PageRanges(selectedPageRanges.toString());
            int next = pageRanges.next(model.getNumberOfPages());
            if (next != -1 && !model.isValidPagePosition(next)) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public PageRanges getPageRanges() {
        StringBuffer selectedPageRanges = new StringBuffer(this.getSelPagesText().getText());
        PageRanges pageRanges = new PageRanges(selectedPageRanges.toString());
        return pageRanges;
    }

    public int getPageRangeCount() {
        StringBuffer selectedPageRanges = new StringBuffer(this.getSelPagesText().getText());
        PageRanges pageRanges = new PageRanges(selectedPageRanges.toString());
        int[][] myMembers = pageRanges.getMembers();
        int n = myMembers.length;
        int totalCount = 0;
        for (int i = 0; i < n; ++i) {
            totalCount += myMembers[i][1] - myMembers[i][0] + 1;
        }
        return totalCount;
    }

    class FindCardFocusTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        FindCardFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(PFindCard.this.getFindTextField())) {
                return PFindCard.this.getOptionCaseCB();
            }
            if (aComponent.equals(PFindCard.this.getOptionCaseCB())) {
                return PFindCard.this.getOptionWordCB();
            }
            if (aComponent.equals(PFindCard.this.getOptionWordCB())) {
                return PFindCard.this.getAllDocsRB();
            }
            if (aComponent.equals(PFindCard.this.getAllDocsRB())) {
                return PFindCard.this.getCurrDocRB();
            }
            if (aComponent.equals(PFindCard.this.getCurrDocRB())) {
                return PFindCard.this.getCurrPageRB();
            }
            if (aComponent.equals(PFindCard.this.getCurrPageRB())) {
                if (PFindCard.this.getPagesRB().isSelected()) {
                    return PFindCard.this.getSelPagesText();
                }
                return PFindCard.this.getPagesRB();
            }
            return null;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(PFindCard.this.getSelPagesText())) {
                return PFindCard.this.getPagesRB();
            }
            if (aComponent.equals(PFindCard.this.getPagesRB())) {
                return PFindCard.this.getCurrPageRB();
            }
            if (aComponent.equals(PFindCard.this.getCurrPageRB())) {
                return PFindCard.this.getCurrDocRB();
            }
            if (aComponent.equals(PFindCard.this.getCurrDocRB())) {
                return PFindCard.this.getAllDocsRB();
            }
            if (aComponent.equals(PFindCard.this.getAllDocsRB())) {
                return PFindCard.this.getOptionWordCB();
            }
            if (aComponent.equals(PFindCard.this.getOptionWordCB())) {
                return PFindCard.this.getOptionCaseCB();
            }
            if (aComponent.equals(PFindCard.this.getOptionCaseCB())) {
                return PFindCard.this.getFindTextField();
            }
            return null;
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return PFindCard.this.getFindTextField();
        }

        public Component getLastComponent(Container focusCycleRoot) {
            if (PFindCard.this.getPagesRB().isSelected()) {
                return PFindCard.this.getSelPagesText();
            }
            return PFindCard.this.getPagesRB();
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            return PFindCard.this.getFindTextField();
        }
    }
}

