/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.PViewerUtilities;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class PFileMappedByteBuffer {
    private static final int INITIAL_DATA_ARRAY_LENGTH = 1000000;
    private static final int INCREMENTAL_DATA_ARRAY_LENGTH = 1000000;
    private File dataFile;
    private RandomAccessFile randomFile;
    private byte[] dataArray;
    private int validDataLength;
    private boolean disposed;

    public PFileMappedByteBuffer(boolean useMemory, int initialLength) {
        if (!useMemory) {
            try {
                this.dataFile = File.createTempFile("cmbview", "tmp");
                this.randomFile = new RandomAccessFile(this.dataFile, "rw");
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (initialLength == 0) {
            initialLength = 1000000;
        }
        this.dataArray = new byte[initialLength];
    }

    public synchronized byte readByte(int offset) {
        String methodName = "readBytes";
        if (this.disposed) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("Document.usedAfterDropped"));
        }
        if (this.randomFile != null) {
            try {
                this.randomFile.seek(offset);
                int value = this.randomFile.read();
                if (value < 0) {
                    throw new IndexOutOfBoundsException();
                }
                return (byte)value;
            }
            catch (IOException e) {
                ViewerLogger.logError((Object)this, methodName, e);
                throw new IndexOutOfBoundsException();
            }
        }
        return this.dataArray[offset];
    }

    public synchronized byte[] readBytes(int offset, int length) {
        String methodName = "readBytes";
        if (this.disposed) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("Document.usedAfterDropped"));
        }
        byte[] bytes = new byte[length];
        if (this.randomFile != null) {
            try {
                this.randomFile.seek(offset);
                int actualLen = this.randomFile.read(bytes);
                if (actualLen != length) {
                    throw new IndexOutOfBoundsException();
                }
            }
            catch (IOException e) {
                ViewerLogger.logError((Object)this, methodName, e);
                throw new IndexOutOfBoundsException();
            }
            return bytes;
        }
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.dataArray[offset + i];
        }
        return bytes;
    }

    public synchronized void readBytes(int offset, int length, byte[] returnData, int returnDataOffset) {
        block6: {
            String methodName = "readBytes";
            if (this.disposed) {
                throw new CMBDocumentEngineException(PViewerUtilities.getMessage("Document.usedAfterDropped"));
            }
            if (this.randomFile != null) {
                try {
                    this.randomFile.seek(offset);
                    int actualLen = this.randomFile.read(returnData, returnDataOffset, length);
                    if (actualLen != length) {
                        throw new IndexOutOfBoundsException();
                    }
                    break block6;
                }
                catch (IOException e) {
                    ViewerLogger.logError((Object)this, methodName, e);
                    throw new IndexOutOfBoundsException();
                }
            }
            for (int i = 0; i < length; ++i) {
                returnData[returnDataOffset + i] = this.dataArray[offset + i];
            }
        }
    }

    public synchronized void writeBytes(byte[] bytes, int length) throws IOException {
        if (this.disposed) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("Document.usedAfterDropped"));
        }
        if (this.randomFile != null) {
            this.randomFile.seek(this.validDataLength);
            this.randomFile.write(bytes, 0, length);
        } else {
            if (this.dataArray.length < this.validDataLength + length) {
                byte[] newDataArray = new byte[this.dataArray.length + Math.max(length, 1000000)];
                for (int i = 0; i < this.dataArray.length; ++i) {
                    newDataArray[i] = this.dataArray[i];
                }
                this.dataArray = newDataArray;
            }
            for (int i = 0; i < length; ++i) {
                this.dataArray[this.validDataLength + i] = bytes[i];
            }
        }
        this.validDataLength += length;
    }

    public synchronized int getLength() {
        if (this.disposed) {
            throw new CMBDocumentEngineException(PViewerUtilities.getMessage("Document.usedAfterDropped"));
        }
        return this.validDataLength;
    }

    public synchronized void dispose() throws IOException {
        this.disposed = true;
        if (this.randomFile != null) {
            this.randomFile.close();
            this.randomFile = null;
        }
        if (this.dataFile != null) {
            if (!this.dataFile.delete()) {
                throw new IOException(PViewerUtilities.getMessage("DocumentEngine.tempFileDeleteFailed", new String[]{this.dataFile.getAbsolutePath()}));
            }
            this.dataFile = null;
        }
        this.dataArray = null;
        this.validDataLength = 0;
    }
}

