/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.PDataAccessInterface;
import com.ibm.mm.viewer.PFileMappedByteBuffer;
import com.ibm.mm.viewer.PViewerUtilities;
import java.io.IOException;
import java.io.InputStream;

final class PFastStreamAccess
implements PDataAccessInterface {
    private boolean bigEndian;
    private PFileMappedByteBuffer dataBuffer;
    private ReadThread readThread;
    private RuntimeException readThreadError;
    private boolean dataComplete;
    private int contentLength = -1;
    private Object dataCompleteMonitor = new Object();
    private Object moreDataAvailableMonitor = new Object();

    public PFastStreamAccess(InputStream inputStream, int contentLength, boolean useMemory) throws IOException {
        this.contentLength = contentLength;
        this.dataBuffer = new PFileMappedByteBuffer(useMemory, contentLength);
        this.readThread = new ReadThread(inputStream);
        this.readThread.start();
    }

    public int getCurrentSize() {
        return this.dataBuffer.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalSize() {
        try {
            Object object = this.dataCompleteMonitor;
            synchronized (object) {
                if (!this.dataComplete) {
                    this.dataCompleteMonitor.wait();
                    if (this.readThreadError != null) {
                        throw this.readThreadError;
                    }
                }
            }
            return this.dataBuffer.getLength();
        }
        catch (InterruptedException e) {
            if (this.readThreadError != null) {
                throw this.readThreadError;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitTillAvailable(int offset) {
        try {
            while (this.getCurrentSize() <= offset) {
                Object object = this.moreDataAvailableMonitor;
                synchronized (object) {
                    if (this.readThreadError != null) {
                        throw this.readThreadError;
                    }
                    if (this.dataComplete) {
                        return;
                    }
                    if (this.getCurrentSize() <= offset) {
                        this.moreDataAvailableMonitor.wait();
                        if (this.readThreadError != null) {
                            throw this.readThreadError;
                        }
                    }
                }
            }
            return;
        }
        catch (InterruptedException e) {
            if (this.readThreadError == null) return;
            throw this.readThreadError;
        }
    }

    public boolean getBigEndian() {
        return this.bigEndian;
    }

    public byte getByte(int offset) {
        this.waitTillAvailable(offset);
        return this.dataBuffer.readByte(offset);
    }

    public byte[] getByteArray(int offset, int length) {
        return this.getByteArray(offset, length, false);
    }

    public byte[] getByteArray(int offset, int length, boolean invertBits) {
        this.waitTillAvailable(offset + length - 1);
        byte[] returnData = new byte[length];
        for (int i = 0; i < length; ++i) {
            returnData[i] = invertBits ? this.invertBits(this.dataBuffer.readByte(offset + i)) : this.dataBuffer.readByte(offset + i);
        }
        return returnData;
    }

    private byte invertBits(byte dataByte) {
        byte invertedByte = 0;
        if ((dataByte & 0x80) == 128) {
            invertedByte = (byte)(invertedByte | 1);
        }
        if ((dataByte & 0x40) == 64) {
            invertedByte = (byte)(invertedByte | 2);
        }
        if ((dataByte & 0x20) == 32) {
            invertedByte = (byte)(invertedByte | 4);
        }
        if ((dataByte & 0x10) == 16) {
            invertedByte = (byte)(invertedByte | 8);
        }
        if ((dataByte & 8) == 8) {
            invertedByte = (byte)(invertedByte | 0x10);
        }
        if ((dataByte & 4) == 4) {
            invertedByte = (byte)(invertedByte | 0x20);
        }
        if ((dataByte & 2) == 2) {
            invertedByte = (byte)(invertedByte | 0x40);
        }
        if ((dataByte & 1) == 1) {
            invertedByte = (byte)(invertedByte | 0x80);
        }
        return invertedByte;
    }

    public int getByteArray(int offset, int length, byte[] returnData, int returnDataOffset) {
        this.waitTillAvailable(offset + length - 1);
        int actualLength = Math.min(length, this.getCurrentSize() - offset);
        this.dataBuffer.readBytes(offset, actualLength, returnData, returnDataOffset);
        return actualLength;
    }

    public int getInt(int offset) {
        int returnInt;
        this.waitTillAvailable(offset + 3);
        if (this.bigEndian) {
            returnInt = this.dataBuffer.readByte(offset) & 0xFF;
            returnInt = (returnInt << 8) + (this.dataBuffer.readByte(offset + 1) & 0xFF);
            returnInt = (returnInt << 8) + (this.dataBuffer.readByte(offset + 2) & 0xFF);
            returnInt = (returnInt << 8) + (this.dataBuffer.readByte(offset + 3) & 0xFF);
        } else {
            returnInt = this.dataBuffer.readByte(offset + 3) & 0xFF;
            returnInt = (returnInt << 8) + (this.dataBuffer.readByte(offset + 2) & 0xFF);
            returnInt = (returnInt << 8) + (this.dataBuffer.readByte(offset + 1) & 0xFF);
            returnInt = (returnInt << 8) + (this.dataBuffer.readByte(offset) & 0xFF);
        }
        return returnInt;
    }

    public int[] getIntArray(int offset, int length) {
        int[] returnIntArray = new int[length];
        for (int i = 0; i < length; ++i) {
            returnIntArray[i] = this.getInt(offset + 4 * i);
        }
        return returnIntArray;
    }

    public int getShort(int offset) {
        int returnShort;
        this.waitTillAvailable(offset + 1);
        if (this.bigEndian) {
            returnShort = this.dataBuffer.readByte(offset) & 0xFF;
            returnShort = (short)(returnShort << 8) + (this.dataBuffer.readByte(offset + 1) & 0xFF);
        } else {
            returnShort = this.dataBuffer.readByte(offset + 1) & 0xFF;
            returnShort = (returnShort << 8) + (this.dataBuffer.readByte(offset) & 0xFF);
        }
        return returnShort;
    }

    public int[] getShortArray(int offset, int length) {
        int[] returnShortArray = new int[length];
        for (int i = 0; i < length; ++i) {
            returnShortArray[i] = this.getShort(offset + 2 * i);
        }
        return returnShortArray;
    }

    public void setBigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public boolean isValidOffset(int offset) {
        this.waitTillAvailable(offset);
        return offset < this.getCurrentSize();
    }

    public InputStream getInputStream() {
        return new FastStreamAccessInputStream();
    }

    public void dispose() {
        String methodName = "dispose";
        try {
            this.dataBuffer.dispose();
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    private class FastStreamAccessInputStream
    extends InputStream {
        int location;
        int markedLocation;
        private boolean zeroReturnedOneTime;

        private FastStreamAccessInputStream() {
        }

        public int read() throws IOException {
            try {
                int readByte = PFastStreamAccess.this.getByte(this.location) & 0xFF;
                ++this.location;
                return readByte;
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
            catch (NullPointerException e) {
                return -1;
            }
        }

        public int available() throws IOException {
            if (PFastStreamAccess.this.contentLength >= 0) {
                return PFastStreamAccess.this.contentLength - this.location;
            }
            if (!this.zeroReturnedOneTime) {
                this.zeroReturnedOneTime = true;
                return 0;
            }
            int avail = Math.max(PFastStreamAccess.this.getCurrentSize() - this.location, 0);
            return avail;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            int actualLengthRead = PFastStreamAccess.this.getByteArray(this.location, len, b, off);
            this.location += actualLengthRead;
            if (actualLengthRead == 0 && len > 0) {
                return -1;
            }
            return actualLengthRead;
        }

        public boolean markSupported() {
            return true;
        }

        public synchronized void mark(int readlimit) {
            this.markedLocation = this.location;
        }

        public synchronized void reset() throws IOException {
            this.location = this.markedLocation;
        }

        public long skip(long n) throws IOException {
            if ((long)this.location + n > (long)PFastStreamAccess.this.contentLength) {
                n = PFastStreamAccess.this.contentLength - this.location;
            }
            if (n < 0L) {
                return 0L;
            }
            this.location = (int)((long)this.location + n);
            return n;
        }
    }

    private class ReadThread
    extends Thread {
        InputStream inputStream;

        public ReadThread(InputStream inputStream) {
            this.inputStream = inputStream;
            this.setName("PFastStreamAccess.ReadThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            Object object;
            String methodName = "run";
            int len = 0;
            byte[] buff = new byte[65536];
            do {
                if ((len = this.inputStream.read(buff)) <= 0) continue;
                PFastStreamAccess.this.dataBuffer.writeBytes(buff, len);
                object = PFastStreamAccess.this.moreDataAvailableMonitor;
                synchronized (object) {
                    PFastStreamAccess.this.moreDataAvailableMonitor.notifyAll();
                }
            } while (len != -1);
            if (PFastStreamAccess.this.dataBuffer.getLength() != PFastStreamAccess.this.contentLength) {
                throw new RuntimeException(PViewerUtilities.getMessage("DocumentEngine.documentDataNotExpectedLength"));
            }
            object = PFastStreamAccess.this.dataCompleteMonitor;
            synchronized (object) {
                Object object2 = PFastStreamAccess.this.moreDataAvailableMonitor;
                synchronized (object2) {
                    PFastStreamAccess.this.moreDataAvailableMonitor.notifyAll();
                }
                PFastStreamAccess.this.dataComplete = true;
                PFastStreamAccess.this.dataCompleteMonitor.notifyAll();
            }
            Object var11_12 = null;
            if (this.inputStream == null) return;
            try {
                this.inputStream.close();
                return;
            }
            catch (IOException e2) {
                ViewerLogger.logError((Object)this, methodName, e2);
            }
            return;
            {
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        PFastStreamAccess.this.readThreadError = (RuntimeException)e;
                    } else {
                        PFastStreamAccess.this.readThreadError = new RuntimeException(e);
                    }
                    Object object3 = PFastStreamAccess.this.dataCompleteMonitor;
                    synchronized (object3) {
                        Object object4 = PFastStreamAccess.this.moreDataAvailableMonitor;
                        synchronized (object4) {
                            PFastStreamAccess.this.moreDataAvailableMonitor.notifyAll();
                        }
                        PFastStreamAccess.this.dataCompleteMonitor.notifyAll();
                    }
                    Object var11_13 = null;
                    if (this.inputStream == null) return;
                    try {
                        this.inputStream.close();
                        return;
                    }
                    catch (IOException e2) {
                        ViewerLogger.logError((Object)this, methodName, e2);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (this.inputStream == null) throw throwable;
                try {
                    this.inputStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    ViewerLogger.logError((Object)this, methodName, e2);
                }
                throw throwable;
            }
        }
    }
}

