/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBGenericDocHelpEvent;
import com.ibm.mm.viewer.CMBGenericDocHelpListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBStreamingDocServices;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class PExportDocumentDialog
extends JDialog
implements DocumentListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBGenericDocViewer viewer = null;
    private PDocModel docModel = null;
    private CMBStreamingDocServices docServices = null;
    private Hashtable mimeTypes = null;
    protected Vector docHelpListeners = new Vector();
    private ComponentOrientation compOri = null;
    private JLabel infoLabel = null;
    private JLabel destFolderLabel = null;
    private JTextField destFolderField = null;
    private JButton destFolderBrowseButton = null;
    private JLabel filenameLabel = null;
    private JTextField filenameField = null;
    private JLabel mimetypeLabel = null;
    private JComboBox mimetypeField = null;
    private JCheckBox includeAnnotationCheckbox = null;
    private JCheckBox reduceColorsCheckbox = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JButton helpButton = null;
    private ExportFocusTraversalPolicy focusPolicy = new ExportFocusTraversalPolicy();
    JFileChooser chooser;

    public PExportDocumentDialog(Frame owner, PDocModel docModel, CMBStreamingDocServices docServices, CMBGenericDocViewer viewer) {
        super(owner, PViewerUtilities.getMessage("exportDialog.Title"), true);
        this.setName("Export");
        if (docModel == null || docModel.getDocument() == null) {
            return;
        }
        this.docModel = docModel;
        this.docServices = docServices;
        this.viewer = viewer;
        this.setFocusTraversalPolicy(this.focusPolicy);
    }

    public void buildLayout() {
        this.getContentPane().add("North", this.getInfoLabel());
        this.getContentPane().add("Center", this.makeCenterPanel());
        this.getContentPane().add("South", this.makeButtonPanel());
        this.setButtonStates();
        this.applyComponentOrientation(this.getCompOri());
        AbstractAction EscAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PExportDocumentDialog.this.dispatchEvent(new WindowEvent(PExportDocumentDialog.this, 201));
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        Object o1 = this.getRootPane().getInputMap().get(ks);
        this.getRootPane().getInputMap(2).put(ks, "escape");
        this.getRootPane().getActionMap().put("escape", EscAction);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent we) {
                PExportDocumentDialog.this.requestFocus();
            }

            public void windowClosing(WindowEvent we) {
                PExportDocumentDialog.this.getDestFolderField().requestFocusInWindow();
            }
        });
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(4));
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 0, 5, 5));
        p2.add(this.getOkButton());
        p2.add(this.getCancelButton());
        if (!this.docHelpListeners.isEmpty()) {
            p2.add(this.getHelpButton());
        }
        p2.setComponentOrientation(this.getCompOri());
        panel.add((Component)p2, "After");
        panel.setComponentOrientation(this.getCompOri());
        return panel;
    }

    private JPanel makeCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.makeFileSelectionPanel(), "North");
        panel.add((Component)this.makeOptionsPanel(), "Center");
        return panel;
    }

    private JPanel makeFileSelectionPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(0, 5, 0, 5));
        panel.setLayout(new BorderLayout());
        JPanel p6 = new JPanel();
        p6.setLayout(new BorderLayout());
        JPanel p5 = new JPanel();
        p5.setLayout(new BorderLayout());
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(3, 0, 0, 0));
        p1.add(this.getDestFolderLabel());
        p1.add(this.getFilenameLabel());
        p1.add(this.getMimetypeLabel());
        JPanel p2 = new JPanel();
        p2.setBorder(new EmptyBorder(0, 5, 0, 5));
        p2.setLayout(new GridLayout(3, 0, 0, 0));
        p2.add(this.getDestFolderField());
        p2.add(this.getFilenameField());
        p2.add(this.getMimetypeField());
        p5.add((Component)p1, "Before");
        p5.add((Component)p2, "Center");
        JPanel p4 = new JPanel();
        p4.setLayout(new BorderLayout());
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(3, 0, 0, 0));
        p3.add(this.getDestFolderBrowseButton());
        p4.add((Component)p3, "Before");
        p6.add((Component)p5, "Center");
        p6.add((Component)p4, "After");
        panel.add((Component)p6, "North");
        panel.setComponentOrientation(this.getCompOri());
        this.getDestFolderLabel().setLabelFor(this.getDestFolderField());
        this.getFilenameLabel().setLabelFor(this.getFilenameField());
        this.getMimetypeLabel().setLabelFor(this.getMimetypeField());
        return panel;
    }

    private JPanel makeOptionsPanel() {
        JPanel panel = new JPanel();
        if (this.viewer.getAnnotationServices() != null) {
            panel.setLayout(new FlowLayout(3));
            JPanel p2 = new JPanel();
            p2.setLayout(new GridLayout(2, 0, 0, 0));
            p2.add(this.getIncludeAnnotationCheckbox());
            p2.add(this.getReduceColorsCheckbox());
            p2.setComponentOrientation(this.getCompOri());
            panel.add((Component)p2, "Before");
            panel.setComponentOrientation(this.getCompOri());
        }
        return panel;
    }

    public JButton getDestFolderBrowseButton() {
        if (this.destFolderBrowseButton == null) {
            this.destFolderBrowseButton = new JButton(PViewerUtilities.getMessage("exportDialog.button.Browse"));
            this.destFolderBrowseButton.setMnemonic(PViewerUtilities.getMessage("exportDialog.button.Browse.mnemonic").charAt(0));
            this.destFolderBrowseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PExportDocumentDialog.this.chooser = new JFileChooser(PExportDocumentDialog.this.getDestFolderField().getText());
                    PExportDocumentDialog.this.chooser.setFileSelectionMode(1);
                    PExportDocumentDialog.this.chooser.setComponentOrientation(PExportDocumentDialog.this.getCompOri());
                    int ret = PExportDocumentDialog.this.chooser.showOpenDialog(PExportDocumentDialog.this);
                    String directory = new String("");
                    if (ret == 0) {
                        directory = PExportDocumentDialog.this.chooser.getSelectedFile().getPath();
                        PExportDocumentDialog.this.destFolderField.setText(directory);
                    }
                    PExportDocumentDialog.this.chooser = null;
                }
            });
            this.destFolderBrowseButton.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent fe) {
                    PExportDocumentDialog.this.getRootPane().setDefaultButton(PExportDocumentDialog.this.destFolderBrowseButton);
                }

                public void focusLost(FocusEvent fe) {
                    PExportDocumentDialog.this.setButtonStates();
                }
            });
        }
        return this.destFolderBrowseButton;
    }

    public JTextField getDestFolderField() {
        if (this.destFolderField == null) {
            this.destFolderField = new JTextField(System.getProperty("user.home"));
            this.destFolderField.getDocument().addDocumentListener(this);
            this.destFolderField.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent fe) {
                    PExportDocumentDialog.this.getRootPane().setDefaultButton(PExportDocumentDialog.this.getDestFolderBrowseButton());
                }

                public void focusLost(FocusEvent fe) {
                    if (!fe.isTemporary()) {
                        PExportDocumentDialog.this.setButtonStates();
                    }
                }
            });
        }
        return this.destFolderField;
    }

    public JLabel getDestFolderLabel() {
        if (this.destFolderLabel == null) {
            this.destFolderLabel = new JLabel(PViewerUtilities.getMessage("exportDialog.Directory"));
            this.destFolderLabel.setDisplayedMnemonic(PViewerUtilities.getMessage("exportDialog.Directory.mnemonic").charAt(0));
        }
        return this.destFolderLabel;
    }

    public JTextField getFilenameField() {
        if (this.filenameField == null) {
            this.filenameField = new JTextField();
            this.filenameField.getDocument().addDocumentListener(this);
        }
        return this.filenameField;
    }

    public JLabel getFilenameLabel() {
        if (this.filenameLabel == null) {
            this.filenameLabel = new JLabel(PViewerUtilities.getMessage("exportDialog.Filename"));
            this.filenameLabel.setDisplayedMnemonic(PViewerUtilities.getMessage("exportDialog.Filename.mnemonic").charAt(0));
        }
        return this.filenameLabel;
    }

    public JCheckBox getIncludeAnnotationCheckbox() {
        if (this.includeAnnotationCheckbox == null) {
            this.includeAnnotationCheckbox = new JCheckBox(PViewerUtilities.getMessage("exportDialog.IncludeAnnotations"));
            this.includeAnnotationCheckbox.setMnemonic(PViewerUtilities.getMessage("exportDialog.IncludeAnnotations.mnemonic").charAt(0));
            this.includeAnnotationCheckbox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (PExportDocumentDialog.this.getIncludeAnnotationCheckbox().isSelected()) {
                        PExportDocumentDialog.this.getReduceColorsCheckbox().setEnabled(true);
                    } else {
                        PExportDocumentDialog.this.getReduceColorsCheckbox().setEnabled(false);
                    }
                }
            });
        }
        if (this.docModel.getAnnotationSet() == null || this.docModel.getAnnotationSet().getAnnotationCount() == 0) {
            this.includeAnnotationCheckbox.setEnabled(false);
        } else {
            this.includeAnnotationCheckbox.setEnabled(true);
        }
        return this.includeAnnotationCheckbox;
    }

    JCheckBox getReduceColorsCheckbox() {
        if (this.reduceColorsCheckbox == null) {
            this.reduceColorsCheckbox = new JCheckBox(PViewerUtilities.getMessage("exportDialog.reduceAnnotationColors"));
            this.reduceColorsCheckbox.setMnemonic(PViewerUtilities.getMessage("exportDialog.reduceAnnotationColors.mnemonic").charAt(0));
            this.reduceColorsCheckbox.setEnabled(false);
        }
        return this.reduceColorsCheckbox;
    }

    Vector getValidMimetypes() {
        this.mimeTypes = new Hashtable();
        String validTypesString = this.viewer.getConfigPropertyOrMessage("exportDialog.SaveAsType.validTypes");
        StringTokenizer tok = new StringTokenizer(validTypesString, ",");
        int count = tok.countTokens();
        Object[] validTypes = new Object[count];
        int i = 0;
        while (tok.hasMoreTokens()) {
            validTypes[i++] = tok.nextToken();
        }
        Vector<String> v = new Vector<String>();
        String sourceMimeType = this.docModel.document.getMimeType();
        for (i = 0; i < validTypes.length; ++i) {
            String validType = (String)validTypes[i];
            String destMimeType = this.getMimeType(validType);
            String destMimeSuffix = this.getMimeSuffix(validType);
            String destMimeName = this.getMimeName(validType);
            String selectString = destMimeName + " (." + destMimeSuffix + ")";
            this.mimeTypes.put(selectString, validType);
            if (!this.docModel.document.getEngine().canWriteDocument(sourceMimeType, destMimeType)) continue;
            v.addElement(selectString);
        }
        return v;
    }

    String getMimeName(String type) {
        return this.viewer.getConfigPropertyOrMessage("exportDialog.SaveAsType.validTypes." + type + ".name");
    }

    String getMimeType(String type) {
        return this.viewer.getConfigPropertyOrMessage("exportDialog.SaveAsType.validTypes." + type + ".mimetype");
    }

    String getMimeSuffix(String type) {
        return this.viewer.getConfigPropertyOrMessage("exportDialog.SaveAsType.validTypes." + type + ".suffix");
    }

    public JComboBox getMimetypeField() {
        if (this.mimetypeField == null) {
            this.mimetypeField = new JComboBox(this.getValidMimetypes());
            this.mimetypeField.setEnabled(true);
        }
        return this.mimetypeField;
    }

    public JLabel getMimetypeLabel() {
        if (this.mimetypeLabel == null) {
            this.mimetypeLabel = new JLabel(PViewerUtilities.getMessage("exportDialog.SaveAsType"));
            this.mimetypeLabel.setDisplayedMnemonic(PViewerUtilities.getMessage("exportDialog.SaveAsType.mnemonic").charAt(0));
        }
        return this.mimetypeLabel;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(PViewerUtilities.getMessage("printDialog.button.Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PExportDocumentDialog.this.dispatchEvent(new WindowEvent(PExportDocumentDialog.this, 201));
                }
            });
        }
        return this.cancelButton;
    }

    public JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton(PViewerUtilities.getMessage("exportDialog.button.Help"));
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PExportDocumentDialog.this.fireCMBDocHelpEvent();
                }
            });
        }
        return this.helpButton;
    }

    public JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(PViewerUtilities.getMessage("printDialog.button.OK"));
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PExportDocumentDialog.this.exportDocument();
                }
            });
        }
        return this.okButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportDocument() {
        String methodName = "exportDocument";
        File file = null;
        FileOutputStream os = null;
        try {
            int option;
            boolean withAnnotations = this.getIncludeAnnotationCheckbox().isSelected();
            boolean reduceColors = this.getReduceColorsCheckbox().isSelected();
            String selectString = (String)this.getMimetypeField().getSelectedItem();
            String validType = (String)this.mimeTypes.get(selectString);
            String destMimetype = this.getMimeType(validType);
            String destMimetypeSuffix = this.getMimeSuffix(validType);
            String filename = this.getFilenameField().getText();
            String dirname = this.getDestFolderField().getText();
            if (!filename.endsWith(destMimetypeSuffix)) {
                filename = filename + "." + destMimetypeSuffix;
            }
            if (dirname.length() > 0) {
                dirname.trim();
                filename = dirname.endsWith(File.separator) ? dirname + filename : dirname + File.separatorChar + filename;
            }
            if ((file = new File(filename)).exists() && (option = JOptionPane.showConfirmDialog(this, PViewerUtilities.getMessage("DocumentViewer.overwriteWarning.message", new Object[]{filename}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0)) != 0) {
                return;
            }
            os = new FileOutputStream(file);
            this.viewer.exportDocument(this.docModel, os, withAnnotations, reduceColors, destMimetype);
            this.dispatchEvent(new WindowEvent(this, 201));
        }
        catch (OutOfMemoryError me) {
            JOptionPane.showMessageDialog(null, PViewerUtilities.getMessage("DocumentViewer.outOfMemoryErrorMessage"), PViewerUtilities.getMessage("DocumentViewer.outOfMemoryErrorDialogTitle"), 0, null);
            if (file != null && file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            JOptionPane.showMessageDialog(null, PViewerUtilities.getMessage("exportDialog.cannotBeExported", new Object[]{e.getMessage()}), PViewerUtilities.getMessage("exportDialog.Title"), 0, null);
            if (file != null && file.exists()) {
                file.delete();
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    ViewerLogger.logError((Object)this, methodName, e);
                }
            }
        }
    }

    void setButtonStates() {
        String dirname = this.getDestFolderField().getText();
        File f = new File(dirname);
        if (dirname.length() > 0 && f.isDirectory() && this.getFilenameField().getText().length() > 0 && this.getMimetypeField().getSelectedIndex() >= 0) {
            this.getOkButton().setEnabled(true);
            if (this.getDestFolderField().hasFocus() || this.getDestFolderBrowseButton().hasFocus()) {
                this.getRootPane().setDefaultButton(this.getDestFolderBrowseButton());
            } else {
                this.getRootPane().setDefaultButton(this.getOkButton());
            }
        } else {
            this.getOkButton().setEnabled(false);
            if (this.getDestFolderField().hasFocus() || this.getDestFolderBrowseButton().hasFocus()) {
                this.getRootPane().setDefaultButton(this.getDestFolderBrowseButton());
            } else {
                this.getRootPane().setDefaultButton(this.getCancelButton());
            }
        }
    }

    public ComponentOrientation getCompOri() {
        if (this.compOri == null) {
            boolean ltr = PViewerUtilities.isLeftToRight();
            this.compOri = ComponentOrientation.LEFT_TO_RIGHT;
            if (!ltr) {
                this.compOri = ComponentOrientation.RIGHT_TO_LEFT;
            }
        }
        return this.compOri;
    }

    public JLabel getInfoLabel() {
        if (this.infoLabel == null) {
            this.infoLabel = new JLabel(PViewerUtilities.getMessage("exportDialog.InfoLine"));
            this.infoLabel.setBorder(new EmptyBorder(10, 5, 10, 5));
        }
        return this.infoLabel;
    }

    public void changedUpdate(DocumentEvent e) {
        this.setButtonStates();
    }

    public void insertUpdate(DocumentEvent e) {
        this.setButtonStates();
    }

    public void removeUpdate(DocumentEvent e) {
        this.setButtonStates();
    }

    public void addDocHelpListener(CMBGenericDocHelpListener listener) {
        this.docHelpListeners.addElement(listener);
    }

    public void removeDocHelpListener(CMBGenericDocHelpListener listener) {
        this.docHelpListeners.removeElement(listener);
    }

    public void fireCMBDocHelpEvent() {
        CMBGenericDocHelpEvent docHelpEvent = new CMBGenericDocHelpEvent(this);
        for (int i = 0; i < this.docHelpListeners.size(); ++i) {
            CMBGenericDocHelpListener listener = (CMBGenericDocHelpListener)this.docHelpListeners.elementAt(i);
            listener.onHelp(docHelpEvent);
        }
    }

    public void updateDialog(PDocModel docModel, CMBStreamingDocServices docServices) {
        this.docModel = docModel;
        this.docServices = docServices;
        this.getMimetypeField().setModel(new DefaultComboBoxModel(this.getValidMimetypes()));
        this.getIncludeAnnotationCheckbox().setSelected(false);
        this.getReduceColorsCheckbox().setSelected(false);
        this.getFilenameField().setText(null);
        Timer focusTimer = new Timer(200, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PExportDocumentDialog.this.requestFocus();
            }
        });
        focusTimer.setRepeats(false);
        focusTimer.setInitialDelay(0);
        focusTimer.start();
    }

    public void dispose() {
        if (this.chooser != null) {
            this.chooser.cancelSelection();
        }
        super.dispose();
    }

    private class ExportFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private ExportFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(PExportDocumentDialog.this.getDestFolderField())) {
                return PExportDocumentDialog.this.getDestFolderBrowseButton();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getDestFolderBrowseButton())) {
                return PExportDocumentDialog.this.getFilenameField();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getFilenameField())) {
                return PExportDocumentDialog.this.getMimetypeField();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getMimetypeField())) {
                if (PExportDocumentDialog.this.getIncludeAnnotationCheckbox().isEnabled()) {
                    return PExportDocumentDialog.this.getIncludeAnnotationCheckbox();
                }
                if (PExportDocumentDialog.this.getReduceColorsCheckbox().isEnabled()) {
                    return PExportDocumentDialog.this.getReduceColorsCheckbox();
                }
                if (PExportDocumentDialog.this.getOkButton().isEnabled()) {
                    return PExportDocumentDialog.this.getOkButton();
                }
                return PExportDocumentDialog.this.getCancelButton();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getIncludeAnnotationCheckbox())) {
                if (PExportDocumentDialog.this.getReduceColorsCheckbox().isEnabled()) {
                    return PExportDocumentDialog.this.getReduceColorsCheckbox();
                }
                if (PExportDocumentDialog.this.getOkButton().isEnabled()) {
                    return PExportDocumentDialog.this.getOkButton();
                }
                return PExportDocumentDialog.this.getCancelButton();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getReduceColorsCheckbox())) {
                if (PExportDocumentDialog.this.getOkButton().isEnabled()) {
                    return PExportDocumentDialog.this.getOkButton();
                }
                return PExportDocumentDialog.this.getCancelButton();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getOkButton())) {
                return PExportDocumentDialog.this.getCancelButton();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getCancelButton())) {
                if (!PExportDocumentDialog.this.docHelpListeners.isEmpty()) {
                    return PExportDocumentDialog.this.getHelpButton();
                }
                return PExportDocumentDialog.this.getDestFolderField();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getHelpButton())) {
                return PExportDocumentDialog.this.getDestFolderField();
            }
            return PExportDocumentDialog.this.getDestFolderField();
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(PExportDocumentDialog.this.getHelpButton())) {
                return PExportDocumentDialog.this.getCancelButton();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getCancelButton())) {
                if (PExportDocumentDialog.this.getOkButton().isEnabled()) {
                    return PExportDocumentDialog.this.getOkButton();
                }
                if (PExportDocumentDialog.this.getReduceColorsCheckbox().isEnabled()) {
                    return PExportDocumentDialog.this.getReduceColorsCheckbox();
                }
                if (PExportDocumentDialog.this.getIncludeAnnotationCheckbox().isEnabled()) {
                    return PExportDocumentDialog.this.getIncludeAnnotationCheckbox();
                }
                return PExportDocumentDialog.this.getMimetypeField();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getOkButton())) {
                if (PExportDocumentDialog.this.getReduceColorsCheckbox().isEnabled()) {
                    return PExportDocumentDialog.this.getReduceColorsCheckbox();
                }
                if (PExportDocumentDialog.this.getIncludeAnnotationCheckbox().isEnabled()) {
                    return PExportDocumentDialog.this.getIncludeAnnotationCheckbox();
                }
                return PExportDocumentDialog.this.getMimetypeField();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getReduceColorsCheckbox())) {
                return PExportDocumentDialog.this.getIncludeAnnotationCheckbox();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getIncludeAnnotationCheckbox())) {
                return PExportDocumentDialog.this.getMimetypeField();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getMimetypeField())) {
                return PExportDocumentDialog.this.getFilenameField();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getFilenameField())) {
                return PExportDocumentDialog.this.getDestFolderBrowseButton();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getDestFolderBrowseButton())) {
                return PExportDocumentDialog.this.getDestFolderField();
            }
            if (aComponent.equals(PExportDocumentDialog.this.getDestFolderField())) {
                if (!PExportDocumentDialog.this.docHelpListeners.isEmpty()) {
                    return PExportDocumentDialog.this.getHelpButton();
                }
                return PExportDocumentDialog.this.getCancelButton();
            }
            return PExportDocumentDialog.this.getDestFolderField();
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return PExportDocumentDialog.this.getDestFolderField();
        }

        public Component getLastComponent(Container focusCycleRoot) {
            return PExportDocumentDialog.this.getCancelButton();
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            return PExportDocumentDialog.this.getDestFolderField();
        }

        public Component getInitialComponent(Window window) {
            return PExportDocumentDialog.this.getDestFolderField();
        }
    }
}

