/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBViewerAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class PDropDownButton
extends JButton {
    private JButton selectedToolButton;
    private Action[] tools;
    private CMBGenericDocViewer gdv;

    public PDropDownButton(CMBGenericDocViewer gdv) {
        this.gdv = gdv;
        this.setLayout(new BorderLayout(0, 0));
        this.setAction(new DropDownAction());
        this.setIcon(this.loadIcon("DropDown.gif"));
        this.selectedToolButton = new JButton();
        this.add((Component)this.selectedToolButton, "Before");
        DropDownMouseListener dropDownMouseListener = new DropDownMouseListener();
        this.addMouseListener(dropDownMouseListener);
        this.selectedToolButton.addMouseListener(dropDownMouseListener);
    }

    public void setTools(Action[] tools) {
        this.tools = tools;
        ToolPropertyChangeListener toolPropertyChangeListener = new ToolPropertyChangeListener();
        for (int i = 0; i < tools.length; ++i) {
            tools[i].addPropertyChangeListener(toolPropertyChangeListener);
        }
        this.selectedToolButton.setAction(tools[0]);
    }

    public JButton getSelectedToolButton() {
        return this.selectedToolButton;
    }

    private ImageIcon loadIcon(String name) {
        URL iconUrl = this.gdv.getClass().getClassLoader().getResource("com/ibm/mm/viewer/images/" + name);
        if (iconUrl != null) {
            ImageIcon normalIcon = new ImageIcon(iconUrl);
            return normalIcon;
        }
        return null;
    }

    private class ToolPropertyChangeListener
    implements PropertyChangeListener {
        private ToolPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            for (int i = 0; i < PDropDownButton.this.tools.length; ++i) {
                if (!PDropDownButton.this.tools[i].isEnabled()) continue;
                PDropDownButton.this.setEnabled(true);
                return;
            }
            PDropDownButton.this.setEnabled(false);
        }
    }

    private class ToolActionListener
    implements ActionListener {
        private ToolActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PDropDownButton.this.selectedToolButton.setAction(((JMenuItem)e.getSource()).getAction());
            PDropDownButton.this.selectedToolButton.setLabel(null);
        }
    }

    private class DropDownAction
    extends AbstractAction {
        private DropDownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JPopupMenu menu = new JPopupMenu();
            menu.setLightWeightPopupEnabled(false);
            for (int i = 0; i < PDropDownButton.this.tools.length; ++i) {
                JMenuItem item;
                Boolean toggle = (Boolean)PDropDownButton.this.tools[1].getValue("toggle");
                if (toggle != null && toggle.booleanValue()) {
                    item = new JCheckBoxMenuItem(PDropDownButton.this.tools[i]);
                    ((JCheckBoxMenuItem)item).setSelected(((CMBViewerAction)PDropDownButton.this.tools[i]).isSelected());
                } else {
                    item = new JMenuItem(PDropDownButton.this.tools[i]);
                }
                menu.add(item);
                item.addActionListener(new ToolActionListener());
            }
            menu.show(PDropDownButton.this.selectedToolButton, 0, PDropDownButton.this.selectedToolButton.getHeight());
        }
    }

    private class DropDownMouseListener
    implements MouseListener {
        private DropDownMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            PDropDownButton.this.selectedToolButton.getModel().setRollover(true);
            PDropDownButton.this.getModel().setRollover(true);
        }

        public void mouseExited(MouseEvent e) {
            PDropDownButton.this.selectedToolButton.getModel().setRollover(false);
            PDropDownButton.this.getModel().setRollover(false);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

