/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocClosedEvent;
import com.ibm.mm.viewer.CMBGenericDocClosedListener;
import com.ibm.mm.viewer.CMBGenericDocOpenedEvent;
import com.ibm.mm.viewer.CMBGenericDocOpenedListener;
import com.ibm.mm.viewer.CMBGenericDocSelectedEvent;
import com.ibm.mm.viewer.CMBGenericDocSelectedListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBViewerAction;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

class PDockThumbnailsAction
extends CMBViewerAction
implements CMBGenericDocOpenedListener,
CMBGenericDocClosedListener,
CMBGenericDocSelectedListener,
CMBGenericDocStateChangedListener {
    public PDockThumbnailsAction(CMBGenericDocViewer viewer) {
        super(viewer);
        this.initialize();
    }

    public PDockThumbnailsAction(CMBGenericDocViewer viewer, String name) {
        super(viewer, name);
        this.initialize();
    }

    public PDockThumbnailsAction(CMBGenericDocViewer viewer, String name, Icon icon) {
        super(viewer, name, icon);
        this.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        this.getViewer().dockThumbnails();
    }

    private void initialize() {
        CMBGenericDocViewer viewer = this.getViewer();
        viewer.addDocOpenedListener(this);
        viewer.addDocClosedListener(this);
        viewer.addDocSelectedListener(this);
        viewer.addDocStateChangedListener(this);
        viewer.addPropertyChangeListener("Thumbnailbar.show", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent arg0) {
                PDockThumbnailsAction.this.setToolStatus();
            }
        });
        viewer.addPropertyChangeListener("Thumbnails.dock", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent arg0) {
                PDockThumbnailsAction.this.setToolStatus();
            }
        });
        this.setToolStatus();
    }

    private void setToolStatus() {
        CMBGenericDocViewer viewer = this.getViewer();
        this.setEnabled(viewer.canDockThumbnails());
        this.setSelected(viewer.getSelectedModel() != null && viewer.areThumbnailsDocked() && viewer.getViewerLayout() != 3);
        if (viewer.canDockThumbnails()) {
            if (viewer.areThumbnailsDocked()) {
                this.putValue("ShortDescription", PViewerUtilities.getMessage("thumbnail_dock.toggle_on.tooltip"));
            } else {
                this.putValue("ShortDescription", PViewerUtilities.getMessage("thumbnail_dock.toggle_off.tooltip"));
            }
        } else {
            this.putValue("ShortDescription", PViewerUtilities.getMessage("thumbnail_dock.tooltip"));
        }
    }

    public void genericDocOpened(CMBGenericDocOpenedEvent evt) {
        this.setToolStatus();
    }

    public void genericDocClosed(CMBGenericDocClosedEvent evt) {
        this.setToolStatus();
    }

    public void genericDocSelected(CMBGenericDocSelectedEvent evt) {
        this.setToolStatus();
    }

    public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
        this.setToolStatus();
    }
}

