/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocStateChangedListener;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.PTaskManager;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.Properties;
import java.util.Vector;

abstract class PDocModel
implements Pageable,
Printable {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    protected CMBDocument document;
    protected CMBAnnotationSet annoSet;
    private String docName;
    private String styledDocName;
    private Vector stateChangedListeners;
    protected PageFormat pageFormat = null;
    private PTaskManager taskManager;
    private boolean activeDocument;
    private boolean relatedInfoModified;
    private boolean _viewed = false;
    private boolean fireEvents = true;

    abstract int getFit();

    abstract void fitWidth(Dimension var1, int var2, int var3);

    abstract void fitHeight(Dimension var1, int var2, int var3);

    abstract void fitInWindow(Dimension var1, int var2, int var3);

    abstract void fitActualSize();

    abstract boolean canDeletePages(int var1);

    abstract boolean canPastePages(int var1);

    abstract boolean canEnhance();

    abstract boolean canInvert();

    abstract boolean canRotate();

    abstract boolean canScale();

    abstract boolean canPaginate();

    abstract boolean canPrint();

    abstract boolean canExport();

    abstract void setEnhance(boolean var1);

    abstract boolean isEnhance();

    abstract void setInvert(boolean var1);

    abstract boolean isInvert();

    abstract double getZoomFactor();

    abstract void setZoomFactor(double var1);

    abstract double getScale();

    abstract void setScale(double var1);

    abstract int getRotation();

    abstract boolean isMaxZoomedOut();

    abstract boolean isMaxZoomedIn();

    abstract void zoom(Rectangle var1, Rectangle var2);

    abstract void zoomIn();

    abstract void zoomOut();

    private PDocModel() {
    }

    protected PDocModel(CMBDocument document, CMBAnnotationSet annoSet) {
        this.document = document;
        this.annoSet = annoSet;
        if (document != null && document.getCanEnhance()) {
            document.setEnhance(true);
        }
    }

    public String getDocName() {
        return this.docName;
    }

    public void setDocName(String docName) {
        this.docName = docName;
    }

    public String getStyledDocName() {
        if (this.styledDocName == null) {
            return this.docName;
        }
        return this.styledDocName;
    }

    public void setStyledDocName(String styledDocName) {
        this.styledDocName = styledDocName;
    }

    void addDocStateChangedListener(CMBGenericDocStateChangedListener listener) {
        if (this.stateChangedListeners == null) {
            this.stateChangedListeners = new Vector();
        }
        this.stateChangedListeners.add(listener);
    }

    void removeDocStateChangedListener(CMBGenericDocStateChangedListener listener) {
        if (this.stateChangedListeners == null) {
            return;
        }
        this.stateChangedListeners.remove(listener);
    }

    void fireDocStateChangedEvent(int changeType) {
        CMBGenericDocStateChangedEvent event = new CMBGenericDocStateChangedEvent(this, this.document, new int[]{this.getCurrentPageNumber()}, changeType);
        this.fireDocStateChangedEvent(event);
    }

    void fireDocStateChangedEvent(CMBGenericDocStateChangedEvent event) {
        String methodName = "fireDocStateChangedEvent";
        if (!this.fireEvents) {
            return;
        }
        if (this.stateChangedListeners == null) {
            return;
        }
        int size = this.stateChangedListeners.size();
        for (int i = 0; i < size; ++i) {
            Object listener = this.stateChangedListeners.elementAt(i);
            try {
                if (listener instanceof CMBGenericDocStateChangedListener) {
                    ((CMBGenericDocStateChangedListener)listener).genericDocStateChanged(event);
                    continue;
                }
                ((CMBDocStateChangedListener)listener).handleDocStateChangedEvent(event.getDocument());
                continue;
            }
            catch (Exception e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
        }
    }

    void addDocStateChangedListener(CMBDocStateChangedListener listener) {
        if (this.stateChangedListeners == null) {
            this.stateChangedListeners = new Vector();
        }
        this.stateChangedListeners.add(listener);
    }

    void removeDocStateChangedListener(CMBDocStateChangedListener listener) {
        if (this.stateChangedListeners == null) {
            return;
        }
        this.stateChangedListeners.remove(listener);
    }

    CMBDocument getDocument() {
        return this.document;
    }

    CMBAnnotationSet getAnnotationSet() {
        return this.annoSet;
    }

    abstract int getCurrentPagePosition();

    abstract void setCurrentPagePosition(int var1);

    abstract int getCurrentPageNumber();

    abstract void setCurrentPageNumber(int var1);

    int getPageCount() {
        return 1;
    }

    public int getNumberOfPages() {
        return -1;
    }

    public PageFormat getPageFormat(int index) {
        return this.pageFormat;
    }

    void setPageFormat(PageFormat pf) {
        this.pageFormat = pf;
    }

    public Printable getPrintable(int index) {
        return this;
    }

    public boolean getPrivilege(int privilege) {
        return false;
    }

    public void setPrivilege(int privilege, boolean enable) {
    }

    void dispose() {
        if (this.annoSet != null) {
            this.annoSet.dispose();
            this.annoSet = null;
        }
        if (this.document != null) {
            this.document.dispose();
            this.document = null;
        }
        if (this.stateChangedListeners != null) {
            this.stateChangedListeners.clear();
            this.stateChangedListeners = null;
        }
    }

    public PTaskManager getTaskManager() {
        if (this.taskManager == null) {
            this.taskManager = new PTaskManager();
        }
        return this.taskManager;
    }

    public void setActiveDocument(boolean activeDocument) {
        this.activeDocument = activeDocument;
    }

    public boolean isActiveDocument() {
        return this.activeDocument;
    }

    public void setRelatedInfoModified(boolean modified) {
        this.relatedInfoModified = modified;
    }

    public boolean isRelatedInfoModified() {
        return this.relatedInfoModified;
    }

    boolean isViewed() {
        return this._viewed;
    }

    void setViewed(boolean viewed) {
        this._viewed = viewed;
    }

    public void initUsingProperties(Properties properties) {
    }

    void refit(Dimension viewDim, int vScrollBarWidth, int hScrollBarHeight) {
    }

    public void setFireChangeEvents(boolean fireEvents) {
        this.fireEvents = fireEvents;
    }

    public String toString() {
        return PViewerUtilities.stripHtml(this.getDocName());
    }
}

