/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PAbstractTask;
import com.ibm.mm.viewer.PClippedPages;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PTaskManager;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.Rectangle;
import javax.swing.JOptionPane;

class PDeleteSelectedAreaTask
extends PAbstractTask {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBGenericDocViewer viewer = null;
    int pageNumber;
    private Rectangle selectedArea;
    private PClippedPages originalPages;

    PDeleteSelectedAreaTask(PTaskManager taskManager, CMBGenericDocViewer viewer, int pageNumber, Rectangle selectedArea) {
        super(taskManager);
        this.viewer = viewer;
        this.pageNumber = pageNumber;
        this.selectedArea = selectedArea;
        this.getManager().invokeTask(this, true);
    }

    public boolean doIt() {
        String methodName = "doIt";
        try {
            PPageModel model = (PPageModel)this.viewer.getSelectedModel();
            this.originalPages = new PClippedPages(this.viewer.getDocServices(), this.viewer.getAnnotationServices());
            this.originalPages.setThumbnailSize(this.viewer.getThumbnailsSize());
            model.copyPages(new int[]{this.pageNumber}, this.originalPages);
            model.redact(this.pageNumber, this.selectedArea);
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            JOptionPane.showMessageDialog(this.viewer, PViewerUtilities.getMessage("DocumentViewer.selectedAreaNotDeleted", new String[]{e.getMessage()}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
            return false;
        }
        return true;
    }

    public boolean undoIt() {
        String methodName = "undoIt";
        try {
            PPageModel model = (PPageModel)this.viewer.getSelectedModel();
            PClippedPages redactedPages = new PClippedPages(this.viewer.getDocServices(), this.viewer.getAnnotationServices());
            redactedPages.setThumbnailSize(this.viewer.getThumbnailsSize());
            model.deletePages(new int[]{this.pageNumber}, redactedPages);
            model.restorePages(this.originalPages, new int[]{this.pageNumber});
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            JOptionPane.showMessageDialog(this.viewer, PViewerUtilities.getMessage("DocumentViewer.selectedAreaNotRestored", new String[]{e.getMessage()}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
            return false;
        }
        return true;
    }

    public String getDescription() {
        return PViewerUtilities.getMessage("deleteSelectedAreaTask.description");
    }
}

