/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PAbstractTask;
import com.ibm.mm.viewer.PTaskManager;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;

class PDeleteAnnotationTask
extends PAbstractTask {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBGenericDocViewer viewer = null;
    private CMBPageAnnotation anno;
    private int originalIndex;

    PDeleteAnnotationTask(PTaskManager taskManager, CMBGenericDocViewer viewer, CMBPageAnnotation anno, boolean doItNow) {
        super(taskManager);
        this.viewer = viewer;
        this.anno = anno;
        this.originalIndex = anno.getCurrentIndex();
        this.getManager().invokeTask(this, doItNow);
    }

    public boolean doIt() {
        String methodName = "doIt";
        try {
            this.viewer.getSelectedAnnotationSet().removeAnnotation(this.anno);
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return false;
        }
        return true;
    }

    public boolean undoIt() {
        String methodName = "undoIt";
        try {
            this.viewer.addAnnotation(this.anno);
            this.viewer.getSelectedAnnotationSet().reorderAnnotation(this.anno, this.originalIndex);
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return false;
        }
        return true;
    }

    public String getDescription() {
        return PViewerUtilities.getMessage("deleteAnnotationTask.description");
    }
}

