/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PAbstractTask;
import com.ibm.mm.viewer.PTaskManager;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;

class PCreateAnnotationTask
extends PAbstractTask {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    CMBGenericDocViewer viewer = null;
    CMBPageAnnotation anno = null;

    PCreateAnnotationTask(PTaskManager taskManager, CMBGenericDocViewer viewer, CMBPageAnnotation anno, boolean doItNow) {
        super(taskManager);
        this.viewer = viewer;
        this.anno = anno;
        this.getManager().invokeTask(this, doItNow);
    }

    PCreateAnnotationTask(PTaskManager taskManager) {
        super(taskManager);
    }

    public boolean doIt() {
        String methodName = "doIt";
        try {
            CMBAnnotationSet annoModel = this.viewer.getSelectedAnnotationSet();
            this.anno.setImageHeight(annoModel.getImageHeight());
            this.anno.setImageWidth(annoModel.getImageWidth());
            this.anno.setScaleNum((int)((double)annoModel.getScale() * annoModel.getScaleFactor()));
            this.anno.setRotation(annoModel.getRotation());
            this.anno.setAnnotationRotation(0);
            annoModel.addAnnotation(this.anno);
            annoModel.setSelectedAnnotations(new CMBPageAnnotation[]{this.anno});
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return false;
        }
        return true;
    }

    public boolean undoIt() {
        String methodName = "undoIt";
        try {
            this.viewer.getSelectedAnnotationSet().removeAnnotation(this.anno);
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return false;
        }
        return true;
    }

    public String getDescription() {
        return PViewerUtilities.getMessage("createAnnotationTask.description");
    }
}

