/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PAbstractTask;
import com.ibm.mm.viewer.PClippedPages;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PTaskManager;
import com.ibm.mm.viewer.PViewerUtilities;
import javax.swing.JOptionPane;

class PCopyPagesTask
extends PAbstractTask {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBGenericDocViewer viewer = null;
    private int[] pages;
    private PClippedPages clippedPages;

    PCopyPagesTask(PTaskManager taskManager, CMBGenericDocViewer viewer, int[] pages) {
        super(taskManager);
        this.viewer = viewer;
        this.pages = pages;
        this.getManager().invokeTask(this, true);
    }

    public boolean doIt() {
        String methodName = "doIt";
        try {
            PPageModel model = (PPageModel)this.viewer.getSelectedModel();
            this.clippedPages = new PClippedPages(this.viewer.getDocServices(), this.viewer.getAnnotationServices());
            this.clippedPages.setThumbnailSize(this.viewer.getThumbnailsSize());
            model.copyPages(this.pages, this.clippedPages);
            this.viewer.localClipboard.setContents(this.clippedPages, null);
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            JOptionPane.showMessageDialog(this.viewer, PViewerUtilities.getMessage("DocumentViewer.pagesNotCopied", new String[]{e.getMessage()}), PViewerUtilities.getMessage("DocumentViewer.errorMessageTitle"), 0, null);
            return false;
        }
        return false;
    }

    public boolean undoIt() {
        return true;
    }

    public String getDescription() {
        return PViewerUtilities.getMessage("copyPagesTask.description");
    }
}

