/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.CMBStreamingDocServices;
import com.ibm.mm.viewer.CMBViewerException;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

class PClippedPages
implements Transferable {
    public static DataFlavor clippedPagesFlavor = new DataFlavor(PClippedPages.class, "Clipped Pages");
    private static DataFlavor[] flavors = new DataFlavor[]{clippedPagesFlavor};
    private CMBStreamingDocServices docServices;
    private CMBDocument clipDocument;
    private CMBDocument clipDocumentConverted;
    private CMBAnnotationServices annoServices;
    private CMBAnnotationSet clipAnnoSet;
    private Serializable relatedInfo;
    private Image[] thumbnailPageImages;
    private Dimension thumbnailSize;

    public PClippedPages(CMBStreamingDocServices docServices, CMBAnnotationServices annoServices) {
        this.docServices = docServices;
        this.annoServices = annoServices;
    }

    public void moveToClippedPages(CMBDocument sourceDocument, CMBAnnotationSet sourceAnnoSet, int[] sourcePages) throws IOException, CMBAnnotationEngineException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.initializeClipDoc(sourceDocument, sourceAnnoSet);
        for (int i = 0; i < sourcePages.length; ++i) {
            this.moveSinglePageToClippedPages(sourceDocument, sourceAnnoSet, sourcePages[i] - i);
        }
    }

    private void moveSinglePageToClippedPages(CMBDocument sourceDocument, CMBAnnotationSet sourceAnnoSet, int sourcePage) throws IOException, CMBAnnotationEngineException {
        int i;
        for (int i2 = 0; i2 < sourceAnnoSet.getAnnotationCount(); ++i2) {
            CMBPageAnnotation annotation = sourceAnnoSet.getAnnotationAt(i2);
            if (annotation.getPageNumber() == sourcePage && !annotation.canDelete()) {
                throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.cannotDeleteAnnotations"));
            }
            if (annotation.getPageNumber() <= sourcePage || annotation.canUpdate()) continue;
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.cannotUpdateAnnotations"));
        }
        int brightness = sourceDocument.getPage(sourcePage).getBrightness();
        int contrast = sourceDocument.getPage(sourcePage).getContrast();
        this.docServices.movePages(sourceDocument, sourcePage, sourcePage, this.clipDocument, this.clipDocument.getPageCount());
        int clippedDocPageNumber = this.clipDocument.getPageCount();
        this.clipDocument.getPage((int)clippedDocPageNumber).letters = sourceDocument.getPage((int)sourcePage).letters;
        this.clipDocument.getPage((int)clippedDocPageNumber).ocrLetters = sourceDocument.getPage((int)sourcePage).ocrLetters;
        this.clipDocument.getPage(clippedDocPageNumber).setBrightness(brightness);
        this.clipDocument.getPage(clippedDocPageNumber).setContrast(contrast);
        CMBPageAnnotation[] annotations = sourceAnnoSet.getPageAnnotations(sourcePage);
        for (i = 0; i < annotations.length; ++i) {
            CMBPageAnnotation pageAnnotation = annotations[i];
            pageAnnotation.setPageNumber(-1);
            sourceAnnoSet.removeAnnotation(pageAnnotation);
            pageAnnotation.setPageNumber(clippedDocPageNumber);
            this.clipAnnoSet.addAnnotation(pageAnnotation);
        }
        for (i = 0; i < sourceAnnoSet.getAnnotationCount(); ++i) {
            CMBPageAnnotation annotation = sourceAnnoSet.getAnnotationAt(i);
            if (annotation.getPageNumber() <= sourcePage) continue;
            annotation.setPageNumber(annotation.getPageNumber() - 1);
            sourceAnnoSet.setDirty(true);
        }
    }

    public void copyToClippedPages(CMBDocument sourceDocument, CMBAnnotationSet sourceAnnoSet, int[] sourcePages) throws IOException, CMBAnnotationEngineException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.initializeClipDoc(sourceDocument, sourceAnnoSet);
        for (int i = 0; i < sourcePages.length; ++i) {
            this.copySinglePageToClippedPages(sourceDocument, sourceAnnoSet, sourcePages[i]);
        }
    }

    private void copySinglePageToClippedPages(CMBDocument sourceDocument, CMBAnnotationSet sourceAnnoSet, int sourcePage) throws IOException, CMBAnnotationEngineException {
        if (sourceAnnoSet != null && sourceAnnoSet.getPageAnnotations(sourcePage).length > 0 && !this.clipAnnoSet.getPrivilege(8)) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.cannotCreateAnnotations"));
        }
        this.docServices.copyPages(sourceDocument, sourcePage, sourcePage, this.clipDocument, this.clipDocument.getPageCount());
        if (sourceAnnoSet != null) {
            CMBPageAnnotation[] annotations = sourceAnnoSet.getPageAnnotations(sourcePage);
            int clippedPage = this.clipDocument.getPageCount();
            for (int i = 0; i < annotations.length; ++i) {
                CMBPageAnnotation annotation = (CMBPageAnnotation)annotations[i].clone();
                annotation.setPageNumber(clippedPage);
                this.clipAnnoSet.addAnnotation(annotation);
            }
        }
        CMBPage clippedPage = this.clipDocument.getPage(this.clipDocument.getPageCount());
        clippedPage.letters = sourceDocument.getPage((int)sourcePage).letters;
        clippedPage.ocrLetters = sourceDocument.getPage((int)sourcePage).ocrLetters;
        clippedPage.setBrightness(sourceDocument.getPage(sourcePage).getBrightness());
        clippedPage.setContrast(sourceDocument.getPage(sourcePage).getContrast());
    }

    private void convertClippedPages(String destMimetype) throws IOException, CMBAnnotationEngineException {
        String methodName = "convertClippedPages";
        ViewerLogger.logEntry(this, methodName);
        ViewerLogger.logInfo(this, methodName, "destMimeType: " + destMimetype + " orig mimetype: " + this.clipDocument.getMimeType());
        CMBDocument document = this.clipDocument;
        CMBAnnotationSet annoSet = this.clipAnnoSet;
        ByteArrayOutputStream annoStream = new ByteArrayOutputStream();
        ByteArrayOutputStream docStream = new ByteArrayOutputStream();
        document.write(false, true, docStream, document.getMimeType());
        docStream.close();
        annoSet.write(annoStream);
        annoStream.close();
        byte[] docbytes = docStream.toByteArray();
        byte[] annobytes = annoStream.toByteArray();
        ByteArrayInputStream annoInputStream = new ByteArrayInputStream(annobytes);
        ByteArrayInputStream docInputStream = new ByteArrayInputStream(docbytes);
        try {
            CMBDocument exportableDocument = this.docServices.loadDocument((InputStream)docInputStream, 1, document.getMimeType(), document.getMimeType(), annoInputStream, null, null);
            docStream = new ByteArrayOutputStream();
            exportableDocument.write(false, false, docStream, destMimetype);
            docStream.close();
            docbytes = docStream.toByteArray();
            docInputStream = new ByteArrayInputStream(docbytes);
            this.clipDocumentConverted = this.docServices.loadDocument(docInputStream, 1, destMimetype, destMimetype, null, null);
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
            // empty catch block
        }
        ViewerLogger.logExit(this, methodName);
    }

    public void copyFromClippedPages(CMBDocument destDocument, CMBAnnotationSet destAnnoSet, int destPage) throws IOException, CMBAnnotationEngineException {
        String methodName = "copyFromClippedPages";
        CMBDocument srcDocument = this.clipDocument;
        if (!destDocument.getMimeType().equals(this.clipDocument.getMimeType())) {
            ViewerLogger.logInfo(this, methodName, "src: " + this.clipDocument.getMimeType() + " and dest: " + destDocument.getMimeType() + " mimetypes are different");
            this.convertClippedPages(destDocument.getMimeType());
            srcDocument = this.clipDocumentConverted;
        }
        int nClippedPages = srcDocument.getPageCount();
        for (int i = 0; i < nClippedPages; ++i) {
            this.copySinglePageFromClippedPages(srcDocument, destDocument, destAnnoSet, i + 1, destPage + i);
        }
    }

    private void copySinglePageFromClippedPages(CMBDocument srcDocument, CMBDocument destDocument, CMBAnnotationSet destAnnoSet, int clipPage, int destPage) throws IOException, CMBAnnotationEngineException {
        CMBPageAnnotation annotation;
        int i;
        if (this.clipAnnoSet.getPageAnnotations(clipPage).length > 0 && !destAnnoSet.getPrivilege(8)) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.cannotCreateAnnotations"));
        }
        if (destAnnoSet != null) {
            for (i = 0; i < destAnnoSet.getAnnotationCount(); ++i) {
                annotation = destAnnoSet.getAnnotationAt(i);
                if (annotation.getPageNumber() <= destPage || annotation.canUpdate()) continue;
                throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.cannotUpdateAnnotations"));
            }
        }
        this.docServices.copyPages(srcDocument, clipPage, clipPage, destDocument, destPage);
        if (destAnnoSet != null) {
            for (i = 0; i < destAnnoSet.getAnnotationCount(); ++i) {
                annotation = destAnnoSet.getAnnotationAt(i);
                if (annotation.getPageNumber() <= destPage) continue;
                annotation.setPageNumber(annotation.getPageNumber() + 1);
                destAnnoSet.setDirty(true);
            }
        }
        if (this.clipAnnoSet != null) {
            CMBPageAnnotation[] annotations = this.clipAnnoSet.getPageAnnotations(clipPage);
            for (int i2 = 0; i2 < annotations.length; ++i2) {
                CMBPageAnnotation annotation2 = (CMBPageAnnotation)annotations[i2].clone();
                annotation2.setPageNumber(destPage + 1);
                annotation2.setCanHide(true);
                annotation2.setCanShow(true);
                annotation2.setCanUpdate(true);
                annotation2.setCanDelete(true);
                destAnnoSet.addAnnotation(annotation2);
            }
        }
        CMBPage page = destDocument.getPage(destPage + 1);
        page.letters = srcDocument.getPage((int)clipPage).letters;
        page.ocrLetters = srcDocument.getPage((int)clipPage).ocrLetters;
        if (destDocument.isOCRValid()) {
            System.out.println("PClippedPages:destDocument ocr is valid");
            if (page.getOCRLetters() == null) {
                this.docServices.ocrPage(page, null);
            }
        }
        page.setBrightness(srcDocument.getPage(clipPage).getBrightness());
        page.setContrast(srcDocument.getPage(clipPage).getContrast());
    }

    public void restoreFromClippedPages(CMBDocument destDocument, CMBAnnotationSet destAnnoSet, int[] destPages) throws IOException, CMBAnnotationEngineException {
        for (int i = 0; i < destPages.length; ++i) {
            this.restoreSinglePageFromClippedPages(destDocument, destAnnoSet, i + 1, destPages[i] - 1);
        }
    }

    private void restoreSinglePageFromClippedPages(CMBDocument destDocument, CMBAnnotationSet destAnnoSet, int clipPage, int destPage) throws IOException, CMBAnnotationEngineException {
        CMBPageAnnotation annotation;
        int i;
        if (this.clipAnnoSet != null && this.clipAnnoSet.getPageAnnotations(clipPage).length > 0 && !destAnnoSet.getPrivilege(8)) {
            throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.cannotCreateAnnotations"));
        }
        if (destAnnoSet != null) {
            for (i = 0; i < destAnnoSet.getAnnotationCount(); ++i) {
                annotation = destAnnoSet.getAnnotationAt(i);
                if (annotation.getPageNumber() <= destPage || annotation.canUpdate()) continue;
                throw new CMBViewerException(PViewerUtilities.getMessage("DocumentViewer.cannotUpdateAnnotations"));
            }
        }
        this.docServices.copyPages(this.clipDocument, clipPage, clipPage, destDocument, destPage);
        if (destAnnoSet != null) {
            for (i = 0; i < destAnnoSet.getAnnotationCount(); ++i) {
                annotation = destAnnoSet.getAnnotationAt(i);
                if (annotation.getPageNumber() <= destPage) continue;
                annotation.setPageNumber(annotation.getPageNumber() + 1);
                destAnnoSet.setDirty(true);
            }
        }
        if (this.clipAnnoSet != null) {
            CMBPageAnnotation[] annotations = this.clipAnnoSet.getPageAnnotations(clipPage);
            for (int i2 = 0; i2 < annotations.length; ++i2) {
                CMBPageAnnotation oldAnnotation = annotations[i2];
                CMBPageAnnotation newAnnotation = (CMBPageAnnotation)annotations[i2].clone();
                oldAnnotation.setPageNumber(destPage + 1);
                this.clipAnnoSet.removeAnnotation(oldAnnotation);
                this.clipAnnoSet.addAnnotation(newAnnotation);
                destAnnoSet.addAnnotation(oldAnnotation);
            }
        }
        destDocument.getPage((int)(destPage + 1)).letters = this.clipDocument.getPage((int)clipPage).letters;
        destDocument.getPage((int)(destPage + 1)).ocrLetters = this.clipDocument.getPage((int)clipPage).ocrLetters;
        destDocument.getPage(destPage + 1).setBrightness(this.clipDocument.getPage(clipPage).getBrightness());
        destDocument.getPage(destPage + 1).setContrast(this.clipDocument.getPage(clipPage).getContrast());
    }

    private void initializeClipDoc(CMBDocument sourceDocument, CMBAnnotationSet sourceAnnoSet) throws CMBAnnotationEngineException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.clipDocument != null) {
            this.docServices.dropDocument(this.clipDocument);
            if (this.annoServices != null && this.clipAnnoSet != null) {
                this.annoServices.dropAnnotationSet(this.clipAnnoSet);
            }
        }
        this.clipDocument = this.docServices.createDocument(sourceDocument.getMimeType());
        this.clipDocument.setEnhance(sourceDocument.getEnhance());
        this.clipDocument.setInvert(sourceDocument.getInvert());
        this.clipDocument.setRotation(sourceDocument.getRotation());
        if (this.annoServices != null) {
            this.clipAnnoSet = this.annoServices.loadAnnotationSet(null, sourceAnnoSet.getAnnotationFormat(), sourceAnnoSet.getAnnotationPosition(), 1, 0);
        }
    }

    protected void finalize() throws Throwable {
        this.docServices.dropDocument(this.clipDocument);
        if (this.annoServices != null) {
            this.annoServices.dropAnnotationSet(this.clipAnnoSet);
        }
    }

    public int getPageCount() {
        try {
            return this.clipDocument.getPageCount();
        }
        catch (IOException e) {
            return 0;
        }
    }

    public Serializable getRelatedInfo() {
        return this.relatedInfo;
    }

    public void setRelatedInfo(Serializable relatedInfo) {
        this.relatedInfo = relatedInfo;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(clippedPagesFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(clippedPagesFlavor);
    }

    public Image[] getThumbnailPageImages() {
        return this.thumbnailPageImages;
    }

    public void setThumbnailPageImages(Image[] thumbnailPageImages) {
        this.thumbnailPageImages = thumbnailPageImages;
    }

    public Dimension getThumbnailSize() {
        return this.thumbnailSize;
    }

    public void setThumbnailSize(Dimension dimension) {
        this.thumbnailSize = dimension;
    }

    public CMBDocument getClipDocument() {
        return this.clipDocument;
    }
}

